/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PolymerPackingVis {
    int L;
    int[] dirs;
    int[] xs;
    int[] ys;
    int score;
    int minx;
    int maxx;
    int miny;
    int maxy;
    final int[] dx = new int[]{1, 0, -1, 0};
    final int[] dy = new int[]{0, 1, 0, -1};
    static String exec;
    static boolean vis;
    static boolean manual;
    static Process proc;
    static int del;
    JFrame jf;
    Vis v;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    static int SZX;
    static int SZY;
    static int offset;
    volatile int visret;
    volatile boolean visreted;

    void generate(String string) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(Long.parseLong(string));
            boolean bl = false;
            boolean[] blArray = new boolean[3];
            this.L = secureRandom.nextInt(401) + 100;
            this.dirs = new int[this.L - 1];
            this.xs = new int[this.L + 1];
            this.ys = new int[this.L + 1];
            block2: while (!bl) {
                int n = 0;
                this.ys[0] = 0;
                this.xs[0] = 0;
                bl = true;
                for (int i = 0; i < this.L; ++i) {
                    int n2;
                    int n3;
                    this.xs[i + 1] = this.xs[i] + this.dx[n];
                    this.ys[i + 1] = this.ys[i] + this.dy[n];
                    if (i == this.L - 1) continue block2;
                    int n4 = 0;
                    block4: for (n3 = 0; n3 < 3; ++n3) {
                        blArray[n3] = true;
                        for (n2 = 0; n2 <= i; ++n2) {
                            if (this.xs[n2] != this.xs[i + 1] + this.dx[(n + (n3 - 1) + 4) % 4] || this.ys[n2] != this.ys[i + 1] + this.dy[(n + (n3 - 1) + 4) % 4]) continue;
                            blArray[n3] = false;
                            continue block4;
                        }
                    }
                    if ((blArray[0] || blArray[2]) && secureRandom.nextInt(10) < 8) {
                        blArray[1] = false;
                    }
                    if ((n4 = (blArray[0] ? 1 : 0) + (blArray[1] ? 1 : 0) + (blArray[2] ? 1 : 0)) == 0) {
                        bl = false;
                        continue block2;
                    }
                    n3 = secureRandom.nextInt(n4);
                    n2 = 0;
                    n2 = 0;
                    while (n3 >= 0) {
                        if (blArray[n2]) {
                            if (n3 == 0) {
                                this.dirs[i] = n2 - 1;
                                break;
                            }
                            --n3;
                        }
                        ++n2;
                    }
                    n = (n + this.dirs[i] + 4) % 4;
                }
            }
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
        }
    }

    void calcMinMax(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.L + 1; ++i) {
            n2 = Math.min(this.xs[i], n2);
            n3 = Math.max(this.xs[i], n3);
            n4 = Math.min(this.ys[i], n4);
            n5 = Math.max(this.ys[i], n5);
        }
        this.score = (n3 - n2) * (n5 - n4);
        if (n == 1) {
            this.maxx = n3;
            this.minx = n2;
            this.maxy = n5;
            this.miny = n4;
            if (vis) {
                SZX = (this.maxx - this.minx) * SZ + 2 * offset;
                SZY = (this.maxy - this.miny) * SZ + 2 * offset;
            }
        }
    }

    public double runTest(String string) {
        try {
            this.generate(string);
            if (vis) {
                offset = 30 * SZ;
                this.calcMinMax(1);
                this.jf.setSize(SZX + 7, SZY + 27);
                this.jf.setVisible(true);
                this.visret = -2;
                this.draw();
            }
            int n = this.mirrorSequence(this.dirs);
            int n2 = this.L / 8;
            if (n < 0) {
                this.addFatalError("Your return can't contain negative number of elements.");
                return 0.0;
            }
            if (n > n2) {
                this.addFatalError("Your return contained more than " + n2 + " elements.");
                return 0.0;
            }
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4 = this.mirrorIndex();
                if (n4 == -2) {
                    return 0.0;
                }
                if (n4 < 0 || n4 > this.L - 1) {
                    this.addFatalError("Invalid node index.");
                    return 0.0;
                }
                int n5 = n4;
                while (n5 < this.L - 1) {
                    int n6 = n5++;
                    this.dirs[n6] = this.dirs[n6] * -1;
                }
                int n7 = 0;
                for (n3 = 0; n3 < this.L; ++n3) {
                    this.xs[n3 + 1] = this.xs[n3] + this.dx[n7];
                    this.ys[n3 + 1] = this.ys[n3] + this.dy[n7];
                    if (n3 == this.L - 1) break;
                    n7 = (n7 + this.dirs[n3] + 4) % 4;
                }
                if (vis) {
                    this.calcMinMax(0);
                    this.draw();
                }
                for (n3 = 0; n3 < this.L + 1; ++n3) {
                    for (n5 = 0; n5 < n3; ++n5) {
                        if (this.xs[n3] != this.xs[n5] || this.ys[n3] != this.ys[n5]) continue;
                        this.addFatalError("After mirroring (step " + i + ") polymer intersects itself: " + n3 + "=" + n5);
                        return 0.0;
                    }
                }
            }
            this.calcMinMax(0);
            return this.score;
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String checkData(String string) {
        return "";
    }

    public String displayTestCase(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("seed = " + string + "\n");
        this.generate(string);
        stringBuffer.append("L = " + this.L);
        return stringBuffer.toString();
    }

    public double[] score(double[][] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < dArray[0].length; ++n) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (!(dArray[n2][n] < d)) continue;
                d = dArray[n2][n];
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + d / dArray[n2][n];
            }
        }
        return dArray2;
    }

    int mirrorSequence(int[] nArray) throws IOException {
        if (!manual && proc != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nArray.length).append('\n');
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]).append('\n');
            }
            this.os.write(stringBuffer.toString().getBytes());
            this.os.flush();
            return Integer.parseInt(this.br.readLine());
        }
        if (manual) {
            return this.L / 8;
        }
        return 0;
    }

    int mirrorIndex() {
        if (!manual && proc == null) {
            return -1;
        }
        try {
            if (!manual && proc != null) {
                this.visret = Integer.parseInt(this.br.readLine());
                return this.visret;
            }
        }
        catch (Exception exception) {
            System.err.println("Your return doesn't parse into an integer.");
            exception.printStackTrace();
            return -2;
        }
        while (!this.visreted) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.visreted = false;
        return this.visret;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
        if (del > 0) {
            try {
                Thread.sleep(del);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public PolymerPackingVis(String string) {
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = false;
        manual = false;
        del = 0;
        SZ = 8;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-delay")) {
                del = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-vis")) {
                vis = true;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-manual")) continue;
            manual = true;
        }
        if (manual) {
            vis = true;
            del = 0;
            exec = null;
        }
        if (SZ < 6) {
            SZ = 6;
        }
        PolymerPackingVis polymerPackingVis = new PolymerPackingVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        public void paint(Graphics graphics) {
            try {
                BufferedImage bufferedImage = new BufferedImage(SZX, SZY, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(Color.LIGHT_GRAY);
                graphics2D.fillRect(0, 0, SZX, SZY);
                graphics2D.setColor(Color.BLACK);
                for (int i = 0; i < PolymerPackingVis.this.L; ++i) {
                    graphics2D.drawLine((PolymerPackingVis.this.xs[i] - PolymerPackingVis.this.minx) * SZ + offset, (PolymerPackingVis.this.maxy - PolymerPackingVis.this.ys[i]) * SZ + offset, (PolymerPackingVis.this.xs[i + 1] - PolymerPackingVis.this.minx) * SZ + offset, (PolymerPackingVis.this.maxy - PolymerPackingVis.this.ys[i + 1]) * SZ + offset);
                    graphics2D.fillRect((PolymerPackingVis.this.xs[i] - PolymerPackingVis.this.minx) * SZ + offset - 1, (PolymerPackingVis.this.maxy - PolymerPackingVis.this.ys[i]) * SZ + offset - 1, 3, 3);
                }
                char[] cArray = ("" + PolymerPackingVis.this.score).toCharArray();
                graphics2D.setFont(new Font("Arial", 1, 18));
                graphics2D.drawChars(cArray, 0, cArray.length, 8, 16);
                graphics2D.setColor(Color.GREEN);
                graphics2D.fillRect((PolymerPackingVis.this.xs[0] - PolymerPackingVis.this.minx) * SZ + offset - 1, (PolymerPackingVis.this.maxy - PolymerPackingVis.this.ys[0]) * SZ + offset - 1, 3, 3);
                graphics2D.setColor(Color.BLUE);
                graphics2D.fillRect((PolymerPackingVis.this.xs[PolymerPackingVis.this.L] - PolymerPackingVis.this.minx) * SZ + offset - 1, (PolymerPackingVis.this.maxy - PolymerPackingVis.this.ys[PolymerPackingVis.this.L]) * SZ + offset - 1, 3, 3);
                if (PolymerPackingVis.this.visret > -1) {
                    graphics2D.setColor(Color.RED);
                    graphics2D.fillRect((PolymerPackingVis.this.xs[PolymerPackingVis.this.visret + 1] - PolymerPackingVis.this.minx) * SZ + offset - 1, (PolymerPackingVis.this.maxy - PolymerPackingVis.this.ys[PolymerPackingVis.this.visret + 1]) * SZ + offset - 1, 3, 3);
                }
                graphics.drawImage(bufferedImage, 0, 0, SZX, SZY, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Vis() {
            this.addMouseListener(this);
            PolymerPackingVis.this.jf.addWindowListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!manual) {
                return;
            }
            if (mouseEvent.getButton() == 1) {
                PolymerPackingVis.this.visreted = false;
                int n = mouseEvent.getX() - offset;
                int n2 = mouseEvent.getY() - offset;
                int n3 = n / SZ;
                int n4 = n2 / SZ;
                if (n % SZ > SZ / 2) {
                    ++n3;
                }
                if (n2 % SZ > SZ / 2) {
                    ++n4;
                }
                n3 += PolymerPackingVis.this.minx;
                n4 = PolymerPackingVis.this.maxy - n4;
                for (int i = 1; i < PolymerPackingVis.this.L; ++i) {
                    if (PolymerPackingVis.this.xs[i] != n3 || PolymerPackingVis.this.ys[i] != n4) continue;
                    PolymerPackingVis.this.visret = i - 1;
                    PolymerPackingVis.this.visreted = true;
                }
            } else {
                PolymerPackingVis.this.calcMinMax(1);
                PolymerPackingVis.this.jf.setSize(SZX + 7, SZY + 27);
                PolymerPackingVis.this.v.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

