/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class Runner {
    boolean paused = false;
    boolean running = false;
    Process pr;
    BufferedReader input;
    InputStream error;
    DataOutputStream os;
    Problem prob;
    Display dis;
    int pause;

    public Runner(Problem problem, Display display) {
        this.prob = problem;
        this.dis = display;
    }

    public void start(boolean bl) {
        this.running = true;
        this.paused = false;
        try {
            Main.addMessage("Area = " + this.prob.area() + "\n");
            this.pr = Runtime.getRuntime().exec(Main.getProcess());
            this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
            this.error = this.pr.getErrorStream();
            this.os = new DataOutputStream(this.pr.getOutputStream());
            new ErrorReader().start();
            this.os.write((this.prob.M + "\n").getBytes());
            this.os.flush();
            if (bl) {
                new Stepper().start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void stop() {
        this.running = false;
        if (this.pr != null) {
            this.pr.destroy();
            this.pr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean step() throws IOException {
        if (!this.running) {
            return false;
        }
        Object object = Main.lock;
        synchronized (object) {
            String string = this.input.readLine();
            if (string == null) {
                throw new RuntimeException("Simulation over");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            double d = Double.parseDouble(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) {
                throw new RuntimeException("Simulation over.  Difference = " + (d - this.prob.area()));
            }
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            boolean bl = this.prob.isInside(d, d2);
            if (!Main.novis) {
                this.dis.addPoint(d, d2, bl);
            }
            this.os.write(((bl ? 1 : 0) + "\n").getBytes());
            this.os.flush();
        }
        return true;
    }

    public void pause() {
        if (this.paused) {
            this.paused = false;
            new Stepper().start();
        } else {
            this.paused = true;
        }
    }

    public void setPause(int n) {
        this.pause = n;
    }

    public class ErrorReader
    extends Thread {
        public void run() {
            try {
                int n;
                byte[] byArray = new byte[50000];
                while ((n = Runner.this.error.read(byArray)) > 0 && Runner.this.running) {
                    String string = new String(byArray, 0, n);
                    Main.addMessage(string);
                }
                Main.addMessage("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Stepper
    extends Thread {
        Stepper() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (Runner.this.running && !Runner.this.paused) {
                    try {
                        Runner.this.step();
                        if (Runner.this.paused) continue;
                        try {
                            Thread.sleep(Runner.this.pause);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        Runner.this.running = false;
                        try {
                            Thread.sleep(5L);
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        Main.addFatalError(exception.getMessage());
                    }
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

