/*
 * Decompiled with CFR 0.152.
 */
import java.security.SecureRandom;
import java.text.NumberFormat;

public class Problem {
    int N;
    Point[] v;
    int ncalls;
    int M;
    SecureRandom r;
    Errors err;
    long seed = 1L;

    public boolean isInside(double d, double d2) {
        if (this.ncalls == this.M) {
            throw new RuntimeException("Number of measurements exceeded M.");
        }
        ++this.ncalls;
        double d3 = 0.0;
        for (int i = 0; i < this.N; ++i) {
            double d4 = Math.atan2(this.v[i + 1].y - d2, this.v[i + 1].x - d) - Math.atan2(this.v[i].y - d2, this.v[i].x - d);
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            if (d4 < -Math.PI) {
                d4 += Math.PI * 2;
            }
            d3 += d4;
        }
        return !(d3 > -Math.PI) || !(d3 < Math.PI);
    }

    double area() {
        double d = 0.0;
        for (int i = 0; i < this.N; ++i) {
            d += (this.v[i + 1].y + this.v[i].y) * (this.v[i + 1].x - this.v[i].x) / 2.0;
        }
        return Math.abs(d);
    }

    double perimeter() {
        double d = 0.0;
        for (int i = 0; i < this.N; ++i) {
            d += this.v[i + 1].subtract(this.v[i]).abs();
        }
        return d;
    }

    double init(String string) {
        try {
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.seed = Long.parseLong(string);
            this.r.setSeed(this.seed);
            if (this.M == 0) {
                this.M = this.r.nextInt(201) + 100;
            } else {
                this.r.nextInt(201);
            }
            if (this.N == 0) {
                this.N = this.r.nextInt(16) + 5;
            } else {
                this.r.nextInt(16);
            }
            if (this.N < 3) {
                this.N = 3;
            }
            if (this.N > 20) {
                this.N = 20;
            }
            this.fractal();
            return this.area();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0;
        }
    }

    void centre() {
        int n;
        double d = 0.0;
        double d2 = 10.0;
        double d3 = 0.0;
        double d4 = 10.0;
        for (n = 0; n < this.N; ++n) {
            if (this.v[n].x > d) {
                d = this.v[n].x;
            }
            if (this.v[n].x < d2) {
                d2 = this.v[n].x;
            }
            if (this.v[n].y > d3) {
                d3 = this.v[n].y;
            }
            if (!(this.v[n].y < d4)) continue;
            d4 = this.v[n].y;
        }
        Point point = new Point(-(10.0 - d - d2) / 2.0, -(10.0 - d3 - d4) / 2.0);
        for (n = 0; n <= this.N; ++n) {
            this.v[n] = this.v[n].subtract(point);
        }
    }

    void shift() {
        int n;
        double d = 0.0;
        double d2 = 10.0;
        double d3 = 0.0;
        double d4 = 10.0;
        for (n = 0; n < this.N; ++n) {
            if (this.v[n].x > d) {
                d = this.v[n].x;
            }
            if (this.v[n].x < d2) {
                d2 = this.v[n].x;
            }
            if (this.v[n].y > d3) {
                d3 = this.v[n].y;
            }
            if (!(this.v[n].y < d4)) continue;
            d4 = this.v[n].y;
        }
        double d5 = this.r.nextDouble() * (10.0 - d + d2) - d2;
        double d6 = this.r.nextDouble() * (10.0 - d3 + d4) - d4;
        for (n = 0; n <= this.N; ++n) {
            this.v[n] = this.v[n].add(new Point(d5, d6));
        }
        Main.addFatalError("shifted " + d5 + "," + d6 + "\n");
    }

    void rotate() {
        Point[] pointArray;
        double d;
        boolean bl;
        Point point = new Point(5.0, 5.0);
        int n = 0;
        block0: do {
            ++n;
            d = this.r.nextDouble() * 2.0 * Math.PI;
            pointArray = new Point[this.N + 1];
            bl = true;
            for (int i = 0; i < this.N; ++i) {
                pointArray[i] = this.v[i].rotate(point, d);
                if (!(pointArray[i].x < 0.0 || pointArray[i].x > 10.0 || pointArray[i].y < 0.0) && !(pointArray[i].y > 10.0)) continue;
                bl = false;
                continue block0;
            }
        } while (!bl);
        pointArray[this.N] = pointArray[0];
        System.arraycopy(pointArray, 0, this.v, 0, this.N + 1);
        Main.addFatalError("rotated through " + d + "\n");
    }

    void scale() {
        Point[] pointArray;
        double d;
        boolean bl;
        Point point = new Point(5.0, 5.0);
        int n = 0;
        block0: do {
            ++n;
            d = this.r.nextDouble() * 0.4 + 0.7;
            pointArray = new Point[this.N + 1];
            bl = true;
            for (int i = 0; i < this.N; ++i) {
                pointArray[i] = this.v[i].scale(point, d);
                if (!(pointArray[i].x < 0.0 || pointArray[i].x > 10.0 || pointArray[i].y < 0.0) && !(pointArray[i].y > 10.0)) continue;
                bl = false;
                continue block0;
            }
        } while (!bl);
        pointArray[this.N] = pointArray[0];
        System.arraycopy(pointArray, 0, this.v, 0, this.N + 1);
        Main.addFatalError("scaled " + d + " times\n");
    }

    public String checkData(String string) {
        return "";
    }

    public String displayTestCase(String string) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        double d = this.init(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("seed = " + string + "\n");
        stringBuffer.append("M = " + this.M + "\n");
        stringBuffer.append(this.N + " vertices\n" + this.v[0]);
        for (int i = 1; i < this.N; ++i) {
            stringBuffer.append(" " + this.v[i]);
        }
        stringBuffer.append("\npolygon area = " + numberFormat.format(d));
        stringBuffer.append("\npolygon perimeter = " + numberFormat.format(this.perimeter()));
        return stringBuffer.toString();
    }

    public double[] score(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = 0.0;
            for (int j = 0; j < dArray[0].length; ++j) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[i][j];
            }
        }
        return dArray2;
    }

    void fractal() {
        int n;
        this.v = new Point[this.N + 1];
        Point point = new Point(5.0, 5.0);
        for (n = 0; n < 3; ++n) {
            this.v[n] = new Point(this.r.nextDouble() * 10.0, this.r.nextDouble() * 10.0);
        }
        int n2 = this.v[2].subtract(this.v[1]).crossProd(this.v[1].subtract(this.v[0])) > 0.0 ? 1 : -1;
        for (n = 3; n < this.N; ++n) {
            int n3;
            int n4;
            Point point2;
            boolean bl;
            block2: do {
                point2 = new Point(this.r.nextDouble() * 10.0, this.r.nextDouble() * 10.0);
                n4 = this.r.nextInt(n);
                while (this.inside(point2.x, point2.y, n) || this.v[(n4 + 2) % n].subtract(this.v[(n4 + 1) % n]).crossProd(point2.subtract(this.v[(n4 + 1) % n])) * (double)n2 > 0.0 || this.v[n4].subtract(this.v[(n4 + n - 1) % n]).crossProd(point2.subtract(this.v[(n4 + n - 1) % n])) * (double)n2 > 0.0) {
                    point2 = new Point(this.r.nextDouble() * 10.0, this.r.nextDouble() * 10.0);
                    n4 = this.r.nextInt(n);
                }
                bl = true;
                for (n3 = 0; n3 < n; ++n3) {
                    if (n3 == n4) continue;
                    Point point3 = this.v[n4];
                    Point point4 = this.v[(n4 + 1) % n];
                    Point point5 = this.v[n3];
                    Point point6 = this.v[(n3 + 1) % n];
                    if (this.intersect(point3, point2, point5, point6)) {
                        bl = false;
                        continue block2;
                    }
                    if (!this.intersect(point4, point2, point5, point6)) continue;
                    bl = false;
                    continue block2;
                }
            } while (!bl);
            for (n3 = n - 1; n3 > n4; --n3) {
                this.v[n3 + 1] = this.v[n3];
            }
            this.v[n4 + 1] = point2;
        }
        this.v[this.N] = this.v[0];
    }

    public boolean inside(double d, double d2, int n) {
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = Math.atan2(this.v[(i + 1) % n].y - d2, this.v[(i + 1) % n].x - d) - Math.atan2(this.v[i].y - d2, this.v[i].x - d);
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            if (d4 < -Math.PI) {
                d4 += Math.PI * 2;
            }
            d3 += d4;
        }
        return !(d3 > -Math.PI) || !(d3 < Math.PI);
    }

    boolean between(double d, double d2, double d3) {
        if (d2 < d3) {
            return d >= d2 && d <= d3;
        }
        return d >= d3 && d <= d2;
    }

    boolean intersect(Point point, Point point2, Point point3, Point point4) {
        double d = point2.y - point.y;
        double d2 = point.x - point2.x;
        double d3 = point.x * d + point.y * d2;
        double d4 = point4.y - point3.y;
        double d5 = point3.x - point4.x;
        double d6 = point3.x * d4 + point3.y * d5;
        double d7 = d * d5 - d4 * d2;
        double d8 = (d5 * d3 - d2 * d6) / d7;
        double d9 = (d * d6 - d4 * d3) / d7;
        return this.between(d8, point.x, point2.x) && this.between(d8, point3.x, point4.x) && this.between(d9, point.y, point2.y) && this.between(d9, point3.y, point4.y);
    }

    double distance(Point point, Point point2, Point point3) {
        double d;
        double d2;
        double d3 = point2.subtract(point).abs();
        if (d3 * d3 > (d2 = point3.subtract(point).abs()) * d2 + (d = point2.subtract(point3).abs()) * d) {
            return d2;
        }
        if (d2 * d2 > d3 * d3 + d * d) {
            return d3;
        }
        return Math.abs(point3.subtract(point2).crossProd(point.subtract(point2)) / d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate(boolean bl, long l) {
        Object object = Main.lock;
        synchronized (object) {
            if (bl) {
                this.N = 0;
                this.M = 0;
            }
            this.ncalls = 0;
            this.init("" + l);
        }
    }
}

