/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;

class Point
implements Comparable {
    public double x;
    public double y;

    public Point(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public boolean equals(Point point) {
        return this.x == point.x && this.y == point.y;
    }

    public int compareTo(Object object) {
        Point point = (Point)object;
        if (this.equals(point)) {
            return 0;
        }
        if (this.x < point.x) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return numberFormat.format(this.x) + " " + numberFormat.format(this.y);
    }

    public double dotProd(Point point) {
        return this.x * point.x + this.y * point.y;
    }

    public double crossProd(Point point) {
        return this.x * point.y - this.y * point.x;
    }

    public double abs() {
        return Math.sqrt(this.dotProd(this));
    }

    public Point add(Point point) {
        return new Point(this.x + point.x, this.y + point.y);
    }

    public Point subtract(Point point) {
        return new Point(this.x - point.x, this.y - point.y);
    }

    public Point rotate(Point point, double d) {
        Point point2 = this.subtract(point);
        double d2 = Math.atan2(point2.y, point2.x) + d;
        return point.add(new Point(point2.abs() * Math.cos(d2), point2.abs() * Math.sin(d2)));
    }

    public Point scale(Point point, double d) {
        Point point2 = this.subtract(point);
        return point.add(new Point(point2.x * d, point2.y * d));
    }
}

