/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Display
extends JPanel {
    BufferedImage bi;
    Problem p;
    int size = 5;
    JPanel vis;
    Object lock = new Object();
    int SCALE = 99;
    int SHIFT = 5;
    DecimalFormat df = new DecimalFormat("0.000");
    ArrayList<Double> xs = new ArrayList();
    ArrayList<Double> ys = new ArrayList();
    ArrayList<Boolean> bs = new ArrayList();

    public Display(Problem problem) {
        this.p = problem;
        JSlider jSlider = new JSlider(1, 0, 50, 5);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                Display.this.size = jSlider.getValue();
                Display.this.rebuffer();
                for (int i = 0; i < Display.this.xs.size(); ++i) {
                    Display.this.draw(Display.this.xs.get(i), Display.this.ys.get(i), Display.this.bs.get(i));
                }
                Display.this.vis.repaint();
            }
        });
        jSlider.setMajorTickSpacing(5);
        jSlider.setMinorTickSpacing(1);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.vis = new Vis();
        this.setLayout(new BorderLayout());
        this.add((Component)this.vis, "Center");
        this.add((Component)jSlider, "West");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuffer() {
        Object object = this.lock;
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.p.v == null) {
                return;
            }
            this.bi = new BufferedImage(1000, 1000, 1);
            Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, 1000, 1000);
            graphics2D.setColor(Color.black);
            int n5 = this.size;
            if (n5 > 5) {
                n5 = 5;
            }
            BasicStroke basicStroke = new BasicStroke(n5);
            graphics2D.setStroke(basicStroke);
            for (n4 = 0; n4 < this.p.v.length; ++n4) {
                n3 = (int)(this.p.v[n4].x * (double)this.SCALE + (double)this.SHIFT);
                n2 = (int)(this.p.v[n4].y * (double)this.SCALE + (double)this.SHIFT);
                n = (int)(this.p.v[(n4 + 1) % this.p.v.length].x * (double)this.SCALE + (double)this.SHIFT);
                int n6 = (int)(this.p.v[(n4 + 1) % this.p.v.length].y * (double)this.SCALE + (double)this.SHIFT);
                graphics2D.drawLine(n3, n2, n, n6);
            }
            graphics2D.setColor(Color.gray);
            n4 = this.SHIFT;
            n3 = 10 * this.SCALE + this.SHIFT;
            graphics2D.drawLine(n4, n4, n3, n4);
            graphics2D.drawLine(n4, n4, n4, n3);
            graphics2D.drawLine(n4, n3, n3, n3);
            graphics2D.drawLine(n3, n4, n3, n3);
            basicStroke = new BasicStroke((float)n5 / 2.0f);
            graphics2D.setStroke(basicStroke);
            for (n2 = 1; n2 < 10; ++n2) {
                n = n2 * this.SCALE + this.SHIFT;
                graphics2D.drawLine(n, n4, n, n3);
                graphics2D.drawLine(n4, n, n3, n);
            }
        }
    }

    public void repaintSim(boolean bl) {
        this.bi = null;
        this.xs = new ArrayList();
        this.ys = new ArrayList();
        this.bs = new ArrayList();
        this.rebuffer();
        this.repaint();
    }

    public void addPoint(double d, double d2, boolean bl) {
        this.xs.add(d);
        this.ys.add(d2);
        this.bs.add(bl);
        this.draw(d, d2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(double d, double d2, boolean bl) {
        while (this.bi == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.bi != null) {
                int n = (int)(d * (double)this.SCALE + (double)this.SHIFT);
                int n2 = (int)(d2 * (double)this.SCALE + (double)this.SHIFT);
                Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (bl) {
                    graphics2D.setColor(new Color(65280));
                    graphics2D.fillOval(n - this.size / 2, n2 - this.size / 2, this.size, this.size);
                } else {
                    graphics2D.setColor(new Color(0xFF0000));
                    graphics2D.fillOval(n - this.size / 2, n2 - this.size / 2, this.size, this.size);
                }
            }
            this.repaint();
        }
    }

    public class Vis
    extends JPanel {
        public void paint(Graphics graphics) {
            Object object;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (Display.this.bi == null) {
                Display.this.rebuffer();
            }
            Font font = new Font(graphics2D.getFont().getName(), 0, 20);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getAscent();
            if (Display.this.bi != null) {
                object = new AffineTransform();
                double d = (double)Math.min(this.getWidth(), this.getHeight()) / 1000.0;
                double d2 = ((double)this.getWidth() - (double)Display.this.bi.getWidth() * d) / 2.0 / d;
                double d3 = ((double)this.getHeight() - (double)Display.this.bi.getHeight() * d) / 2.0 / d;
                ((AffineTransform)object).scale(d, d);
                ((AffineTransform)object).translate(d2, d3);
                AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, 3);
                graphics2D.drawImage(Display.this.bi, affineTransformOp, 0, 0);
            }
            object = "Area = " + Display.this.df.format(Display.this.p.area());
            String string = "No Calls = " + Display.this.p.ncalls;
            int n2 = fontMetrics.stringWidth((String)object);
            graphics2D.setColor(Color.black);
            graphics2D.drawString((String)object, 0, n);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, 0, 2 * n);
        }
    }
}

