/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;

public class PoisonedWineVis {
    private SecureRandom r;
    private int numBottles;
    private int testStrips;
    private int testRounds;
    private int numPoison;
    private boolean[] bottles;
    private boolean failure = false;
    static String exec;
    static Process proc;
    static boolean vis;
    InputStream is;
    OutputStream os;
    BufferedReader br;

    private void generateTestCase(long l) {
        try {
            this.r = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.r.setSeed(l);
        this.numBottles = this.r.nextInt(9951) + 50;
        this.bottles = new boolean[this.numBottles];
        this.testStrips = this.r.nextInt(16) + 5;
        this.testRounds = this.r.nextInt(10) + 1;
        int n = this.numPoison = this.r.nextInt(this.numBottles / 50) + 1;
        while (n > 0) {
            int n2 = this.r.nextInt(this.numBottles);
            if (this.bottles[n2]) continue;
            this.bottles[n2] = true;
            --n;
        }
    }

    public int[] useTestStrips(String[] stringArray) {
        if (stringArray.length > this.testStrips) {
            this.addFatalError("testWine() called with " + stringArray.length + " tests when only " + this.testStrips + " strips remain");
            this.failure = true;
            return new int[0];
        }
        if (this.testRounds <= 0) {
            this.addFatalError("testWine() called too many times");
            this.failure = true;
            return new int[0];
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            String[] stringArray2 = stringArray[i].split(",");
            for (int j = 0; j < stringArray2.length; ++j) {
                int n = -1;
                try {
                    n = Integer.parseInt(stringArray2[j]);
                }
                catch (Exception exception) {
                    this.addFatalError("Invalid value " + stringArray2[j] + " found in a test request");
                    this.failure = true;
                    return new int[0];
                }
                if (n < 0 || n >= this.numBottles) {
                    this.addFatalError("Invalid value " + n + " found in a test request");
                    this.failure = true;
                    return new int[0];
                }
                bl |= this.bottles[n];
            }
            if (!bl) continue;
            nArray[i] = 1;
            --this.testStrips;
        }
        --this.testRounds;
        return nArray;
    }

    public double runTest(String string) {
        try {
            int n;
            this.generateTestCase(Long.parseLong(string));
            int[] nArray = this.testWine(this.numBottles, this.testStrips, this.testRounds, this.numPoison);
            if (this.failure) {
                return 0.0;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] < 0 || nArray[n] >= this.numBottles) {
                    this.addFatalError("Invalid return value: " + nArray[n]);
                    return 0.0;
                }
                this.bottles[nArray[n]] = false;
            }
            for (n = 0; n < this.bottles.length; ++n) {
                if (!this.bottles[n]) continue;
                this.addFatalError("A poisoned bottle remained.");
                return 0.0;
            }
            Arrays.sort(nArray);
            for (n = 1; n < nArray.length; ++n) {
                if (nArray[n] != nArray[n - 1]) continue;
                this.addFatalError("Bottle " + nArray[n] + " was duplicated in the return");
                return 0.0;
            }
            double d = 1.0 * (double)(this.numBottles - nArray.length) / (double)(this.numBottles - this.numPoison);
            return d * d;
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    int[] testWine(int n, int n2, int n3, int n4) throws IOException {
        int n5;
        String string;
        int[] nArray = new int[]{};
        if (proc == null) {
            return nArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append("\n");
        stringBuffer.append(n2).append("\n");
        stringBuffer.append(n3).append("\n");
        stringBuffer.append(n4).append("\n");
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        while ((string = this.br.readLine()).equals("?")) {
            try {
                n5 = Integer.parseInt(this.br.readLine());
            }
            catch (NumberFormatException numberFormatException) {
                return nArray;
            }
            String[] stringArray = new String[n5];
            for (int i = 0; i < n5; ++i) {
                stringArray[i] = this.br.readLine();
            }
            int[] nArray2 = this.useTestStrips(stringArray);
            stringBuffer = new StringBuffer();
            stringBuffer.append(nArray2.length).append("\n");
            for (int i = 0; i < nArray2.length; ++i) {
                stringBuffer.append(nArray2[i]).append("\n");
            }
            this.os.write(stringBuffer.toString().getBytes());
            this.os.flush();
        }
        n5 = Integer.parseInt(string);
        nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = Integer.parseInt(this.br.readLine());
        }
        return nArray;
    }

    public PoisonedWineVis(String string) {
        try {
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (!stringArray[i].equals("-exec")) continue;
            exec = stringArray[++i];
        }
        PoisonedWineVis poisonedWineVis = new PoisonedWineVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

