/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PointsOnTheCircleVis {
    static int maxN = 200;
    static int minN = 20;
    static int maxP = 200;
    static int minP = 5;
    int N;
    int[][] matrix;
    int[] perm;
    static String exec;
    static String fileName;
    static boolean vis;
    static boolean debug;
    static boolean save;
    static Process proc;
    JFrame jf;
    Vis v;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZX;
    static int SZY;
    static int SZ;
    static final int D = 30;

    String generate(String string) {
        try {
            int n;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.N = secureRandom.nextInt(maxN - minN + 1) + minN;
            int n2 = secureRandom.nextInt(maxP - minP + 1) + minP;
            if (l == 1L) {
                this.N = 8;
                n2 = 200;
            } else if (l == 2L) {
                this.N = minN;
            } else if (l == 3L) {
                this.N = maxN;
            }
            int n3 = 0;
            this.matrix = new int[this.N][this.N];
            for (int i = 0; i < this.N; ++i) {
                for (n = i + 1; n < this.N; ++n) {
                    int n4 = secureRandom.nextInt(1000) < n2 ? 1 : 0;
                    this.matrix[n][i] = n4;
                    this.matrix[i][n] = n4;
                    if (this.matrix[i][n] != 1) continue;
                    ++n3;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("N = ").append(this.N).append('\n');
            stringBuffer.append("Edge probability = ").append((double)n2 * 0.1).append("%\n");
            stringBuffer.append("Number of edges = ").append(n3).append('\n');
            if (l < 3L) {
                for (n = 0; n < this.N; ++n) {
                    for (int i = 0; i < this.N; ++i) {
                        stringBuffer.append(this.matrix[n][i]).append(' ');
                    }
                    stringBuffer.append('\n');
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
            return "";
        }
    }

    public double runTest(String string) {
        try {
            int n;
            int n2;
            String string2 = this.generate(string);
            if (debug) {
                System.out.println(string2);
            }
            int[] nArray = new int[this.N * this.N];
            for (n2 = 0; n2 < this.N; ++n2) {
                for (n = 0; n < this.N; ++n) {
                    nArray[n2 * this.N + n] = this.matrix[n2][n];
                }
            }
            if (proc != null) {
                try {
                    this.perm = this.permute(nArray);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from permute.");
                    return -1.0;
                }
                if (this.perm.length != this.N) {
                    this.addFatalError("Your return must contain " + this.N + " elements, and it contained " + this.perm.length + ".");
                    return -1.0;
                }
                boolean[] blArray = new boolean[this.N];
                for (n = 0; n < this.N; ++n) {
                    if (this.perm[n] < 0 || this.perm[n] >= this.N) {
                        this.addFatalError("All elements of your return must be between 0 and " + (this.N - 1) + ", and your return contained " + this.perm[n] + ".");
                        return -1.0;
                    }
                    if (blArray[this.perm[n]]) {
                        this.addFatalError("All elements of your return must be unique, and your return contained " + this.perm[n] + " twice.");
                        return -1.0;
                    }
                    blArray[this.perm[n]] = true;
                }
            } else {
                this.perm = new int[this.N];
                for (n2 = 0; n2 < this.N; ++n2) {
                    this.perm[n2] = n2;
                }
            }
            if (debug) {
                System.err.println("Permutation:");
                for (int i = 0; i < this.N; ++i) {
                    System.err.print(this.perm[i] + " ");
                }
                System.err.println();
            }
            double d = 0.0;
            for (int i = 0; i < this.N; ++i) {
                for (int j = i + 1; j < this.N; ++j) {
                    if (this.matrix[this.perm[i]][this.perm[j]] != 1) continue;
                    double d2 = Math.PI / (double)this.N * (double)(j - i);
                    d += 2.0 * Math.sin(d2);
                    if (!debug) continue;
                    System.err.println("p[" + i + "] = " + this.perm[i] + ", p[" + j + "] = " + this.perm[j] + ", angle = " + d2 + ", length = " + 2.0 * Math.sin(d2));
                }
            }
            if (vis) {
                this.jf.setSize(SZX + 10, SZY + 40);
                this.jf.setVisible(true);
                this.draw();
            }
            return d;
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to process your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    int[] permute(int[] nArray) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length).append('\n');
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(nArray[n]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        int n2 = Integer.parseInt(this.br.readLine());
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = Integer.parseInt(this.br.readLine());
        }
        return nArray2;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    public PointsOnTheCircleVis(String string) {
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        SZ = 200;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-vis")) {
                vis = true;
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-save")) continue;
            save = true;
        }
        if (string.equals("1") && SZ < 100) {
            SZ = 100;
        }
        if (save) {
            fileName = string;
            vis = true;
        }
        SZX = SZY = 2 * (SZ + 30);
        PointsOnTheCircleVis pointsOnTheCircleVis = new PointsOnTheCircleVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements WindowListener {
        @Override
        public void paint(Graphics graphics) {
            try {
                int n;
                BufferedImage bufferedImage = new BufferedImage(SZX, SZY, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(new Color(0xD3D3D3));
                graphics2D.fillRect(0, 0, SZX, SZY);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillOval(30, 30, 2 * SZ, 2 * SZ);
                graphics2D.setColor(Color.BLACK);
                for (n = 0; n < PointsOnTheCircleVis.this.N; ++n) {
                    for (int i = n + 1; i < PointsOnTheCircleVis.this.N; ++i) {
                        if (PointsOnTheCircleVis.this.matrix[PointsOnTheCircleVis.this.perm[n]][PointsOnTheCircleVis.this.perm[i]] != 1) continue;
                        graphics2D.drawLine(SZ + (int)Math.round((double)SZ * Math.sin((double)(2 * n) * Math.PI / (double)PointsOnTheCircleVis.this.N)) + 30, SZ - (int)Math.round((double)SZ * Math.cos((double)(2 * n) * Math.PI / (double)PointsOnTheCircleVis.this.N)) + 30, SZ + (int)Math.round((double)SZ * Math.sin((double)(2 * i) * Math.PI / (double)PointsOnTheCircleVis.this.N)) + 30, SZ - (int)Math.round((double)SZ * Math.cos((double)(2 * i) * Math.PI / (double)PointsOnTheCircleVis.this.N)) + 30);
                    }
                }
                for (n = 0; n < PointsOnTheCircleVis.this.N; ++n) {
                    graphics2D.drawOval(SZ + (int)Math.round((double)SZ * Math.sin((double)(2 * n) * Math.PI / (double)PointsOnTheCircleVis.this.N)) + 30 - 2, SZ - (int)Math.round((double)SZ * Math.cos((double)(2 * n) * Math.PI / (double)PointsOnTheCircleVis.this.N)) + 30 - 2, 4, 4);
                }
                graphics2D.setFont(new Font("Arial", 1, 11));
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                for (int i = 0; i < PointsOnTheCircleVis.this.N; ++i) {
                    char[] cArray = ("" + PointsOnTheCircleVis.this.perm[i]).toCharArray();
                    int n2 = SZ + 30 + (int)Math.round((double)(SZ + 15) * Math.sin((double)(2 * i) * Math.PI / (double)PointsOnTheCircleVis.this.N)) - 5;
                    int n3 = SZ + 30 - (int)Math.round((double)(SZ + 15) * Math.cos((double)(2 * i) * Math.PI / (double)PointsOnTheCircleVis.this.N)) + fontMetrics.getHeight() / 2 - 2;
                    graphics2D.drawChars(cArray, 0, cArray.length, n2, n3);
                }
                graphics.drawImage(bufferedImage, 0, 0, SZX, SZY, null);
                if (save) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", new File(fileName + ".png"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Vis() {
            PointsOnTheCircleVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

