/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PointsOnGridVis {
    private static int minN = 5;
    private static int maxN = 50;
    private static int minM = 2;
    private static int minK1 = 1;
    private static int minK2 = 0;
    private static int minNum = 0;
    private static int maxNum = 9;
    int H;
    int W;
    int P;
    int Q;
    int Kmin;
    int Kmax;
    String[] numbers;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    static String[] board;

    void generate(String string) {
        try {
            int n;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.H = secureRandom.nextInt(maxN - minN + 1) + minN;
            this.W = secureRandom.nextInt(maxN - minN + 1) + minN;
            this.P = secureRandom.nextInt(this.H - 1 - minM + 1) + minM;
            this.Q = secureRandom.nextInt(this.W - 1 - minM + 1) + minM;
            this.Kmax = secureRandom.nextInt(this.P * this.Q - 1 - minK1 + 1) + minK1;
            this.Kmin = secureRandom.nextInt(this.Kmax - 1 - minK2 + 1) + minK2;
            if (l == 1L) {
                this.H = 8;
                this.W = 8;
                this.P = 3;
                this.Q = 4;
                this.Kmin = 0;
                this.Kmax = 5;
            }
            this.numbers = new String[this.H];
            for (n = 0; n < this.H; ++n) {
                this.numbers[n] = "";
                for (int i = 0; i < this.W; ++i) {
                    int n2 = n;
                    this.numbers[n2] = this.numbers[n2] + (secureRandom.nextInt(maxNum - minNum + 1) + minNum);
                }
            }
            System.err.println("seed = " + string);
            System.err.println("H = " + this.H + ", W = " + this.W + ", h = " + this.P + ", w = " + this.Q + ", Kmin = " + this.Kmin + ", Kmax = " + this.Kmax);
            for (n = 0; n < this.H; ++n) {
                System.err.println(this.numbers[n]);
            }
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
        }
    }

    int getScore() {
        int n = 0;
        for (int i = 0; i < this.H; ++i) {
            for (int j = 0; j < this.W; ++j) {
                if (board[i].charAt(j) != 'x') continue;
                n += this.numbers[i].charAt(j) - 48;
            }
        }
        return n;
    }

    public double runTest(String string) {
        try {
            this.generate(string);
            if (proc != null) {
                int n;
                int n2;
                int n3;
                String[] stringArray;
                try {
                    stringArray = this.callSolution();
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from your solution.");
                    return -1.0;
                }
                if (stringArray == null) {
                    this.addFatalError("Your return contained invalid number of elements.");
                    return -1.0;
                }
                if (stringArray.length != this.H) {
                    this.addFatalError("Your return did not contain " + this.H + " elements.");
                    return -1.0;
                }
                for (n3 = 0; n3 < this.H; ++n3) {
                    if (stringArray[n3].length() != this.W) {
                        this.addFatalError("Row " + n3 + " does not contain " + this.W + " elements.");
                        return -1.0;
                    }
                    for (n2 = 0; n2 < this.W; ++n2) {
                        n = stringArray[n3].charAt(n2);
                        if (n == 46 || n == 120) continue;
                        this.addFatalError("Row " + n3 + " column " + n2 + " contains an illegal character");
                        return -1.0;
                    }
                }
                for (n3 = 0; n3 < this.H - (this.P - 1); ++n3) {
                    for (n2 = 0; n2 < this.W - (this.Q - 1); ++n2) {
                        n = 0;
                        for (int i = n3; i < n3 + this.P; ++i) {
                            for (int j = n2; j < n2 + this.Q; ++j) {
                                if (stringArray[i].charAt(j) != 'x') continue;
                                ++n;
                            }
                        }
                        if (n > this.Kmax) {
                            this.addFatalError("Subgrid starting at (" + n3 + "," + n2 + ") contains too many painted cells");
                            return -1.0;
                        }
                        if (n >= this.Kmin) continue;
                        this.addFatalError("Subgrid starting at (" + n3 + "," + n2 + ") contains not enough painted cells");
                        return -1.0;
                    }
                }
                board = stringArray;
                if (vis) {
                    this.jf.setSize((this.W + 3) * SZ + 50, this.H * SZ + 40);
                    this.jf.setVisible(true);
                    this.draw();
                }
            }
            return this.getScore();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    private String[] callSolution() throws IOException, NumberFormatException {
        if (exec == null) {
            return null;
        }
        String string = this.H + "\n" + this.W + "\n" + this.P + "\n" + this.Q + "\n" + this.Kmin + "\n" + this.Kmax + "\n" + this.H + "\n";
        this.os.write(string.getBytes());
        for (int i = 0; i < this.H; ++i) {
            string = this.numbers[i] + "\n";
            this.os.write(string.getBytes());
        }
        this.os.flush();
        String[] stringArray = new String[Integer.parseInt(this.br.readLine())];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.br.readLine();
        }
        return stringArray;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    public PointsOnGridVis(String string) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.v = new Vis();
                this.jf.getContentPane().add(this.v);
            }
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        SZ = 20;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (!stringArray[i].equals("-size")) continue;
            SZ = Integer.parseInt(stringArray[++i]);
        }
        if (string.equals("1")) {
            SZ = 50;
        }
        PointsOnGridVis pointsOnGridVis = new PointsOnGridVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        @Override
        public void paint(Graphics graphics) {
            int n;
            graphics.setColor(new Color(0xDDDDDD));
            graphics.fillRect(0, 0, PointsOnGridVis.this.W * SZ + 120, PointsOnGridVis.this.H * SZ + 40);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, PointsOnGridVis.this.W * SZ, PointsOnGridVis.this.H * SZ);
            for (n = 0; n < PointsOnGridVis.this.H; ++n) {
                for (int i = 0; i < PointsOnGridVis.this.W; ++i) {
                    if (board[n].charAt(i) == 'x') {
                        graphics.setColor(Color.CYAN);
                        graphics.fillRect(i * SZ + 1, n * SZ + 1, SZ - 1, SZ - 1);
                    }
                    graphics.setFont(new Font("Arial", 1, 14));
                    graphics.setColor(Color.BLACK);
                    graphics.drawString("" + PointsOnGridVis.this.numbers[n].charAt(i), i * SZ + SZ / 2 - 3, n * SZ + SZ / 2 + 3);
                }
            }
            graphics.setColor(Color.BLACK);
            for (n = 0; n <= PointsOnGridVis.this.H; ++n) {
                graphics.drawLine(0, n * SZ, PointsOnGridVis.this.W * SZ, n * SZ);
            }
            for (n = 0; n <= PointsOnGridVis.this.W; ++n) {
                graphics.drawLine(n * SZ, 0, n * SZ, PointsOnGridVis.this.H * SZ);
            }
            graphics.setFont(new Font("Arial", 1, 14));
            graphics.drawString("SCORE", SZ * PointsOnGridVis.this.W + 25, 30);
            graphics.drawString(String.format("%d", PointsOnGridVis.this.getScore()), SZ * PointsOnGridVis.this.W + 25, 50);
        }

        public Vis() {
            PointsOnGridVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

