/*
 * Decompiled with CFR 0.152.
 */
import java.security.SecureRandom;

class TestCase {
    final Object worldLock = new Object();
    public static final int MIN_BOARD_SIZE = 20;
    public static final int MAX_BOARD_SIZE = 60;
    public static final int MIN_PEG_TYPES = 1;
    public static final int MAX_PEG_TYPES = 10;
    public static final int MIN_PEG_VALUE = 1;
    public static final int MAX_PEG_VALUE = 10;
    public static final int MIN_PEG_BLOBS = 0;
    public static final int MAX_PEG_BLOBS = 10;
    public static final double MIN_FILL_RATIO = 0.1;
    public static final double MAX_FILL_RATIO = 0.9;
    public int boardSize;
    public int pegTypeCnt;
    public int pegStartCnt;
    public int pegNowCnt;
    public int numMoves;
    public int numJumps;
    public int[] pegValue;
    public int score;
    public int blobCnt;
    public double fillRatio;
    public int[] lastX;
    public int[] lastY;
    public int[] lastPeg;
    public int lastScore;
    public char[][] board;
    public SecureRandom rnd = null;

    public TestCase(long l) {
        int n;
        int n2;
        try {
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            System.err.println("ERROR: unable to generate test case.");
            System.exit(1);
        }
        this.rnd.setSeed(l);
        this.boardSize = this.rnd.nextInt(41) + 20;
        if (l == 1L) {
            this.boardSize = 20;
        }
        this.board = new char[this.boardSize][this.boardSize];
        this.pegTypeCnt = this.rnd.nextInt(10) + 1;
        this.pegValue = new int[this.pegTypeCnt];
        for (n2 = 0; n2 < this.pegTypeCnt; ++n2) {
            this.pegValue[n2] = this.rnd.nextInt(10) + 1;
        }
        this.fillRatio = this.rnd.nextDouble() * 0.8 + 0.1;
        for (n2 = 0; n2 < this.boardSize; ++n2) {
            for (n = 0; n < this.boardSize; ++n) {
                this.board[n2][n] = this.rnd.nextDouble() < this.fillRatio ? 46 : (char)(48 + this.rnd.nextInt(this.pegTypeCnt));
            }
        }
        this.blobCnt = this.rnd.nextInt(11) + 0;
        for (n2 = 0; n2 < this.blobCnt; ++n2) {
            n = this.rnd.nextInt(this.pegTypeCnt);
            int n3 = this.rnd.nextInt(this.boardSize / 4) + 1;
            int n4 = this.rnd.nextInt(this.boardSize);
            int n5 = this.rnd.nextInt(this.boardSize);
            for (int i = n4 - n3; i <= n4 + n3; ++i) {
                if (i < 0 || i >= this.boardSize) continue;
                for (int j = n5 - n3; j <= n5 + n3; ++j) {
                    int n6;
                    if (j < 0 || j >= this.boardSize || (n6 = (i - n4) * (i - n4) + (j - n5) * (j - n5)) > n3 * n3) continue;
                    this.board[j][i] = (char)(48 + n);
                }
            }
        }
        this.pegStartCnt = 0;
        for (n2 = 0; n2 < this.boardSize; ++n2) {
            for (n = 0; n < this.boardSize; ++n) {
                if (this.board[n2][n] == '.') continue;
                ++this.pegStartCnt;
            }
        }
        this.pegNowCnt = this.pegStartCnt;
        this.numJumps = 0;
        this.score = 0;
        this.lastScore = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doMove(int n, int n2, String string) throws Exception {
        Object object = this.worldLock;
        synchronized (object) {
            char c = this.board[n2][n];
            if (c == '.') {
                System.err.println("ERROR: Trying to move an empty cell.");
                return false;
            }
            this.lastX = new int[string.length() + 1];
            this.lastY = new int[string.length() + 1];
            this.lastPeg = new int[string.length() + 1];
            this.lastX[0] = n;
            this.lastY[0] = n2;
            int n3 = 0;
            for (int i = 0; i < string.length(); ++i) {
                int n4 = 0;
                int n5 = 0;
                char c2 = string.charAt(i);
                if (c2 == 'L') {
                    n4 = -1;
                } else if (c2 == 'R') {
                    n4 = 1;
                } else if (c2 == 'U') {
                    n5 = -1;
                } else if (c2 == 'D') {
                    n5 = 1;
                }
                if (n4 == 0 && n5 == 0) {
                    System.err.println("ERROR: Invalid move character [" + c2 + "].");
                    return false;
                }
                int n6 = n + n4;
                int n7 = n2 + n5;
                if (n6 >= 0 && n6 < this.boardSize && n7 >= 0 && n7 < this.boardSize) {
                    if (this.board[n7][n6] == '.') {
                        System.err.println("ERROR: Can not jump over empty space.");
                        return false;
                    }
                    int n8 = n6 + n4;
                    int n9 = n7 + n5;
                    if (n8 >= 0 && n8 < this.boardSize && n9 >= 0 && n9 < this.boardSize) {
                        if (this.board[n9][n8] != '.') {
                            System.err.println("ERROR: Trying to jump onto another peg.");
                            return false;
                        }
                        this.lastPeg[i + 1] = this.board[n7][n6] - 48;
                        this.board[n2][n] = 46;
                        n3 += this.pegValue[this.board[n7][n6] - 48];
                        this.board[n7][n6] = 46;
                        this.board[n9][n8] = c;
                        n = n8;
                        n2 = n9;
                        this.lastX[i + 1] = n;
                        this.lastY[i + 1] = n2;
                        --this.pegNowCnt;
                        continue;
                    }
                    System.err.println("ERROR: Trying to jump outside the board.");
                    return false;
                }
                System.err.println("ERROR: Trying to move outside the board.");
                return false;
            }
            this.lastScore = string.length() * n3;
            this.score += this.lastScore;
            ++this.numJumps;
        }
        return true;
    }
}

