/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class PegJumpVis {
    public static String execCommand = null;
    public static long seed = 1L;
    public static boolean vis = true;
    public static boolean debug = false;
    public static int cellSize = 12;
    public static int delay = 100;
    public static boolean startPaused = false;
    public static Process solution;

    public int runTest() {
        int n;
        solution = null;
        try {
            solution = Runtime.getRuntime().exec(execCommand);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Unable to execute your solution using the provided command: " + execCommand + ".");
            return -1;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(solution.getInputStream()));
        PrintWriter printWriter = new PrintWriter(solution.getOutputStream());
        new ErrorStreamRedirector(solution.getErrorStream()).start();
        TestCase testCase = new TestCase(seed);
        printWriter.println(testCase.pegTypeCnt);
        int[] nArray = testCase.pegValue;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            int n3 = nArray[n];
            printWriter.println(n3);
        }
        printWriter.println(testCase.boardSize);
        for (int i = 0; i < testCase.boardSize; ++i) {
            String string = "";
            for (n = 0; n < testCase.boardSize; ++n) {
                string = string + testCase.board[i][n];
            }
            printWriter.println(string);
        }
        printWriter.flush();
        Drawer drawer = null;
        if (vis) {
            drawer = new Drawer(testCase, cellSize);
            drawer.debugMode = debug;
            if (startPaused) {
                drawer.pauseMode = true;
            }
        }
        try {
            n2 = Integer.parseInt(bufferedReader.readLine());
            if (n2 > testCase.boardSize * testCase.boardSize * 10) {
                System.err.println("ERROR: Return array from getMoves too large.");
                return -1;
            }
            for (n = 0; n < n2; ++n) {
                String string = bufferedReader.readLine();
                String[] stringArray = string.split(" ");
                if (stringArray.length != 3) {
                    System.err.println("ERROR: The move command with index " + n + " does not contain 3 space seperated values. Value is [" + string + "]");
                    return -1;
                }
                int n4 = Integer.parseInt(stringArray[0]);
                int n5 = Integer.parseInt(stringArray[1]);
                if (n5 < 0 || n5 >= testCase.boardSize || n4 < 0 || n4 >= testCase.boardSize) {
                    System.err.println("ERROR: (" + n4 + "," + n5 + ") outside of bounds.");
                    return -1;
                }
                if (testCase.board[n4][n5] == '.') {
                    System.err.println("ERROR: (" + n4 + "," + n5 + ") does not contain a peg.");
                    return -1;
                }
                if (!testCase.doMove(n5, n4, stringArray[2])) {
                    return -1;
                }
                if (!vis) continue;
                drawer.processPause();
                drawer.repaint();
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: Unable to process the move commands from your solution.");
            return -1;
        }
        PegJumpVis.stopSolution();
        return testCase.score;
    }

    public static void stopSolution() {
        if (solution != null) {
            try {
                solution.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                execCommand = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                seed = Long.parseLong(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
                continue;
            }
            if (stringArray[i].equals("-sz")) {
                cellSize = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-delay")) {
                delay = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-pause")) {
                startPaused = true;
                continue;
            }
            System.out.println("WARNING: unknown argument " + stringArray[i] + ".");
        }
        if (execCommand == null) {
            System.err.println("ERROR: You did not provide the command to execute your solution. Please use -exec <command> for this.");
            System.exit(1);
        }
        PegJumpVis pegJumpVis = new PegJumpVis();
        try {
            int n = pegJumpVis.runTest();
            System.out.println("Score = " + n);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("ERROR: Unexpected error while running your test case.");
            runtimeException.printStackTrace();
            PegJumpVis.stopSolution();
        }
    }
}

