/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Drawer
extends JFrame {
    public static final int EXTRA_WIDTH = 200;
    public static final int EXTRA_HEIGHT = 50;
    public TestCase tc;
    public DrawerPanel panel;
    public int cellSize;
    public int boardSize;
    public int width;
    public int height;
    public boolean pauseMode = false;
    public boolean debugMode = false;
    final Object keyMutex = new Object();
    boolean keyPressed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPause() {
        Object object = this.keyMutex;
        synchronized (object) {
            if (!this.pauseMode) {
                return;
            }
            this.keyPressed = false;
            while (!this.keyPressed) {
                try {
                    this.keyMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Drawer(TestCase testCase, int n) {
        this.panel = new DrawerPanel();
        this.getContentPane().add(this.panel);
        this.addWindowListener(new DrawerWindowListener());
        this.tc = testCase;
        this.boardSize = this.tc.boardSize;
        this.cellSize = n;
        this.width = n * this.boardSize + 200;
        this.height = n * this.boardSize + 50;
        this.addKeyListener(new DrawerKeyListener());
        this.setSize(this.width, this.height);
        this.setTitle("Visualizer tool for problem PegJump");
        this.setResizable(false);
        this.setVisible(true);
    }

    class DrawerWindowListener
    extends WindowAdapter {
        DrawerWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            PegJumpVis.stopSolution();
            System.exit(0);
        }
    }

    class DrawerPanel
    extends JPanel {
        DrawerPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            Object object = Drawer.this.tc.worldLock;
            synchronized (object) {
                float f;
                int n;
                graphics.setColor(new Color(32, 32, 32));
                graphics.fillRect(15, 15, Drawer.this.cellSize * Drawer.this.boardSize + 1, Drawer.this.cellSize * Drawer.this.boardSize + 1);
                graphics.setColor(Color.BLACK);
                for (n = 0; n <= Drawer.this.boardSize; ++n) {
                    graphics.drawLine(15 + n * Drawer.this.cellSize, 15, 15 + n * Drawer.this.cellSize, 15 + Drawer.this.cellSize * Drawer.this.boardSize);
                    graphics.drawLine(15, 15 + n * Drawer.this.cellSize, 15 + Drawer.this.cellSize * Drawer.this.boardSize, 15 + n * Drawer.this.cellSize);
                }
                for (n = 0; n < Drawer.this.boardSize; ++n) {
                    for (int i = 0; i < Drawer.this.boardSize; ++i) {
                        if (Drawer.this.tc.board[n][i] < '0' || Drawer.this.tc.board[n][i] > '9') continue;
                        f = (float)(Drawer.this.tc.board[n][i] - 48) / (float)Drawer.this.tc.pegTypeCnt;
                        graphics.setColor(Color.getHSBColor(f, 0.9f, 1.0f));
                        graphics.fillOval(15 + i * Drawer.this.cellSize + 1, 15 + n * Drawer.this.cellSize + 1, Drawer.this.cellSize - 1, Drawer.this.cellSize - 1);
                    }
                }
                if (Drawer.this.tc.lastX != null && Drawer.this.tc.lastX.length > 0) {
                    for (n = 0; n < Drawer.this.tc.lastX.length - 1; ++n) {
                        float f2 = (float)Drawer.this.tc.lastPeg[n + 1] / (float)Drawer.this.tc.pegTypeCnt;
                        graphics.setColor(Color.getHSBColor(f2, 0.9f, 1.0f));
                        graphics.drawOval(15 + (Drawer.this.tc.lastX[n + 1] + Drawer.this.tc.lastX[n]) / 2 * Drawer.this.cellSize + 1, 15 + (Drawer.this.tc.lastY[n + 1] + Drawer.this.tc.lastY[n]) / 2 * Drawer.this.cellSize + 1, Drawer.this.cellSize - 1, Drawer.this.cellSize - 1);
                        graphics.setColor(Color.WHITE);
                        f = 0.5f + 0.5f * (float)(n + 1) / (float)(Drawer.this.tc.lastX.length - 1);
                        graphics.setColor(new Color(f, f, f));
                        graphics.drawLine(15 + Drawer.this.tc.lastX[n] * Drawer.this.cellSize + Drawer.this.cellSize / 2, 15 + Drawer.this.tc.lastY[n] * Drawer.this.cellSize + Drawer.this.cellSize / 2, 15 + Drawer.this.tc.lastX[n + 1] * Drawer.this.cellSize + Drawer.this.cellSize / 2, 15 + Drawer.this.tc.lastY[n + 1] * Drawer.this.cellSize + Drawer.this.cellSize / 2);
                        graphics.fillOval(15 + Drawer.this.tc.lastX[n] * Drawer.this.cellSize + Drawer.this.cellSize / 4, 15 + Drawer.this.tc.lastY[n] * Drawer.this.cellSize + Drawer.this.cellSize / 4, Drawer.this.cellSize / 2, Drawer.this.cellSize / 2);
                    }
                }
                n = 40 + Drawer.this.boardSize * Drawer.this.cellSize;
                graphics.setColor(Color.BLACK);
                graphics.setFont(new Font("Arial", 1, 12));
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.drawString("Board size = " + Drawer.this.boardSize, n, 30);
                graphics2D.drawString("Pegs at start = " + Drawer.this.tc.pegStartCnt, n, 50);
                graphics2D.drawString("Pegs on board = " + Drawer.this.tc.pegNowCnt, n, 70);
                graphics2D.drawString("Jumps = " + Drawer.this.tc.numJumps, n, 90);
                if (Drawer.this.tc.lastScore > 0) {
                    graphics2D.drawString("Sequence score = " + Drawer.this.tc.lastScore, n, 110);
                }
                graphics2D.drawString("Score = " + Drawer.this.tc.score, n, 140);
                for (int i = 0; i < Drawer.this.tc.pegTypeCnt; ++i) {
                    float f3 = (float)i / (float)Drawer.this.tc.pegTypeCnt;
                    graphics.setColor(Color.getHSBColor(f3, 0.9f, 1.0f));
                    graphics.fillOval(n, 170 + i * Drawer.this.cellSize + 1, Drawer.this.cellSize - 1, Drawer.this.cellSize - 1);
                    graphics.setColor(Color.BLACK);
                    graphics2D.drawString(Integer.toString(Drawer.this.tc.pegValue[i]), n + Drawer.this.cellSize * 2, 180 + i * Drawer.this.cellSize + 1);
                }
            }
        }
    }

    class DrawerKeyListener
    extends KeyAdapter {
        DrawerKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = Drawer.this.keyMutex;
            synchronized (object) {
                if (keyEvent.getKeyChar() == ' ') {
                    boolean bl = Drawer.this.pauseMode = !Drawer.this.pauseMode;
                }
                if (keyEvent.getKeyChar() == 'd') {
                    Drawer.this.debugMode = !Drawer.this.debugMode;
                }
                Drawer.this.keyPressed = true;
                Drawer.this.keyMutex.notifyAll();
            }
        }
    }
}

