/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class OrdinalTraitAssociationMappingTester {
    Process solution;
    BufferedReader reader;
    PrintWriter writer;
    final int GENE_CNT = 2913;
    final int IND_CNT = 281;
    static String solutionCmd = null;
    static String genotypeFile = "genotype.dat";
    static String componentsFile = "comp_id.dat";
    static String inputFile = "trait_inputs.tsv";
    static String answerFile = "trait_answers.tsv";
    static boolean debugInfo = true;

    String[] loadStringData(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        int N = Integer.parseInt(br.readLine());
        String[] res = new String[N];
        int i = 0;
        while (i < N) {
            res[i] = br.readLine();
            ++i;
        }
        br.close();
        return res;
    }

    int[] loadIntData(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        int N = Integer.parseInt(br.readLine());
        int[] res = new int[N];
        int i = 0;
        while (i < N) {
            res[i] = Integer.parseInt(br.readLine());
            ++i;
        }
        br.close();
        return res;
    }

    int[][] load2DIntData(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        int N = Integer.parseInt(br.readLine());
        int[][] res = new int[N][];
        int i = 0;
        while (i < N) {
            String[] items = br.readLine().split("\t");
            res[i] = new int[items.length];
            int j = 0;
            while (j < items.length) {
                res[i][j] = Integer.parseInt(items[j]);
                ++j;
            }
            ++i;
        }
        br.close();
        return res;
    }

    double func(double prec) {
        if (prec <= 0.9) {
            return 0.1111111111111111 * prec;
        }
        if (prec <= 0.95) {
            return 0.1 + 16.0 * (prec - 0.9);
        }
        return 0.9 + 2.0 * (prec - 0.95);
    }

    double runTest() {
        int j;
        String[] genotype = null;
        try {
            genotype = this.loadStringData(genotypeFile);
        }
        catch (Exception e) {
            System.err.println("Unable to read genotype data from " + genotypeFile + ". " + "Please check that it exists and has appropriate format.");
            return 0.0;
        }
        int[] compId = null;
        try {
            compId = this.loadIntData(componentsFile);
        }
        catch (Exception e) {
            System.err.println("Unable to read components data from " + componentsFile + ". " + "Please check that it exists and has appropriate format.");
            return 0.0;
        }
        int[][] traitInputs = null;
        try {
            traitInputs = this.load2DIntData(inputFile);
        }
        catch (Exception e) {
            System.err.println("Unable to read trait inputs data from " + inputFile + ". " + "Please check that it exists and has appropriate format.");
            return 0.0;
        }
        int[][] traitAnswers = null;
        try {
            traitAnswers = this.load2DIntData(answerFile);
        }
        catch (Exception e) {
            System.err.println("Unable to read trait answers data from " + answerFile + ". " + "Please check that it exists and has appropriate format.");
            return 0.0;
        }
        if (genotype.length != 281) {
            System.err.println("Genotype data must consist of 281 lines.");
            return 0.0;
        }
        int i = 0;
        while (i < genotype.length) {
            if (genotype[i].length() != 2913) {
                System.err.println("Element " + i + " (0-based) of genotype data must" + " contain " + 2913 + " characters.");
                return 0.0;
            }
            j = 0;
            while (j < genotype.length) {
                char c = genotype[i].charAt(j);
                if (c != '+' && c != '-' && c != 'X') {
                    System.err.println("Character " + j + " (0-based) in element " + i + " (0-based)" + " of genotype data must be '+', '-' or 'X'.");
                    return 0.0;
                }
                ++j;
            }
            ++i;
        }
        if (compId.length != 2913) {
            System.err.println("Components data must contain exactly 2913 elements.");
            return 0.0;
        }
        if (traitInputs.length != traitAnswers.length) {
            System.err.println("Trait inputs and trait answers contain different amount of traits: " + traitInputs.length + " and " + traitAnswers.length + ".");
            return 0.0;
        }
        i = 0;
        while (i < traitInputs.length) {
            if (traitInputs[i].length != 281) {
                System.err.println("Input data for trait " + i + " (0-based) must contain " + "exactly " + 281 + " elements.");
                return 0.0;
            }
            j = 0;
            while (j < 281) {
                if (traitInputs[i][j] < 1 || traitInputs[i][j] > 5) {
                    System.err.println("Element " + j + " (0-based) in input data for trait " + i + " (0-based) " + "must be between 1 and 5, inclusive.");
                    return 0.0;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < traitAnswers.length) {
            if (traitAnswers[i].length != 2913) {
                System.err.println("Answer data for trait " + i + " (0-based) must contain " + "exactly " + 2913 + " elements.");
                return 0.0;
            }
            j = 0;
            while (j < 2913) {
                if (traitAnswers[i][j] != 0 && traitAnswers[i][j] != 1) {
                    System.err.println("Element " + j + " (0-based) in answer data for trait " + i + " (0-based) " + "must be 0 or 1.");
                    return 0.0;
                }
                ++j;
            }
            ++i;
        }
        this.writer.println(281);
        i = 0;
        while (i < 281) {
            this.writer.println(genotype[i]);
            ++i;
        }
        this.writer.flush();
        double avePrec = 0.0;
        double aveRec = 0.0;
        int i2 = 0;
        while (i2 < traitInputs.length) {
            this.writer.println(281);
            int j2 = 0;
            while (j2 < 281) {
                this.writer.println(traitInputs[i2][j2]);
                ++j2;
            }
            this.writer.flush();
            int retLen = -1;
            try {
                retLen = Integer.parseInt(this.reader.readLine());
            }
            catch (Exception e) {
                System.err.println("Unable to read your return value for trait " + i2 + " (0-based).");
                return 0.0;
            }
            if (retLen != 2913) {
                System.err.println("Your return value for trait " + i2 + " (0-based) must contain" + " exactly " + 2913 + " elements.");
                return 0.0;
            }
            int[] ret = new int[2913];
            int j3 = 0;
            while (j3 < 2913) {
                ret[j3] = -1;
                try {
                    ret[j3] = Integer.parseInt(this.reader.readLine());
                }
                catch (Exception e) {
                    System.err.println("Unable to read element " + j3 + " (0-based) of your return value " + "for trait " + i2 + " (0-based).");
                    return 0.0;
                }
                if (ret[j3] != 0 && ret[j3] != 1) {
                    System.err.println("Element " + j3 + " (0-based) of your return value for trait " + i2 + " (0-based) must be 0 or 1.");
                    return 0.0;
                }
                ++j3;
            }
            boolean[] ansComp = new boolean[2913];
            int j4 = 0;
            while (j4 < 2913) {
                if (traitAnswers[i2][j4] == 1) {
                    ansComp[compId[j4]] = true;
                }
                ++j4;
            }
            boolean[] retComp = new boolean[2913];
            int j5 = 0;
            while (j5 < 2913) {
                if (ret[j5] == 1) {
                    retComp[compId[j5]] = true;
                }
                ++j5;
            }
            int X = 0;
            int Y = 0;
            int Z = 0;
            int j6 = 0;
            while (j6 < 2913) {
                if (ansComp[j6] && retComp[j6]) {
                    ++X;
                }
                if (ansComp[j6] && !retComp[j6]) {
                    ++Y;
                }
                if (!ansComp[j6] && retComp[j6]) {
                    ++Z;
                }
                ++j6;
            }
            if (debugInfo) {
                System.out.println("Trait #" + i2 + ": X = " + X + ", Y = " + Y + " Z = " + Z);
            }
            aveRec += (double)X / (double)(X + Y);
            if (X + Z > 0) {
                avePrec += (double)X / (double)(X + Z);
            }
            ++i2;
        }
        this.writer.println(0);
        this.writer.flush();
        if (traitInputs.length > 0) {
            aveRec /= (double)traitInputs.length;
            avePrec /= (double)traitInputs.length;
        }
        if (debugInfo) {
            System.out.println("Average recall: " + aveRec);
            System.out.println("Average precision: " + avePrec);
        }
        return 1000000.0 * aveRec * this.func(avePrec);
    }

    public OrdinalTraitAssociationMappingTester() throws Exception {
        try {
            this.solution = Runtime.getRuntime().exec(solutionCmd);
        }
        catch (Exception e) {
            System.err.println("ERROR: unable to execute your solution");
            e.printStackTrace();
            System.exit(0);
        }
        this.reader = new BufferedReader(new InputStreamReader(this.solution.getInputStream()));
        this.writer = new PrintWriter(this.solution.getOutputStream());
        new ErrorStreamRedirector(this.solution.getErrorStream()).start();
        double score = this.runTest();
        this.solution.destroy();
        System.out.println("Overall score = " + score);
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-exec")) {
                solutionCmd = args[++i];
            } else if (args[i].equals("-inp")) {
                inputFile = args[++i];
            } else if (args[i].equals("-ans")) {
                answerFile = args[++i];
            } else if (args[i].equals("-gen")) {
                genotypeFile = args[++i];
            } else if (args[i].equals("-comp")) {
                componentsFile = args[++i];
            } else if (args[i].equals("-silent")) {
                debugInfo = false;
            } else {
                System.out.println("WARNING: unknown argument " + args[i]);
            }
            ++i;
        }
        if (solutionCmd == null) {
            System.err.println("ERROR: please specify the command to execute your solution using -exec \"command\"");
            System.exit(0);
        }
        new OrdinalTraitAssociationMappingTester();
    }

    class ErrorStreamRedirector
    extends Thread {
        BufferedReader reader;

        public ErrorStreamRedirector(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            while (true) {
                String s = null;
                try {
                    s = this.reader.readLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                if (s == null) break;
                System.err.println(s);
            }
        }
    }
}

