/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class Runner {
    boolean paused = false;
    boolean running = false;
    Process pr;
    Scanner input;
    InputStream error;
    DataOutputStream os;
    Stepper stepper;
    Problem prob;
    Display dis;
    int pause;
    boolean man;
    int curPlayer = 1;
    int cantmove = 0;

    public Runner(Problem problem, Display display) {
        this.prob = problem;
        this.dis = display;
    }

    public void start(boolean bl) {
        boolean bl2 = Main.c != null && Main.c.manual.isSelected();
        this.running = true;
        this.paused = false;
        try {
            if (!bl2) {
                this.pr = Runtime.getRuntime().exec(Main.getProcess());
                this.input = new Scanner(this.pr.getInputStream());
                this.error = this.pr.getErrorStream();
                this.os = new DataOutputStream(this.pr.getOutputStream());
                new ErrorReader().start();
                this.os.flush();
            }
            this.cantmove = 0;
            this.curPlayer = 1;
            if (bl) {
                this.stepper = new Stepper(bl2);
                this.stepper.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void stop() {
        if (this.stepper != null) {
            this.stepper.interrupt();
        }
        this.running = false;
        if (this.pr != null) {
            this.pr.destroy();
            this.pr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean step() throws IOException, InterruptedException {
        if (!this.running) {
            return false;
        }
        Object object = Main.lock;
        synchronized (object) {
            int n;
            if (this.cantmove == 5) {
                this.running = false;
                return false;
            }
            int n2 = this.prob.size;
            int n3 = this.prob.players;
            boolean bl = false;
            if (this.curPlayer == 1) {
                for (int i = 0; i < n2; ++i) {
                    for (n = 0; n < n2; ++n) {
                        if (this.prob.board[i][n] != 0 || this.prob.doMove(this.prob.board, 1, i, n) == null) continue;
                        bl = true;
                    }
                }
            }
            if (this.curPlayer == 1 && bl) {
                this.cantmove = 0;
                Object object2 = Main.move;
                synchronized (object2) {
                    int n4;
                    Object object3;
                    if (this.man && this.dis.x == -1) {
                        Main.move.wait();
                    }
                    if (!this.man) {
                        object3 = this.prob.getBoard();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(((String[])object3).length);
                        for (int i = 0; i < ((String[])object3).length; ++i) {
                            stringBuffer.append(' ').append(object3[i]);
                        }
                        stringBuffer.append('\n');
                        this.os.write(stringBuffer.toString().getBytes());
                        this.os.flush();
                        n = this.input.nextInt();
                        n4 = this.input.nextInt();
                    } else {
                        n = this.dis.x;
                        n4 = this.dis.y;
                        this.dis.y = -1;
                        this.dis.x = -1;
                    }
                    if (n < 0 || n4 < 0 || n >= n2 || n4 >= n2) {
                        Main.addFatalError("Return value outside the board.");
                        return false;
                    }
                    if (this.prob.board[n4][n] != 0) {
                        Main.addFatalError("Invalid move.");
                        return false;
                    }
                    object3 = this.prob.doMove(this.prob.board, this.curPlayer, n4, n);
                    if (object3 == null) {
                        Main.addFatalError("Invalid move.");
                        return false;
                    }
                    this.prob.board = (int[][])object3;
                }
            } else {
                this.cantmove = this.curPlayer > 1 ? (this.prob.doNextMove(this.curPlayer) ? 0 : ++this.cantmove) : ++this.cantmove;
            }
            ++this.curPlayer;
            if (this.curPlayer > n3) {
                this.curPlayer = 1;
            }
            if (!Main.novis) {
                this.dis.vis.repaint();
            }
            return true;
        }
    }

    public void pause() {
        if (this.paused) {
            boolean bl = Main.c.manual.isSelected();
            this.paused = false;
            new Stepper(bl).start();
        } else {
            this.paused = true;
        }
    }

    public void setPause(int n) {
        this.pause = n;
    }

    public class ErrorReader
    extends Thread {
        public void run() {
            try {
                int n;
                byte[] byArray = new byte[50000];
                while ((n = Runner.this.error.read(byArray)) > 0 && Runner.this.running) {
                    String string = new String(byArray, 0, n);
                    Main.addMessage(string);
                }
                Main.addMessage("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Stepper
    extends Thread {
        public Stepper(boolean bl) {
            Runner.this.man = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                int n;
                while (Runner.this.running && !Runner.this.paused) {
                    try {
                        Runner.this.step();
                        if (Runner.this.paused) continue;
                        Thread.sleep(Runner.this.pause);
                    }
                    catch (InterruptedException interruptedException) {
                        Runner.this.running = false;
                    }
                    catch (Exception exception) {
                        Runner.this.running = false;
                        try {
                            Thread.sleep(5L);
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        exception.printStackTrace();
                        Main.addFatalError(exception.getMessage());
                    }
                }
                int[] nArray = new int[Runner.this.prob.players];
                for (int i = 0; i < Runner.this.prob.size; ++i) {
                    for (n = 0; n < Runner.this.prob.size; ++n) {
                        if (Runner.this.prob.board[i][n] <= 0) continue;
                        int n2 = Runner.this.prob.board[i][n] - 1;
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                String string = "Scores = {" + nArray[0];
                for (n = 1; n < nArray.length; ++n) {
                    string = string + ", " + nArray[n];
                }
                string = string + "} - " + (double)nArray[0] / (double)Runner.this.prob.size / (double)Runner.this.prob.size * (double)Runner.this.prob.players;
                Main.addFatalError(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            if (!Runner.this.running && Runner.this.pr != null) {
                Runner.this.pr.destroy();
            }
        }
    }
}

