/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;

public class MovingNQueensVis {
    final int MIN_NQ = 8;
    final int MAX_NQ = 100;
    int NQ;
    int[] QR;
    int[] QC;
    int rawScore;
    int maxMoves;
    static String exec;
    static boolean debug;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;

    void generate(String string) {
        try {
            int n;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(Long.parseLong(string));
            this.NQ = string.equals("1") ? 8 : secureRandom.nextInt(93) + 8;
            if (debug) {
                System.out.println("Number of queens = " + this.NQ);
            }
            int n2 = (int)Math.sqrt(this.NQ) + 1;
            int n3 = n2 * 2;
            int n4 = secureRandom.nextInt(n3 - n2 + 1) + n2;
            if (debug) {
                System.out.println("Initial arrangement size = " + n4);
            }
            this.QR = new int[this.NQ];
            this.QC = new int[this.NQ];
            char[][] cArray = new char[n4][n4];
            for (n = 0; n < n4; ++n) {
                Arrays.fill(cArray[n], '.');
            }
            int n5 = 0;
            while (n5 < this.NQ) {
                int n6;
                n = secureRandom.nextInt(n4);
                if (cArray[n][n6 = secureRandom.nextInt(n4)] != '.') continue;
                cArray[n][n6] = 81;
                this.QR[n5] = n;
                this.QC[n5] = n6;
                ++n5;
            }
            if (debug) {
                for (int i = 0; i < n4; ++i) {
                    System.out.println(new String(cArray[i]));
                }
                System.out.println();
            }
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while generating the test case.");
            exception.printStackTrace();
        }
    }

    boolean isValidMove(int n, int n2) {
        return n == 0 || n2 == 0 || n == n2 || n == -n2;
    }

    public double runTest(String string) {
        try {
            int n;
            this.generate(string);
            this.rawScore = 0;
            this.maxMoves = this.NQ * 8;
            String[] stringArray = this.rearrange(this.QR, this.QC);
            if (stringArray == null || stringArray.length == 0) {
                this.addFatalError("Your return must contain at least one element.");
                return 0.0;
            }
            if (stringArray.length > this.maxMoves) {
                this.addFatalError("Your return can contain at most " + this.maxMoves + " elements (contains " + stringArray.length + ").");
                return 0.0;
            }
            for (n = 0; n < stringArray.length; ++n) {
                int n2;
                int n3;
                int n4;
                String[] stringArray2 = stringArray[n].split(" ");
                if (stringArray2.length != 3) {
                    this.addFatalError("Each element of your return must be formatted as \"INDEX ROW COL\" (element " + n + " is \"" + stringArray[n] + "\").");
                    return 0.0;
                }
                try {
                    n4 = Integer.parseInt(stringArray2[0]);
                    n3 = Integer.parseInt(stringArray2[1]);
                    n2 = Integer.parseInt(stringArray2[2]);
                }
                catch (Exception exception) {
                    this.addFatalError("Each element of your return must be formatted as \"INDEX ROW COL\" (element " + n + " is \"" + stringArray[n] + "\").");
                    return 0.0;
                }
                if (n4 < 0 || n4 >= this.NQ) {
                    this.addFatalError("Element " + n + ": invalid queen index " + n4 + ".");
                    return 0.0;
                }
                int n5 = n3 - this.QR[n4];
                int n6 = n2 - this.QC[n4];
                if (n5 == 0 && n6 == 0) {
                    this.addFatalError("Element " + n + ": a queen must move at least one square (queen " + n4 + " stayed at (" + n3 + "," + n2 + ")).");
                    return 0.0;
                }
                if (!this.isValidMove(n5, n6)) {
                    this.addFatalError("Element " + n + ": a queen can move in a straight line vertically, horizontally or diagonally only (queen " + n4 + " moved by (" + n5 + "," + n6 + ")).");
                    return 0.0;
                }
                int n7 = Math.max(Math.abs(n5), Math.abs(n6));
                n5 /= n7;
                n6 /= n7;
                for (int i = 0; i < this.NQ; ++i) {
                    int n8;
                    int n9;
                    int n10;
                    if (n4 == i || !this.isValidMove(n10 = this.QR[i] - this.QR[n4], n9 = this.QC[i] - this.QC[n4])) continue;
                    if (n5 != (n10 /= (n8 = Math.max(Math.abs(n10), Math.abs(n9)))) || n6 != (n9 /= n8) || n8 > n7) continue;
                    this.addFatalError("Element " + n + ": a queen can move only over unoccupied squares (queen " + n4 + " passed queen " + i + " at (" + this.QR[i] + "," + this.QC[i] + ")).");
                    return 0.0;
                }
                this.rawScore += Math.max(Math.abs(n3 - this.QR[n4]), Math.abs(n2 - this.QC[n4]));
                this.QR[n4] = n3;
                this.QC[n4] = n2;
            }
            for (n = 0; n < this.NQ; ++n) {
                for (int i = n + 1; i < this.NQ; ++i) {
                    if (!this.isValidMove(this.QR[n] - this.QR[i], this.QC[n] - this.QC[i])) continue;
                    this.addFatalError("After all moves queens " + n + " and " + i + " threaten each other.");
                    return 0.0;
                }
            }
            return this.rawScore;
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String checkData(String string) {
        return "";
    }

    public String displayTestCase(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Seed = " + string + "\n");
        this.generate(string);
        stringBuffer.append("Number of queens = " + this.NQ + "\n");
        for (int i = 0; i < this.NQ; ++i) {
            stringBuffer.append("(" + this.QR[i] + "," + this.QC[i] + ") ");
        }
        return stringBuffer.toString();
    }

    public double[] score(double[][] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < dArray[0].length; ++n) {
            int n2;
            double d = -1.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (!(d < 0.0) && (!(dArray[n2][n] > 0.0) || !(d > dArray[n2][n]))) continue;
                d = dArray[n2][n];
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (dArray[n2][n] == 0.0) continue;
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + d / dArray[n2][n];
            }
        }
        return dArray2;
    }

    String[] rearrange(int[] nArray, int[] nArray2) throws IOException {
        String[] stringArray = new String[]{};
        if (exec != null) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.NQ).append('\n');
            for (n = 0; n < this.NQ; ++n) {
                stringBuffer.append(nArray[n]).append('\n');
            }
            stringBuffer.append(this.NQ).append('\n');
            for (n = 0; n < this.NQ; ++n) {
                stringBuffer.append(nArray2[n]).append('\n');
            }
            this.os.write(stringBuffer.toString().getBytes());
            this.os.flush();
            int n2 = Integer.parseInt(this.br.readLine());
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = this.br.readLine();
            }
        }
        return stringArray;
    }

    public MovingNQueensVis(String string) {
        try {
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        debug = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (!stringArray[i].equals("-debug")) continue;
            debug = true;
        }
        MovingNQueensVis movingNQueensVis = new MovingNQueensVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

