/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Scanner;

public class Runner {
    boolean paused = false;
    boolean running = false;
    Process pr;
    Scanner input;
    InputStream error;
    DataOutputStream os;
    Problem prob;
    Display dis;
    int pause;
    Object plock = new Object();
    ErrorReader er;
    long tt = 0L;

    public Runner(Problem problem, Display display) {
        this.prob = problem;
        this.dis = display;
    }

    public void start(boolean bl) {
        Stepper stepper;
        block16: {
            this.running = true;
            this.paused = !bl;
            stepper = new Stepper();
            try {
                int n;
                if (Main.manual()) {
                    stepper.dir = new int[0];
                    stepper.end = new double[0];
                    break block16;
                }
                this.pr = Runtime.getRuntime().exec(Main.getProcess());
                this.input = new Scanner(this.pr.getInputStream());
                this.error = this.pr.getErrorStream();
                this.os = new DataOutputStream(this.pr.getOutputStream());
                this.er = new ErrorReader();
                this.er.start();
                this.os.write((this.prob.W + " " + this.prob.H + " " + this.prob.D + " " + this.prob.N + " " + this.prob.speed + "\n").getBytes());
                for (n = 0; n < this.prob.N; ++n) {
                    this.os.write((this.prob.p[n] + "\n").getBytes());
                }
                this.os.flush();
                try {
                    n = this.input.nextInt();
                    stepper.dir = new int[n];
                    stepper.end = new double[n];
                    for (int i = 0; i < n; ++i) {
                        String string = this.input.next();
                        if (string.equals("UP")) {
                            stepper.dir[i] = -1;
                        } else if (string.equals("DOWN")) {
                            stepper.dir[i] = 1;
                        } else if (string.equals("STAY")) {
                            stepper.dir[i] = 0;
                        } else if (!string.equals("CLOSE")) {
                            Main.addFatalError("Invalid output");
                            return;
                        }
                        if (!string.equals("CLOSE")) {
                            stepper.end[i] = this.input.nextDouble() * (double)this.prob.LCM;
                        } else {
                            stepper.stop = i == 0 ? 0.0 : stepper.end[i - 1];
                        }
                        if (i <= 0) continue;
                        int n2 = i;
                        stepper.end[n2] = stepper.end[n2] + stepper.end[i - 1];
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Main.addFatalError("Invalid output");
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        stepper.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        if (this.pr != null) {
            this.pr.destroy();
            this.pr = null;
        }
        Object object = this.plock;
        synchronized (object) {
            this.plock.notify();
        }
    }

    public void setPause(int n) {
        this.pause = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (!this.paused) {
            this.paused = true;
        } else {
            this.paused = false;
            Object object = this.plock;
            synchronized (object) {
                this.plock.notify();
            }
            this.dis.requestFocus();
        }
    }

    public boolean step() {
        this.dis.requestFocus();
        if (!this.running) {
            return false;
        }
        this.paused = true;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (int i = 0; i < 60; ++i) {
                    try {
                        Object object = Runner.this.plock;
                        synchronized (object) {
                            Runner.this.plock.notify();
                            Runner.this.plock.wait();
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        thread.start();
        return this.running;
    }

    public class ErrorReader
    extends Thread {
        public void run() {
            try {
                int n;
                byte[] byArray = new byte[50000];
                while ((n = Runner.this.error.read(byArray)) > 0 && Runner.this.running) {
                    String string = new String(byArray, 0, n);
                    Main.addMessage(string);
                }
                Main.addMessage("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Stepper
    extends Thread {
        int[] X;
        int[] Y;
        int[] DX;
        int[] DY;
        int[] dir;
        double stop;
        double[] end;
        int W;
        int H;
        int D;
        int N;
        int ptr;

        Stepper() {
            this.stop = 1000 * Runner.this.prob.LCM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.X = Runner.this.prob.X;
            this.Y = Runner.this.prob.Y;
            this.DX = Runner.this.prob.DX;
            this.DY = Runner.this.prob.DY;
            this.W = Runner.this.prob.W2;
            this.H = Runner.this.prob.H2;
            this.D = Runner.this.prob.D2;
            this.N = Runner.this.prob.N;
            int n = 0;
            while ((double)n < this.stop && Runner.this.running) {
                Runner.this.prob.time = (double)(n + 1) / (double)Runner.this.prob.LCM;
                Object object = Runner.this.plock;
                synchronized (object) {
                    if (Runner.this.paused) {
                        Runner.this.plock.notify();
                        try {
                            Runner.this.plock.wait();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                this.step(n);
                if (!Main.novis) {
                    Runner.this.dis.repaintSim(true);
                    try {
                        if (Runner.this.pause != 0 && Runner.this.pause > 100) {
                            Thread.sleep(Runner.this.pause / 10);
                        } else if (Runner.this.pause != 0 && n % 10 == 0) {
                            Thread.sleep(Runner.this.pause);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n;
            }
            Main.addFatalError("Your score is " + Runner.this.prob.score());
            Runner.this.stop();
        }

        void step(int n) {
            double d = n;
            while (this.ptr < this.end.length && (double)(n + 1) >= this.end[this.ptr]) {
                Runner.this.prob.pos += (this.end[this.ptr] - d) * (double)this.dir[this.ptr] * (double)Runner.this.prob.speed;
                d = this.end[this.ptr];
                ++this.ptr;
                if (Runner.this.prob.pos < 0.0) {
                    Runner.this.prob.pos = 0.0;
                }
                if (!(Runner.this.prob.pos > (double)(this.H - this.D))) continue;
                Runner.this.prob.pos = this.H - this.D;
            }
            if (this.ptr < this.end.length && this.end[this.ptr] >= (double)(n + 1)) {
                Runner.this.prob.pos += ((double)(n + 1) - d) * (double)this.dir[this.ptr] * (double)Runner.this.prob.speed;
                if (Runner.this.prob.pos < 0.0) {
                    Runner.this.prob.pos = 0.0;
                }
                if (Runner.this.prob.pos > (double)(this.H - this.D)) {
                    Runner.this.prob.pos = this.H - this.D;
                }
            }
            if (Main.manual()) {
                Runner.this.prob.pos += (double)(Manual.dir * Runner.this.prob.speed);
                if (Runner.this.prob.pos < 0.0) {
                    Runner.this.prob.pos = 0.0;
                }
                if (Runner.this.prob.pos > (double)(this.H - this.D)) {
                    Runner.this.prob.pos = this.H - this.D;
                }
            }
            for (int i = 0; i < this.N; ++i) {
                int n2 = i;
                this.X[n2] = this.X[n2] + this.DX[i];
                int n3 = i;
                this.Y[n3] = this.Y[n3] + this.DY[i];
                if (this.X[i] > this.W) {
                    this.X[i] = 2 * this.W - this.X[i];
                    this.DX[i] = -this.DX[i];
                }
                if (this.X[i] < -this.W) {
                    this.X[i] = -this.X[i] - 2 * this.W;
                    this.DX[i] = -this.DX[i];
                }
                if (this.Y[i] < 0) {
                    this.Y[i] = -this.Y[i];
                    this.DY[i] = -this.DY[i];
                }
                if (this.Y[i] > this.H) {
                    this.Y[i] = 2 * this.H - this.Y[i];
                    this.DY[i] = -this.DY[i];
                }
                if (this.X[i] != 0 || !((double)this.Y[i] < Runner.this.prob.pos) && !((double)this.Y[i] > Runner.this.prob.pos + (double)this.D)) continue;
                this.DX[i] = -this.DX[i];
            }
        }
    }
}

