/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Mars {
    Controller c;
    View v;
    String[] paramNames = new String[]{"seed", "rovers", "a_pockets"};
    static Object runlock = new Object();
    static Object movelock = new Object();

    public String getProcess() {
        if (this.v != null) {
            return this.v.fileName.getText();
        }
        return this.c.process;
    }

    public void setProcess(String string) {
        this.c.process = string;
        if (this.v != null) {
            this.v.fileName.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        new Mars(stringArray);
    }

    public Mars(String[] stringArray) {
        int n = 1000;
        int n2 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        this.c = new Controller();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                bl2 = true;
                this.setProcess(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-drop")) {
                this.c.setDrop(true);
                continue;
            }
            if (stringArray[i].equals("-go")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                bl = true;
                this.c.novis = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-speed")) {
                int n3 = Integer.parseInt(stringArray[++i]);
                this.c.setSlide(n3);
                if (n3 >= 80) {
                    this.c.setPause(100 - n3);
                    continue;
                }
                this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, n3)));
                continue;
            }
            if (!stringArray[i].startsWith("-")) continue;
            String string = stringArray[i].substring(1);
            String string2 = stringArray[++i];
            try {
                Field field = this.c.getClass().getDeclaredField(string);
                field.set(this.c, new Integer(string2));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Invalid parameters");
                return;
            }
        }
        if (this.c.novis && !bl2) {
            System.err.println("You must specify the executable when using -novis");
            return;
        }
        this.c.generate(false, this.c.getSeed());
        if (!this.c.novis) {
            this.v = new View(n);
            this.v.setSize(n2, n);
            this.v.setVisible(true);
        } else {
            System.out.println("rovers = " + this.c.rovers + ", a_pockets = " + this.c.a_pockets);
        }
        if (bl) {
            this.c.start();
        }
    }

    class View
    extends JFrame
    implements WindowListener,
    ChangeListener {
        JTextArea err;
        JTextField fileName;
        JScrollPane scroll;
        JSplitPane splitPane;
        JTextField[] params;
        int position;
        Vis sim;

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Mars.this.c.stop();
            System.exit(0);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        void update(int n, int n2) {
            this.sim.update(n, n2);
        }

        public View(int n) {
            JSlider jSlider = new JSlider(0, 0, 100, Mars.this.c.getSlide());
            jSlider.addChangeListener(this);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.sim = new Vis();
            this.err = new JTextArea("Standard Error from your program, as well as other messages will appear here");
            this.scroll = new JScrollPane(this.err);
            this.splitPane = new JSplitPane(0, this.sim, this.scroll);
            this.splitPane.setDividerLocation(n - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            this.splitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            this.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            this.params = new JTextField[Mars.this.paramNames.length];
            for (int i = 0; i < Mars.this.paramNames.length; ++i) {
                this.params[i] = new JTextField(Mars.this.c.getParameter(Mars.this.paramNames[i]));
                if (i <= this.params.length / 2) {
                    jPanel2.add(new Label(Mars.this.paramNames[i] + ": "));
                    jPanel2.add(this.params[i]);
                    continue;
                }
                jPanel3.add(new Label(Mars.this.paramNames[i] + ": "));
                jPanel3.add(this.params[i]);
            }
            jPanel2.setAlignmentX(0.5f);
            jPanel3.setAlignmentX(0.5f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel4.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mars.this.c.stop();
                    Mars.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.repaintSim(false);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mars.this.c.stop();
                    if (Mars.this.c.getSeed() == Integer.parseInt(View.this.params[0].getText())) {
                        View.this.params[0].setText(String.valueOf(Mars.this.c.newSeed()));
                        Mars.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    } else {
                        Mars.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    }
                    for (int i = 1; i < View.this.params.length; ++i) {
                        View.this.params[i].setText(Mars.this.c.getParameter(Mars.this.paramNames[i]));
                    }
                    View.this.sim.bi = null;
                    View.this.repaintSim(false);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mars.this.c.stop();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Mars.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.repaintSim(false);
                    Mars.this.c.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mars.this.c.stop();
                }
            });
            JPanel jPanel5 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            this.fileName = new JTextField(Mars.this.c.process);
            jPanel5.add(jButton5);
            jPanel5.add(this.fileName);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(View.this);
                    if (n == 0) {
                        View.this.fileName.setText(jFileChooser.getSelectedFile().getPath());
                        Mars.this.c.process = jFileChooser.getSelectedFile().getPath();
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
            this.add((Component)this.splitPane, "Center");
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel6, "South");
            this.addWindowListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValue() >= 80) {
                Mars.this.c.setPause(100 - jSlider.getValue());
            } else {
                Mars.this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue())));
            }
        }

        void addMessage(final String string) {
            final JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            if (!(jScrollBar.getValueIsAdjusting() || jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum() && jScrollBar.getValue() != this.position)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        View.this.err.append(string);
                        View.this.position = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                        jScrollBar.setValue(View.this.position);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.position = -1;
                this.err.append(string);
            }
        }

        void repaintSim(boolean bl) {
            Runnable runnable = new Runnable(){

                public void run() {
                    View.this.sim.paintImmediately(0, 0, View.this.sim.getWidth(), View.this.sim.getHeight());
                }
            };
            if (bl && !Mars.this.c.drop()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.sim.repaint();
            }
        }

        public String getParam(int n) {
            String string = this.params[n].getText();
            return string;
        }

        class Vis
        extends JPanel {
            BufferedImage bi = null;
            int size;

            Vis() {
            }

            void update(int n, int n2) {
                int n3;
                int n4 = (1000 + this.size - 1) / this.size;
                Graphics graphics = this.bi.getGraphics();
                int n5 = n / this.size;
                int n6 = n2 / this.size;
                int n7 = 0;
                int n8 = 0;
                block0: for (n3 = 0; n3 < this.size && n5 * this.size + n3 < 1000; ++n3) {
                    for (int i = 0; i < this.size && n6 * this.size + i < 1000; ++i) {
                        if (Mars.this.c.minerals[0][n5 * this.size + n3][n6 * this.size + i] < 0) {
                            n8 = -1;
                            n7 = -1;
                            n3 = 1000;
                            continue block0;
                        }
                        n7 += Mars.this.c.minerals[0][n5 * this.size + n3][n6 * this.size + i];
                        n8 += Mars.this.c.minerals[1][n5 * this.size + n3][n6 * this.size + i];
                    }
                }
                if (n7 < 0 || n8 < 0) {
                    graphics.setColor(Color.white);
                } else {
                    n3 = Math.min(40 * Math.max(0, n7 * 80 / this.size / this.size - 255) + 40 * Math.max(0, n8 * 80 / this.size / this.size - 255), 255);
                    n7 = Math.max(0, Math.min(n7 * 80 / this.size / this.size, 255));
                    n8 = Math.max(0, Math.min(n8 * 80 / this.size / this.size, 255));
                    graphics.setColor(new Color(n7, n8, n3));
                }
                graphics.fillRect(n5, n6, 1, 1);
            }

            void rebuffer(int n) {
                this.size = n;
                int n2 = (1000 + n - 1) / n;
                this.bi = new BufferedImage(n2, n2, 1);
                Graphics graphics = this.bi.getGraphics();
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n3;
                        int n4 = 0;
                        int n5 = 0;
                        block2: for (n3 = 0; n3 < n && i * n + n3 < 1000; ++n3) {
                            for (int k = 0; k < n && j * n + k < 1000; ++k) {
                                if (Mars.this.c.minerals[0][i * n + n3][j * n + k] < 0) {
                                    n5 = -1;
                                    n4 = -1;
                                    n3 = 1000;
                                    continue block2;
                                }
                                n4 += Mars.this.c.minerals[0][i * n + n3][j * n + k];
                                n5 += Mars.this.c.minerals[1][i * n + n3][j * n + k];
                            }
                        }
                        if (n4 < 0 || n5 < 0) {
                            graphics.setColor(Color.white);
                        } else {
                            n3 = Math.min(40 * Math.max(0, n4 * 80 / n / n - 255) + 40 * Math.max(0, n5 * 80 / n / n - 255), 255);
                            n4 = Math.max(0, Math.min(n4 * 80 / n / n, 255));
                            n5 = Math.max(0, Math.min(n5 * 80 / n / n, 255));
                            graphics.setColor(new Color(n4, n5, n3));
                        }
                        graphics.fillRect(i, j, 1, 1);
                    }
                }
            }

            public void paint(Graphics graphics) {
                int n = Math.max(1, (999 + Math.min(this.getWidth(), this.getHeight())) / Math.min(this.getWidth(), this.getHeight()));
                n = 1;
                if (this.bi == null || this.size != n) {
                    this.rebuffer(n);
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                Font font = new Font(graphics2D.getFont().getName(), 0, 40);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n2 = fontMetrics.getAscent();
                double d = Math.min((double)this.getWidth() / 1000.0, (double)this.getHeight() / (1000.0 + (double)(2 * n2)));
                graphics2D.scale(d, d);
                graphics2D.translate(((double)this.getWidth() - 1000.0 * d) / 2.0 / d, ((double)this.getHeight() - (double)(1000 + 2 * n2) * d) / 2.0 / d);
                graphics2D.drawImage(this.bi, null, 0, 2 * n2);
                graphics2D.setColor(Color.blue);
                for (int i = 0; i < Mars.this.c.roverX.length; ++i) {
                    graphics2D.fillOval(Mars.this.c.roverX[i] - 10, Mars.this.c.roverY[i] - 10 + 2 * n2, 20, 20);
                }
                String string = "Type A Minerals: " + Mars.this.c.mineralsDelivered[0];
                String string2 = "Type B Minerals: " + Mars.this.c.mineralsDelivered[1];
                graphics2D.setColor(new Color(255, 255, 255));
                graphics2D.drawString(string, 0, n2);
                graphics2D.drawString(string2, 0, 2 * n2);
            }
        }
    }

    class Controller {
        String process = "Enter your executable and its arguments here";
        Runner current;
        Random r;
        int ST = 20;
        int slide = 80;
        int seed;
        boolean running;
        boolean novis;
        boolean drop;
        int rovers;
        int a_pockets;
        int bpockets;
        int C;
        int score;
        int time;
        int[][][] minerals;
        int[] noOfMineralPockets;
        int[] roverX;
        int[] roverY;
        double[] roverF;
        int[][] mineralsCollected;
        int[] mineralsDelivered;

        Controller() {
        }

        public void generate(boolean bl, int n) {
            int n2;
            int n3;
            int n4;
            this.seed = n;
            this.r = new Random();
            this.r.setSeed(n);
            if (bl) {
                this.rovers = this.r.nextInt(6) + 5;
                this.a_pockets = this.r.nextInt(201) + 50;
            } else {
                if (this.rovers == 0) {
                    this.rovers = this.r.nextInt(6) + 5;
                } else {
                    this.r.nextInt(6);
                }
                if (this.a_pockets == 0) {
                    this.a_pockets = this.r.nextInt(201) + 50;
                } else {
                    this.r.nextInt(201);
                }
                if (Mars.this.v != null) {
                    try {
                        for (n4 = 1; n4 < Mars.this.paramNames.length; ++n4) {
                            Field field = this.getClass().getDeclaredField(Mars.this.paramNames[n4]);
                            field.set(this, new Integer(Mars.this.v.getParam(n4)));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.bpockets = 300 - this.a_pockets;
            this.minerals = new int[2][1000][1000];
            this.noOfMineralPockets = new int[2];
            n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < 1000; ++n3) {
                for (n2 = 0; n2 < 1000; ++n2) {
                    this.minerals[1][n3][n2] = 0;
                    this.minerals[0][n3][n2] = 0;
                }
            }
            this.noOfMineralPockets[0] = this.a_pockets;
            this.noOfMineralPockets[1] = this.bpockets;
            for (n3 = 0; n3 < 2; ++n3) {
                for (n2 = 0; n2 < this.noOfMineralPockets[n3]; ++n2) {
                    int n6 = this.r.nextInt(2001) + 2000;
                    int n7 = this.r.nextInt(1000);
                    int n8 = this.r.nextInt(1000);
                    double d = this.r.nextDouble() * 60.0 + 10.0;
                    for (int i = 0; i < n6; ++i) {
                        int n9 = (int)(this.r.nextGaussian() * d + (double)n7 + 0.5);
                        int n10 = (int)(this.r.nextGaussian() * d + (double)n8 + 0.5);
                        if (n9 < 0 || n9 >= 1000 || n10 < 0 || n10 >= 1000) continue;
                        int[] nArray = this.minerals[n3][n9];
                        int n11 = n10;
                        nArray[n11] = nArray[n11] + 1;
                        if (this.minerals[n3][n9][n10] > n5) {
                            n5 = this.minerals[n3][n9][n10];
                        }
                        ++n4;
                    }
                }
            }
            for (n3 = 450; n3 <= 550; ++n3) {
                for (n2 = 450; n2 <= 550; ++n2) {
                    this.minerals[1][n3][n2] = 0;
                    this.minerals[0][n3][n2] = 0;
                }
            }
            this.roverX = new int[this.rovers];
            this.roverY = new int[this.rovers];
            this.roverF = new double[this.rovers];
            for (n3 = 0; n3 < this.rovers; ++n3) {
                this.roverY[n3] = 500;
                this.roverX[n3] = 500;
                this.roverF[n3] = 2000.0;
            }
            this.mineralsCollected = new int[2][this.rovers];
            this.mineralsDelivered = new int[2];
        }

        void collectMineralsScan(int n, int n2, int n3) {
            int n4 = this.roverX[n];
            int n5 = this.roverY[n];
            if (n4 > n2) {
                int n6 = n4;
                n4 = n2;
                n2 = n6;
                n6 = n5;
                n5 = n3;
                n3 = n6;
            }
            double d = n4;
            double d2 = n5;
            double d3 = n2 - n4;
            double d4 = n3 - n5;
            int n7 = Math.max(Math.min(n4, n2) - 10, 0);
            int n8 = Math.min(Math.max(n4, n2) + 10, 999);
            int n9 = Math.max(Math.min(n5, n3) - 10, 0);
            int n10 = Math.min(Math.max(n5, n3) + 10, 999);
            int n11 = n3 - n5;
            double d5 = 10.0 * Math.hypot(n2 - n4, n3 - n5) / (double)Math.abs(n11);
            double d6 = (n4 - n2) * (n4 - n2) + (n5 - n3) * (n5 - n3);
            for (int i = n9; i <= n10; ++i) {
                int n12;
                double d7;
                double d8;
                int n13 = 999;
                int n14 = 0;
                int n15 = 999;
                int n16 = 999;
                int n17 = 999;
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                if (n3 - n5 != 0) {
                    d8 = (double)((i - n5) * (n2 - n4)) / (double)n11;
                    n15 = (int)((double)n4 + d8 - d5 + 0.999999999);
                    d7 = (double)((n15 - n4) * (n2 - n4) + (i - n5) * (n3 - n5)) / d6;
                    if (d7 >= 0.0 && d7 <= 1.0) {
                        n13 = n15;
                    }
                    if ((d7 = (double)(((n18 = (int)((double)n4 - (d8 = (double)((n5 - i) * (n2 - n4)) / (double)n11) + d5)) - n4) * (n2 - n4) + (i - n5) * (n3 - n5)) / d6) >= 0.0 && d7 <= 1.0) {
                        n14 = n18;
                    }
                }
                if ((d8 = (double)(100 - (n5 - i) * (n5 - i))) >= 0.0) {
                    int n21 = (int)Math.sqrt(d8);
                    n16 = n4 - n21;
                    if (n16 < n13) {
                        n13 = n16;
                    }
                    if ((n19 = n4 + n21) > n14) {
                        n14 = n19;
                    }
                }
                if ((d7 = (double)(100 - (n3 - i) * (n3 - i))) >= 0.0) {
                    n12 = (int)Math.sqrt(d7);
                    n17 = n2 - n12;
                    if (n17 < n13) {
                        n13 = n17;
                    }
                    if ((n20 = n2 + n12) > n14) {
                        n14 = n20;
                    }
                }
                if (n13 < 0) {
                    n13 = 0;
                }
                if (n14 > 999) {
                    n14 = 999;
                }
                for (n12 = n13; n12 <= n14; ++n12) {
                    if (this.minerals[0][n12][i] == -1) continue;
                    int[] nArray = this.mineralsCollected[0];
                    int n22 = n;
                    nArray[n22] = nArray[n22] + this.minerals[0][n12][i];
                    int[] nArray2 = this.mineralsCollected[1];
                    int n23 = n;
                    nArray2[n23] = nArray2[n23] + this.minerals[1][n12][i];
                    this.minerals[1][n12][i] = -1;
                    this.minerals[0][n12][i] = -1;
                    if (this.novis) continue;
                    Mars.this.v.update(n12, i);
                }
            }
        }

        public int getScore() {
            return this.score;
        }

        public int getTime() {
            return this.time;
        }

        void start() {
            if (Mars.this.v != null) {
                Mars.this.v.err.setText("");
            }
            this.current = new Runner();
            this.current.start();
        }

        void stop() {
            this.running = false;
            if (this.current != null) {
                try {
                    if (this.current.pr != null) {
                        this.current.pr.destroy();
                        this.current.pr.waitFor();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.current = null;
            }
        }

        public int newSeed() {
            return this.r.nextInt();
        }

        public void setSeed(int n) {
            this.seed = n;
        }

        public int getSeed() {
            return this.seed;
        }

        public String getParameter(String string) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                return field.get(this).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "ERR";
            }
        }

        public void setParameter(String string, String string2) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                field.set(this, Integer.parseInt(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getSlide() {
            return this.slide;
        }

        public void setSlide(int n) {
            this.slide = n;
        }

        public void setPause(int n) {
            this.ST = n;
        }

        public void addMessage(String string) {
            if (this.novis) {
                System.out.print(string);
            } else {
                Mars.this.v.addMessage(string);
            }
        }

        public void addFatalError(String string) {
            this.addMessage(string);
        }

        public boolean drop() {
            return this.drop;
        }

        public void setDrop(boolean bl) {
            this.drop = bl;
        }

        class Runner
        extends Thread {
            Process pr;
            BufferedReader input;
            InputStream error;
            DataOutputStream os;

            Runner() {
            }

            void writeParams() throws IOException {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Controller.this.rovers).append('\n');
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 1000; ++j) {
                        for (int k = 0; k < 1000; ++k) {
                            stringBuffer.append(Controller.this.minerals[i][k][j]).append(' ');
                        }
                    }
                    stringBuffer.setCharAt(stringBuffer.length() - 1, '\n');
                }
                this.os.write(stringBuffer.toString().getBytes());
                this.os.flush();
            }

            int[] next() throws IOException {
                String string = this.input.readLine();
                if (string == null) {
                    return null;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int[] nArray = new int[]{Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())};
                return nArray;
            }

            public void run() {
                this.runTest();
                this.pr.destroy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runTest() {
                Controller.this.running = true;
                try {
                    Object object = runlock;
                    synchronized (object) {
                        this.pr = Runtime.getRuntime().exec(Mars.this.getProcess());
                        this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
                        this.error = this.pr.getErrorStream();
                        this.os = new DataOutputStream(this.pr.getOutputStream());
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            public void run() {
                                Runner.this.pr.destroy();
                            }
                        }));
                        Controller.this.time = 0;
                        Controller.this.score = 0;
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    int n;
                                    byte[] byArray = new byte[50000];
                                    while ((n = Runner.this.error.read(byArray)) > 0 && Controller.this.running) {
                                        Controller.this.addMessage(new String(byArray, 0, n));
                                    }
                                    Controller.this.addMessage("\n");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        thread.start();
                        boolean bl = false;
                        this.writeParams();
                        while (Controller.this.running) {
                            int[] nArray = this.next();
                            if (nArray == null) {
                                Controller.this.addFatalError("Program terminated\n");
                                break;
                            }
                            if (nArray[0] < 0 || nArray[0] >= Controller.this.rovers) {
                                Controller.this.addFatalError("Invalid roverId: " + nArray[0]);
                                break;
                            }
                            if (nArray[1] < 0 || nArray[1] >= 1000) {
                                Controller.this.addFatalError("Invalid x_coord: " + nArray[1]);
                                break;
                            }
                            if (nArray[2] < 0 || nArray[2] >= 1000) {
                                Controller.this.addFatalError("Invalid y_coord: " + nArray[2]);
                                break;
                            }
                            Object object2 = movelock;
                            synchronized (object2) {
                                int n = nArray[0];
                                int n2 = nArray[1];
                                int n3 = nArray[2];
                                double d = Math.hypot(Controller.this.roverX[n] - n2, Controller.this.roverY[n] - n3);
                                int n4 = n;
                                Controller.this.roverF[n4] = Controller.this.roverF[n4] - d;
                                if (Controller.this.roverF[n] >= 0.0) {
                                    Controller.this.collectMineralsScan(n, n2, n3);
                                    Controller.this.roverX[n] = n2;
                                    Controller.this.roverY[n] = n3;
                                    if (n2 == 500 && n3 == 500) {
                                        Controller.this.mineralsDelivered[0] = Controller.this.mineralsDelivered[0] + Controller.this.mineralsCollected[0][n];
                                        Controller.this.mineralsDelivered[1] = Controller.this.mineralsDelivered[1] + Controller.this.mineralsCollected[1][n];
                                        Controller.this.mineralsCollected[0][n] = 0;
                                        Controller.this.mineralsCollected[1][n] = 0;
                                    }
                                } else {
                                    Controller.this.addMessage("Out of fuel: " + n + "\n");
                                }
                            }
                            if (Controller.this.novis) continue;
                            Mars.this.v.repaintSim(true);
                            if (Controller.this.ST == 0) continue;
                            Thread.sleep(Controller.this.ST);
                        }
                        Controller.this.addMessage("You scored " + Math.min(Mars.this.c.mineralsDelivered[0], Mars.this.c.mineralsDelivered[1]) + " points\n");
                        this.os.writeBytes("-1 -1\n");
                        this.os.flush();
                    }
                }
                catch (IOException iOException) {
                    Controller.this.addMessage("Simulation over because communication between the visualizer and your process ended.\n");
                    Controller.this.addMessage(iOException.getMessage() + "\n");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

