/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;

public class MapRecoloringVis {
    static int minS = 20;
    static int maxS = 200;
    static int minC = 2;
    static int maxC = 5;
    static int[] dr = new int[]{1, 0, -1, 0};
    static int[] dc = new int[]{0, 1, 0, -1};
    int H;
    int W;
    int R;
    int[][] regions;
    int[][] oldColors;
    int[] newColors;
    int[] regPrimaryColor;
    static String exec;
    static String fileName;
    static boolean vis;
    static boolean debug;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    static int SZX;
    static int SZY;
    List<Color> palette;

    boolean isInside(int n, int n2) {
        return n >= 0 && n < this.H && n2 >= 0 && n2 < this.W;
    }

    int getColor(boolean bl, int n, int n2) {
        return bl ? this.newColors[this.regions[n][n2]] : this.oldColors[n][n2];
    }

    String generate(String string) {
        try {
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.H = secureRandom.nextInt(maxS - minS + 1) + minS;
            this.W = secureRandom.nextInt(maxS - minS + 1) + minS;
            int n10 = secureRandom.nextInt(maxC - minC + 1) + minC;
            if (l == 1L) {
                this.W = this.H = minS;
                n10 = 2;
            } else if (l == 2L) {
                this.W = this.H = maxS;
                n10 = maxC;
            }
            int n11 = secureRandom.nextInt(41) + 10;
            this.R = this.W * this.H / n11;
            this.regions = new int[this.H][this.W];
            for (n9 = 0; n9 < this.H; ++n9) {
                Arrays.fill(this.regions[n9], -1);
            }
            for (n9 = 0; n9 < this.R; ++n9) {
                n8 = secureRandom.nextInt(4) + 1;
                for (n7 = 0; n7 < n8; ++n7) {
                    while (this.regions[n6 = secureRandom.nextInt(this.H - 2) + 1][n5 = secureRandom.nextInt(this.W - 2) + 1] != -1) {
                    }
                    this.regions[n6][n5] = n9;
                }
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n8 = 0; n8 < this.H; ++n8) {
                for (n7 = 0; n7 < this.W; ++n7) {
                    if (this.regions[n8][n7] == -1) continue;
                    for (n6 = 0; n6 < 4; ++n6) {
                        n5 = n8 + dr[n6];
                        n4 = n7 + dc[n6];
                        if (!this.isInside(n5, n4) || this.regions[n5][n4] != -1 || arrayList.contains(n5 * this.W + n4)) continue;
                        arrayList.add(n5 * this.W + n4);
                    }
                }
            }
            while (!arrayList.isEmpty()) {
                n8 = secureRandom.nextInt(arrayList.size());
                n7 = (Integer)arrayList.get(n8) / this.W;
                n6 = (Integer)arrayList.get(n8) % this.W;
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (n4 = 0; n4 < 4; ++n4) {
                    n3 = n7 + dr[n4];
                    n2 = n6 + dc[n4];
                    if (!this.isInside(n3, n2) || this.regions[n3][n2] == -1) continue;
                    arrayList2.add(n4);
                }
                n4 = (Integer)arrayList2.get(secureRandom.nextInt(arrayList2.size()));
                this.regions[n7][n6] = this.regions[n7 + dr[n4]][n6 + dc[n4]];
                arrayList.remove(n8);
                for (n3 = 0; n3 < 4; ++n3) {
                    n2 = n7 + dr[n3];
                    int n12 = n6 + dc[n3];
                    if (!this.isInside(n2, n12) || this.regions[n2][n12] != -1 || arrayList.contains(n2 * this.W + n12)) continue;
                    arrayList.add(n2 * this.W + n12);
                }
            }
            do {
                this.regPrimaryColor = new int[this.R];
                object = new int[this.R][];
                int[] nArray = new int[this.R];
                for (n6 = 0; n6 < this.R; ++n6) {
                    this.regPrimaryColor[n6] = secureRandom.nextInt(n10);
                    int n13 = secureRandom.nextInt(n10);
                    object[n6] = new int[n13];
                    for (n4 = 0; n4 < n13; ++n4) {
                        do {
                            object[n6][n4] = secureRandom.nextInt(n10);
                        } while (object[n6][n4] == this.regPrimaryColor[n6]);
                    }
                    nArray[n6] = n13 == 0 ? 100 : secureRandom.nextInt(50) + 50;
                }
                this.oldColors = new int[this.H][this.W];
                for (n6 = 0; n6 < this.H; ++n6) {
                    for (int i = 0; i < this.W; ++i) {
                        n4 = this.regions[n6][i];
                        this.oldColors[n6][i] = secureRandom.nextInt(100) < nArray[n4] ? this.regPrimaryColor[n4] : (int)object[n4][secureRandom.nextInt(((Object)object[n4]).length)];
                    }
                }
                n4 = 0;
                for (n3 = 0; n3 < this.H && n4 == 0; ++n3) {
                    for (n2 = 0; n2 < this.W && n4 == 0; ++n2) {
                        int n14;
                        if (n3 > 0 && (n6 = this.regions[n3][n2]) != (n14 = this.regions[n3 - 1][n2]) && this.getColor(false, n3, n2) == this.getColor(false, n3 - 1, n2)) {
                            n4 = 1;
                        }
                        if (n2 <= 0 || (n6 = this.regions[n3][n2]) == (n14 = this.regions[n3][n2 - 1]) || this.getColor(false, n3, n2) != this.getColor(false, n3, n2 - 1)) continue;
                        n4 = 1;
                    }
                }
            } while (n4 == 0);
            if (vis) {
                int n15;
                this.palette = new ArrayList<Color>();
                object = new int[]{0x6633FF, 0xCC33FF, 0xFFCC33, 0x33CCFF, 0x66FF33};
                for (n15 = 0; n15 < this.R && n15 < ((Object)object).length; ++n15) {
                    this.palette.add(new Color((int)object[n15]));
                }
                for (n15 = ((Object)object).length; n15 < this.R; ++n15) {
                    this.palette.add(new Color(secureRandom.nextInt(0x1000000)));
                }
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("H = ").append(this.H).append('\n');
            ((StringBuffer)object).append("W = ").append(this.W).append('\n');
            ((StringBuffer)object).append("R = ").append(this.R).append('\n');
            ((StringBuffer)object).append("Regions:\n");
            for (n = 0; n < this.H; ++n) {
                for (n6 = 0; n6 < this.W; ++n6) {
                    ((StringBuffer)object).append(this.regions[n][n6]).append(" ");
                }
                ((StringBuffer)object).append('\n');
            }
            ((StringBuffer)object).append("Old map colors:\n");
            for (n = 0; n < this.H; ++n) {
                for (n6 = 0; n6 < this.W; ++n6) {
                    ((StringBuffer)object).append(this.oldColors[n][n6]).append(" ");
                }
                ((StringBuffer)object).append('\n');
            }
            return ((StringBuffer)object).toString();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
            return "";
        }
    }

    public double runTest(String string) {
        try {
            int n;
            int n2;
            int n3;
            String string2 = this.generate(string);
            if (debug) {
                System.out.println(string2);
            }
            if (vis) {
                SZX = this.W * SZ + 1;
                SZY = this.H * SZ + 1;
                this.draw(false);
            }
            if (proc != null) {
                int[] nArray = new int[this.H * this.W];
                int[] nArray2 = new int[this.H * this.W];
                for (n3 = 0; n3 < this.H; ++n3) {
                    for (n2 = 0; n2 < this.W; ++n2) {
                        nArray[n3 * this.W + n2] = this.regions[n3][n2];
                        nArray2[n3 * this.W + n2] = this.oldColors[n3][n2];
                    }
                }
                try {
                    this.newColors = this.recolor(this.H, nArray, nArray2);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from recolor.");
                    return -1.0;
                }
                if (this.newColors == null) {
                    this.addFatalError("Your return contained invalid number of elements.");
                    return -1.0;
                }
                if (this.newColors.length != this.R) {
                    this.addFatalError("Your return contained " + this.newColors.length + " elements, and it should have contained " + this.R + ".");
                    return -1.0;
                }
                for (n3 = 0; n3 < this.R; ++n3) {
                    if (this.newColors[n3] >= 0 && this.newColors[n3] < this.R) continue;
                    this.addFatalError("Each color in your return must be between 0 and " + (this.R - 1) + ", inclusive.");
                    return -1.0;
                }
            } else {
                this.newColors = new int[this.R];
                for (int i = 0; i < this.R; ++i) {
                    this.newColors[i] = this.regPrimaryColor[i];
                }
            }
            if (vis) {
                this.draw(true);
            }
            for (n3 = 0; n3 < this.H; ++n3) {
                for (n2 = 0; n2 < this.W; ++n2) {
                    int n4;
                    int n5;
                    if (n3 > 0 && (n5 = this.regions[n3][n2]) != (n4 = this.regions[n3 - 1][n2]) && this.newColors[n5] == this.newColors[n4]) {
                        this.addFatalError("Regions " + n5 + " and " + n4 + " adjacent in pixels (" + (n3 - 1) + "," + n2 + ") and (" + n3 + "," + n2 + ") are of the same color " + this.newColors[n5] + ".");
                        return -1.0;
                    }
                    if (n2 <= 0 || (n5 = this.regions[n3][n2]) == (n4 = this.regions[n3][n2 - 1]) || this.newColors[n5] != this.newColors[n4]) continue;
                    this.addFatalError("Regions " + n5 + " and " + n4 + " adjacent in pixels (" + n3 + "," + (n2 - 1) + ") and (" + n3 + "," + n2 + ") are of the same color " + this.newColors[n5] + ".");
                    return -1.0;
                }
            }
            n3 = 0;
            for (n2 = 0; n2 < this.H; ++n2) {
                for (n = 0; n < this.W; ++n) {
                    if (this.getColor(true, n2, n) == this.getColor(false, n2, n)) continue;
                    ++n3;
                }
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (n = 0; n < this.R; ++n) {
                hashSet.add(this.newColors[n]);
            }
            if (debug) {
                this.addFatalError("Number of colors used: " + hashSet.size());
                this.addFatalError("Number of pixels recolored: " + n3 + " / " + this.H * this.W);
            }
            return 100000.0 * (double)hashSet.size() + (double)n3;
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    int[] recolor(int n, int[] nArray, int[] nArray2) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append("\n");
        stringBuffer.append(nArray.length).append("\n");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            stringBuffer.append(nArray[n2]).append("\n");
        }
        stringBuffer.append(nArray2.length).append("\n");
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            stringBuffer.append(nArray2[n2]).append("\n");
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        n2 = Integer.parseInt(this.br.readLine());
        int[] nArray3 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray3[i] = Integer.parseInt(this.br.readLine());
        }
        return nArray3;
    }

    public void draw(boolean bl) {
        int n;
        int n2;
        int n3;
        BufferedImage bufferedImage = new BufferedImage(SZX, SZY, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, SZX, SZY);
        for (int i = 0; i < this.H; ++i) {
            for (int j = 0; j < this.W; ++j) {
                graphics2D.setColor(this.palette.get(this.getColor(bl, i, j)));
                graphics2D.fillRect(j * SZ + 1, i * SZ + 1, SZ - 1, SZ - 1);
            }
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(new Font("Arial", 0, 9));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (n3 = 0; n3 < this.H; ++n3) {
            for (n2 = 0; n2 < this.W; ++n2) {
                char[] cArray = ("" + this.regions[n3][n2]).toCharArray();
                n = n3 * SZ + SZ / 2 + fontMetrics.getHeight() / 2 - 2;
                graphics2D.drawChars(cArray, 0, cArray.length, n2 * SZ + 2, n);
            }
        }
        for (n3 = 0; n3 <= this.H; ++n3) {
            graphics2D.drawLine(0, n3 * SZ, this.W * SZ, n3 * SZ);
        }
        for (n3 = 0; n3 <= this.W; ++n3) {
            graphics2D.drawLine(n3 * SZ, 0, n3 * SZ, this.H * SZ);
        }
        graphics2D.setStroke(new BasicStroke(3.0f));
        for (n3 = 0; n3 < this.H; ++n3) {
            for (n2 = 0; n2 < this.W; ++n2) {
                int n4;
                if (n3 > 0 && this.regions[n3][n2] != this.regions[n3 - 1][n2] && (n = this.getColor(bl, n3, n2)) == (n4 = this.getColor(bl, n3 - 1, n2))) {
                    graphics2D.drawLine(n2 * SZ, n3 * SZ, (n2 + 1) * SZ, n3 * SZ);
                }
                if (n2 <= 0 || this.regions[n3][n2] == this.regions[n3][n2 - 1] || (n = this.getColor(bl, n3, n2)) != (n4 = this.getColor(bl, n3, n2 - 1))) continue;
                graphics2D.drawLine(n2 * SZ, n3 * SZ, n2 * SZ, (n3 + 1) * SZ);
            }
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(fileName + (bl ? "-res" : "-in") + ".png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MapRecoloringVis(String string) {
        try {
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + String.format("%.0f", this.runTest(string)));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        SZ = 20;
        if (string.equals("1")) {
            SZ = 30;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (!stringArray[i].equals("-debug")) continue;
            debug = true;
        }
        if (exec == null) {
            vis = true;
        }
        if (vis) {
            fileName = string;
        }
        MapRecoloringVis mapRecoloringVis = new MapRecoloringVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

