/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Tester {
    int N;
    int M;
    int D = 4500;
    double[] tmp = new double[3];
    double R = 6378.1;
    double[] x;
    double[] y;
    Random r;
    static String exec;
    static String file;
    static Process proc;
    static int C;
    InputStream is;
    OutputStream os;
    int[][] done;
    BufferedImage bi;
    static boolean projection;
    int color;

    void gen() {
        this.tmp[0] = Math.asin(this.r.nextDouble() * 2.0 - 1.0) / Math.PI * 180.0;
        this.tmp[1] = this.r.nextDouble() * 360.0 - 180.0;
    }

    double haversine(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        double d7 = Math.sin(d5 / 2.0);
        d7 *= d7;
        double d8 = Math.sin(d6 / 2.0);
        d8 *= d8;
        return 2.0 * Math.asin(Math.sqrt(d7 + Math.cos(d) * Math.cos(d3) * d8));
    }

    int[] schedule(int n, int n2, double d, double d2, double[] dArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(dArray.length * 20);
        stringBuffer.append(n).append('\n');
        stringBuffer.append(n2).append('\n');
        stringBuffer.append(d).append('\n');
        stringBuffer.append(d2).append('\n');
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(dArray[i]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        Scanner scanner = new Scanner(this.is);
        int[] nArray = new int[n2 * n];
        try {
            for (int i = 0; i < n2 * n; ++i) {
                nArray[i] = scanner.nextInt();
            }
            return nArray;
        }
        catch (Exception exception) {
            System.err.println("Unable to get your program's output");
            exception.printStackTrace();
            return null;
        }
    }

    double distance(double d, double d2, double d3, double d4) {
        d = d / 180.0 * Math.PI;
        d2 = d2 / 180.0 * Math.PI;
        d3 = d3 / 180.0 * Math.PI;
        d4 = d4 / 180.0 * Math.PI;
        return this.R * this.haversine(d, d2, d3, d4);
    }

    public double runTest(String string) {
        try {
            try {
                this.r = SecureRandom.getInstance("SHA1PRNG");
                this.r.setSeed(Long.parseLong(string));
            }
            catch (Exception exception) {
                return -1.0;
            }
            this.N = this.r.nextInt(71) + 30;
            this.M = this.r.nextInt(26) + 5;
            if (string.equals("1")) {
                this.N = 30;
                this.M = 5;
            } else if (string.equals("2")) {
                this.N = 40;
                this.M = 5;
            } else if (string.equals("10")) {
                this.N = 100;
                this.M = 30;
            }
            double[] dArray = new double[this.N * (this.N + 1) * this.M * 2];
            for (int i = 0; i < dArray.length; i += 2) {
                this.gen();
                dArray[i] = this.tmp[0];
                dArray[i + 1] = this.tmp[1];
            }
            this.gen();
            double d = this.tmp[0];
            double d2 = this.tmp[1];
            int[] nArray = this.schedule(this.M, this.N, d, d2, dArray);
            if (nArray == null) {
                return 0.0;
            }
            if (nArray.length != this.N * this.M) {
                this.addFatalError("Wrong number of elements: " + nArray.length);
                return 0.0;
            }
            boolean[] blArray = new boolean[this.N];
            double d3 = 0.0;
            this.x = new double[(this.N + 1) * this.M + 1];
            this.y = new double[(this.N + 1) * this.M + 1];
            for (int i = 0; i < this.M; ++i) {
                double d4;
                double d5 = d;
                this.x[i * (this.N + 1)] = d4 = d2;
                this.y[i * (this.N + 1)] = d5;
                Arrays.fill(blArray, false);
                for (int j = 0; j < this.N; ++j) {
                    int n = i * this.N + j;
                    if (nArray[n] < 0 || nArray[n] >= this.N || blArray[nArray[n]]) {
                        this.addFatalError("Invalid return in cycle " + i);
                        return 0.0;
                    }
                    blArray[nArray[n]] = true;
                    int n2 = (nArray[n] + (i * (this.N + 1) + j) * this.N) * 2;
                    double d6 = this.distance(d5, d4, dArray[n2], dArray[n2 + 1]);
                    if (d6 > (double)this.D) {
                        d6 += d6;
                    }
                    d3 += d6;
                    d5 = dArray[n2];
                    this.x[i * (this.N + 1) + j + 1] = d4 = dArray[n2 + 1];
                    this.y[i * (this.N + 1) + j + 1] = d5;
                }
                double d7 = this.distance(d5, d4, d, d2);
                if (d7 > (double)this.D) {
                    d7 += d7;
                }
                d3 += d7;
            }
            this.x[this.M * (this.N + 1)] = d2;
            this.y[this.M * (this.N + 1)] = d;
            this.addFatalError("Average Distance = " + d3 / (double)this.M / (double)(this.N + 1));
            return 10000.0 / (d3 / (double)this.M / (double)(this.N + 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1.0;
        }
    }

    double[] project(double d, double d2) {
        if (projection) {
            return this.mollweide(d, d2);
        }
        d2 = d2 / Math.PI * 180.0 + 180.0;
        d = -d / Math.PI * 180.0 + 90.0;
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        if (d2 > 360.0) {
            d2 -= 360.0;
        }
        return new double[]{d2 * (double)C, d * (double)C};
    }

    double[] mollweide(double d, double d2) {
        double d3 = d;
        for (int i = 0; i < 20; ++i) {
            d3 -= d3 + Math.sin(d3) - Math.PI * Math.sin(d);
        }
        d3 /= 2.0;
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        double d4 = 0.6366197723675814 * d2 * Math.cos(d3);
        double d5 = -Math.sin(d3);
        return new double[]{(d4 + 2.0) * (double)C * 90.0, (d5 + 1.0) * (double)C * 90.0};
    }

    void connect(double d, double d2, double d3, double d4, int n) {
        double[] dArray = this.project(d, d2);
        double[] dArray2 = this.project(d3, d4);
        int n2 = (int)dArray[0];
        int n3 = (int)dArray[1];
        int n4 = (int)dArray2[0];
        int n5 = (int)dArray2[1];
        if (n2 == n4 && n3 == n5 || Math.abs(d - d3) < 1.0E-6 && Math.abs(d2 - d4) < 1.0E-6) {
            return;
        }
        this.bi.setRGB(n2, n3, this.color);
        double d5 = (d2 + d4) / 2.0;
        double d6 = d4 - d2 < 1.0E-6 ? (d + d3) / 2.0 : Math.atan((Math.sin(d) * Math.cos(d3) * Math.sin(d5 - d4) - Math.sin(d3) * Math.cos(d) * Math.sin(d5 - d2)) / (Math.cos(d) * Math.cos(d3) * Math.sin(d2 - d4)));
        this.connect(d, d2, d6, d5, n + 1);
        this.connect(d6, d5, d3, d4, n + 1);
    }

    BufferedImage drawCase() {
        double d;
        int n;
        this.bi = new BufferedImage(C * 360 + 1, C * 180 + 1, 1);
        Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(0, 0, 96));
        if (projection) {
            graphics2D.fillOval(0, 0, this.bi.getWidth(), this.bi.getHeight());
        } else {
            graphics2D.fillRect(0, 0, this.bi.getWidth(), this.bi.getHeight());
        }
        this.color = 0x202060;
        for (n = -160; n <= 160; n += 20) {
            d = (double)n / 180.0 * Math.PI;
            this.connect(-1.5706963267948966, d, 1.5706963267948966, d, 0);
        }
        graphics2D.setColor(new Color(this.color));
        graphics2D.drawLine(0, C * 90, C * 360, C * 90);
        this.color = 0xFFFFFF;
        n = 0;
        while (n + 1 < this.x.length) {
            d = this.x[n] / 180.0 * Math.PI;
            double d2 = this.y[n] / 180.0 * Math.PI;
            double d3 = this.x[n + 1] / 180.0 * Math.PI;
            double d4 = this.y[n + 1] / 180.0 * Math.PI;
            if (Math.abs(d3 - d) > Math.PI) {
                if (d < d3) {
                    d += Math.PI * 2;
                } else {
                    d3 += Math.PI * 2;
                }
            }
            if (d3 < d) {
                double d5 = d2;
                d2 = d4;
                d4 = d5;
                double d6 = d;
                d = d3;
                d3 = d6;
            }
            this.connect(d2, d, d4, d3, 0);
            ++n;
        }
        for (n = 0; n < this.x.length; ++n) {
            if (n % (this.N + 1) == 0) {
                graphics2D.setColor(Color.red);
            } else {
                graphics2D.setColor(Color.blue);
            }
            double[] dArray = this.project(this.y[n] / 180.0 * Math.PI, this.x[n] / 180.0 * Math.PI);
            graphics2D.fillOval((int)dArray[0] - 2, (int)dArray[1] - 2, 5, 5);
        }
        return this.bi;
    }

    public Tester(String string) throws IOException {
        Object object;
        if (exec != null) {
            try {
                object = Runtime.getRuntime();
                proc = ((Runtime)object).exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (file != null) {
            object = this.drawCase();
            if (file.equals("-")) {
                JFrame jFrame = new JFrame();
                jFrame.setSize(C * 360 + 10, C * 180 + 50);
                jFrame.getContentPane().add(new JPanel((BufferedImage)object){
                    final /* synthetic */ BufferedImage val$bi;
                    {
                        this.val$bi = bufferedImage;
                    }

                    public void paint(Graphics graphics) {
                        graphics.drawImage(this.val$bi, 0, 0, null);
                    }
                });
                jFrame.setDefaultCloseOperation(3);
                jFrame.setVisible(true);
            } else {
                ImageIO.write((RenderedImage)object, "png", new File(file + ".png"));
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-vis")) {
                file = stringArray[++i];
            }
            if (stringArray[i].equals("-noproj")) {
                projection = false;
            }
            if (!stringArray[i].equals("-C")) continue;
            C = Integer.parseInt(stringArray[++i]);
        }
        Tester tester = new Tester(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    static {
        C = 2;
        projection = true;
    }
}

