/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Lumberjack
extends JFrame
implements WindowListener,
ChangeListener {
    boolean drop = false;
    boolean showall = false;
    static DecimalFormat df = new DecimalFormat("0.#######", new DecimalFormatSymbols(Locale.US));
    boolean novis;
    boolean running;
    static int ST = 20;
    JScrollPane scroll;
    Vis c;
    Object msg = new Object();
    int position;
    Random r;
    boolean failure = false;
    int curX = 0;
    int curY = 0;
    int curTime = 0;
    int height;
    int width;
    int time;
    double density;
    int K;
    int M;
    int P;
    double q;
    double q0;
    boolean[][] infected;
    boolean[][] marked;
    int score = 0;
    double baseline;
    int ldir = -1;
    JTextArea err;
    JTextField fileName;
    int seed = 1;
    Runner current;
    String procname = "";

    void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.current != null && this.current.pr != null) {
            this.current.pr.destroy();
        }
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    void addFatalError(String string) {
        if (!this.novis) {
            this.addMessage(string, false);
        } else {
            System.out.println(string);
        }
    }

    void addMessage(String string) {
        if (!this.novis) {
            this.addMessage(string, false);
        } else {
            System.out.println(string);
        }
    }

    void addMessage(final String string, boolean bl) {
        if (bl) {
            System.out.println(string);
        }
        if (!this.novis) {
            final JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            if (!(jScrollBar.getValueIsAdjusting() || jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum() && jScrollBar.getValue() != this.position)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        Lumberjack.this.err.append(string);
                        Lumberjack.this.position = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                        jScrollBar.setValue(Lumberjack.this.position);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {}
            } else {
                this.position = -1;
                this.err.append(string);
            }
        }
    }

    private void generate(boolean bl) {
        int n;
        int n2;
        int n3;
        if (bl) {
            this.height = this.r.nextInt(51) + 50;
            this.width = this.r.nextInt(51) + 50;
            this.time = this.r.nextInt(2301) + 200;
            this.density = this.r.nextDouble() * 0.25 + 0.05;
            this.M = 40 + this.r.nextInt(21);
            this.P = 10 + this.r.nextInt(6);
            this.q0 = this.r.nextDouble() * 0.04 + 0.3;
            this.q = this.r.nextDouble() * 0.04 + 0.45;
            if (this.seed == 1) {
                this.height = 20;
                this.width = 20;
            } else if (this.seed == 2) {
                this.height = 30;
                this.width = 30;
            } else if (this.seed == 3) {
                this.height = 40;
                this.width = 40;
            } else if (this.seed == 4) {
                this.height = 50;
                this.width = 50;
            }
        } else {
            this.r.nextInt(51);
            this.r.nextInt(51);
            this.r.nextInt(2301);
            this.r.nextDouble();
            this.r.nextInt(21);
            this.r.nextInt(6);
            this.r.nextDouble();
            this.r.nextDouble();
        }
        this.score = 0;
        this.curTime = 0;
        this.curY = 0;
        this.curX = 0;
        this.ldir = -1;
        this.K = this.width * this.height / 200;
        this.infected = new boolean[this.height][this.width];
        this.marked = new boolean[this.height][this.width];
        PriorityQueue<InfectedTree> priorityQueue = new PriorityQueue<InfectedTree>();
        for (int i = 0; i < this.K; ++i) {
            n3 = this.r.nextInt(this.width);
            n2 = this.r.nextInt(this.height);
            n = this.r.nextInt(this.M);
            if (this.infected[n2][n3]) {
                --i;
                continue;
            }
            this.infected[n2][n3] = true;
            priorityQueue.add(new InfectedTree(n3, n2, n));
        }
        double[] dArray = new double[1000];
        dArray[0] = this.q0;
        for (n3 = 1; n3 < dArray.length; ++n3) {
            dArray[n3] = dArray[n3 - 1] * this.q;
        }
        while (priorityQueue.size() > 0) {
            InfectedTree infectedTree = (InfectedTree)priorityQueue.poll();
            for (n2 = 0; n2 < this.height; ++n2) {
                for (n = 0; n < this.width; ++n) {
                    if (this.infected[n2][n] || !(this.r.nextDouble() < dArray[Math.abs(infectedTree.x - n) + Math.abs(infectedTree.y - n2)])) continue;
                    this.infected[n2][n] = true;
                    if (infectedTree.time + this.P >= this.M) continue;
                    priorityQueue.add(new InfectedTree(n, n2, infectedTree.time + this.P));
                }
            }
        }
        int n4 = 0;
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                if (!this.infected[n2][n]) continue;
                ++n4;
            }
        }
        this.baseline = 1.0 * (double)n4 / (double)this.width / (double)this.height;
    }

    private char getLook(int n, int n2) {
        int n3;
        boolean bl = this.infected[n2][n];
        int n4 = (int)Math.abs(-0.5 + (double)this.curX - (double)n);
        int n5 = n4 + (n3 = (int)Math.abs(-0.5 + (double)this.curY - (double)n2));
        if (n5 == 0 && bl && !this.marked[n2][n]) {
            ++this.score;
            this.marked[n2][n] = true;
        }
        double d = Math.pow(1.0 - this.density, n5);
        double d2 = d * (double)(bl ? 1 : 0) + (1.0 - d) * this.baseline;
        return this.r.nextDouble() < d2 ? (char)'Y' : 'N';
    }

    public String[] look(String string) {
        ++this.curTime;
        String[] stringArray = new String[]{"", ""};
        if (string.equals("E")) {
            int n;
            if (this.curY > 0) {
                for (n = this.curX; n < this.width; ++n) {
                    stringArray[0] = stringArray[0] + this.getLook(n, this.curY - 1);
                }
            }
            if (this.curY < this.height) {
                for (n = this.curX; n < this.width; ++n) {
                    stringArray[1] = stringArray[1] + this.getLook(n, this.curY);
                }
            }
        } else if (string.equals("W")) {
            int n;
            if (this.curY > 0) {
                for (n = this.curX - 1; n >= 0; --n) {
                    stringArray[1] = stringArray[1] + this.getLook(n, this.curY - 1);
                }
            }
            if (this.curY < this.height) {
                for (n = this.curX - 1; n >= 0; --n) {
                    stringArray[0] = stringArray[0] + this.getLook(n, this.curY);
                }
            }
        } else if (string.equals("N")) {
            int n;
            if (this.curX > 0) {
                for (n = this.curY - 1; n >= 0; --n) {
                    stringArray[0] = stringArray[0] + this.getLook(this.curX - 1, n);
                }
            }
            if (this.curX < this.width) {
                for (n = this.curY - 1; n >= 0; --n) {
                    stringArray[1] = stringArray[1] + this.getLook(this.curX, n);
                }
            }
        } else if (string.equals("S")) {
            int n;
            if (this.curX > 0) {
                for (n = this.curY; n < this.height; ++n) {
                    stringArray[1] = stringArray[1] + this.getLook(this.curX - 1, n);
                }
            }
            if (this.curX < this.width) {
                for (n = this.curY; n < this.height; ++n) {
                    stringArray[0] = stringArray[0] + this.getLook(this.curX, n);
                }
            }
        } else {
            this.failure = true;
            this.addFatalError("look() was called with an invalid parameter.");
        }
        if (stringArray[0].length() == 0) {
            stringArray[0] = "^";
        }
        if (stringArray[1].length() == 0) {
            stringArray[1] = "^";
        }
        return stringArray;
    }

    public int[] move(String string) {
        for (int i = 0; i < string.length(); ++i) {
            ++this.curTime;
            switch (string.charAt(i)) {
                case 'N': {
                    --this.curY;
                    break;
                }
                case 'S': {
                    ++this.curY;
                    break;
                }
                case 'E': {
                    ++this.curX;
                    break;
                }
                case 'W': {
                    --this.curX;
                    break;
                }
                default: {
                    this.failure = true;
                    this.addFatalError("move() was called with an invalid parameter.");
                    return null;
                }
            }
            if (this.curX >= 0 && this.curX <= this.width && this.curY >= 0 && this.curY <= this.height) continue;
            this.addFatalError("You moved outside the woods.");
            return null;
        }
        return new int[]{this.curX, this.curY};
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        ST = jSlider.getValue() >= 80 ? 100 - jSlider.getValue() : (int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue()));
    }

    void stop() {
        this.running = false;
        if (this.current != null) {
            this.current.running = false;
            try {
                if (this.current.pr != null) {
                    this.current.pr.destroy();
                    this.current.pr.waitFor();
                }
                this.current.interrupt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.current = null;
        }
    }

    public static void main(String[] stringArray) {
        final Lumberjack lumberjack = new Lumberjack();
        lumberjack.seed = new Random().nextInt();
        lumberjack.r = new Random(lumberjack.seed);
        boolean bl = false;
        lumberjack.procname = "Enter your executable and its arguments here";
        int n = 80;
        int n2 = 600;
        int n3 = 800;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-M")) {
                    lumberjack.M = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-height")) {
                    lumberjack.height = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-width")) {
                    lumberjack.width = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-time")) {
                    lumberjack.time = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-P")) {
                    lumberjack.P = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-density")) {
                    lumberjack.density = Double.parseDouble(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-q")) {
                    lumberjack.q = Double.parseDouble(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-q0")) {
                    lumberjack.q0 = Double.parseDouble(stringArray[i + 1]);
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    lumberjack.seed = Integer.parseInt(stringArray[i + 1]);
                    lumberjack.r = new Random(lumberjack.seed);
                    continue;
                }
                if (stringArray[i].equals("-t")) {
                    n = Integer.parseInt(stringArray[i + 1]);
                    if (n > 100) {
                        n = 100;
                    } else if (n < 0) {
                        n = 0;
                    }
                    if (n >= 80) {
                        ST = 100 - n;
                        continue;
                    }
                    ST = (int)(5000.0 * Math.pow(0.9333096363135965, n));
                    continue;
                }
                if (stringArray[i].equals("-exec")) {
                    lumberjack.procname = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equals("-novis")) {
                    bl = true;
                    lumberjack.novis = true;
                    lumberjack.showall = false;
                    lumberjack.drop = true;
                    continue;
                }
                if (stringArray[i].equals("-drop")) {
                    lumberjack.drop = true;
                    continue;
                }
                if (stringArray[i].equals("-showall")) {
                    lumberjack.showall = true;
                    continue;
                }
                if (stringArray[i].equals("-go")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-windowWidth")) {
                    n2 = Integer.parseInt(stringArray[i + 1]);
                    continue;
                }
                if (!stringArray[i].equals("-windowHeight")) continue;
                n3 = Integer.parseInt(stringArray[i + 1]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Your command line parameters are invalid.");
            System.exit(1);
        }
        if ((lumberjack.novis || bl) && lumberjack.procname.startsWith("Enter your exec")) {
            System.err.println("You must specify an executable when using the -novis or -go options");
            if (lumberjack.novis) {
                System.exit(1);
            } else {
                bl = false;
            }
        }
        if (lumberjack.seed == 1) {
            if (lumberjack.height == 0) {
                lumberjack.height = 20;
                lumberjack.r.nextInt(51);
            }
            if (lumberjack.width == 0) {
                lumberjack.width = 20;
                lumberjack.r.nextInt(51);
            }
        } else if (lumberjack.seed == 2) {
            if (lumberjack.height == 0) {
                lumberjack.height = 30;
                lumberjack.r.nextInt(51);
            }
            if (lumberjack.width == 0) {
                lumberjack.width = 30;
                lumberjack.r.nextInt(51);
            }
        } else if (lumberjack.seed == 3) {
            if (lumberjack.height == 0) {
                lumberjack.height = 40;
                lumberjack.r.nextInt(51);
            }
            if (lumberjack.width == 0) {
                lumberjack.width = 40;
                lumberjack.r.nextInt(51);
            }
        } else if (lumberjack.seed == 4) {
            if (lumberjack.height == 0) {
                lumberjack.height = 50;
                lumberjack.r.nextInt(51);
            }
            if (lumberjack.width == 0) {
                lumberjack.width = 50;
                lumberjack.r.nextInt(51);
            }
        }
        if (lumberjack.height == 0) {
            lumberjack.height = lumberjack.r.nextInt(51) + 50;
        }
        if (lumberjack.width == 0) {
            lumberjack.width = lumberjack.r.nextInt(51) + 50;
        }
        if (lumberjack.time == 0) {
            lumberjack.time = lumberjack.r.nextInt(2301) + 200;
        }
        if (lumberjack.density == 0.0) {
            lumberjack.density = lumberjack.r.nextDouble() * 0.25 + 0.05;
        }
        if (lumberjack.M == 0) {
            lumberjack.M = 40 + lumberjack.r.nextInt(21);
        }
        if (lumberjack.P == 0) {
            lumberjack.P = 10 + lumberjack.r.nextInt(6);
        }
        if (lumberjack.q0 == 0.0) {
            lumberjack.q0 = lumberjack.r.nextDouble() * 0.04 + 0.3;
        }
        if (lumberjack.q == 0.0) {
            lumberjack.q = lumberjack.r.nextDouble() * 0.04 + 0.45;
        }
        if (!lumberjack.novis) {
            lumberjack.r = new Random(lumberjack.seed);
            lumberjack.generate(false);
            lumberjack.c = lumberjack.new Vis();
            JSlider jSlider = new JSlider(0, 0, 100, n);
            jSlider.addChangeListener(lumberjack);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            lumberjack.err = new JTextArea();
            if (!bl) {
                lumberjack.err.setText("Standard Error from your program, as well as other messages will appear here");
            }
            lumberjack.scroll = new JScrollPane(lumberjack.err);
            JSplitPane jSplitPane = new JSplitPane(0, lumberjack.c, lumberjack.scroll);
            jSplitPane.setDividerLocation(n3 - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            jSplitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            lumberjack.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            final JTextField jTextField = new JTextField("" + lumberjack.seed);
            final JTextField jTextField2 = new JTextField("" + lumberjack.height);
            final JTextField jTextField3 = new JTextField("" + lumberjack.width);
            final JTextField jTextField4 = new JTextField("" + lumberjack.time);
            final JTextField jTextField5 = new JTextField(df.format(lumberjack.density));
            final JTextField jTextField6 = new JTextField("" + lumberjack.M);
            final JTextField jTextField7 = new JTextField("" + lumberjack.P);
            final JTextField jTextField8 = new JTextField(df.format(lumberjack.q));
            final JTextField jTextField9 = new JTextField(df.format(lumberjack.q0));
            jPanel2.add(new Label("height: "));
            jPanel2.add(jTextField2);
            jPanel2.add(new Label("width: "));
            jPanel2.add(jTextField3);
            jPanel2.add(new Label("time: "));
            jPanel2.add(jTextField4);
            jPanel2.add(new Label("M: "));
            jPanel2.add(jTextField6);
            jPanel2.add(new Label("P: "));
            jPanel2.add(jTextField7);
            jPanel3.add(new Label("density: "));
            jPanel3.add(jTextField5);
            jPanel3.add(new Label("q: "));
            jPanel3.add(jTextField8);
            jPanel3.add(new Label("q0: "));
            jPanel3.add(jTextField9);
            jPanel3.add(new Label("seed: "));
            jPanel3.add(jTextField);
            jPanel2.setAlignmentX(0.5f);
            jPanel3.setAlignmentX(0.5f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel4.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    lumberjack.stop();
                    lumberjack.seed = Integer.parseInt(jTextField.getText());
                    lumberjack.height = Integer.parseInt(jTextField2.getText());
                    lumberjack.width = Integer.parseInt(jTextField3.getText());
                    lumberjack.time = Integer.parseInt(jTextField4.getText());
                    lumberjack.density = Double.parseDouble(jTextField5.getText());
                    lumberjack.M = Integer.parseInt(jTextField6.getText());
                    lumberjack.P = Integer.parseInt(jTextField7.getText());
                    lumberjack.q = Double.parseDouble(jTextField8.getText());
                    lumberjack.q0 = Double.parseDouble(jTextField9.getText());
                    lumberjack.r = new Random(lumberjack.seed);
                    lumberjack.generate(false);
                    lumberjack.c.rep(true);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    lumberjack.stop();
                    lumberjack.seed = lumberjack.seed == Integer.parseInt(jTextField.getText()) ? lumberjack.r.nextInt() : Integer.parseInt(jTextField.getText());
                    lumberjack.r = new Random(lumberjack.seed);
                    lumberjack.generate(true);
                    jTextField.setText("" + lumberjack.seed);
                    jTextField2.setText("" + lumberjack.height);
                    jTextField3.setText("" + lumberjack.width);
                    jTextField4.setText("" + lumberjack.time);
                    jTextField5.setText(df.format(lumberjack.density));
                    jTextField6.setText("" + lumberjack.M);
                    jTextField7.setText("" + lumberjack.P);
                    jTextField8.setText(df.format(lumberjack.q));
                    jTextField9.setText(df.format(lumberjack.q0));
                    lumberjack.c.rep(true);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    lumberjack.stop();
                    lumberjack.seed = Integer.parseInt(jTextField.getText());
                    lumberjack.r = new Random(lumberjack.seed);
                    lumberjack.height = Integer.parseInt(jTextField2.getText());
                    lumberjack.width = Integer.parseInt(jTextField3.getText());
                    lumberjack.time = Integer.parseInt(jTextField4.getText());
                    lumberjack.density = Double.parseDouble(jTextField5.getText());
                    lumberjack.M = Integer.parseInt(jTextField6.getText());
                    lumberjack.P = Integer.parseInt(jTextField7.getText());
                    lumberjack.q = Double.parseDouble(jTextField8.getText());
                    lumberjack.q0 = Double.parseDouble(jTextField9.getText());
                    lumberjack.r = new Random(lumberjack.seed);
                    lumberjack.generate(false);
                    lumberjack.c.rep(true);
                    lumberjack.procname = lumberjack.fileName.getText();
                    lumberjack.current = new Runner(lumberjack);
                    lumberjack.err.setText("");
                    lumberjack.current.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    lumberjack.stop();
                }
            });
            JPanel jPanel5 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            lumberjack.fileName = new JTextField(lumberjack.procname);
            jPanel5.add(jButton5);
            jPanel5.add(lumberjack.fileName);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(lumberjack);
                    if (n == 0) {
                        lumberjack.procname = jFileChooser.getSelectedFile().getPath();
                        lumberjack.fileName.setText(lumberjack.procname);
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
            lumberjack.add((Component)jPanel, "North");
            lumberjack.add((Component)jSplitPane, "Center");
            lumberjack.add((Component)jPanel6, "South");
            lumberjack.addWindowListener(lumberjack);
            lumberjack.setSize(n2, n3);
            lumberjack.setVisible(true);
            if (bl) {
                lumberjack.procname = lumberjack.fileName.getText();
                lumberjack.current = new Runner(lumberjack);
                lumberjack.current.start();
            }
        } else {
            lumberjack.r = new Random(lumberjack.seed);
            lumberjack.generate(false);
            lumberjack.current = new Runner(lumberjack);
            lumberjack.current.start();
        }
    }

    String getProcessName() {
        return this.procname;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InfectedTree
    implements Comparable<InfectedTree> {
        public int x;
        public int y;
        public int time;

        public InfectedTree(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.time = n3;
        }

        @Override
        public int compareTo(InfectedTree infectedTree) {
            if (this.time < infectedTree.time) {
                return -1;
            }
            if (this.time > infectedTree.time) {
                return 1;
            }
            if (this.y < infectedTree.y) {
                return -1;
            }
            if (this.y > infectedTree.y) {
                return 1;
            }
            if (this.x < infectedTree.x) {
                return -1;
            }
            if (this.x > infectedTree.x) {
                return 1;
            }
            return 0;
        }
    }

    public class Vis
    extends JPanel {
        BufferedImage bi;
        Object painting = new Object();
        int pldir;
        int px;
        int py;
        int pH;
        int pW;
        int pScore;
        int pcurx;
        int pcury;
        boolean firstTime = true;
        Image img;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rep(boolean bl) {
            if (!Lumberjack.this.drop) {
                Object object = this.painting;
                synchronized (object) {
                    this.firstTime = bl;
                    try {
                        this.repaint();
                        if (!this.firstTime) {
                            this.painting.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (bl) {
                Object object = this.painting;
                synchronized (object) {
                    this.firstTime = true;
                }
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            if (Lumberjack.this.novis) {
                return;
            }
            Object object = this.painting;
            synchronized (object) {
                int n;
                int n2;
                int n3 = Lumberjack.this.curX;
                int n4 = Lumberjack.this.curY;
                int n5 = Lumberjack.this.ldir;
                if (Lumberjack.this.infected == null) {
                    this.painting.notify();
                    return;
                }
                int n6 = Math.min(this.getWidth() / Lumberjack.this.width, this.getHeight() / Lumberjack.this.height);
                int n7 = this.getWidth();
                int n8 = this.getHeight();
                if (n7 != this.pW || n8 != this.pH) {
                    this.img = new BufferedImage(n7, n8, 1);
                    this.firstTime = true;
                }
                this.pW = n7;
                this.pH = n8;
                Graphics2D graphics2D = (Graphics2D)this.img.getGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int n9 = (n7 /= 2) + (n3 - Lumberjack.this.infected[0].length / 2) * n6 - (n6 + 1) / 4;
                int n10 = (n8 /= 2) + (n4 - Lumberjack.this.infected.length / 2) * n6 - (n6 + 1) / 4;
                if (this.firstTime) {
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    graphics2D.fillRect(this.px - n6, this.py - n6, 2 * n6, 2 * n6);
                }
                this.pldir = n5;
                this.px = n9;
                this.py = n10;
                Font font = new Font(graphics2D.getFont().getName(), 0, 40);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                String string = Lumberjack.this.score + " / " + Lumberjack.this.curTime;
                int n11 = fontMetrics.stringWidth(string);
                int n12 = fontMetrics.getAscent();
                this.pScore = Lumberjack.this.score;
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(n7 - n11 / 2, n8 - n12 / 2, n11, n12);
                for (n2 = Math.max(0, Lumberjack.this.infected.length / 2 - n12 / 2 / n6 - 1); n2 < Math.min(Lumberjack.this.infected.length, Lumberjack.this.infected.length / 2 + n12 / 2 / n6 + 1); ++n2) {
                    for (n = Math.max(0, Lumberjack.this.infected[0].length / 2 - n11 / 2 / n6 - 1); n < Math.min(Lumberjack.this.infected[0].length, Lumberjack.this.infected[0].length / 2 + n11 / 2 / n6 + 1); ++n) {
                        if (Lumberjack.this.marked[n2][n]) {
                            graphics2D.setColor(Color.blue);
                        } else if (Lumberjack.this.infected[n2][n]) {
                            graphics2D.setColor(Color.red);
                        } else {
                            graphics2D.setColor(Color.green);
                        }
                        graphics2D.fillOval(n7 + (n - Lumberjack.this.infected[0].length / 2) * n6, n8 + (n2 - Lumberjack.this.infected.length / 2) * n6, (n6 + 1) / 2, (n6 + 1) / 2);
                    }
                }
                if (this.firstTime) {
                    graphics2D.setColor(Color.cyan);
                    if (n5 != -1) {
                        if (n5 == 0) {
                            graphics2D.fillRect(n9, n10 - 1, this.getWidth(), 2);
                        } else if (n5 == 1) {
                            graphics2D.fillRect(n9 - 1, n10, 2, this.getHeight());
                        } else if (n5 == 2) {
                            graphics2D.fillRect(0, n10 - 1, n9, 2);
                        } else if (n5 == 3) {
                            graphics2D.fillRect(n9 - 1, 0, 2, n10);
                        }
                    }
                    graphics2D.setColor(Color.black);
                    graphics2D.fillOval(n7 + (n3 - Lumberjack.this.infected[0].length / 2) * n6 - n6, n8 + (n4 - Lumberjack.this.infected.length / 2) * n6 - n6, (3 * n6 + 1) / 2, (3 * n6 + 1) / 2);
                    for (n2 = 0; n2 < Lumberjack.this.infected.length; ++n2) {
                        for (n = 0; n < Lumberjack.this.infected[0].length; ++n) {
                            if (Lumberjack.this.marked[n2][n]) {
                                graphics2D.setColor(Color.blue);
                            } else if (Lumberjack.this.infected[n2][n]) {
                                graphics2D.setColor(Color.red);
                            } else {
                                graphics2D.setColor(Color.green);
                            }
                            graphics2D.fillOval(n7 + (n - Lumberjack.this.infected[0].length / 2) * n6, n8 + (n2 - Lumberjack.this.infected.length / 2) * n6, (n6 + 1) / 2, (n6 + 1) / 2);
                        }
                    }
                } else {
                    graphics2D.setColor(Color.white);
                    graphics2D.fillRect(0, n8 + (this.pcury - 2 - Lumberjack.this.infected.length / 2) * n6, this.getWidth(), n6 * 4);
                    graphics2D.fillRect(n7 + (this.pcurx - 2 - Lumberjack.this.infected[0].length / 2) * n6, 0, n6 * 4, this.getHeight());
                    graphics2D.setColor(Color.cyan);
                    if (n5 != -1) {
                        if (n5 == 0) {
                            graphics2D.fillRect(n9, n10 - 1, this.getWidth(), 2);
                        } else if (n5 == 1) {
                            graphics2D.fillRect(n9 - 1, n10, 2, this.getHeight());
                        } else if (n5 == 2) {
                            graphics2D.fillRect(0, n10 - 1, n9, 2);
                        } else if (n5 == 3) {
                            graphics2D.fillRect(n9 - 1, 0, 2, n10);
                        }
                    }
                    graphics2D.setColor(Color.black);
                    graphics2D.fillOval(n7 + (n3 - Lumberjack.this.infected[0].length / 2) * n6 - n6, n8 + (n4 - Lumberjack.this.infected.length / 2) * n6 - n6, (3 * n6 + 1) / 2, (3 * n6 + 1) / 2);
                    for (n2 = Math.max(0, this.pcury - 2); n2 < Math.min(Lumberjack.this.infected.length, this.pcury + 2); ++n2) {
                        for (n = 0; n < Lumberjack.this.infected[0].length; ++n) {
                            if (Lumberjack.this.marked[n2][n]) {
                                graphics2D.setColor(Color.blue);
                            } else if (Lumberjack.this.infected[n2][n]) {
                                graphics2D.setColor(Color.red);
                            } else {
                                graphics2D.setColor(Color.green);
                            }
                            graphics2D.fillOval(n7 + (n - Lumberjack.this.infected[0].length / 2) * n6, n8 + (n2 - Lumberjack.this.infected.length / 2) * n6, (n6 + 1) / 2, (n6 + 1) / 2);
                        }
                    }
                    for (n2 = 0; n2 < Lumberjack.this.infected.length; ++n2) {
                        for (n = Math.max(0, this.pcurx - 2); n < Math.min(Lumberjack.this.infected[0].length, this.pcurx + 2); ++n) {
                            if (Lumberjack.this.marked[n2][n]) {
                                graphics2D.setColor(Color.blue);
                            } else if (Lumberjack.this.infected[n2][n]) {
                                graphics2D.setColor(Color.red);
                            } else {
                                graphics2D.setColor(Color.green);
                            }
                            graphics2D.fillOval(n7 + (n - Lumberjack.this.infected[0].length / 2) * n6, n8 + (n2 - Lumberjack.this.infected.length / 2) * n6, (n6 + 1) / 2, (n6 + 1) / 2);
                        }
                    }
                    this.pcurx = n3;
                    this.pcury = n4;
                }
                graphics2D.setColor(Color.gray);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                graphics2D.drawString(string, n7 - n11 / 2, n8 + n12 / 2);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (this.firstTime) {
                    this.firstTime = false;
                }
                graphics.drawImage(this.img, 0, 0, null);
                this.painting.notify();
            }
        }
    }
}

