import java.util.*;
import java.io.*;
public class Runner {
    boolean paused = false;
    boolean running = false;
    Process pr;
    Scanner input;
    InputStream error;
    DataOutputStream os;
    Stepper st;

    Problem prob;
    Display dis;
    int pause;
    Thread runtest;


    public Runner(Problem prob, Display d){
        this.prob = prob;
        this.dis = d;
    }

    public void start(boolean go){
        running = true;
        paused = !go;


        try{
            pr = Runtime.getRuntime().exec(Main.getProcess());
            input = new Scanner(pr.getInputStream());
            error = pr.getErrorStream();
            os = new DataOutputStream(pr.getOutputStream());

            new ErrorReader().start();

            (runtest = new Thread(){
                public void run(){
                    double score = prob.runTest();
                    Main.addFatalError("Your score is: "+score);
                    running = false;
                }
            }).start();
            if(go){
                (st = new Stepper()).start();
            }


        }catch(Exception e){
            e.printStackTrace();
            return;
        }
    }
    class Stepper extends Thread{
        public void run(){
            try{
                while(running && !paused){
                    try{
                        step();
                        if(!paused){
                            try{
                                Thread.sleep(pause);
                            }catch(Exception e){
                                if(!running){
                                    break;
                                }else {
                                    System.out.println(running);
                                    e.printStackTrace();
                                }
                            }
                        }
                    }catch(Exception ex){
                        running = false;
                        ex.printStackTrace();
                        Main.addFatalError(ex.getMessage());
                    }
                }
                //Main.addMessage("Score = "+prob.score+"\n");
            }catch(Exception e){
                e.printStackTrace();
                return;
            }
        }
    }
    public void stop(){
        running = false;
        try{
            if(st != null){
                st.interrupt();
                st.join();
            }
            if(pr != null){
                pr.destroy();
                pr = null;
            }
            if(runtest != null){
                runtest.interrupt();
                runtest.join();
            }
        }catch(InterruptedException e){
            e.printStackTrace();
        }
    }
    boolean go;
    public boolean step() throws IOException {
        if(!running){
            return false;
        }
        synchronized(Main.step){
            if(go){
                try{
                    Main.step.wait();
                }catch(InterruptedException e){
                    return false;
                }
            }
            if(!go){
                go = true;
                Main.step.notify();
            }
        }
        return true;
    }
    public void pause(){
        if(paused){
            paused = false;
            (st = new Stepper()).start();
        }else{
            paused = true;
        }
    }
    public class ErrorReader extends Thread{
        public void run(){
            try{
                byte[] ch = new byte[50000];
                int read;
                while((read = error.read(ch)) > 0 && running){
                    String s = new String(ch,0,read);
                    //System.out.println("err: "+s+" "+s.endsWith("\n"));
                    Main.addMessage(s);
                }
                Main.addMessage("\n");
            }catch(Exception e){
                //System.err.println("Failed to read from stderr");
            }
        }
    }
    public void setPause(int p){
        pause = p;
    }
    public void done(){
        try{
            os.write(("-1\n").getBytes());
            os.flush();
        }catch(Exception ie){
            //tried...
        }
    }
    public int initialise(int N, int M, int C) throws IOException, StoppedException{
        try{
            os.write(("0\n"+N+" "+M+" "+C+"\n").getBytes());
            os.flush();
            return 0;
        }catch(IOException ie){
            if(!running)throw new StoppedException();
            else throw ie;
        }
    }
    public String step(int[] upRequests, int[] downRequests, int[] liftRequests, int[] destinationRequests, String state) throws IOException, InterruptedException, StoppedException{
        if(!running)throw new StoppedException();
        synchronized(Main.step){
            try{
                if(!go) Main.step.wait();
                StringBuffer sb = new StringBuffer();
                sb.append("1\n");
                sb.append(upRequests.length);
                for(int i = 0; i<upRequests.length; i++){
                    sb.append(' ').append(upRequests[i]);
                }
                sb.append('\n');
                sb.append(downRequests.length);
                for(int i = 0; i<downRequests.length; i++){
                    sb.append(' ').append(downRequests[i]);
                }
                sb.append('\n');
                sb.append(liftRequests.length);
                for(int i = 0; i<liftRequests.length; i++){
                    sb.append(' ').append(liftRequests[i]);
                }
                sb.append('\n');
                sb.append(destinationRequests.length);
                for(int i = 0; i<destinationRequests.length; i++){
                    sb.append(' ').append(destinationRequests[i]);
                }
                sb.append('\n');
                sb.append(state);
                sb.append('\n');
                //System.out.println(sb);
                os.write(sb.toString().getBytes());
                os.flush();
                String ret = input.next();
                go = false;
                Main.step.notify();
                return ret;
            }catch(IOException ie){
                if(!running)throw new StoppedException();
                else throw ie;
            }catch(NoSuchElementException e){
                if(!running)throw new StoppedException();
                else throw e;
            //}catch(Exception e){
                //Main.step.notify();
                //if(!running)throw new StoppedException();
                //else throw new RuntimeException(e);
            }
        }
    }
}
class StoppedException extends Exception{}
