import java.util.*;
import java.io.*;
import java.security.*;

public class Problem {

Random randgen,r;


boolean[][] testliftbuttons = new boolean[50][50];
int[][] testliftstartt = new int[50][30]; //lift occupants' journey start time- set to -1 if there is no-one there
int[][] testliftdest = new int[50][30]; //lift occuptants' destination
int[] testliftsize = new int[50]; //number of people in lift
int[][] testfloorupstartt = new int[50][25000]; //for each floor, the start times of people waiting to go up
int[][] testfloordownstartt= new int[50][25000]; //for each floor, the start times of people waiting to go down
int[][] testfloorupdest= new int[50][25000]; //for each floor, the destinations of people waiting to go up
int[][] testfloordowndest= new int[50][25000]; //for each floor, the destinations of people waiting to go down
int[] floorupreadfrom= new int[50]; //floors implemented as 'circular' queues. the readfrom is pointing to front of queue, and writeto is pointing to the end of the queue
int[] floordownreadfrom= new int[50];
int[] floorupwriteto= new int[50];
int[] floordownwriteto= new int[50];
int[] testliftlocs= new int[50]; //which floor is the lift at?
int[] testliftrestarts= new int[50]; //if the lift has open doors, at which time does it close its doors?
double[] testpresent= new double[50]; //what is the cdf of the number of staff present?
boolean[] upButtons= new boolean[50]; //is the up button lit on this floor?
boolean[] downButtons= new boolean[50]; // down
boolean[] isuploading= new boolean[50];
boolean[] isdownloading= new boolean[50];
int HOUR = 1200;
int MINUTE = 20;
int[][][] testjlis = new int[5][320000][3];
int[] testclis=new int[5];
//time_t start,end;
int M,N,C,P,B;
double businessprob;
boolean[] floorbusiness;
int totCommerce;
int[] arrtimes;
int[] deptimes;
int[] arrdevs;
int[] depdevs;
int journeys;
long disttot;
long score;
boolean makeall;



void init(final int seed){
    new Thread(){
        public void run(){
            generate(seed);
        }
    }.start();
}
private void generate(int seed) {
        //System.out.println("Generating");
    synchronized(ready){
        randgen = r = new Random();
        randgen.setSeed(this.seed = seed);
        double d,x,y;
        int i,j,k;

        if(N == 0)N = randgen.nextInt(36)+5; //number of floors
        else randgen.nextInt(46);
        if(M == 0)M = randgen.nextInt(41)+10; //number of lifts
        else randgen.nextInt(41);
        if(C == 0)C = randgen.nextInt(26)+5; //capacity of each lift
        else randgen.nextInt(26);
        if(P == 0)P = randgen.nextInt(176)+25; //'people' per floor
        else randgen.nextInt(176);
        if(B == 0)B = randgen.nextInt(20)+1; //baseline flows between any pair of non-ground floors
        else randgen.nextInt(20);
        //System.out.println(N+" "+M+" "+C+" "+P+" "+B+" ");
        if(businessprob == 0)businessprob = randgen.nextDouble();
        else randgen.nextDouble();
        basic = true;
        score = 0;
        floorbusiness = new boolean[N];
        totCommerce = 0;
        for(i=1; i<N; i++) {
            d=randgen.nextDouble();
            floorbusiness[i]=(d<businessprob);
            if(floorbusiness[i]==false) {
                totCommerce++;
            }
        }
        if(!makeall) {
            return;
        }
        Main.addFatalError("Generating parameters...");
        //System.out.println(totCommerce);
        arrtimes=new int[N]; //mean arrival time for floor
        deptimes=new int[N]; //mean departure time for floor
        arrdevs=new int[N]; //arrival std.dev
        depdevs=new int[N]; //departure std. dev
        for(i=1; i<N; i++) {
            arrtimes[i]=randgen.nextInt(2*HOUR+1)+HOUR;
            arrdevs[i]=randgen.nextInt(25*MINUTE+1)+5*MINUTE;
            deptimes[i]=randgen.nextInt(2*HOUR+1)+HOUR*9;
            depdevs[i]=randgen.nextInt(25*MINUTE+1)+5*MINUTE;
        }
        journeys = 0;
        disttot = 0;
        int day;
        int currt;
        testpresent = new double[50];
        testclis = new int[5];
        for(currt=0; currt<=13*HOUR; currt++) {											
            for(i=0; i<N && currt<=12*HOUR; i++) {
                for(j=0; j<N; j++) {
                    if(i==j) {
                        continue;
                    }
                    if(i==0) {

                        //baseline
                        x=((double)B)/((double)HOUR)/((double)N);

                        //arriving staff
                        y=(1./Math.sqrt(2*Math.PI))/((double)arrdevs[j])*Math.exp( 0.0-((double)(currt-arrtimes[j])*(currt-arrtimes[j]))/(2.0*((double)arrdevs[j]*arrdevs[j])));
                        y*=((double)P);
                        if(!floorbusiness[j]) {
                            y/=10.0;
                        }
                        testpresent[j]+=y;
                        x+=y;

                        if(!floorbusiness[j]) {
                            //customers arriving
                            y=testpresent[j]*10.0;
                            y/=((double)HOUR);
                            x+=y;
                        }

                        //natural staff flow
                        x+=(testpresent[j]/10.0)/((double)HOUR);
                        for(k=0; k<4; k++) {
                            d=randgen.nextDouble();
                            if(d<x) {
                                //fout2 << currt << " " << i << " " << j << endl;
                                disttot+=(j+3)*(j+3);
                                journeys++;
                                //person arrives at currt wanting to travel 0->j

                                testjlis[k][testclis[k]][0]=currt;
                                testjlis[k][testclis[k]][1]=0;
                                testjlis[k][testclis[k]][2]=j;
                                testclis[k]++;
                            }
                        }
                    } else if(j==0) {
                        //baseline
                        x=((double)B)/((double)HOUR)/((double)N);

                        //departing staff
                        y=(1./Math.sqrt(2*Math.PI))/((double)depdevs[i])*Math.exp(0.0- ((double)(currt-deptimes[i])*(currt-deptimes[i]))/(2.0*((double)depdevs[i]*depdevs[i])));
                        y*=((double)P);
                        if(!floorbusiness[i]) {
                            y/=10.0;
                        }
                        testpresent[i]-=y;
                        x+=y;

                        //departing customers
                        if(!floorbusiness[i]) {
                            //customers arriving
                            y=testpresent[i]*10.0;
                            y/=((double)HOUR);
                            x+=y;
                        }

                        //natural staff flow
                        x+=(testpresent[i]/10.0)/((double)HOUR);
                        for(k=0; k<4; k++) {
                            d=randgen.nextDouble();
                            if(d<x)
                            {
                                //fout2 << currt << " "  << i << " " << j << endl;
                                disttot+=(i+3)*(i+3);
                                journeys++;
                                //person arrives at currt wanting to travel 0->j
                                testjlis[k][testclis[k]][0]=currt;
                                testjlis[k][testclis[k]][1]=i;
                                testjlis[k][testclis[k]][2]=0;
                                testclis[k]++;
                            }
                        }
                    } else {
                        //baseline
                        x=((double)B)/((double)HOUR)/((double)N);

                        if(floorbusiness[i]==false && floorbusiness[j]==false)
                        {
                            //proportion present on each floor
                            y=testpresent[i]/((double)P)*testpresent[j]/((double)P)*100.0;
                            //P/2 travel on per HOUR and they go to all other commerce places with equal probability
                            y*=(double)P/((double)HOUR)/2.0/((double)totCommerce-1.);
                            x+=y;
                        }
                        for(k=0; k<4; k++)
                        {					
                            d=randgen.nextDouble();
                            if(d<x)
                            {
                                //fout2 << currt << " "  << i << " " << j << endl;
                                if(j>i)
                                {
                                    disttot+=(j-i+3)*(j-i+3);
                                }
                                else
                                {
                                    disttot+=(i-j+3)*(i-j+3);
                                }
                                journeys++;
                                testjlis[k][testclis[k]][0]=currt;
                                testjlis[k][testclis[k]][1]=i;
                                testjlis[k][testclis[k]][2]=j;
                                testclis[k]++;

                            }
                        }
                    }
                }
            }
        }
        //System.out.println("Generated");
        togo = true;
        ready.notify();
        Main.addFatalError("Generated");
    }
}



        int currt,day;
public double runTest() {
    synchronized(ready){
        if(!togo){
            try{
                ready.wait();
            }catch(Exception e){
                e.printStackTrace();
            }
        }
        //System.out.println("running");
        int i,j,k;
        int journeysum = 0;
        double d,x,y;
        int time = 0;
        int currv;
        for(day=0; day<4; day++)
        {
            currv=0;
            for(i=0; i<M; i++)
            {
                for(j=0; j<C; j++)
                {
                    testliftstartt[i][j]=-1;
                }
                testliftsize[i]=0;
                testliftlocs[i]=0;
            }
            for(i=0; i<N; i++)
            {
                floorupreadfrom[i]=floordownreadfrom[i]=floorupwriteto[i]=floordownwriteto[i]=0;
            }
            testliftbuttons = new boolean[50][50];
            upButtons = new boolean[50];
            downButtons = new boolean[50];
            try{
                Main.r.initialise(N,M,C);
            }catch(StoppedException e){
                Main.addFatalError("Stopped");
                return 0;
            }catch(IOException e){
                Main.addFatalError("An IOException occurred");
                return 0;
            }
            int[] upReqs=new int[N];
            int[] downReqs=new int[N];
            int[] liftReqs1=new int[N*M*2];
            int[] liftReqs2=new int[N*M*2];
            int upRsz,downRsz,liftRsz;
            upRsz=downRsz=liftRsz=0;
            char[] states = new char[M];
            for(i=0; i<M; i++)
            {
                states[i]='S';
            }


            for(currt=0; currt<=13*HOUR; currt++) {
                for(i=0; i<N; i++) {
                    while(floorupreadfrom[i]!=floorupwriteto[i] && testfloorupstartt[i][floorupreadfrom[i]]<=currt-20*MINUTE) {
                        score+=60*MINUTE*60*MINUTE;
                        floorupreadfrom[i]++;
                        floorupreadfrom[i]%=25000;
                    }
                    while(floordownreadfrom[i]!=floordownwriteto[i] && testfloordownstartt[i][floordownreadfrom[i]]<=currt-20*MINUTE) {
                        score+=60*MINUTE*60*MINUTE;
                        floordownreadfrom[i]++;
                        floordownreadfrom[i]%=25000;
                    }
                }
                for(i=0; i<N; i++) {
                    isuploading[i]=isdownloading[i]=false;
                }
                upRsz=downRsz=0;



                for(i=0; i<M; i++) {
                    if(states[i]=='L') {
                        isuploading[testliftlocs[i]]=true;
                    } else if(states[i]=='M') {
                        isdownloading[testliftlocs[i]]=true;
                    }
                }

                while(currv < testclis[day] && testjlis[day][currv][0]==currt) {
                    i=testjlis[day][currv][1];
                    j=testjlis[day][currv][2];
                    if(i<j) {
                        if(!isuploading[i] && !upButtons[i]) {
                            upReqs[upRsz]=i;
                            upRsz++;
                            upButtons[i]=true;
                        }
                        testfloorupstartt[i][floorupwriteto[i]]=currt;
                        testfloorupdest[i][floorupwriteto[i]]=j;
                        floorupwriteto[i]++;
                        floorupwriteto[i]%=25000;
                    } else {
                        if(!isdownloading[i] && !downButtons[i]) {
                            downReqs[downRsz]=i;
                            downRsz++;
                            downButtons[i]=true;
                        }	
                        testfloordownstartt[i][floordownwriteto[i]]=currt;
                        testfloordowndest[i][floordownwriteto[i]]=j;
                        floordownwriteto[i]++;
                        floordownwriteto[i]%=25000;
                    }
                    currv++;

                }

                for(i=0; i<N; i++) {
                    if(!isuploading[i] && !upButtons[i] && floorupwriteto[i]!=floorupreadfrom[i]) {
                        upReqs[upRsz]=i;
                        upRsz++;
                        upButtons[i]=true;
                    }
                    if(!isdownloading[i] && !downButtons[i] && floordownwriteto[i]!=floordownreadfrom[i]) {
                        downReqs[downRsz]=i;
                        downRsz++;
                        downButtons[i]=true;
                    }
                }
                int []tempupReqs = new int[upRsz];
                int []tempdownReqs = new int[downRsz];
                int []templiftReqs2 = new int[liftRsz];
                int[]templiftReqs1 = new int[liftRsz];
                for(i=0; i<upRsz; i++) {
                    tempupReqs[i]=upReqs[i];
                }
                for(i=0; i<downRsz; i++) {
                    tempdownReqs[i]=downReqs[i];
                }
                for(i=0; i<liftRsz; i++) {
                    templiftReqs1[i]=liftReqs1[i];
                }
                for(i=0; i<liftRsz; i++) {
                    templiftReqs2[i]=liftReqs2[i];
                }
                String cheatstates = new String(states);
                String s = null;
                try{
                    s = Main.r.step(tempupReqs, tempdownReqs,templiftReqs1,templiftReqs2,cheatstates);
                }catch(StoppedException e){
                    Main.addFatalError("Stopped");
                    return 0;
                }catch(IOException e){
                    Main.addFatalError("An IOException occurred");
                    return 0;
                }catch(InterruptedException e){
                    Main.addFatalError("Stopped");
                    return 0;
                }
                liftRsz=0;
                if(s.length()!=M) {
                    Main.addFatalError("Invalid Move: "+s);
                    return 0.0;
                }
                for(i=0; i<M; i++)
                {
                    if(s.charAt(i)=='U')
                    {
                        if((states[i]=='U' || states[i]=='S')==false)
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                        states[i]='U';
                        testliftlocs[i]++;
                        if(testliftlocs[i]>=N)
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                    }
                    else if(s.charAt(i)=='D')
                    {
                        if((states[i]=='D' || states[i]=='S')==false)
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                        states[i]='D';
                        testliftlocs[i]--;
                        if(testliftlocs[i]<0)
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                    }
                    else if(s.charAt(i)=='S')
                    {
                        if(states[i]=='L' || states[i]=='M')
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                        states[i]='S';
                    }
                    else if(s.charAt(i)=='L' && states[i]!='L')
                    {
                        if(states[i]=='M')
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                        states[i]='L';
                        testliftbuttons[i][testliftlocs[i]]=false;
                        upButtons[testliftlocs[i]]=false;
                    }
                    else if(s.charAt(i)=='M' && states[i]!='M')
                    {
                        if(states[i]=='L')
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                        states[i]='M';
                        testliftbuttons[i][testliftlocs[i]]=false;
                        downButtons[testliftlocs[i]]=false;
                    }
                    else if(s.charAt(i)!='L' && s.charAt(i)!='M')
                    {
                        Main.addFatalError("Invalid Move: "+s);
                        return 0.0;
                    }
                    else
                    {

                        if(states[i]!=s.charAt(i))
                        {
                            Main.addFatalError("Invalid Move: "+s);
                            return 0.0;
                        }
                        int tmp = 0;
                        for(j=0; j<C; j++)
                        {
                            if(testliftstartt[i][j]!=-1 && testliftdest[i][j]==testliftlocs[i])
                            {
                                score+=(currt-testliftstartt[i][j])*(currt-testliftstartt[i][j]);
                                testliftstartt[i][j]=-1;
                                testliftsize[i]--;
                                tmp++;

                            }
                        }

                        while(true)
                        {
                            if(states[i]=='L')
                            {
                                if(floorupreadfrom[testliftlocs[i]]!=floorupwriteto[testliftlocs[i]] && testliftsize[i]<C)
                                {
                                    j=0;
                                    while(testliftstartt[i][j]!=-1)
                                    {
                                        j++;
                                    }
                                    testliftstartt[i][j]=testfloorupstartt[testliftlocs[i]][floorupreadfrom[testliftlocs[i]]];
                                    testliftdest[i][j]=testfloorupdest[testliftlocs[i]][floorupreadfrom[testliftlocs[i]]];
                                    if(testliftbuttons[i][testliftdest[i][j]]==false)
                                    {
                                        liftReqs1[liftRsz]=i;

                                        liftReqs2[liftRsz]=testliftdest[i][j];
                                        liftRsz++;


                                        testliftbuttons[i][testliftdest[i][j]]=true;
                                    }
                                    floorupreadfrom[testliftlocs[i]]++;
                                    floorupreadfrom[testliftlocs[i]]%=25000;
                                    testliftsize[i]++;
                                    tmp++;
                                }
                                else
                                {
                                    break;
                                }

                            }
                            else
                            {
                                if(floordownreadfrom[testliftlocs[i]]!=floordownwriteto[testliftlocs[i]] && testliftsize[i]<C)
                                {
                                    j=0;
                                    while(testliftstartt[i][j]!=-1)
                                    {
                                        j++;
                                    }
                                    testliftstartt[i][j]=testfloordownstartt[testliftlocs[i]][floordownreadfrom[testliftlocs[i]]];
                                    testliftdest[i][j]=testfloordowndest[testliftlocs[i]][floordownreadfrom[testliftlocs[i]]];
                                    if(testliftbuttons[i][testliftdest[i][j]]==false)
                                    {
                                        liftReqs1[liftRsz]=i;

                                        liftReqs2[liftRsz]=testliftdest[i][j];
                                        liftRsz++;
                                        testliftbuttons[i][testliftdest[i][j]]=true;
                                    }
                                    floordownreadfrom[testliftlocs[i]]++;
                                    floordownreadfrom[testliftlocs[i]]%=25000;
                                    testliftsize[i]++;
                                    tmp++;
                                }
                                else
                                {
                                    break;
                                }

                            }
                        }
                        if(tmp==0)
                        {
                            states[i]='S';
                        }
                    }
                }
                if(!Main.novis)
                    Main.d.repaintSim();
            }
            for(i=0; i<M; i++)
            {
                for(j=0; j<C; j++)
                {
                    if(testliftstartt[i][j]!=-1)
                    {
                        score+=(currt-testliftstartt[i][j])*(currt-testliftstartt[i][j]);
                    }
                }
            }
            //System.out.println(score+" "+journeys+" "+((double)score)/((double)journeys));
		journeysum += testclis[day];
		Main.addFatalError("After " + (day+1) + " days your (unnormalized) score is " + score + " from a total of " + journeysum + " journeys\n");

        }

        double retval = Math.sqrt(((double)score+1.)/((double)journeys))-Math.sqrt((double)disttot/((double)journeys));


        //System.out.print(disttot+"\t"+score+"\t");
        Main.r.done();
        Main.r.runtest = null;
        Main.r.stop();
        return retval;
    }
}

int waitingUp(int n){
    return (25000 + floorupwriteto[n] - floorupreadfrom[n]) % 25000;
}
int waitingDown(int n){
    return (25000 + floordownwriteto[n] - floordownreadfrom[n]) % 25000;
}


Object ready = new Object();
boolean togo;
boolean basic;
    Errors err;
    long seed = 1;
    void generate(boolean b, long s){
        togo = false;
        synchronized(Main.step){
            makeall = !b && r != null;
            //System.out.println(makeall);
            if(b){
                N = M = C = P = B = 0;
                businessprob = 0;
                basic = false;
            }
            init((int)s);
        }
    }
}

