import java.util.*;
import java.lang.reflect.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
public class Main{
    static Object step = new Object();
    static String[] paramNames = {"seed","N","M","C","P","businessprob"};
    static Controls c;
    static Display d;
    static Errors e;
    static Problem p;
    static Runner r;

    static boolean novis;
    static String process = "Enter your executable and its arguments here";
    static void setProcess(String s){
        process = s;
        if(c != null)
            c.fileName.setText(s);
    }

    public static void main(String[] args){

        boolean go = false, onewindow = false;

        p = new Problem();
        for(int i = 0; i<args.length; i++){
            if(args[i].equals("-exec")){
                setProcess(args[i+1]);
            }else if(args[i].equals("-go")){
                go = true;
            }else if(args[i].equals("-novis")){
                go = novis = true;
            }else if(args[i].equals("-onewindow")){
                onewindow = true;
            }else {
                for(int j = 0; j<paramNames.length; j++){
                    if(args[i].equals("-"+paramNames[j])){
                        setParameter(j,args[i+1]);
                    }
                }
            }
        }


        if(!novis){
            e = new Errors();
            p.err = e;
            d = new Display(p);
            r = new Runner(p,d);
            c = new Controls(p,d,r,e);
            p.generate(false,getSeed());
            if(onewindow){
                JFrame jf1 = new JFrame("Lift Scheduler");
                JSplitPane js = new JSplitPane(JSplitPane.VERTICAL_SPLIT,d,e);
                jf1.getContentPane().setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                Closer cl = new Closer();
                jf1.addWindowListener(cl);
                gbc.weightx = 1;
                gbc.weighty = 0;
                gbc.fill = 1;
                gbc.gridy = 0;
                jf1.add(c,gbc);
                gbc.gridy = 1;
                gbc.weighty = 1;
                jf1.add(js,gbc);

                jf1.setSize(600,600);
                jf1.setVisible(true);
                js.setDividerLocation(0.7);
            }else{

                JFrame jf1 = new JFrame("Controls");
                JFrame jf2 = new JFrame("Visualizer");
                JFrame jf3 = new JFrame("Messages");

                Closer cl = new Closer();
                jf1.addWindowListener(cl);
                jf2.addWindowListener(cl);
                jf3.addWindowListener(cl);

                jf1.add(c);
                jf2.add(d);
                jf3.add(e);

                jf1.setSize(600,250);
                jf2.setSize(600,450);
                jf3.setSize(600,200);

                jf1.setLocation(0,0);
                jf2.setLocation(0,250);
                jf3.setLocation(0,700);

                jf1.setVisible(true);
                jf2.setVisible(true);
                jf3.setVisible(true);
            }
            for(int i = 0; i<paramNames.length; i++){
                c.params[i].setText(getParameter(paramNames[i]).toString());
            }
        }else{
            r = new Runner(p,null);
            //p.generate(false,getSeed());
        }

        if(go){
            p.makeall = true;
            p.init((int)getSeed());
            r.start(true);
        }

        
    }
        public static void setParameter(int idx, String val){
            String name = paramNames[idx];
            try{
                Field f = p.getClass().getDeclaredField(name);
                if(f.getType().getName().equals("int"))
                    f.set(p,new Integer(val));
                else if(f.getType().getName().equals("long"))
                    f.set(p,new Long(val));
                else if(f.getType().getName().equals("double"))
                    f.set(p,new Double(val));
                if(c != null) c.params[idx].setText(val);
            }catch(Exception e){
                e.printStackTrace();
            }
        }
        public static Object getParameter(String name){
            try{
                Field f = p.getClass().getDeclaredField(name);
                return f.get(p);
            }catch(Exception e){
                e.printStackTrace();
                return null;
            }
        }
    public static long getSeed(){
        return p.seed;
    }
    public static long newSeed(){
        return p.r.nextInt();
    }
    static class Closer implements WindowListener{
        public void windowActivated(WindowEvent e){}
        public void windowDeactivated(WindowEvent e){}
        public void windowOpened(WindowEvent e){}
        public void windowClosing(WindowEvent e){ 
            r.stop();
            System.exit(0); 
        }
        public void windowClosed(WindowEvent e){}
        public void windowIconified(WindowEvent e) {}
        public void windowDeiconified(WindowEvent e) {}
    }
    public static String getProcess(){
        if(c != null) return c.fileName.getText();
        else return process;
    }
    synchronized static void addMessage(final String s){
        if(novis){
            System.out.print(s);
        }else{
            e.addMessage(s);
            d.repaint();
        }
    }
    public static void addFatalError(String s){
        //System.out.println(s);
        addMessage(s+"\n");
    }
}
