/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImageScannerVis {
    int W;
    int H;
    int nb;
    int nLetter;
    char[][] image;
    volatile boolean[] openRows;
    volatile int nScans;
    volatile int maxScans;
    boolean ok;
    String errmes;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static boolean manual;
    static boolean hint;
    static Process proc;
    static int del;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    volatile boolean ready;
    volatile int highlightRow;
    volatile char[][] openImage;

    void generate(long seed) {
        try {
            int j;
            SecureRandom r1 = SecureRandom.getInstance("SHA1PRNG");
            r1.setSeed(seed);
            this.H = r1.nextInt(251) + 50;
            this.W = r1.nextInt(251) + 50;
            if (seed == 1L) {
                this.H = 30;
                this.W = 30;
            }
            System.out.println("H = " + this.H);
            System.out.println("W = " + this.W);
            int minLetter = this.W * this.H / 400;
            int maxLetter = this.W * this.H / 200;
            this.nLetter = r1.nextInt(maxLetter - minLetter + 1) + minLetter;
            System.out.println("Number of letters = " + this.nLetter);
            this.image = new char[this.H][this.W];
            int i = 0;
            while (i < this.H) {
                j = 0;
                while (j < this.W) {
                    this.image[i][j] = 48;
                    ++j;
                }
                ++i;
            }
            int[] placedSize = new int[this.nLetter];
            Rectangle[] placed = new Rectangle[this.nLetter];
            i = 0;
            while (i < this.nLetter) {
                boolean small;
                String name = String.valueOf((char)(65 + r1.nextInt(26))) + (r1.nextInt(2) == 0 ? (char)'P' : 'B') + (r1.nextInt(21) + 8);
                BufferedReader br = new BufferedReader(new FileReader("letters/" + name + ".txt"));
                int h = Integer.parseInt(br.readLine());
                int w = Integer.parseInt(br.readLine());
                placed[i] = new Rectangle(w, h);
                placedSize[i] = w + h;
                int tries = 0;
                do {
                    placed[i].setLocation(r1.nextInt(this.W - w + 1), r1.nextInt(this.H - h + 1));
                    small = true;
                    j = 0;
                    while (j < i && small) {
                        Rectangle interRect = placed[j].intersection(placed[i]);
                        int intSize = (int)(interRect.getWidth() + interRect.getHeight());
                        if (!(interRect.isEmpty() || 2 * intSize <= placedSize[i] && 2 * intSize <= placedSize[j])) {
                            small = false;
                        }
                        ++j;
                    }
                } while (!small && ++tries < 100);
                int y = (int)placed[i].getY();
                int x = (int)placed[i].getX();
                int k = y;
                while (k < y + h) {
                    String line = br.readLine();
                    j = x;
                    while (j < x + w) {
                        if (line.charAt(j - x) == '1') {
                            this.image[k][j] = 49;
                        }
                        ++j;
                    }
                    ++k;
                }
                ++i;
            }
            this.nb = 0;
            i = 0;
            while (i < this.H) {
                j = 0;
                while (j < this.W) {
                    if (this.image[i][j] == '1') {
                        ++this.nb;
                    }
                    ++j;
                }
                ++i;
            }
            System.out.println("Number of black pixels = " + this.nb);
            this.openRows = new boolean[this.H];
            this.maxScans = this.H;
            this.nScans = 0;
            this.ok = true;
        }
        catch (Exception e) {
            System.err.println("An exception occurred while generating test case.");
            e.printStackTrace();
        }
    }

    public String scan(int row) {
        if (row < 0 || row >= this.H) {
            this.errmes = "Invalid row specified for scanning.";
            this.ok = false;
            return "";
        }
        if (this.nScans == this.maxScans) {
            this.errmes = "Number of scans exceeded the maximal number of scans avaliable.";
            this.ok = false;
            return "";
        }
        if (this.openRows[row]) {
            this.errmes = "Second scan of row " + row + " attempted.";
            this.ok = false;
            return "";
        }
        ++this.nScans;
        this.openRows[row] = true;
        int i = 0;
        while (i < this.W) {
            this.openImage[row][i] = this.image[row][i];
            ++i;
        }
        this.draw();
        return new String(this.image[row]);
    }

    /*
     * Exception decompiling
     */
    public double runTest(String seed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String[] restore(int H, int W, int nb, int nLetter) throws IOException {
        if (!manual && proc != null) {
            String s;
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(H) + "\n").append(String.valueOf(W) + "\n").append(String.valueOf(nb) + "\n").append(String.valueOf(nLetter) + "\n");
            this.os.write(sb.toString().getBytes());
            this.os.flush();
            while ((s = this.br.readLine()).equals("?")) {
                int row = Integer.parseInt(this.br.readLine());
                s = this.scan(row);
                if (!this.ok) {
                    return new String[0];
                }
                this.draw();
                this.os.write((String.valueOf(s) + "\n").getBytes());
                this.os.flush();
            }
        }
        String[] ret = new String[H];
        if (manual) {
            while (!this.ready) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int i = 0;
            while (i < H) {
                ret[i] = new String(this.openImage[i]);
                ++i;
            }
        } else if (proc != null) {
            int i = 0;
            while (i < H) {
                ret[i] = this.br.readLine();
                if (!this.openRows[i]) {
                    int j = 0;
                    while (j < W) {
                        this.openImage[i][j] = ret[i].charAt(j);
                        ++j;
                    }
                }
                ++i;
            }
            this.draw();
            System.out.println("done");
        }
        return ret;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
        try {
            Thread.sleep(del);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ImageScannerVis(String seed) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.v = new Vis();
                this.jf.getContentPane().add(this.v);
            }
            if (exec != null) {
                try {
                    Runtime rt = Runtime.getRuntime();
                    proc = rt.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(seed));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String seed = "1";
        vis = true;
        hint = false;
        manual = false;
        del = 100;
        SZ = 3;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-seed")) {
                seed = args[++i];
            }
            if (args[i].equals("-exec")) {
                exec = args[++i];
            }
            if (args[i].equals("-delay")) {
                del = Integer.parseInt(args[++i]);
            }
            if (args[i].equals("-novis")) {
                vis = false;
            }
            if (args[i].equals("-manual")) {
                manual = true;
            }
            if (args[i].equals("-size")) {
                SZ = Integer.parseInt(args[++i]);
            }
            if (args[i].equals("-hint")) {
                hint = true;
            }
            ++i;
        }
        if (seed.equals("1")) {
            SZ = 9;
        }
        if (SZ > 9) {
            SZ = 9;
        }
        if (exec == null) {
            manual = true;
        }
        if (manual) {
            vis = true;
        }
        ImageScannerVis f = new ImageScannerVis(seed);
    }

    void addFatalError(String message) {
        System.out.println(message);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    WindowListener {
        @Override
        public void paint(Graphics g) {
            int j;
            int i;
            BufferedImage bi = new BufferedImage((ImageScannerVis.this.W + 2) * SZ + 50, ImageScannerVis.this.H * SZ + 40, 1);
            Graphics2D g2 = (Graphics2D)bi.getGraphics();
            g2.setColor(new Color(0xDDDDDD));
            g2.fillRect(0, 0, (ImageScannerVis.this.W + 2) * SZ + 50, ImageScannerVis.this.H * SZ + 40);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, ImageScannerVis.this.W * SZ, ImageScannerVis.this.H * SZ);
            if (ImageScannerVis.this.highlightRow > -1) {
                g2.setColor(new Color(0xDDDDDD));
                g2.fillRect(0, ImageScannerVis.this.highlightRow * SZ, ImageScannerVis.this.W * SZ, SZ);
            }
            if (hint) {
                g2.setColor(new Color(0xCCCCFF));
                i = 0;
                while (i < ImageScannerVis.this.H) {
                    j = 0;
                    while (j < ImageScannerVis.this.W) {
                        if (ImageScannerVis.this.image[i][j] == '1') {
                            g2.fillRect(j * SZ, i * SZ, SZ, SZ);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < ImageScannerVis.this.H) {
                if (ImageScannerVis.this.openRows[i]) {
                    g2.setColor(Color.BLACK);
                } else {
                    g2.setColor(new Color(0x888888));
                }
                j = 0;
                while (j < ImageScannerVis.this.W) {
                    if (ImageScannerVis.this.openImage[i][j] == '1') {
                        g2.fillRect(j * SZ, i * SZ, SZ, SZ);
                    }
                    ++j;
                }
                ++i;
            }
            g2.setColor(new Color(0xDDDDDD));
            i = 0;
            while (i <= ImageScannerVis.this.H) {
                g2.drawLine(0, i * SZ, ImageScannerVis.this.W * SZ, i * SZ);
                ++i;
            }
            i = 0;
            while (i <= ImageScannerVis.this.W) {
                g2.drawLine(i * SZ, 0, i * SZ, ImageScannerVis.this.H * SZ);
                ++i;
            }
            g2.setColor(Color.BLACK);
            char[] ch = ("" + (ImageScannerVis.this.maxScans - ImageScannerVis.this.nScans)).toCharArray();
            g2.setFont(new Font("Arial", 1, 14));
            FontMetrics fm = g2.getFontMetrics();
            g2.drawChars(ch, 0, ch.length, (ImageScannerVis.this.W + 2) * SZ, SZ + fm.getHeight());
            g.drawImage(bi, 0, 0, (ImageScannerVis.this.W + 2) * SZ + 50, ImageScannerVis.this.H * SZ + 40, null);
        }

        public Vis() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            ImageScannerVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!manual || ImageScannerVis.this.ready) {
                return;
            }
            if (e.getButton() != 1) {
                manual = false;
                ImageScannerVis.this.ready = true;
                return;
            }
            ImageScannerVis.this.highlightRow = -1;
            int row = e.getY() / SZ;
            int col = e.getX() / SZ;
            if (row >= 0 && row < ImageScannerVis.this.H && col >= 0 && col < ImageScannerVis.this.W && !ImageScannerVis.this.openRows[row]) {
                ImageScannerVis.this.openImage[row][col] = (char)(97 - ImageScannerVis.this.openImage[row][col]);
                this.repaint();
            }
            if (row >= 0 && row < ImageScannerVis.this.H && col >= ImageScannerVis.this.W && !ImageScannerVis.this.openRows[row]) {
                ImageScannerVis.this.scan(row);
                if (!ImageScannerVis.this.ok) {
                    ImageScannerVis.this.ready = true;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!manual || ImageScannerVis.this.ready) {
                return;
            }
            int row = e.getY() / SZ;
            int col = e.getX() / SZ;
            if (row >= 0 && row < ImageScannerVis.this.H && col >= ImageScannerVis.this.W && !ImageScannerVis.this.openRows[row]) {
                if (row != ImageScannerVis.this.highlightRow) {
                    ImageScannerVis.this.highlightRow = row;
                    ImageScannerVis.this.v.repaint();
                }
            } else {
                ImageScannerVis.this.highlightRow = -1;
                ImageScannerVis.this.v.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

