/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Reconstruct {
    Controller c;
    View v;
    String[] paramNames = new String[]{"seed", "pieceSize", "file", "redness"};
    static Object runlock = new Object();
    static Object movelock = new Object();
    protected static final int[] POSSIBLE_SIZES = new int[]{10, 20, 30};

    public String getProcess() {
        if (this.v != null) {
            return this.v.fileName.getText();
        }
        return this.c.process;
    }

    public void setProcess(String string) {
        this.c.process = string;
        if (this.v != null) {
            this.v.fileName.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        new Reconstruct(stringArray);
    }

    public Reconstruct(String[] stringArray) {
        int n = 1000;
        int n2 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        this.c = new Controller();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                bl2 = true;
                this.setProcess(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-drop")) {
                this.c.setDrop(true);
                continue;
            }
            if (stringArray[i].equals("-go")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                bl = true;
                this.c.novis = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-speed")) {
                int n3 = Integer.parseInt(stringArray[++i]);
                this.c.setSlide(n3);
                if (n3 >= 80) {
                    this.c.setPause(100 - n3);
                    continue;
                }
                this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, n3)));
                continue;
            }
            if (!stringArray[i].startsWith("-")) continue;
            String string = stringArray[i].substring(1);
            String string2 = stringArray[++i];
            try {
                Field field = this.c.getClass().getDeclaredField(string);
                if (field.getType().getName().equals("int")) {
                    field.set(this.c, new Integer(string2));
                    continue;
                }
                if (field.getType().getName().endsWith("String")) {
                    field.set(this.c, string2);
                    continue;
                }
                System.err.println(field.getType().getName());
                continue;
            }
            catch (Exception exception) {
                System.err.println("Invalid parameters");
                return;
            }
        }
        if (this.c.novis && !bl2) {
            System.err.println("You must specify the executable when using -novis");
            return;
        }
        this.c.generate(false, this.c.getSeed());
        if (!this.c.novis) {
            this.v = new View(n);
            this.v.setSize(n2, n);
            this.v.setVisible(true);
        }
        if (bl) {
            this.c.start();
        }
    }

    class View
    extends JFrame
    implements WindowListener,
    ChangeListener {
        JTextArea err;
        JTextField fileName;
        JScrollPane scroll;
        JSplitPane splitPane;
        JTextField[] params;
        int position;
        Vis sim;

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Reconstruct.this.c.stop();
            System.exit(0);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public View(int n) {
            JSlider jSlider = new JSlider(0, 0, 100, Reconstruct.this.c.getSlide());
            jSlider.addChangeListener(this);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.sim = new Vis();
            this.err = new JTextArea("Standard Error from your program, as well as other messages will appear here");
            this.scroll = new JScrollPane(this.err);
            this.splitPane = new JSplitPane(0, this.sim, this.scroll);
            this.splitPane.setDividerLocation(n - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            this.splitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            this.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            this.params = new JTextField[Reconstruct.this.paramNames.length];
            for (int i = 0; i < Reconstruct.this.paramNames.length; ++i) {
                this.params[i] = new JTextField(Reconstruct.this.c.getParameter(Reconstruct.this.paramNames[i]));
                if (i <= this.params.length / 2) {
                    jPanel2.add(new Label(Reconstruct.this.paramNames[i] + ": "));
                    jPanel2.add(this.params[i]);
                    continue;
                }
                jPanel3.add(new Label(Reconstruct.this.paramNames[i] + ": "));
                jPanel3.add(this.params[i]);
            }
            jPanel2.setAlignmentX(0.5f);
            jPanel3.setAlignmentX(0.5f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel4.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Reconstruct.this.c.stop();
                    Reconstruct.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.repaintSim(false);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Reconstruct.this.c.stop();
                    if (Reconstruct.this.c.getSeed() == Integer.parseInt(View.this.params[0].getText())) {
                        View.this.params[0].setText(String.valueOf(Reconstruct.this.c.newSeed()));
                        Reconstruct.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    } else {
                        Reconstruct.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    }
                    for (int i = 1; i < View.this.params.length; ++i) {
                        View.this.params[i].setText(Reconstruct.this.c.getParameter(Reconstruct.this.paramNames[i]));
                    }
                    View.this.sim.bi = null;
                    View.this.repaintSim(false);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Reconstruct.this.c.stop();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Reconstruct.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.repaintSim(false);
                    Reconstruct.this.c.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Reconstruct.this.c.stop();
                }
            });
            JPanel jPanel5 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            this.fileName = new JTextField(Reconstruct.this.c.process);
            jPanel5.add(jButton5);
            jPanel5.add(this.fileName);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(View.this);
                    if (n == 0) {
                        View.this.fileName.setText(jFileChooser.getSelectedFile().getPath());
                        Reconstruct.this.c.process = jFileChooser.getSelectedFile().getPath();
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
            this.add((Component)this.splitPane, "Center");
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel6, "South");
            this.addWindowListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValue() >= 80) {
                Reconstruct.this.c.setPause(100 - jSlider.getValue());
            } else {
                Reconstruct.this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue())));
            }
        }

        void addMessage(final String string) {
            final JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            if (!(jScrollBar.getValueIsAdjusting() || jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum() && jScrollBar.getValue() != this.position)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        View.this.err.append(string);
                        View.this.position = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                        jScrollBar.setValue(View.this.position);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.position = -1;
                this.err.append(string);
            }
        }

        void repaintSim(boolean bl) {
            Runnable runnable = new Runnable(){

                public void run() {
                    View.this.sim.paintImmediately(0, 0, View.this.sim.getWidth(), View.this.sim.getHeight());
                }
            };
            if (bl && !Reconstruct.this.c.drop()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.sim.repaint();
            }
        }

        public String getParam(int n) {
            String string = this.params[n].getText();
            return string;
        }

        class Vis
        extends JPanel {
            BufferedImage bi = null;
            int size;

            Vis() {
            }

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.gray);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.drawImage((Image)Reconstruct.this.c.image2, (this.getWidth() - Reconstruct.this.c.image2.getWidth()) / 2, (this.getHeight() - Reconstruct.this.c.image2.getHeight()) / 2, null);
                Font font = new Font(graphics2D.getFont().getName(), 0, 40);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n = fontMetrics.getAscent();
                double d = Math.min((double)this.getWidth() / 1000.0, (double)this.getHeight() / (1000.0 + (double)(2 * n)));
                graphics2D.setColor(Color.black);
                String string = "Guesses so far: " + Reconstruct.this.c.guesses;
                String string2 = "Incorrect pieces: " + Reconstruct.this.c.wrong + " / " + Reconstruct.this.c.rows * Reconstruct.this.c.columns;
                graphics2D.drawString(string, 0, n);
                graphics2D.drawString(string2, 0, 2 * n);
            }
        }
    }

    class Controller {
        String process = "Enter your executable and its arguments here";
        Runner current;
        Random r;
        int ST = 20;
        int slide = 80;
        int seed = 1;
        boolean running;
        boolean novis;
        boolean drop;
        int[] pixels;
        ArrayList<Integer> currentPieceLocations;
        ArrayList<Integer> originalPieceLocations;
        BufferedImage image;
        BufferedImage image2;
        int pieceSize;
        int redness = 50;
        int columns;
        int rows;
        int guesses;
        int wrong;
        String file = "";

        Controller() {
        }

        public void generate(boolean bl, int n) {
            int n2;
            Object object;
            try {
                this.r = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.r.setSeed(n);
            if (bl) {
                this.pieceSize = POSSIBLE_SIZES[this.r.nextInt(POSSIBLE_SIZES.length)];
            } else {
                if (this.pieceSize == 0) {
                    this.pieceSize = POSSIBLE_SIZES[this.r.nextInt(POSSIBLE_SIZES.length)];
                } else {
                    this.r.nextInt(POSSIBLE_SIZES.length);
                }
                if (Reconstruct.this.v != null) {
                    try {
                        for (int i = 1; i < Reconstruct.this.paramNames.length; ++i) {
                            object = this.getClass().getDeclaredField(Reconstruct.this.paramNames[i]);
                            if (((Field)object).getType().getName().equals("int")) {
                                ((Field)object).set(this, new Integer(Reconstruct.this.v.getParam(i)));
                                continue;
                            }
                            ((Field)object).set(this, Reconstruct.this.v.getParam(i));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            int[] nArray = new int[this.pieceSize * this.pieceSize];
            try {
                object = Toolkit.getDefaultToolkit().getImage(this.file);
                PixelGrabber pixelGrabber = new PixelGrabber((Image)object, 0, 0, ((Image)object).getWidth(null), ((Image)object).getHeight(null), true);
                pixelGrabber.grabPixels();
                nArray = (int[])pixelGrabber.getPixels();
                if (((Image)object).getWidth(null) >= this.pieceSize && ((Image)object).getHeight(null) >= this.pieceSize) {
                    this.image = new BufferedImage(((Image)object).getWidth(null), ((Image)object).getHeight(null), 1);
                } else {
                    nArray = new int[this.pieceSize * this.pieceSize];
                    this.image = new BufferedImage(this.pieceSize, this.pieceSize, 1);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            int n3 = 0;
            for (n2 = 0; n2 < this.image.getHeight(null); ++n2) {
                for (int i = 0; i < this.image.getWidth(null); ++i) {
                    this.image.setRGB(i, n2, nArray[n3++]);
                }
            }
            this.columns = this.image.getWidth() / this.pieceSize;
            this.rows = this.image.getHeight() / this.pieceSize;
            this.image2 = new BufferedImage(this.columns * this.pieceSize, this.rows * this.pieceSize, 1);
            this.currentPieceLocations = new ArrayList(this.rows * this.columns);
            for (n2 = 0; n2 < this.rows * this.columns; ++n2) {
                this.currentPieceLocations.add(n2);
            }
            Collections.shuffle(this.currentPieceLocations, this.r);
            this.originalPieceLocations = (ArrayList)this.currentPieceLocations.clone();
            this.pixels = new int[this.rows * this.columns * this.pieceSize * this.pieceSize];
            this.rebuffer();
        }

        public int[] verify(int[] nArray) {
            this.wrong = 0;
            int[] nArray2 = new int[this.rows * this.columns];
            for (int i = 0; i < this.rows * this.columns; ++i) {
                int n = this.originalPieceLocations.get(nArray[i]);
                nArray2[i] = n == i ? 1 : 0;
                this.wrong += 1 - nArray2[i];
            }
            return nArray2;
        }

        void rebuffer() {
            int n;
            int n2;
            int n3 = (this.columns * this.pieceSize - this.image.getWidth()) / 2;
            int n4 = (this.rows * this.pieceSize - this.image.getHeight()) / 2;
            int n5 = 0;
            for (n2 = 0; n2 < this.image2.getWidth(); ++n2) {
                for (n = 0; n < this.image2.getHeight(); ++n) {
                    this.image2.setRGB(n2, n, 0);
                }
            }
            for (n2 = 0; n2 < this.rows * this.columns; ++n2) {
                for (n = 0; n < this.pieceSize; ++n) {
                    for (int i = 0; i < this.pieceSize; ++i) {
                        int n6 = i + this.currentPieceLocations.get(n2) % this.columns * this.pieceSize - n3;
                        int n7 = n + this.currentPieceLocations.get(n2) / this.columns * this.pieceSize - n4;
                        if (n6 < 0 || n7 < 0 || n6 >= this.image.getWidth() || n7 >= this.image.getHeight()) {
                            this.pixels[n5++] = 0;
                            continue;
                        }
                        int n8 = n2 % this.columns * this.pieceSize + i;
                        int n9 = n2 / this.columns * this.pieceSize + n;
                        this.pixels[n5++] = this.image.getRGB(n6, n7) & 0xFFFFFF;
                        if (n2 == this.currentPieceLocations.get(n2)) {
                            this.image2.setRGB(n8, n9, this.pixels[n5 - 1]);
                            continue;
                        }
                        int n10 = this.pixels[n5 - 1] >> 16;
                        if ((n10 += this.redness) > 255) {
                            n10 = 255;
                        }
                        if (n10 < 0) {
                            n10 = 0;
                        }
                        this.image2.setRGB(n8, n9, this.pixels[n5 - 1] & 0xFFFF | n10 << 16);
                    }
                }
            }
        }

        void start() {
            if (Reconstruct.this.v != null) {
                Reconstruct.this.v.err.setText("");
            }
            this.current = new Runner();
            this.current.start();
        }

        void stop() {
            this.running = false;
            if (this.current != null) {
                try {
                    if (this.current.pr != null) {
                        this.current.pr.destroy();
                        this.current.pr.waitFor();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.current = null;
            }
        }

        public int newSeed() {
            return this.r.nextInt();
        }

        public void setSeed(int n) {
            this.seed = n;
        }

        public int getSeed() {
            return this.seed;
        }

        public String getParameter(String string) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                return field.get(this).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "ERR";
            }
        }

        public void setParameter(String string, String string2) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                field.set(this, Integer.parseInt(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getSlide() {
            return this.slide;
        }

        public void setSlide(int n) {
            this.slide = n;
        }

        public void setPause(int n) {
            this.ST = n;
        }

        public void addMessage(String string) {
            if (this.novis) {
                System.out.print(string);
            } else {
                Reconstruct.this.v.addMessage(string);
            }
        }

        public void addFatalError(String string) {
            this.addMessage(string);
        }

        public boolean drop() {
            return this.drop;
        }

        public void setDrop(boolean bl) {
            this.drop = bl;
        }

        class Runner
        extends Thread {
            Process pr;
            BufferedReader input;
            InputStream error;
            DataOutputStream os;

            Runner() {
            }

            void writeParams() throws IOException {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Controller.this.pieceSize).append(' ').append(Controller.this.columns).append(' ').append(Controller.this.rows).append('\n');
                for (int i = 0; i < Controller.this.pixels.length; ++i) {
                    stringBuffer.append(Controller.this.pixels[i]).append('\n');
                }
                this.os.write(stringBuffer.toString().getBytes());
                this.os.flush();
            }

            int[] next() throws IOException {
                try {
                    String string = this.input.readLine();
                    if (string == null) {
                        return null;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    int[] nArray = new int[Controller.this.rows * Controller.this.columns];
                    for (int i = 0; i < nArray.length; ++i) {
                        while (!stringTokenizer.hasMoreTokens()) {
                            stringTokenizer = new StringTokenizer(this.input.readLine());
                        }
                        nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    return nArray;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void run() {
                this.runTest();
                this.pr.destroy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runTest() {
                Controller.this.running = true;
                try {
                    Object object = runlock;
                    synchronized (object) {
                        Object object2;
                        Object object3;
                        this.pr = Runtime.getRuntime().exec(Reconstruct.this.getProcess());
                        this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
                        this.error = this.pr.getErrorStream();
                        this.os = new DataOutputStream(this.pr.getOutputStream());
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            public void run() {
                                Runner.this.pr.destroy();
                            }
                        }));
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    int n;
                                    byte[] byArray = new byte[50000];
                                    while ((n = Runner.this.error.read(byArray)) > 0 && Controller.this.running) {
                                        Controller.this.addMessage(new String(byArray, 0, n));
                                    }
                                    Controller.this.addMessage("\n");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        thread.start();
                        Controller.this.guesses = 0;
                        this.writeParams();
                        while (Controller.this.running) {
                            ++Controller.this.guesses;
                            object3 = this.next();
                            if (object3 == null) {
                                Controller.this.addMessage("Ending simulation because I didn't receive a valid sequence for verification (pipe closed or invalid format)");
                                break;
                            }
                            if (((int[])object3).length != Controller.this.rows * Controller.this.columns) {
                                Controller.this.addMessage("Received only " + ((int[])object3).length + " integers for verification");
                                break;
                            }
                            object2 = Controller.this.verify((int[])object3);
                            for (int i = 0; i < ((int[])object3).length; ++i) {
                                Controller.this.currentPieceLocations.set(i, Controller.this.originalPieceLocations.get(object3[i]));
                            }
                            Reconstruct.this.c.rebuffer();
                            if (!Controller.this.novis) {
                                Reconstruct.this.v.repaintSim(true);
                                if (Controller.this.ST != 0) {
                                    Thread.sleep(Controller.this.ST);
                                }
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            for (int i = 0; i < ((int[])object2).length; ++i) {
                                stringBuffer.append(object2[i]);
                            }
                            stringBuffer.append('\n');
                            this.os.write(stringBuffer.toString().getBytes());
                            this.os.flush();
                        }
                        object3 = "Guesses so far: " + Reconstruct.this.c.guesses + "\n";
                        object2 = "Incorrect pieces: " + Reconstruct.this.c.wrong + " / " + Reconstruct.this.c.rows * Reconstruct.this.c.columns + "\n";
                        Controller.this.addMessage("Simulation over\n");
                        Controller.this.addMessage((String)object3);
                        Controller.this.addMessage((String)object2);
                    }
                }
                catch (IOException iOException) {
                    Controller.this.addMessage("Simulation over because communication between the visualizer and your process ended.\n");
                    Controller.this.addMessage(iOException.getMessage() + "\n");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

