#include <math.h>
#include <vector>
using namespace std;

class ImageFilter{
    public:
        vector <double> filter(int W, int H, int K, vector <double> red, vector <double> green, vector <double> blue, vector <double> A, vector <double> B, double C){
            vector<double> ret(red.size()*3);

            for(int i = 0; i<red.size()/ W; i++){//row
                for(int j = 0; j<W; j++){//column
                    ret[i*W+j] = C;
                    ret[W*H+i*W+j] = C;
                    ret[2*W*H+i*W+j] = C;
                    for(int di = -K; di<=K; di++){
                        for(int dj = -K; dj<=K; dj++){
                            int ii = i + di;
                            int jj = j + dj;
                            int k = (di + K) * (K+K+1) + (dj + K);
                            if(ii >=0 && jj >= 0 && ii < H && jj < W){
                                ret[i*W+j] += red[ii*W+jj] * B[k];
                                ret[W*H+i*W+j] += green[ii*W+jj] * B[k];
                                ret[2*W*H+i*W+j] += blue[ii*W+jj] * B[k];
                                for(int di2 = -K; di2<=K; di2++){
                                    for(int dj2 = -K; dj2<=K; dj2++){
                                        int l = (di2 + K) * (K+K+1) + (dj2 + K);
                                        if(A[k*(K+K+1)*(K+K+1) + l] == 0)continue;
                                        int ii2 = i + di2;
                                        int jj2 = j + dj2;
                                        if(ii2 >=0 && jj2 >= 0 && ii2 < H && jj2 < W){
                                            ret[i*W+j] += red[ii*W+jj] * red[ii2*W+jj2] * A[k*B.size() + l];
                                            ret[W*H+i*W+j] += green[ii*W+jj]  * green[ii2*W+jj2]* A[k*B.size() + l];
                                            ret[2*W*H+i*W+j] += blue[ii*W+jj]  * blue[ii2*W+jj2]* A[k*B.size() + l];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return ret;
        }
};

int main(){
    int W, H, K, i;
    vector<double> red, green, blue, A, B;
    double C;
    double d;
    scanf("%d%d%d",&W,&H,&K);
    for(i = 0; i<W*H; i++){
        scanf("%lf",&d);
        red.push_back(d);
    }
    for(i = 0; i<W*H; i++){
        scanf("%lf",&d);
        green.push_back(d);
    }
    for(i = 0; i<W*H; i++){
        scanf("%lf",&d);
        blue.push_back(d);
    }
    for(i = 0; i<(K+K+1)*(K+K+1)*(K+K+1)*(K+K+1); i++){
        scanf("%lf",&d);
        A.push_back(d);
    }
    for(i = 0; i<(K+K+1)*(K+K+1); i++){
        scanf("%lf",&d);
        B.push_back(d);
    }
    scanf("%lf",&C);
    ImageFilter im;
    fprintf(stderr,"START\n");
    fflush(stderr);
    vector<double> op = im.filter(W,H,K,red,green,blue,A,B,C);
    fprintf(stderr,"DONE\n");
    fflush(stderr);
    for(i = 0; i<op.size(); i++){
        printf("%lf\n",op[i]);
    }
    fflush(stdout);

}

