import java.util.*;
import java.awt.*;
import java.io.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.imageio.*;
import java.security.*;
public class Runner {
    public double pow = 1;
    int it = 0;
    static int S = 2;
    Random r;
    double[][] a;
    double[] b;
    double c;
    int[] used;
    int N, K, L;
    public void generate(int seed){
        seed++;
        try{
            r = SecureRandom.getInstance("SHA1PRNG");
            r.setSeed(seed);
        }catch(Exception e){
            e.printStackTrace();
        }
        K = r.nextInt(10)+1;
        if(seed > 0 && seed <= 10){
            K = seed;
        }
        N = K+K+1;
        N = N*N;
        L = r.nextInt(N)+1;
        boolean[] use = new boolean[N];
        used = new int[L];
        for(int i = 0; i<L ;i++){
            int j = r.nextInt(N);
            if(use[j]){
                i--;
            }else{
                used[i] = j;
                use[j] = true;
            }
        }

        a = new double[L][L];
        b = new double[L];
        c = r.nextGaussian();
        for(int i = 0; i<L; i++){
            b[i] = r.nextGaussian();
        }

        double[] u = new double[L];
        double[] v = new double[L];
        double sum = 0;
        for(int i = 0; i<L; i++){
            for(int j = 0 ;j<L; j++){
                u[j] = r.nextGaussian();
                v[j] = r.nextGaussian();
            }
            for(int j = 0 ;j<L; j++){
                for(int k = 0; k<L; k++){
                    a[j][k] += u[j] * v[k] * pow;
                }
            }
            sum += pow;
            pow *= r.nextDouble();
        }
        for(int i = 0; i<L; i++){
            for(int j = 0 ;j<L; j++){
                a[i][j] /= sum;
            }
        }
    }
    int transpose(int n){
        int row = n / (K+K+1);
        int col = n % (K+K+1);
        return col * (K+K+1) + row;

    }
    String exec;
    Process proc;
    InputStream is;
    OutputStream os;
    public static void main(String[] args) throws Exception{
        //Locale.setDefault(Locale.US);
        new Runner(args);
    }
    public Runner(String[] args) throws Exception{
        String seed = null;
        String base = null;
        String exec = null;
        boolean output = false;
        boolean compare = false;
        boolean diff = false;
        boolean view = false;
        for (int i = 0; i<args.length; i++) {
            if (args[i].equals("-seed"))
                seed = args[++i];
            if (args[i].equals("-exec"))
                exec = args[++i];
            if (args[i].equals("-base"))
                base = args[++i];
            if (args[i].equals("-compare"))
                compare = true;
            if (args[i].equals("-view"))
                view = true;
            if (args[i].equals("-diff"))
                diff = compare = true;
            if (args[i].equals("-output"))
                output = true;
        }
        if(exec == null || seed == null || base == null){
            System.err.println("Usage : java -Xmx256M Runner -exec <cmd> -seed <seed> -base <base>");
            return;
        }
        generate(Integer.parseInt(seed));
        double[] A = new double[N*N];
        double[] B = new double[N];
        for(int i = 0; i<L; i++){
            B[transpose(used[i])] = b[i];
            for(int j = 0; j<L;j++){
                A[transpose(used[i])*N+transpose(used[j])] = a[i][j];
            }
        }
        Scanner sci = new Scanner(new FileInputStream(base+".raw"));
        int W = sci.nextInt();
        int H = sci.nextInt();
        double[] r = new double[W*H];
        double[] g = new double[W*H];
        double[] b = new double[W*H];
        double[] ro = new double[W*H];
        double[] go = new double[W*H];
        double[] bo = new double[W*H];
        for(int i = 0; i<W*H; i++){
            r[i] = sci.nextInt()/65535.0;
            g[i] = sci.nextInt()/65535.0;
            b[i] = sci.nextInt()/65535.0;
        }
        Runtime rt = Runtime.getRuntime();
        proc = rt.exec(exec);
        os = proc.getOutputStream();
        is = proc.getInputStream();
        new ErrorReader(proc.getErrorStream()).start();
        rt.addShutdownHook(
                new Thread(){
                    public void run(){
                        if(proc != null) {
                            try { proc.destroy(); } 
                            catch (Exception ex) { ex.printStackTrace(); }
                        }
                        //System.exit(0); 
                    }
                }
                );
        StringBuffer sb = new StringBuffer();
        sb.append(W).append('\n').append(H).append('\n').append(K).append('\n');

        sb.append(r[0]);
        for(int i = 1; i<r.length; i++)
            sb.append(' ').append(r[i]);
        sb.append('\n');

        sb.append(g[0]);
        for(int i = 1; i<g.length; i++)
            sb.append(' ').append(g[i]);
        sb.append('\n');

        sb.append(b[0]);
        for(int i = 1; i<b.length; i++)
            sb.append(' ').append(b[i]);
        sb.append('\n');

        sb.append(A[0]);
        for(int i = 1; i<A.length; i++)
            sb.append(A[i]).append(' ');
        sb.append('\n');

        sb.append(B[0]);
        for(int i = 1; i<B.length; i++)
            sb.append(B[i]).append(' ');
        sb.append('\n');

        sb.append(c).append('\n');

        os.write(sb.toString().getBytes());
        os.flush();

        Scanner sc = new Scanner(new InputStreamReader(is));
        double min = 1e9, max = -1e9;

        for(int i = 0; i<r.length; i++){
            ro[i] = sc.nextDouble();
            if(ro[i] > max)max = ro[i];
            if(ro[i] < min)min = ro[i];
        }
        for(int i = 0; i<r.length; i++){
            go[i] = sc.nextDouble();
            if(go[i] > max)max = go[i];
            if(go[i] < min)min = go[i];
        }
        for(int i = 0; i<r.length; i++){
            bo[i] = sc.nextDouble();
            if(bo[i] > max)max = bo[i];
            if(bo[i] < min)min = bo[i];
        }
        double[] rc = null, gc = null, bc = null;
        if(compare){
            Scanner sco = new Scanner(new FileInputStream(base+".result"));
            rc = new double[W*H];
            gc = new double[W*H];
            bc = new double[W*H];
            sco.nextInt();
            sco.nextInt();
            for(int i = 0; i<r.length; i++){
                rc[i] = sco.nextDouble();
                gc[i] = sco.nextDouble();
                bc[i] = sco.nextDouble();
            }
            double err = 0;
            min = 1e9; max = -1e9;

            for(int i = 0; i<r.length; i++){
                if(rc[i] > max)max = rc[i];
                if(rc[i] < min)min = rc[i];
                if(gc[i] > max)max = gc[i];
                if(gc[i] < min)min = gc[i];
                if(bc[i] > max)max = bc[i];
                if(bc[i] < min)min = bc[i];
            }
            for(int i = 0; i<r.length; i++){
                double dr = (rc[i] - ro[i])/(max-min);
                double dg = (gc[i] - go[i])/(max-min);
                double db = (bc[i] - bo[i])/(max-min);
                err += dr*dr+dg*dg+db*db;
            }
            //we'll use the real min and max if we've bothered to load them
            err /= r.length * 3;
            System.out.println("E = "+err);
        }

        BufferedImage you = null, diffim = null;
        if(view || output){
            bi = you = new BufferedImage(W,H,BufferedImage.TYPE_INT_RGB);
            for(int i = 0; i<r.length ;i++){
                int rr = (int)((ro[i] - min)/(max-min)*255.999);
                int gg = (int)((go[i] - min)/(max-min)*255.999);
                int bb = (int)((bo[i] - min)/(max-min)*255.999);
                if(rr > 255)rr = 255; else if (rr < 0)rr = 0;
                if(gg > 255)gg = 255; else if (gg < 0)gg = 0;
                if(bb > 255)bb = 255; else if (bb < 0)bb = 0;
                you.setRGB(i%W,i/W,(rr<<16)|(gg<<8)|bb);
            }
            if(diff){
                bi = diffim = new BufferedImage(W,H,BufferedImage.TYPE_INT_RGB);
                min = max = 0;
                for(int i = 0; i<r.length ;i++){
                    double dr = Math.abs(rc[i] - ro[i]);
                    double dg = Math.abs(gc[i] - go[i]);
                    double db = Math.abs(bc[i] - bo[i]);
                    if(dr > max)max = dr;
                    if(dg > max)max = dg;
                    if(db > max)max = db;
                }
                for(int i = 0; i<r.length ;i++){
                    int rr = (int)(Math.abs(ro[i] - rc[i])/max*255.999);
                    int gg = (int)(Math.abs(go[i] - gc[i])/max*255.999);
                    int bb = (int)(Math.abs(bo[i] - bc[i])/max*255.999);
                    diffim.setRGB(i%W,i/W,(rr<<16)|(gg<<8)|bb);
                }
            }
            if(output){
                ImageIO.write(you,"png",new File(base+".you.png"));
                if(diffim != null)
                    ImageIO.write(diffim,"png",new File(base+".diff.png"));
            }
            if(view){
                JFrame jf = new JFrame();
                jf.add(new JPanel(){
                    public void paint(Graphics g){
                        g.drawImage(bi,0,0,null);
                    }
                });
                jf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                jf.setSize(bi.getWidth()+10,bi.getHeight()+50);
                jf.setVisible(true);
            }
        }

    }
    BufferedImage bi;
    /*class Closer implements WindowListener {
        public void windowActivated(WindowEvent e) {}
        public void windowDeactivated(WindowEvent e) {}
        public void windowOpened(WindowEvent e) {}
        public void windowClosing(WindowEvent e) {
            if(proc != null) {
                try { proc.destroy(); } 
                catch (Exception ex) { ex.printStackTrace(); }
            }
            System.exit(0); 
        }
        public void windowClosed(WindowEvent e) {}
        public void windowIconified(WindowEvent e) {}
        public void windowDeiconified(WindowEvent e) {}
    }*/

}


class ErrorReader extends Thread{
    InputStream error;
    public ErrorReader(InputStream is) {
        error = is;
    }
    public void run() {
        try {
            byte[] ch = new byte[50000];
            int read;
            while ((read = error.read(ch)) > 0)
            {   String s = new String(ch,0,read);
                System.out.print(s);
                System.out.flush();
            }
        } catch(Exception e) { }
    }
}

