import java.util.*;
import java.lang.*;
import java.text.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import java.security.*;
import javax.swing.*;
import javax.imageio.*;

public class GraphicalAuthentication {
    int N;			//screen of NxN images in a grid
    int M;			//M pass-images
    int SZ;			//each image sized SZxSZ
    int diff;			//maximal number of pixels to be changed when displaying the image
    BufferedImage[] all;	//all images, including unused
    BufferedImage[] basic;	//basic images for the concrete test
    int[] pass;			//indices of pass-images (in basic)
    int ncalls;			//number of calls of successfullLogin
    int maxcalls;		//max number of calls
    boolean can;		//true if you still can call successfullLogin
    //params of the shown screen
    BufferedImage[] shown;	//shown images (after modification)
    int[] xpass, ypass;		//positions of pass-images
    Point[] hull;		//convex hull of the images
    Point click;		//coordinates of the click
    SecureRandom r;
// ------------- problem itself ----------------
    void loadImages() {
      try {
	//all images from directory images// (can be any type, any size, we don't check)
	all = new BufferedImage[256];
    int ptr = 0;
    for(int i = 0; i<= 258; i++){
        if(i == 24 || i == 230 || i == 252)continue;
	    all[ptr++] = ImageIO.read(new File("images/"+i+".png"));
    }
	System.out.println(all.length+" images loaded");
	SZ = all[0].getWidth();		//assume they are all squares of same size
      }
      catch (Exception e) { e.printStackTrace(); }
    }
    // -----------------------------------------
    void generate(String seed) {
      try {
	loadImages();
        r = SecureRandom.getInstance("SHA1PRNG");
        r.setSeed(Long.parseLong(seed));
	N=10;
	M=r.nextInt(5)+5;
	diff=4;
	//choose and modify the images to be used in this test case
	int i,j,x,y,c, na = all.length, nc = 0;
	boolean[] chosen = new boolean[na];
	boolean invert,ok;
	for (i=0; i<na; i++)
	    if (r.nextInt(1000)<800)
	    {	chosen[i]=true;
		nc++;
	    }
	    else chosen[i]=false;
	basic = new BufferedImage[nc];
	j=0;
	for (i=0; i<na; i++)
	    if (chosen[i])
	    {   basic[j]=new BufferedImage(SZ,SZ,BufferedImage.TYPE_INT_RGB);
		invert = (r.nextInt(2)==1);
		for (x=0; x<SZ; x++)
		for (y=0; y<SZ; y++)
		{   c=all[i].getRGB(x,y);
		    if (invert)
			c=0xFFFFFF-c;
		    basic[j].setRGB(x,y,c);
		}
		j++;
	    }
	//choose pass-images
	pass = new int[M];
	for (i=0; i<M; i++)
	{   do {
		pass[i] = r.nextInt(nc);
		//check for doubles
		ok=true;
		for (j=0; j<i; j++)
		    if (pass[i]==pass[j])
		    {	ok=false;
			break;
		    }
	    } while (!ok);
	}
      }
      catch (Exception e) { e.printStackTrace(); }
    }
    // -----------------------------------------
    void genScreen() {
	//generates the images to be displayed in one login attempt
	int npass,t;
	t = r.nextInt(10);
	     if (t<1) npass=5;
	else if (t<3) npass=4;
	else if (t<7) npass=3;
	else if (t<9) npass=2;
	else          npass=1;
	t=N*N-npass;		//number of free slots
	int ndecoy = r.nextInt(t/2+1)+t/2;	//some of the images might be missing
	int[] ind = new int[N*N];
	int i,j,d,x,y,n;
	boolean ok;
	int[] dx = {1,1,1,0,-1,-1,-1,0};
	int[] dy = {1,0,-1,-1,-1,0,1,1};
	//get the indices of the images to be shown
	//it's possible to have several images with the same index (but distorted differently)
	//pass-images
	for (i=0; i<npass; i++)
	    ind[i] = pass[r.nextInt(pass.length)];
	//decoy-images
	for (i=0; i<ndecoy; i++)
	{   do {
		ind[i+npass] = r.nextInt(basic.length);
		ok = true;
		for (j=0; j<pass.length; j++)
		    if (pass[j]==ind[i+npass])
		    {	ok=false;
			break;
		    }
	    } while (!ok);
	}
	//empty spaces
	for (i=0; i<N*N-ndecoy-npass; i++)
	    ind[i+npass+ndecoy] = -1;
	//now shuffle them randomly
	for (i=0; i<N*N; i++)
	{   j = r.nextInt(N*N-i)+i;
	    if (i==j) continue;
	    t = ind[j];
	    ind[j] = ind[i];
	    ind[i] = t;
	}
	//store positions of pass-images
	xpass = new int[npass];
	ypass = new int[npass];
	j=0;
	for (i=0; i<N*N; i++)
	    if (ind[i]!=-1)
	    	for (t=0; t<M; t++)
		    if (ind[i]==pass[t])
		    {	xpass[j] = i/N;
			ypass[j] = i%N;
			j++;
			break;
		    }
	//finally, get the distorted images
	shown = new BufferedImage[N*N];
	for (i=0; i<N*N; i++)
	{   shown[i] = new BufferedImage(SZ,SZ,BufferedImage.TYPE_INT_RGB);
	    if (ind[i]==-1)
		for (x=0; x<SZ; x++)
		for (y=0; y<SZ; y++)
		    shown[i].setRGB(x,y,0xFFFFFF);
	    else
	    {	for (x=0; x<SZ; x++)
		for (y=0; y<SZ; y++)
		    shown[i].setRGB(x,y,basic[ind[i]].getRGB(x,y));
		d = r.nextInt(diff+1);
		while (d>0)
		{   //invert one random pixel
		    //which has at least one pixel of other color near it
		    do {
			x = r.nextInt(SZ);
			y = r.nextInt(SZ);
			t = shown[i].getRGB(x,y);
			n=0;
			for (j=0; j<8; j++)
			    if (x+dx[j]>=0 && x+dx[j]<SZ && y+dy[j]>=0 && y+dy[j]<SZ && shown[i].getRGB(x+dx[j],y+dy[j])!=t)
				n++;
		    }
		    while (n==0);
		    shown[i].setRGB(x,y,0xFFFFFF-t);
		    d--;
		}
	    }
	}
	genConvexHull();
    }
    // -----------------------------------------
    void genConvexHull() {
	//given the positions of the pass-images, generate their convex hull as a set of points
	//add points - corners of the images
	Point[] p = new Point[4*xpass.length];
	int i,j,x,y,n,d;
	for (i=0; i<xpass.length; i++)
	{   x=xpass[i]*SZ;
	    y=ypass[i]*SZ;
	    p[4*i+0] = new Point(x,y);
	    p[4*i+1] = new Point(x+SZ-1,y);
	    p[4*i+2] = new Point(x,y+SZ-1);
	    p[4*i+3] = new Point(x+SZ-1,y+SZ-1);
	}
	//generate the convex hull (as indices)
	int[] h = new int[p.length+1];
	boolean[] vis = new boolean[p.length];
	n=0;
	//the leftmost point
	j=0;
	for (i=1; i<p.length; i++)
	    if (p[i].compareTo(p[j])<0)
		j=i;
	h[0]=j;
	n++;
	do {//find next point
	    d=0;
	    j=-1;
	    for (i=0; i<p.length; i++)
	    {   if (i==h[n-1] || vis[i]) continue;	//don't reuse points and go back
		y = p[i].subtract(p[h[n-1]]).abs2();	//distance
		if (j==-1) { j=i; d=y; continue; }
		x = p[i].subtract(p[h[n-1]]).crossProd(p[j].subtract(p[h[n-1]]));	//cross-prod
		if (x<0 || x==0 && y>d)
		{   d=y;
		    j=i;
		}
	    }
	    h[n]=j;
	    vis[j]=true;
	    n++;
	} 
	while (h[0]!=h[n-1]);
	//store as points
	hull = new Point[n];
	for (i=0; i<n; i++)
	    hull[i] = p[h[i]];
    }
    // -----------------------------------------
    boolean isInside(Point p) {
	//checks whether the point is inside of the hull
	double a=0,da;
	for (int i=0; i<hull.length-1; i++)
	{   da = Math.atan2(hull[i+1].y-p.y, hull[i+1].x-p.x) - Math.atan2(hull[i].y-p.y, hull[i].x-p.x);
	    if (da >  Math.PI) 
		da-=2*Math.PI;
	    if (da < -Math.PI) 
		da+=2*Math.PI;
	    a+=da;
	}
	if (a>-Math.PI && a<Math.PI)
	    return false;
	return true;
    }
    // -----------------------------------------
    void genClick() {
	//generate a random integer-coord point within the hull
	do { 
	    click = new Point(r.nextInt(N*SZ),r.nextInt(N*SZ));
	} while (!isInside(click));
    }
    // -----------------------------------------
    String[] formatScreen() {
	//converts shown to String[]
	String[] ret = new String[N*SZ];
	int i,j;
	for (i=0; i<N*SZ; i++)
	{   ret[i] = "";
	    for (j=0; j<N*SZ; j++)
	    	if ((shown[(j/SZ)*N+(i/SZ)].getRGB(j%SZ,i%SZ) & 0xFFFFFF)==0xFFFFFF)
		    ret[i] += '0';
		else ret[i] += '1';
	}
	return ret;
    }
    // --------- library function --------------
    public String[] successfullLogin() {
	//generates a successfull login attempt and formats it
	if (ncalls == maxcalls)
	{   addFatalError("Number of successfullLogin calls exceeded the maximal number of calls.");
	    return new String[0];
	} 
	if (!can)
	{   addFatalError("You can't call successfullLogin after you start logging in youself.");
	    return new String[0];
	}
	ncalls++;
	genScreen();
	genClick();
	String[] ret = new String[N*SZ+2];	//x,y,lines
	String[] scr = formatScreen();
	ret[0] = click.x+"";
	ret[1] = click.y+"";
	int i;
	for (i=0; i<N*SZ; i++)
	    ret[i+2] = scr[i];
	return ret;
    }
    // -----------------------------------------
    public double runTest(String seed) {
        try {
            ncalls=0;
            maxcalls=100;
            can=true;
            //simulate call of shoulderSurfing
            os.write((basic.length+"\n"+M+"\n"+SZ+"\n").getBytes());
            os.flush();
            //now get the calls of successfullLogin
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String[] att;
            String t;
            int i,j;
            while ((t=br.readLine()).equals("1"))
            {   att = successfullLogin();
                if (att.length==0)
                    return 0.0;
                //visualize
                if (vis)
                {   v.repaint();
                    rob.delay(del);
                }
                //output
                for (i=0; i<att.length; i++)
                    os.write((att[i]+"\n").getBytes());
                os.flush();
            }
            can=false;	//no more attempts
            //and now restart the random numbers generator and get loginAttempt's
            r = SecureRandom.getInstance("SHA1PRNG");
            r.setSeed(Long.parseLong(seed)+1);
            int na = r.nextInt(6)+3;	//3..8 attempts
            int[] ret = new int[2];
            for (i=0; i<na; i++)
            {   genScreen();
                att = formatScreen();
                //output
                for (j=0; j<att.length; j++)
                    os.write((att[j]+"\n").getBytes());
                os.flush();
                //get the return
                ret[0] = Integer.parseInt(br.readLine());
                ret[1] = Integer.parseInt(br.readLine());
                //check whether it's correct
                click = new Point(ret[0],ret[1]);
                if (vis)
                {   v.repaint();
                    rob.delay(del);
                }
                if (!isInside(click))
                    return 0.0;
            }
            return 1+1.0/(1+ncalls);
        }
        catch (Exception e) { 
            System.err.println("An exception occurred while trying to get your program's results.");
            e.printStackTrace(); 
            return 0.0;
        }
    }
    // -----------------------------------------
    public String checkData(String test) {
        return "";
    }
    // -----------------------------------------
    public String displayTestCase(String test) {
	StringBuffer sb = new StringBuffer();
	sb.append("seed = "+test);
	return sb.toString();
    }
// ------------- visualization part ------------
    Vis v;
    Robot rob;
    static String exec;
    static boolean vis = true;
    static Process proc;
    static int del;
    InputStream is;
    OutputStream os;
    // -----------------------------------------
    public class Vis extends JPanel {
        public void paint(Graphics g) {
	    if (shown==null) return;
	    //display the current attempt
	    int i;
	    for (i=0; i<N*N; i++)
		g.drawImage(shown[i],2*(i/N)*SZ,2*(i%N)*SZ,2*SZ,2*SZ,new Color(0xFFFFFF),null);
	    if (hull==null) return;
	    g.setColor(new Color(0x00FF00));
	    for (i=0; i<hull.length-1; i++)
		g.drawLine(2*hull[i].x, 2*hull[i].y, 2*hull[i+1].x, 2*hull[i+1].y);
	    if (click==null) return;
	    g.setColor(new Color(0xFF0000));
	    g.fillRect(2*click.x,2*click.y,3,3);
	}
    }
    // -----------------------------------------
    public GraphicalAuthentication(String seed) {
	//interface for runTest
	generate(seed);
	if (vis)
	{   JFrame jf = new JFrame();
            Closer cl = new Closer();
            jf.addWindowListener(cl);
            jf.setSize(2*N*SZ+10,2*N*SZ+30);
            v = new Vis();
	    jf.getContentPane().add(v);
            jf.setVisible(true);
	    try { rob = new Robot(); }
	    catch (Exception e) { e.printStackTrace(); }
	}
        if (exec != null) {
            try {
                Runtime rt = Runtime.getRuntime();
                proc = rt.exec(exec);
                os = proc.getOutputStream();
                is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
	System.out.println("Score = "+runTest(seed));
    }
    // -----------------------------------------
    public static void main(String[] args) {
        String seed = "1";
	vis = true;
	del = 0;
        for (int i = 0; i<args.length; i++)
        {   if (args[i].equals("-seed"))
                seed = args[++i];
            if (args[i].equals("-exec"))
                exec = args[++i];
	    if (args[i].equals("-delay"))
		del = Integer.parseInt(args[++i]);
            if (args[i].equals("-novis"))
                vis = false;
	}
	GraphicalAuthentication f = new GraphicalAuthentication(seed);
    }
    // -----------------------------------------
    void addFatalError(String message) {
	System.out.println(message);
    }
    // -----------------------------------------
    class Closer implements WindowListener {
        public void windowActivated(WindowEvent e) {}
        public void windowDeactivated(WindowEvent e) {}
        public void windowOpened(WindowEvent e) {}
        public void windowClosing(WindowEvent e)
	{   if(proc != null) {
                try { proc.destroy(); } 
		catch (Exception ex) { ex.printStackTrace(); }
            }
            System.exit(0); 
        }
        public void windowClosed(WindowEvent e) {}
        public void windowIconified(WindowEvent e) {}
        public void windowDeiconified(WindowEvent e) {}
    }
}

class ErrorReader extends Thread{
    InputStream error;
    public ErrorReader(InputStream is) {
        error = is;
    }
    public void run() {
        try {
            byte[] ch = new byte[50000];
            int read;
            while ((read = error.read(ch)) > 0)
	    {   String s = new String(ch,0,read);
                System.out.print(s);
                System.out.flush();
            }
        } catch(Exception e) { }
    }
}

class Point extends Object implements Comparable {
    // -----------------------------------------
    public int x,y;
    // -----------------------------------------
    public Point(int newx, int newy) {
	x=newx;      y=newy;
    }
    // -----------------------------------------
    public Point(Point newc) {
        x=newc.x;    y=newc.y;
    }
    // -----------------------------------------
    public boolean equals(Point other) {
        return ( x==other.x && y==other.y );
    } 
    // -----------------------------------------
    public int compareTo(Object other) {
        Point otherP = (Point)other;
        if (equals(otherP))
           return 0;
        if (x<otherP.x || x==otherP.x && y<otherP.y) return -1;
        return 1;
    }
    // -----------------------------------------
    public int crossProd(Point other) {
        return x*other.y - y*other.x;
    }
    // -----------------------------------------
    public int abs2() {
        return x*x+y*y;
    }
    // -----------------------------------------
    public Point subtract(Point other) {
        return new Point(x-other.x, y-other.y);
    }
}
