/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GearingVis {
    int N;
    int K;
    int M;
    int[] teeth;
    int[] cnt;
    Random r;
    static final int O2 = 10;
    static final int O1 = 9;
    static final int AXLE = 10;
    static int S = 800;
    static double speed = 1.0;
    static boolean animate = true;
    int W;
    int H;
    double theta;
    double[] pow;
    BufferedImage bi;
    double[] x;
    double[] y;
    int[] s;
    int[] p;
    double minx;
    double maxx;
    double miny;
    double maxy;
    static String exec;
    static String file;
    static Process proc;
    InputStream is;
    OutputStream os;

    BufferedImage drawMap() {
        double d = Math.max(this.maxx - this.minx, this.maxy - this.miny);
        this.W = (int)((double)S * (this.maxx - this.minx) / d) + 1;
        this.H = (int)((double)S * (this.maxy - this.miny) / d) + 1;
        BufferedImage bufferedImage = new BufferedImage(this.W, this.H, 1);
        int[] nArray = new int[this.W * this.H];
        int[] nArray2 = new int[]{255, 65280, 0xFF0000, 65535, 0xFF00FF, 0xFFFF00};
        for (int i = 0; i < this.x.length; ++i) {
            int n = (int)((this.x[i] - (double)(10 * this.s[i]) - this.minx) / d * (double)S);
            int n2 = (int)((this.y[i] - (double)(10 * this.s[i]) - this.miny) / d * (double)S);
            int n3 = (int)((this.x[i] + (double)(10 * this.s[i]) - this.minx) / d * (double)S) + 1;
            int n4 = (int)((this.y[i] + (double)(10 * this.s[i]) - this.miny) / d * (double)S) + 1;
            for (int j = n; j < n3; ++j) {
                for (int k = n2; k < n4; ++k) {
                    double d2 = (double)k * d / (double)S - this.y[i] + this.miny;
                    double d3 = (double)j * d / (double)S - this.x[i] + this.minx;
                    double d4 = Math.atan2(d2, d3) + this.theta * this.pow[i];
                    d4 = d4 < 0.0 ? Math.PI * 2 - -d4 % (Math.PI * 2) : (d4 %= Math.PI * 2);
                    if (!(d3 * d3 + d2 * d2 < (double)(this.s[i] * this.s[i] * 100)) || !(d3 * d3 + d2 * d2 > (double)((this.s[i] * 10 - 20) * (this.s[i] * 10 - 20))) && (!(d4 > 0.0) || !(d4 < 0.7853981633974483))) continue;
                    int n5 = k * this.W + j;
                    int n6 = nArray[n5] >> 24;
                    int n7 = nArray[n5] & 0xFF0000;
                    int n8 = nArray[n5] & 0xFF00;
                    int n9 = nArray[n5] & 0xFF;
                    n7 = (n7 * n6 + (nArray2[this.p[i]] & 0xFF0000)) / (n6 + 1) & 0xFF0000;
                    n8 = (n8 * n6 + (nArray2[this.p[i]] & 0xFF00)) / (n6 + 1) & 0xFF00;
                    n9 = (n9 * n6 + (nArray2[this.p[i]] & 0xFF)) / (n6 + 1) & 0xFF;
                    nArray[k * this.W + j] = n6 + 1 << 24 | n7 | n8 | n9;
                }
            }
        }
        bufferedImage.setRGB(0, 0, this.W, this.H, nArray, 0, this.W);
        return bufferedImage;
    }

    public GearingVis(String string) throws IOException {
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        int n = 0;
        if (file != null) {
            this.bi = this.drawMap();
            if (file.equals("-")) {
                JFrame jFrame = new JFrame();
                jFrame.setSize(this.W + 8, this.H + 30);
                n = this.H + 30;
                final JPanel jPanel = new JPanel(){

                    public void paint(Graphics graphics) {
                        graphics.drawImage(GearingVis.this.bi, 0, 0, null);
                    }
                };
                jFrame.getContentPane().add(jPanel);
                jFrame.setDefaultCloseOperation(3);
                jFrame.setVisible(true);
                if (animate) {
                    new Thread(){

                        public void run() {
                            long l = System.nanoTime();
                            while (true) {
                                long l2 = System.nanoTime();
                                GearingVis.this.theta += speed * (double)(l2 - l) * 1.0E-8;
                                l = l2;
                                GearingVis.this.bi = GearingVis.this.drawMap();
                                jPanel.repaint();
                                try {
                                    Thread.sleep(10L);
                                    continue;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    continue;
                                }
                                break;
                            }
                        }
                    }.start();
                }
            } else {
                ImageIO.write((RenderedImage)this.bi, "png", new File(file + ".png"));
            }
        }
    }

    public String[] place(int n, int[] nArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append('\n');
        stringBuffer.append(nArray.length).append('\n');
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
        int n2 = Integer.parseInt(bufferedReader.readLine());
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = bufferedReader.readLine();
        }
        return stringArray;
    }

    public double runTest(String string) throws IOException {
        int n;
        int n2;
        try {
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(Long.parseLong(string));
        }
        catch (Exception exception) {
            return -1.0;
        }
        this.M = this.r.nextInt(36) + 5;
        this.N = (this.r.nextInt(46) + 5) * 2;
        System.out.println("N = " + this.N);
        this.teeth = new int[this.N];
        this.cnt = new int[51];
        for (int i = 0; i < this.N; ++i) {
            this.teeth[i] = this.r.nextInt(51 - this.M) + this.M;
            int n3 = this.teeth[i];
            this.cnt[n3] = this.cnt[n3] + 1;
        }
        this.K = this.r.nextInt(4) + 3;
        Arrays.sort(this.teeth);
        String[] stringArray = this.place(this.K, this.teeth);
        if (stringArray == null) {
            return 0.0;
        }
        this.s = new int[stringArray.length];
        this.x = new double[stringArray.length];
        this.pow = new double[stringArray.length];
        this.y = new double[stringArray.length];
        this.p = new int[stringArray.length];
        int[][] nArray = new int[stringArray.length][stringArray.length];
        try {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String[] stringArray2 = stringArray[n2].trim().split(" +");
                this.s[n2] = Integer.parseInt(stringArray2[0]);
                this.p[n2] = Integer.parseInt(stringArray2[1]);
                this.x[n2] = Double.parseDouble(stringArray2[2]);
                this.y[n2] = Double.parseDouble(stringArray2[3]);
            }
        }
        catch (Exception exception) {
            this.addFatalError("Your return is not formatted correctly.");
            return 0.0;
        }
        this.minx = Double.POSITIVE_INFINITY;
        this.miny = Double.POSITIVE_INFINITY;
        this.maxx = Double.NEGATIVE_INFINITY;
        this.maxy = Double.NEGATIVE_INFINITY;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.minx = Math.min(this.minx, this.x[n2] - (double)(this.s[n2] * 10));
            this.maxx = Math.max(this.maxx, this.x[n2] + (double)(this.s[n2] * 10));
            this.miny = Math.min(this.miny, this.y[n2] - (double)(this.s[n2] * 10));
            this.maxy = Math.max(this.maxy, this.y[n2] + (double)(this.s[n2] * 10));
        }
        for (n2 = 0; n2 < this.s.length; ++n2) {
            int n4 = this.s[n2];
            this.cnt[n4] = this.cnt[n4] - 1;
            if (this.cnt[this.s[n2]] < 0) {
                this.addFatalError("You used gears you didn't have.");
                return 0.0;
            }
            if (this.p[n2] < 0 || this.p[n2] >= this.K) {
                this.addFatalError("You used invalid planes.");
                return 0.0;
            }
            for (int i = 0; i < this.s.length; ++i) {
                if (n2 == i) continue;
                double d = Math.hypot(this.x[n2] - this.x[i], this.y[n2] - this.y[i]);
                if (d <= 0.01 && this.p[n2] != this.p[i]) {
                    nArray[n2][i] = 2;
                } else {
                    if (d < (double)(10 * (this.s[n2] + this.s[i]) - 10) && this.p[n2] == this.p[i]) {
                        this.addFatalError("Gears " + n2 + " and " + i + " in your return overlap by more than 10. (" + ((double)(10 * (this.s[n2] + this.s[i])) - d) + ")");
                        return 0.0;
                    }
                    if (d > (double)(10 * (this.s[n2] + this.s[i]) - 9) && d < (double)(10 * (this.s[n2] + this.s[i])) && this.p[n2] == this.p[i]) {
                        this.addFatalError("Gears " + n2 + " and " + i + " in your return overlap by between 0 and 9. (" + ((double)(10 * (this.s[n2] + this.s[i])) - d) + ")");
                        return 0.0;
                    }
                    if (d < (double)(10 * (this.s[n2] + this.s[i])) && this.p[n2] == this.p[i]) {
                        nArray[n2][i] = 1;
                    }
                }
                if (!(d > 0.01) || !(d < (double)(this.s[n2] * 10 + 10))) continue;
                this.addFatalError("Gear " + n2 + " and the axle of gear " + i + " in your return overlap.");
                return 0.0;
            }
        }
        double d = 0.0;
        int n5 = 1;
        int n6 = 0;
        Arrays.fill(this.pow, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < stringArray.length; ++i) {
            this.pow[n6] = Math.exp(d) * (double)n5;
            if (n6 == stringArray.length - 1) break;
            boolean bl = false;
            n = 0;
            for (int j = 0; j < stringArray.length; ++j) {
                if (nArray[n6][j] == 1) {
                    if (bl) {
                        this.addFatalError("The axle connected to gear " + i + " drives too many gears.");
                        return 0.0;
                    }
                    bl = true;
                    nArray[j][n6] = 0;
                    nArray[n6][j] = 0;
                    n = j;
                    d += Math.log(this.s[n6]);
                    d -= Math.log(this.s[j]);
                    n5 = -n5;
                }
                if (nArray[n6][j] != 2) continue;
                if (bl) {
                    this.addFatalError("The axle connected to gear " + i + " drives too many gears.");
                    return 0.0;
                }
                bl = true;
                nArray[j][n6] = 0;
                nArray[n6][j] = 0;
                n = j;
            }
            if (!bl) {
                this.addFatalError("The drive train ends at gear " + n6 + ".");
                return 0.0;
            }
            n6 = n;
        }
        if (n6 != stringArray.length - 1) {
            this.addFatalError("The gear given by the last element of your return is not driven. " + n6);
            return 0.0;
        }
        double d2 = 0.0;
        for (n = 0; n < this.teeth.length / 2; ++n) {
            d2 += Math.log(this.teeth[n]);
            d2 -= Math.log(this.teeth[this.N - 1 - n]);
        }
        if (Math.abs(d2 - d) > 0.001) {
            this.addFatalError("You don't achieve the minimum possible speed of " + Math.exp(d2));
            return 0.0;
        }
        this.addFatalError("Speed Ratio (this is not an error): " + Math.exp(d2));
        return (this.maxx - this.minx) * (this.maxy - this.miny);
    }

    public String checkData(String string) {
        return "";
    }

    public String displayTestCase(String string) {
        return "";
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-vis")) {
                file = stringArray[++i];
            }
            if (stringArray[i].equals("-size")) {
                S = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-speed")) {
                speed = Double.parseDouble(stringArray[++i]);
            }
            if (!stringArray[i].equals("-noanimate")) continue;
            animate = false;
        }
        GearingVis gearingVis = new GearingVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

