import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.*;
import java.util.List;


public class ForestFireVis {
    public static String execCommand = null;
    public static long seed = 1;
    public static boolean vis = true;
    public static int cellSize = 15;
    public static int delay = 100;
    public static boolean startPaused = false;

    public static Process solution;

    public Random r;

    // Test case data
    public int boardSize;
    public int tankCapacity;
    public int tankLevel;
    public int maxHeat;
    public int burnTime;
    public int[][] burnTimeCell;
    public char[][] mapChars;
    public String[] map;
    public int[][] heat;
    public int[][] remain;
    public boolean[][] fire;
    public double[][] prob;
    public int[] locX = new int[50];
    public int[] locY = new int[50];

    public int time = 0;
    public int curX, curY;
    public char curDir;
    public int simPos;
    public int ansLength;
    public int startTreeCount;
    public int startCabinCount;
    public int endTreeCount;
    public int endCabinCount;
    public final Object worldLock = new Object();

    class Drawer extends JFrame {
        public static final int EXTRA_WIDTH = 240;
        public static final int EXTRA_HEIGHT = 90;

        public DrawerPanel panel;

        public int width, height;

        public boolean pauseMode = false;

        class DrawerKeyListener extends KeyAdapter {
            public void keyPressed(KeyEvent e) {
                synchronized (keyMutex) {
                    if (e.getKeyChar() == ' ') {
                        pauseMode = !pauseMode;
                    }
                    keyPressed = true;
                    keyMutex.notifyAll();
                }
            }
        }

        class DrawerPanel extends JPanel {

            public void paint(Graphics g) {
                synchronized (worldLock) {
                    g.setColor(Color.WHITE);
                    g.fillRect(15, 15, cellSize * boardSize + 1, cellSize * boardSize + 1);
                    g.setColor(Color.BLACK);
                    for (int i = 0; i <= boardSize; i++) {
                        g.drawLine(15 + i * cellSize, 15, 15 + i * cellSize, 15 + cellSize * boardSize);
                        g.drawLine(15, 15 + i * cellSize, 15 + cellSize * boardSize, 15 + i * cellSize);
                    }

                      for (int y = 0; y < boardSize; y++) {
                          for (int x = 0; x < boardSize; x++) {
                              if (fire[y][x]) g.setColor(new Color(255, 0, 0));
                              else if (mapChars[y][x] == 'X') g.setColor(new Color(100, 100, 100));
                              else if (mapChars[y][x] == 'W') g.setColor(Color.BLUE);
                              else if (mapChars[y][x] == 'T') g.setColor(new Color(0, 100, 0));
                              else if (mapChars[y][x] == 'G') g.setColor(new Color(144, 238, 144));
                              else if (mapChars[y][x] == 'S') g.setColor(Color.WHITE);
                              else if (mapChars[y][x] == 'F') g.setColor(new Color(255, 32, 0));
                              else if (mapChars[y][x] == 'C') g.setColor(new Color(92, 48, 0));
                              g.fillRect(15 + x * cellSize + 1, 15 + y * cellSize + 1, cellSize - 1, cellSize - 1);
				if (mapChars[y][x] == 'S' || mapChars[y][x] == 'W') continue;				
                              // draw heat
                              if (!fire[y][x] && heat[y][x]>0)
                              {
                                 int h = 0;
                                 if (mapChars[y][x] == 'T') {
                                    h = (int)(heat[y][x]*255 / maxHeat);
                                 } else if (mapChars[y][x] == 'C') {
                                    h = (int)(heat[y][x]*255 / (maxHeat/2));
                                 } else if (mapChars[y][x] == 'G') {
                                    h = (int)(heat[y][x]*255 / (maxHeat*2));
                                 }
                                 g.setColor(new Color(h, 0, 0));
                                 g.fillRect(15 + x * cellSize + 1 + cellSize/4, 15 + y * cellSize + 1 + cellSize/4, (cellSize/2), (cellSize/2) );
                              }
                              // draw burnTime
                              if (fire[y][x] && remain[y][x]>0)
                              {
                                 int h = (int)(remain[y][x]*255 / burnTimeCell[y][x]);
                                 g.setColor(new Color(h, 0, 0));
                                 g.fillRect(15 + x * cellSize + 1 + cellSize/4, 15 + y * cellSize + 1 + cellSize/4, (cellSize/2) , (cellSize/2) );
                              }
                          }
                      }

                    // draw plane
                    g.setColor(Color.BLACK);
                    for (int s=0;s<2;s++) {
                        if (s==1) g.setColor(Color.MAGENTA);
                        g.fillOval(15 + curX * cellSize + s + cellSize/6, 15 + curY * cellSize + s + cellSize/6, (cellSize*2/3)+2-s*2 , (cellSize*2/3)+2-s*2 );
                        if (curDir=='E') {
                            g.fillRect(15 + curX * cellSize + s, 15 + curY * cellSize + s, cellSize/3 - 1+2-s*2, cellSize - 1+2-s*2);
                        } else if (curDir=='W') {
                            g.fillRect(15 + (curX+1) * cellSize + s - cellSize/3, 15 + curY * cellSize + s, cellSize/3 - 1+2-s*2, cellSize - 1+2-s*2);
                        } else if (curDir=='S') {
                            g.fillRect(15 + curX * cellSize + s, 15 + curY * cellSize + s, cellSize - 1+2-s*2, cellSize/3 - 1+2-s*2);
                        } else if (curDir=='N') {
                            g.fillRect(15 + curX * cellSize + s, 15 + (curY+1) * cellSize + s - cellSize/3, cellSize - 1+2-s*2, cellSize/3 - 1+2-s*2);
                        }
                    }

                    int horPos = 40 + boardSize * cellSize;

                    g.setColor(Color.BLACK);
                    g.fillRect(horPos-1, 249, 17, 17);
                    g.fillRect(horPos-1, 269, 17, 17);
                    g.fillRect(horPos-1, 289, 17, 17);
                    g.fillRect(horPos-1, 309, 17, 17);
                    g.fillRect(horPos-1, 329, 17, 17);
                    g.fillRect(horPos-1, 349, 17, 17);
                    g.fillRect(horPos-1, 369, 17, 17);

		    g.setColor(Color.WHITE);
                    g.fillRect(horPos, 250, 15, 15);
		    g.setColor(Color.BLUE);
                    g.fillRect(horPos, 270, 15, 15);
		    g.setColor(new Color(255, 0, 0));
                    g.fillRect(horPos, 290, 15, 15);
		    g.setColor(new Color(0, 100, 0));
                    g.fillRect(horPos, 310, 15, 15);
		    g.setColor(new Color(144, 238, 144));
                    g.fillRect(horPos, 330, 15, 15);
		    g.setColor(new Color(92, 48, 0));
                    g.fillRect(horPos, 350, 15, 15);
		    g.setColor(new Color(100, 100, 100));
                    g.fillRect(horPos, 370, 15, 15);

                    g.setColor(Color.BLACK);
                    g.setFont(new Font("Arial", Font.BOLD, 12));
                    Graphics2D g2 = (Graphics2D)g;


                    g2.drawString("Board size = " + boardSize, horPos, 30);
                    g2.drawString("Burn time = " + burnTime, horPos, 50);
                    g2.drawString("Max heat = " + maxHeat, horPos, 70);
                    g2.drawString("Move index = " + (simPos < ansLength ? simPos + 1 : "---") + " (out of " + ansLength + ")", horPos, 90);
                    g2.drawString("Time = " + time, horPos, 110);
                    g2.drawString("Tank level = " + tankLevel + " (out of " + tankCapacity + ")", horPos, 130);

                    g2.drawString("Trees = " + endTreeCount + " of " + startTreeCount, horPos, 160);
                    g2.drawString("Cabins = " + endCabinCount + " of " + startCabinCount, horPos, 180);
                    g2.drawString("Active Fire = " + countFire(), horPos, 200);

                    double treeScore = startTreeCount == 0 ? 1.0 : 1.0 * endTreeCount / startTreeCount;
                    double cabinScore = startCabinCount == 0 ? 1.0 : 1.0 * endCabinCount / startCabinCount;
                    g2.drawString("Score = " + String.format("%.2f",1000000.0 * treeScore * cabinScore * cabinScore), horPos, 230);

                    g2.drawString("[S] Service airport", horPos+20, 262);
                    g2.drawString("[W] Water", horPos+20, 282);
                    g2.drawString("[F] Fire", horPos+20, 302);
                    g2.drawString("[T] Tree", horPos+20, 322);
                    g2.drawString("[G] Grass", horPos+20, 342);
                    g2.drawString("[C] Cabin", horPos+20, 362);
                    g2.drawString("Burned", horPos+20, 382);


                }
            }
        }

        class DrawerWindowListener extends WindowAdapter {
            public void windowClosing(WindowEvent event) {
                ForestFireVis.stopSolution();
                System.exit(0);
            }
        }

        final Object keyMutex = new Object();
        boolean keyPressed;

        public void processPause() {
            synchronized (keyMutex) {
                if (!pauseMode) {
                    return;
                }
                keyPressed = false;
                while (!keyPressed) {
                    try {
                        keyMutex.wait();
                    } catch (InterruptedException e) {
                        // do nothing
                    }
                }
            }
        }

        public Drawer() {
            super();

            panel = new DrawerPanel();
            getContentPane().add(panel);

            addWindowListener(new DrawerWindowListener());

            width = cellSize * boardSize + EXTRA_WIDTH;
            height = cellSize * boardSize + EXTRA_HEIGHT;
	    if (height<450) height = 450;

            addKeyListener(new DrawerKeyListener());

            setSize(width, height);
            setTitle("TCO'14 Marathon Championship Round");

            setResizable(false);
            setVisible(true);
        }
    }

    private boolean touches(int x, int y, char c) {
      if (x > 0 && mapChars[y][x - 1] == c) return true;
      if (x < mapChars[0].length - 1 && mapChars[y][x + 1] == c) return true;
      if (y > 0 && mapChars[y - 1][x] == c) return true;
      if (y < mapChars.length - 1 && mapChars[y + 1][x] == c) return true;
      return false;
    }

    private boolean findCamp(int campNumber) {
      double totalProb = 0;
      int pickX = 0, pickY = 0;
      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++) totalProb += prob[y][x];
      if (totalProb == 0) {
        locX[campNumber] = locY[campNumber] = boardSize - 1;
        return false;
      }
      double pick = r.nextDouble() * totalProb;
      totalProb = 0;
      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++) {
        if (totalProb <= pick && totalProb + prob[y][x] > pick) {
          pickX = x; pickY = y;
        }
        totalProb += prob[y][x];
      }
      locX[campNumber] = pickX;
      locY[campNumber] = pickY;
      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++) {
        int r2 = (y - pickY) * (y - pickY) + (x - pickX) * (x - pickX);
        if (r2 <= 1) {
          prob[y][x] = 0;
          continue;
        }
        double sr = Math.pow(r2, 0.25);
        prob[y][x] *= (1.0 - 1.0/sr);
      }
      return true;
    }

    private int countMap(char c) {
      int ret = 0;
      for (int y = 0; y < boardSize; y++)
        for (int x = 0; x < boardSize; x++)
              if (mapChars[y][x] == c) ret++;
      return ret;
    }

    private void updateMapStrings() {
      for (int i = 0; i < boardSize; i++) {
        map[i] = "";
        for (int j = 0; j < boardSize; j++) map[i] += mapChars[i][j];
      }
    }

    private void generateTestCase(long testCase) {
      r = new Random(testCase ^ 918273645);

      // Basic parameters
      burnTime = r.nextInt(8) * 2 + 10;
      maxHeat = Math.min(r.nextInt(8) * 2 + 6, burnTime - 2);
      boardSize = r.nextInt(40) + 10;
      if (testCase <= 4) boardSize = (int)testCase * 10;
      tankCapacity = (boardSize / 2) + r.nextInt(boardSize + 1);
      mapChars = new char[boardSize][boardSize];
      map = new String[boardSize];
      heat = new int[boardSize][boardSize];
      remain = new int[boardSize][boardSize];
      burnTimeCell = new int[boardSize][boardSize];
      fire = new boolean[boardSize][boardSize];
      prob = new double[boardSize][boardSize];

      // Fill the map with grass, except the starting point
      for (int i = 0; i < boardSize; i++)
        for (int j = 0; j < boardSize; j++) {
          mapChars[i][j] = 'G';
              remain[i][j] = burnTime / 2;
          if (i + j >= 3) prob[i][j] = 1.0;
        }
      mapChars[0][0] = 'S';
      mapChars[0][1] = 'S';
      mapChars[1][0] = 'S';
      mapChars[0][2] = 'S';
      mapChars[1][1] = 'S';
      mapChars[2][0] = 'S';

      // Add water
      int waterSeeds = r.nextInt(boardSize / 5) + 2;
      for (int i = 0; i < waterSeeds; i++) {
        int x = r.nextInt(boardSize);
        int y = r.nextInt(boardSize);
        if (x + y <= 2) continue;
        mapChars[y][x] = 'W';
            remain[y][x] = 0;
        prob[y][x] = 0;
      }

      // Add forests
      int forestSeeds = r.nextInt(boardSize / 4) + 3;
      for (int i = 0; i < forestSeeds; i++) {
        int x = r.nextInt(boardSize);
        int y = r.nextInt(boardSize);
        if (x + y <= 2) continue;
        mapChars[y][x] = 'T';
            remain[y][x] = burnTime;
      }

      // Build up water and forests
      int buildRemain = Math.min(boardSize * boardSize * 2 / 5 + r.nextInt(boardSize * boardSize / 5), boardSize * boardSize - 10 - waterSeeds - forestSeeds);
      while (buildRemain > 0) {
        int x = r.nextInt(boardSize);
        int y = r.nextInt(boardSize);
        if (mapChars[y][x] != 'G') continue;
        if (touches(x, y, 'T')) {
          mapChars[y][x] = 'T';
              remain[y][x] = burnTime;
          buildRemain--;
        } else if (touches(x, y, 'W')) {
          mapChars[y][x] = 'W';
              remain[y][x] = 0;
          prob[y][x] = 0;
          buildRemain--;
        }
      }

      // Determine where cabins/camps will be.
      for (int i = 0; i < 50; i++) findCamp(i);

      int min = boardSize * boardSize / 200 + 1;
      int max = Math.min(boardSize * boardSize / 50, 25);
      int cabinCount = min + r.nextInt(1 + max - min);
      int fireCount = min + r.nextInt(1 + max - min);

      for (int i = 0; i < cabinCount; i++) {
        mapChars[locY[i]][locX[i]] = 'C';
        remain[locY[i]][locX[i]] = burnTime * 2;
      }
      for (int i = cabinCount; i < fireCount + cabinCount; i++) {
        mapChars[locY[i]][locX[i]] = 'F';
        fire[locY[i]][locX[i]] = true;
        remain[locY[i]][locX[i]] = burnTime;
      }

      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++) {
        burnTimeCell[y][x] = remain[y][x];
      }

      ansLength = 0;

      // Build the map strings
      updateMapStrings();
    }

    private void advanceTime() {
      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++) {
            // Location is already burned out.
            if (mapChars[y][x] == 'X') continue;

            // Location is currently on fire.
            if (fire[y][x]) {
              remain[y][x]--;
              if (remain[y][x] <= 0) {
                if (mapChars[y][x]=='T') endTreeCount--;
                if (mapChars[y][x]=='C') endCabinCount--;
                mapChars[y][x] = 'X';
                fire[y][x] = false;
                heat[y][x] = 0;
              }
              continue;
            }
      }

      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++) {
            // Location is already burned out.
            if (mapChars[y][x] == 'X') continue;

            // Location is possibly heating from surrounding cells.
            if (y > 0 && fire[y - 1][x]) heat[y][x]++;
            if (y < boardSize - 1 && fire[y + 1][x]) heat[y][x]++;
            if (x > 0 && fire[y][x - 1]) heat[y][x]++;
            if (x < boardSize - 1 && fire[y][x + 1]) heat[y][x]++;
      }

      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++) {
            // Location is already burned out.
            if (mapChars[y][x] == 'X') continue;

            // Is location heated enough to catch fire?
            if (mapChars[y][x] == 'F' || mapChars[y][x] == 'T') {
              if (heat[y][x] > maxHeat) fire[y][x] = true;
            } else if (mapChars[y][x] == 'C') {
              if (heat[y][x] > maxHeat / 2) fire[y][x] = true;
            } else if (mapChars[y][x] == 'G') {
              if (heat[y][x] > maxHeat * 2) fire[y][x] = true;
            }
      }

      time++;
    }

    private int countFire() {
      int ret = 0;
      for (int y = 0; y < boardSize; y++) for (int x = 0; x < boardSize; x++)
        if (fire[y][x]) ret++;
      return ret;
    }

    private String stepSimulation(String moves) {
      if (simPos < moves.length()) {
        char movement = moves.charAt(simPos);
        curDir = movement;
        boolean dumping = false;
        simPos++;
        if (simPos < moves.length() && moves.charAt(simPos) == 'D') {
          dumping = true;
          simPos++;
        }
        if (movement == 'N') {
          if (curY == 0) return "Attempted to move outside the bounds of the map.";
          curY--;
        } else if (movement == 'S') {
          if (curY == boardSize - 1) return "Attempted to move outside the bounds of the map.";
          curY++;
        } else if (movement == 'W') {
          if (curX == 0) return "Attempted to move outside the bounds of the map.";
          curX--;
        } else if (movement == 'E') {
          if (curX == boardSize - 1) return "Attempted to move outside the bounds of the map.";
          curX++;
        } else {
          return "Invalid move found at character " + simPos + " (" + movement + ")";
        }
        if (mapChars[curY][curX] == 'W' && tankLevel < tankCapacity) tankLevel++;
        if (dumping && tankLevel > 0) {
          heat[curY][curX] = 0;
          fire[curY][curX] = false;
          tankLevel--;
        }
        advanceTime();
      } else advanceTime();
      return "";
    }

    public double runTest() {
        solution = null;

        try {
            solution = Runtime.getRuntime().exec(execCommand);
        } catch (Exception e) {
            System.err.println("ERROR: Unable to execute your solution using the provided command: "
                    + execCommand + ".");
            return -1;
        }

        BufferedReader reader = new BufferedReader(new InputStreamReader(solution.getInputStream()));
        PrintWriter writer = new PrintWriter(solution.getOutputStream());
        new ErrorStreamRedirector(solution.getErrorStream()).start();

        generateTestCase(seed);
        // pass test case to solution
        writer.println(burnTime);
        writer.println(maxHeat);
        writer.println(tankCapacity);
        writer.println(boardSize);
        for (String elm : map) {
            writer.println(elm);
        }
        writer.flush();

        String moves = null;
        try {
            moves = reader.readLine();
        } catch (Exception e) {
            System.out.println("ERROR: unable to read your solution's return value.");
            return -1;
        }

	if (moves.length()>boardSize*boardSize) {
            System.out.println("ERROR: too many moves in return value.");
            return -1;
	}

        startTreeCount = countMap('T');
        startCabinCount = countMap('C');
        endTreeCount = startTreeCount;
        endCabinCount = startCabinCount;
        curX = 0;
        curY = 0;
        curDir = 'E';
        tankLevel = tankCapacity;
        ansLength = moves.length();

        Drawer drawer = null;
        if (vis) {
            drawer = new Drawer();
            if (startPaused) {
                drawer.pauseMode = true;
            }
        }

        simPos = 0;
        int t = 0;
        for (;;) {
            if (vis) {
                drawer.processPause();
                drawer.repaint();
                try {
                    Thread.sleep(delay);
                } catch (Exception e) {
                    // do nothing
                }
            }

            if (countFire()==0 && simPos>=moves.length()) break;

            synchronized (worldLock) {
                String feedback = stepSimulation(moves);
                if (feedback.length() > 0) {
                    System.out.println(feedback);
                    return -1;
                }
            }
            t++;
        }

        double treeScore = startTreeCount == 0 ? 1.0 : 1.0 * endTreeCount / startTreeCount;
        double cabinScore = startCabinCount == 0 ? 1.0 : 1.0 * endCabinCount / startCabinCount;

        stopSolution();

        return 1000000 * treeScore * cabinScore * cabinScore;
    }

    public static void stopSolution() {
        if (solution != null) {
            try {
                solution.destroy();
            } catch (Exception e) {
                // do nothing
            }
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; i++)
            if (args[i].equals("-exec")) {
                execCommand = args[++i];
            } else if (args[i].equals("-seed")) {
                seed = Long.parseLong(args[++i]);
            } else if (args[i].equals("-novis")) {
                vis = false;
            } else if (args[i].equals("-sz")) {
                cellSize = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-delay")) {
                delay = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-pause")) {
                startPaused = true;
            } else {
                System.out.println("WARNING: unknown argument " + args[i] + ".");
            }

        if (execCommand == null) {
            System.err.println("ERROR: You did not provide the command to execute your solution." +
                    " Please use -exec <command> for this.");
            System.exit(1);
        }

        ForestFireVis vis = new ForestFireVis();
        try {
            double score = vis.runTest();
            System.out.println("Score  = " + score);
        } catch (RuntimeException e) {
            System.err.println("ERROR: Unexpected error while running your test case.");
            e.printStackTrace();
            ForestFireVis.stopSolution();
        }
    }
}


class ErrorStreamRedirector extends Thread {
    public BufferedReader reader;

    public ErrorStreamRedirector(InputStream is) {
        reader = new BufferedReader(new InputStreamReader(is));
    }

    public void run() {
        while (true) {
            String s;
            try {
                s = reader.readLine();
            } catch (Exception e) {
                // e.printStackTrace();
                return;
            }
            if (s == null) {
                break;
            }
            System.out.println(s);
        }
    }
}


