/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ForestFireVis {
    public static String execCommand = null;
    public static long seed = 1L;
    public static boolean vis = true;
    public static int cellSize = 15;
    public static int delay = 100;
    public static boolean startPaused = false;
    public static Process solution;
    public Random r;
    public int boardSize;
    public int tankCapacity;
    public int tankLevel;
    public int maxHeat;
    public int burnTime;
    public int[][] burnTimeCell;
    public char[][] mapChars;
    public String[] map;
    public int[][] heat;
    public int[][] remain;
    public boolean[][] fire;
    public double[][] prob;
    public int[] locX = new int[50];
    public int[] locY = new int[50];
    public int time = 0;
    public int curX;
    public int curY;
    public char curDir;
    public int simPos;
    public int ansLength;
    public int startTreeCount;
    public int startCabinCount;
    public int endTreeCount;
    public int endCabinCount;
    public final Object worldLock = new Object();

    private boolean touches(int n, int n2, char c) {
        if (n > 0 && this.mapChars[n2][n - 1] == c) {
            return true;
        }
        if (n < this.mapChars[0].length - 1 && this.mapChars[n2][n + 1] == c) {
            return true;
        }
        if (n2 > 0 && this.mapChars[n2 - 1][n] == c) {
            return true;
        }
        return n2 < this.mapChars.length - 1 && this.mapChars[n2 + 1][n] == c;
    }

    private boolean findCamp(int n) {
        int n2;
        int n3;
        double d = 0.0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                d += this.prob[i][j];
            }
        }
        if (d == 0.0) {
            this.locX[n] = this.locY[n] = this.boardSize - 1;
            return false;
        }
        double d2 = this.r.nextDouble() * d;
        d = 0.0;
        for (n3 = 0; n3 < this.boardSize; ++n3) {
            for (n2 = 0; n2 < this.boardSize; ++n2) {
                if (d <= d2 && d + this.prob[n3][n2] > d2) {
                    n4 = n2;
                    n5 = n3;
                }
                d += this.prob[n3][n2];
            }
        }
        this.locX[n] = n4;
        this.locY[n] = n5;
        for (n3 = 0; n3 < this.boardSize; ++n3) {
            for (n2 = 0; n2 < this.boardSize; ++n2) {
                int n6 = (n3 - n5) * (n3 - n5) + (n2 - n4) * (n2 - n4);
                if (n6 <= 1) {
                    this.prob[n3][n2] = 0.0;
                    continue;
                }
                double d3 = Math.pow(n6, 0.25);
                double[] dArray = this.prob[n3];
                int n7 = n2;
                dArray[n7] = dArray[n7] * (1.0 - 1.0 / d3);
            }
        }
        return true;
    }

    private int countMap(char c) {
        int n = 0;
        for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                if (this.mapChars[i][j] != c) continue;
                ++n;
            }
        }
        return n;
    }

    private void updateMapStrings() {
        for (int i = 0; i < this.boardSize; ++i) {
            this.map[i] = "";
            for (int j = 0; j < this.boardSize; ++j) {
                int n = i;
                this.map[n] = this.map[n] + this.mapChars[i][j];
            }
        }
    }

    private void generateTestCase(long l) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.r = new Random(l ^ 0x36BBBE6DL);
        this.burnTime = this.r.nextInt(8) * 2 + 10;
        this.maxHeat = Math.min(this.r.nextInt(8) * 2 + 6, this.burnTime - 2);
        this.boardSize = this.r.nextInt(40) + 10;
        if (l <= 4L) {
            this.boardSize = (int)l * 10;
        }
        this.tankCapacity = this.boardSize / 2 + this.r.nextInt(this.boardSize + 1);
        this.mapChars = new char[this.boardSize][this.boardSize];
        this.map = new String[this.boardSize];
        this.heat = new int[this.boardSize][this.boardSize];
        this.remain = new int[this.boardSize][this.boardSize];
        this.burnTimeCell = new int[this.boardSize][this.boardSize];
        this.fire = new boolean[this.boardSize][this.boardSize];
        this.prob = new double[this.boardSize][this.boardSize];
        for (n6 = 0; n6 < this.boardSize; ++n6) {
            for (n5 = 0; n5 < this.boardSize; ++n5) {
                this.mapChars[n6][n5] = 71;
                this.remain[n6][n5] = this.burnTime / 2;
                if (n6 + n5 < 3) continue;
                this.prob[n6][n5] = 1.0;
            }
        }
        this.mapChars[0][0] = 83;
        this.mapChars[0][1] = 83;
        this.mapChars[1][0] = 83;
        this.mapChars[0][2] = 83;
        this.mapChars[1][1] = 83;
        this.mapChars[2][0] = 83;
        n6 = this.r.nextInt(this.boardSize / 5) + 2;
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = this.r.nextInt(this.boardSize);
            if (n4 + (n3 = this.r.nextInt(this.boardSize)) <= 2) continue;
            this.mapChars[n3][n4] = 87;
            this.remain[n3][n4] = 0;
            this.prob[n3][n4] = 0.0;
        }
        n5 = this.r.nextInt(this.boardSize / 4) + 3;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.r.nextInt(this.boardSize);
            if (n3 + (n2 = this.r.nextInt(this.boardSize)) <= 2) continue;
            this.mapChars[n2][n3] = 84;
            this.remain[n2][n3] = this.burnTime;
        }
        n4 = Math.min(this.boardSize * this.boardSize * 2 / 5 + this.r.nextInt(this.boardSize * this.boardSize / 5), this.boardSize * this.boardSize - 10 - n6 - n5);
        while (n4 > 0) {
            n3 = this.r.nextInt(this.boardSize);
            n2 = this.r.nextInt(this.boardSize);
            if (this.mapChars[n2][n3] != 'G') continue;
            if (this.touches(n3, n2, 'T')) {
                this.mapChars[n2][n3] = 84;
                this.remain[n2][n3] = this.burnTime;
                --n4;
                continue;
            }
            if (!this.touches(n3, n2, 'W')) continue;
            this.mapChars[n2][n3] = 87;
            this.remain[n2][n3] = 0;
            this.prob[n2][n3] = 0.0;
            --n4;
        }
        for (n3 = 0; n3 < 50; ++n3) {
            this.findCamp(n3);
        }
        n3 = this.boardSize * this.boardSize / 200 + 1;
        n2 = Math.min(this.boardSize * this.boardSize / 50, 25);
        int n7 = n3 + this.r.nextInt(1 + n2 - n3);
        int n8 = n3 + this.r.nextInt(1 + n2 - n3);
        for (n = 0; n < n7; ++n) {
            this.mapChars[this.locY[n]][this.locX[n]] = 67;
            this.remain[this.locY[n]][this.locX[n]] = this.burnTime * 2;
        }
        for (n = n7; n < n8 + n7; ++n) {
            this.mapChars[this.locY[n]][this.locX[n]] = 70;
            this.fire[this.locY[n]][this.locX[n]] = true;
            this.remain[this.locY[n]][this.locX[n]] = this.burnTime;
        }
        for (n = 0; n < this.boardSize; ++n) {
            for (int i = 0; i < this.boardSize; ++i) {
                this.burnTimeCell[n][i] = this.remain[n][i];
            }
        }
        this.ansLength = 0;
        this.updateMapStrings();
    }

    private void advanceTime() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.boardSize; ++n2) {
            for (n = 0; n < this.boardSize; ++n) {
                if (this.mapChars[n2][n] == 'X' || !this.fire[n2][n]) continue;
                int[] nArray = this.remain[n2];
                int n3 = n;
                nArray[n3] = nArray[n3] - 1;
                if (this.remain[n2][n] > 0) continue;
                if (this.mapChars[n2][n] == 'T') {
                    --this.endTreeCount;
                }
                if (this.mapChars[n2][n] == 'C') {
                    --this.endCabinCount;
                }
                this.mapChars[n2][n] = 88;
                this.fire[n2][n] = false;
                this.heat[n2][n] = 0;
            }
        }
        for (n2 = 0; n2 < this.boardSize; ++n2) {
            for (n = 0; n < this.boardSize; ++n) {
                if (this.mapChars[n2][n] == 'X') continue;
                if (n2 > 0 && this.fire[n2 - 1][n]) {
                    int[] nArray = this.heat[n2];
                    int n4 = n;
                    nArray[n4] = nArray[n4] + 1;
                }
                if (n2 < this.boardSize - 1 && this.fire[n2 + 1][n]) {
                    int[] nArray = this.heat[n2];
                    int n5 = n;
                    nArray[n5] = nArray[n5] + 1;
                }
                if (n > 0 && this.fire[n2][n - 1]) {
                    int[] nArray = this.heat[n2];
                    int n6 = n;
                    nArray[n6] = nArray[n6] + 1;
                }
                if (n >= this.boardSize - 1 || !this.fire[n2][n + 1]) continue;
                int[] nArray = this.heat[n2];
                int n7 = n;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        for (n2 = 0; n2 < this.boardSize; ++n2) {
            for (n = 0; n < this.boardSize; ++n) {
                if (this.mapChars[n2][n] == 'X') continue;
                if (this.mapChars[n2][n] == 'F' || this.mapChars[n2][n] == 'T') {
                    if (this.heat[n2][n] <= this.maxHeat) continue;
                    this.fire[n2][n] = true;
                    continue;
                }
                if (this.mapChars[n2][n] == 'C') {
                    if (this.heat[n2][n] <= this.maxHeat / 2) continue;
                    this.fire[n2][n] = true;
                    continue;
                }
                if (this.mapChars[n2][n] != 'G' || this.heat[n2][n] <= this.maxHeat * 2) continue;
                this.fire[n2][n] = true;
            }
        }
        ++this.time;
    }

    private int countFire() {
        int n = 0;
        for (int i = 0; i < this.boardSize; ++i) {
            for (int j = 0; j < this.boardSize; ++j) {
                if (!this.fire[i][j]) continue;
                ++n;
            }
        }
        return n;
    }

    private String stepSimulation(String string) {
        if (this.simPos < string.length()) {
            char c;
            this.curDir = c = string.charAt(this.simPos);
            boolean bl = false;
            ++this.simPos;
            if (this.simPos < string.length() && string.charAt(this.simPos) == 'D') {
                bl = true;
                ++this.simPos;
            }
            if (c == 'N') {
                if (this.curY == 0) {
                    return "Attempted to move outside the bounds of the map.";
                }
                --this.curY;
            } else if (c == 'S') {
                if (this.curY == this.boardSize - 1) {
                    return "Attempted to move outside the bounds of the map.";
                }
                ++this.curY;
            } else if (c == 'W') {
                if (this.curX == 0) {
                    return "Attempted to move outside the bounds of the map.";
                }
                --this.curX;
            } else if (c == 'E') {
                if (this.curX == this.boardSize - 1) {
                    return "Attempted to move outside the bounds of the map.";
                }
                ++this.curX;
            } else {
                return "Invalid move found at character " + this.simPos + " (" + c + ")";
            }
            if (this.mapChars[this.curY][this.curX] == 'W' && this.tankLevel < this.tankCapacity) {
                ++this.tankLevel;
            }
            if (bl && this.tankLevel > 0) {
                this.heat[this.curY][this.curX] = 0;
                this.fire[this.curY][this.curX] = false;
                --this.tankLevel;
            }
            this.advanceTime();
        } else {
            this.advanceTime();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double runTest() {
        solution = null;
        try {
            solution = Runtime.getRuntime().exec(execCommand);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Unable to execute your solution using the provided command: " + execCommand + ".");
            return -1.0;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(solution.getInputStream()));
        PrintWriter printWriter = new PrintWriter(solution.getOutputStream());
        new ErrorStreamRedirector(solution.getErrorStream()).start();
        this.generateTestCase(seed);
        printWriter.println(this.burnTime);
        printWriter.println(this.maxHeat);
        printWriter.println(this.tankCapacity);
        printWriter.println(this.boardSize);
        for (String object2 : this.map) {
            printWriter.println(object2);
        }
        printWriter.flush();
        Object object = null;
        try {
            object = bufferedReader.readLine();
        }
        catch (Exception exception) {
            System.out.println("ERROR: unable to read your solution's return value.");
            return -1.0;
        }
        if (((String)object).length() > this.boardSize * this.boardSize) {
            System.out.println("ERROR: too many moves in return value.");
            return -1.0;
        }
        this.startTreeCount = this.countMap('T');
        this.startCabinCount = this.countMap('C');
        this.endTreeCount = this.startTreeCount;
        this.endCabinCount = this.startCabinCount;
        this.curX = 0;
        this.curY = 0;
        this.curDir = (char)69;
        this.tankLevel = this.tankCapacity;
        this.ansLength = ((String)object).length();
        Drawer drawer = null;
        if (vis) {
            drawer = new Drawer();
            if (startPaused) {
                drawer.pauseMode = true;
            }
        }
        this.simPos = 0;
        int n = 0;
        while (true) {
            if (vis) {
                drawer.processPause();
                drawer.repaint();
                try {
                    Thread.sleep(delay);
                }
                catch (Exception d) {
                    // empty catch block
                }
            }
            if (this.countFire() == 0 && this.simPos >= ((String)object).length()) break;
            Object object2 = this.worldLock;
            synchronized (object2) {
                String string = this.stepSimulation((String)object);
                if (string.length() > 0) {
                    System.out.println(string);
                    return -1.0;
                }
            }
            ++n;
        }
        double d = this.startTreeCount == 0 ? 1.0 : 1.0 * (double)this.endTreeCount / (double)this.startTreeCount;
        double d2 = this.startCabinCount == 0 ? 1.0 : 1.0 * (double)this.endCabinCount / (double)this.startCabinCount;
        ForestFireVis.stopSolution();
        return 1000000.0 * d * d2 * d2;
    }

    public static void stopSolution() {
        if (solution != null) {
            try {
                solution.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                execCommand = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                seed = Long.parseLong(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
                continue;
            }
            if (stringArray[i].equals("-sz")) {
                cellSize = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-delay")) {
                delay = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-pause")) {
                startPaused = true;
                continue;
            }
            System.out.println("WARNING: unknown argument " + stringArray[i] + ".");
        }
        if (execCommand == null) {
            System.err.println("ERROR: You did not provide the command to execute your solution. Please use -exec <command> for this.");
            System.exit(1);
        }
        ForestFireVis forestFireVis = new ForestFireVis();
        try {
            double d = forestFireVis.runTest();
            System.out.println("Score  = " + d);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("ERROR: Unexpected error while running your test case.");
            runtimeException.printStackTrace();
            ForestFireVis.stopSolution();
        }
    }

    class Drawer
    extends JFrame {
        public static final int EXTRA_WIDTH = 240;
        public static final int EXTRA_HEIGHT = 90;
        public DrawerPanel panel;
        public int width;
        public int height;
        public boolean pauseMode = false;
        final Object keyMutex = new Object();
        boolean keyPressed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPause() {
            Object object = this.keyMutex;
            synchronized (object) {
                if (!this.pauseMode) {
                    return;
                }
                this.keyPressed = false;
                while (!this.keyPressed) {
                    try {
                        this.keyMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public Drawer() {
            this.panel = new DrawerPanel();
            this.getContentPane().add(this.panel);
            this.addWindowListener(new DrawerWindowListener());
            this.width = cellSize * ForestFireVis.this.boardSize + 240;
            this.height = cellSize * ForestFireVis.this.boardSize + 90;
            if (this.height < 450) {
                this.height = 450;
            }
            this.addKeyListener(new DrawerKeyListener());
            this.setSize(this.width, this.height);
            this.setTitle("TCO'14 Marathon Championship Round");
            this.setResizable(false);
            this.setVisible(true);
        }

        class DrawerWindowListener
        extends WindowAdapter {
            DrawerWindowListener() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ForestFireVis.stopSolution();
                System.exit(0);
            }
        }

        class DrawerPanel
        extends JPanel {
            DrawerPanel() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics graphics) {
                Object object = ForestFireVis.this.worldLock;
                synchronized (object) {
                    int n;
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(15, 15, cellSize * ForestFireVis.this.boardSize + 1, cellSize * ForestFireVis.this.boardSize + 1);
                    graphics.setColor(Color.BLACK);
                    for (n = 0; n <= ForestFireVis.this.boardSize; ++n) {
                        graphics.drawLine(15 + n * cellSize, 15, 15 + n * cellSize, 15 + cellSize * ForestFireVis.this.boardSize);
                        graphics.drawLine(15, 15 + n * cellSize, 15 + cellSize * ForestFireVis.this.boardSize, 15 + n * cellSize);
                    }
                    for (n = 0; n < ForestFireVis.this.boardSize; ++n) {
                        for (int i = 0; i < ForestFireVis.this.boardSize; ++i) {
                            int n2;
                            if (ForestFireVis.this.fire[n][i]) {
                                graphics.setColor(new Color(255, 0, 0));
                            } else if (ForestFireVis.this.mapChars[n][i] == 'X') {
                                graphics.setColor(new Color(100, 100, 100));
                            } else if (ForestFireVis.this.mapChars[n][i] == 'W') {
                                graphics.setColor(Color.BLUE);
                            } else if (ForestFireVis.this.mapChars[n][i] == 'T') {
                                graphics.setColor(new Color(0, 100, 0));
                            } else if (ForestFireVis.this.mapChars[n][i] == 'G') {
                                graphics.setColor(new Color(144, 238, 144));
                            } else if (ForestFireVis.this.mapChars[n][i] == 'S') {
                                graphics.setColor(Color.WHITE);
                            } else if (ForestFireVis.this.mapChars[n][i] == 'F') {
                                graphics.setColor(new Color(255, 32, 0));
                            } else if (ForestFireVis.this.mapChars[n][i] == 'C') {
                                graphics.setColor(new Color(92, 48, 0));
                            }
                            graphics.fillRect(15 + i * cellSize + 1, 15 + n * cellSize + 1, cellSize - 1, cellSize - 1);
                            if (ForestFireVis.this.mapChars[n][i] == 'S' || ForestFireVis.this.mapChars[n][i] == 'W') continue;
                            if (!ForestFireVis.this.fire[n][i] && ForestFireVis.this.heat[n][i] > 0) {
                                n2 = 0;
                                if (ForestFireVis.this.mapChars[n][i] == 'T') {
                                    n2 = ForestFireVis.this.heat[n][i] * 255 / ForestFireVis.this.maxHeat;
                                } else if (ForestFireVis.this.mapChars[n][i] == 'C') {
                                    n2 = ForestFireVis.this.heat[n][i] * 255 / (ForestFireVis.this.maxHeat / 2);
                                } else if (ForestFireVis.this.mapChars[n][i] == 'G') {
                                    n2 = ForestFireVis.this.heat[n][i] * 255 / (ForestFireVis.this.maxHeat * 2);
                                }
                                graphics.setColor(new Color(n2, 0, 0));
                                graphics.fillRect(15 + i * cellSize + 1 + cellSize / 4, 15 + n * cellSize + 1 + cellSize / 4, cellSize / 2, cellSize / 2);
                            }
                            if (!ForestFireVis.this.fire[n][i] || ForestFireVis.this.remain[n][i] <= 0) continue;
                            n2 = ForestFireVis.this.remain[n][i] * 255 / ForestFireVis.this.burnTimeCell[n][i];
                            graphics.setColor(new Color(n2, 0, 0));
                            graphics.fillRect(15 + i * cellSize + 1 + cellSize / 4, 15 + n * cellSize + 1 + cellSize / 4, cellSize / 2, cellSize / 2);
                        }
                    }
                    graphics.setColor(Color.BLACK);
                    for (n = 0; n < 2; ++n) {
                        if (n == 1) {
                            graphics.setColor(Color.MAGENTA);
                        }
                        graphics.fillOval(15 + ForestFireVis.this.curX * cellSize + n + cellSize / 6, 15 + ForestFireVis.this.curY * cellSize + n + cellSize / 6, cellSize * 2 / 3 + 2 - n * 2, cellSize * 2 / 3 + 2 - n * 2);
                        if (ForestFireVis.this.curDir == 'E') {
                            graphics.fillRect(15 + ForestFireVis.this.curX * cellSize + n, 15 + ForestFireVis.this.curY * cellSize + n, cellSize / 3 - 1 + 2 - n * 2, cellSize - 1 + 2 - n * 2);
                            continue;
                        }
                        if (ForestFireVis.this.curDir == 'W') {
                            graphics.fillRect(15 + (ForestFireVis.this.curX + 1) * cellSize + n - cellSize / 3, 15 + ForestFireVis.this.curY * cellSize + n, cellSize / 3 - 1 + 2 - n * 2, cellSize - 1 + 2 - n * 2);
                            continue;
                        }
                        if (ForestFireVis.this.curDir == 'S') {
                            graphics.fillRect(15 + ForestFireVis.this.curX * cellSize + n, 15 + ForestFireVis.this.curY * cellSize + n, cellSize - 1 + 2 - n * 2, cellSize / 3 - 1 + 2 - n * 2);
                            continue;
                        }
                        if (ForestFireVis.this.curDir != 'N') continue;
                        graphics.fillRect(15 + ForestFireVis.this.curX * cellSize + n, 15 + (ForestFireVis.this.curY + 1) * cellSize + n - cellSize / 3, cellSize - 1 + 2 - n * 2, cellSize / 3 - 1 + 2 - n * 2);
                    }
                    n = 40 + ForestFireVis.this.boardSize * cellSize;
                    graphics.setColor(Color.BLACK);
                    graphics.fillRect(n - 1, 249, 17, 17);
                    graphics.fillRect(n - 1, 269, 17, 17);
                    graphics.fillRect(n - 1, 289, 17, 17);
                    graphics.fillRect(n - 1, 309, 17, 17);
                    graphics.fillRect(n - 1, 329, 17, 17);
                    graphics.fillRect(n - 1, 349, 17, 17);
                    graphics.fillRect(n - 1, 369, 17, 17);
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(n, 250, 15, 15);
                    graphics.setColor(Color.BLUE);
                    graphics.fillRect(n, 270, 15, 15);
                    graphics.setColor(new Color(255, 0, 0));
                    graphics.fillRect(n, 290, 15, 15);
                    graphics.setColor(new Color(0, 100, 0));
                    graphics.fillRect(n, 310, 15, 15);
                    graphics.setColor(new Color(144, 238, 144));
                    graphics.fillRect(n, 330, 15, 15);
                    graphics.setColor(new Color(92, 48, 0));
                    graphics.fillRect(n, 350, 15, 15);
                    graphics.setColor(new Color(100, 100, 100));
                    graphics.fillRect(n, 370, 15, 15);
                    graphics.setColor(Color.BLACK);
                    graphics.setFont(new Font("Arial", 1, 12));
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.drawString("Board size = " + ForestFireVis.this.boardSize, n, 30);
                    graphics2D.drawString("Burn time = " + ForestFireVis.this.burnTime, n, 50);
                    graphics2D.drawString("Max heat = " + ForestFireVis.this.maxHeat, n, 70);
                    graphics2D.drawString("Move index = " + (ForestFireVis.this.simPos < ForestFireVis.this.ansLength ? Integer.valueOf(ForestFireVis.this.simPos + 1) : "---") + " (out of " + ForestFireVis.this.ansLength + ")", n, 90);
                    graphics2D.drawString("Time = " + ForestFireVis.this.time, n, 110);
                    graphics2D.drawString("Tank level = " + ForestFireVis.this.tankLevel + " (out of " + ForestFireVis.this.tankCapacity + ")", n, 130);
                    graphics2D.drawString("Trees = " + ForestFireVis.this.endTreeCount + " of " + ForestFireVis.this.startTreeCount, n, 160);
                    graphics2D.drawString("Cabins = " + ForestFireVis.this.endCabinCount + " of " + ForestFireVis.this.startCabinCount, n, 180);
                    graphics2D.drawString("Active Fire = " + ForestFireVis.this.countFire(), n, 200);
                    double d = ForestFireVis.this.startTreeCount == 0 ? 1.0 : 1.0 * (double)ForestFireVis.this.endTreeCount / (double)ForestFireVis.this.startTreeCount;
                    double d2 = ForestFireVis.this.startCabinCount == 0 ? 1.0 : 1.0 * (double)ForestFireVis.this.endCabinCount / (double)ForestFireVis.this.startCabinCount;
                    graphics2D.drawString("Score = " + String.format("%.2f", 1000000.0 * d * d2 * d2), n, 230);
                    graphics2D.drawString("[S] Service airport", n + 20, 262);
                    graphics2D.drawString("[W] Water", n + 20, 282);
                    graphics2D.drawString("[F] Fire", n + 20, 302);
                    graphics2D.drawString("[T] Tree", n + 20, 322);
                    graphics2D.drawString("[G] Grass", n + 20, 342);
                    graphics2D.drawString("[C] Cabin", n + 20, 362);
                    graphics2D.drawString("Burned", n + 20, 382);
                }
            }
        }

        class DrawerKeyListener
        extends KeyAdapter {
            DrawerKeyListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Object object = Drawer.this.keyMutex;
                synchronized (object) {
                    if (keyEvent.getKeyChar() == ' ') {
                        Drawer.this.pauseMode = !Drawer.this.pauseMode;
                    }
                    Drawer.this.keyPressed = true;
                    Drawer.this.keyMutex.notifyAll();
                }
            }
        }
    }
}

