
import java.util.*;
import java.lang.*;
import java.text.*;
import java.security.*;
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;

// ------------- class G2D ---------------------
class G2D {
    public static Point2D.Double mult(Point2D.Double p, double w) {
	return new Point2D.Double(p.getX()*w, p.getY()*w);
    }
    public static Point2D.Double add(Point2D.Double p1, double w1, Point2D.Double p2, double w2) {
	return new Point2D.Double(p1.getX()*w1+p2.getX()*w2, p1.getY()*w1+p2.getY()*w2);
    }
    public static double norm(Point2D.Double p) {
	return Math.sqrt(p.getX()*p.getX() + p.getY()*p.getY());
    }
    public static double scalar(Point2D.Double p1, Point2D.Double p2) {
	return p1.getX()*p2.getX()+p1.getY()*p2.getY();
    }
    public static Point2D.Double trunc(Point2D.Double p, double l) {
	double n=norm(p);
	if (n<=l) return p;
	return mult(p, l/n);
    }
}

// ------------- class Species -----------------
class Species {
    public int maxSpeed, maxAcc, detectionRange, separationRange, color;
    public void setParam(int ms, int ma, int dr, int sr, int c) {
	maxSpeed=ms;
	maxAcc=ma;
	separationRange=sr;
	detectionRange=Math.max(dr,sr+1);
	color=0x000000;		//black for obstacle for all kinds
	if (c==1) color=0x3030C0;
	if (c==2) color=0xF0F080;
	if (c==3) color=0xF050F0;
	if (c==4) color=0x00FF7F;
	if (c==5) color=0x00BFFF;
	if (c==6) color=0xF09060;
    }
}
// ------------- class Fish --------------------
class Fish {
    public Point2D.Double p,v;	//position and velocity
    public int col;		//color of the individual (0 for an obstacle and 1..N for a fish)
    public void setParam(double px, double py, double vx, double vy, double lim, int c) {
	//sets params which vary for individual fish of one kind
	p = new Point2D.Double(px,py);
	v = new Point2D.Double(vx,vy);
	col=c;
	//bound the speed with maxSpeed for the species
	v = G2D.trunc(v, lim);
    }
    public void move(Point2D.Double newSpeed, double lim) {
	//adjust the speed
	v = G2D.add(v,1.0,newSpeed,1.0);
	//bound it
	v = G2D.trunc(v, lim);
	//adjust the position
	p = G2D.add(p,1.0,v,1.0);
    }
    public void draw(Graphics2D g, Color c) {
	//draw it on the given graphics
	g.setColor(c);
	g.fillOval((int)p.getX()-2,(int)p.getY()-2,5,5);
	g.drawLine((int)p.getX(),(int)p.getY(),(int)(p.getX()+v.getX()),(int)(p.getY()+v.getY()));
    }
}
public class Flock {
// ------------- problem itself ----------------
    SecureRandom r;
    int S;		//area size
    int Nc;		//number of fish species (colors)
    int Nf;		//number of real fish
    int No;		//number of obstacles
    Species[] sp;
    Fish[] fish;	//all real fish in the area
    Fish[] allfish;	//fish + fish-like obstacles
    int x1,y1,x2,y2,ind;	//target rectangle and species index
    String[] p_species, p_fish;	//params to be passed to the solution
    String p_wanted;
    // -----------------------------------------
    void generate(String seed) {
      try {
	int i,j,k;
	S=600;				//area size - fixed?
        r = SecureRandom.getInstance("SHA1PRNG");
        r.setSeed(Long.parseLong(seed));
	Nc = r.nextInt(6)+1;
	sp = new Species[Nc+1];
	sp[0] = new Species();
	sp[0].setParam(0,0,0,0,0);
	for (i=1; i<=Nc; i++)
	{   sp[i] = new Species();
	    sp[i].setParam(r.nextInt(16)+5, r.nextInt(6)+5, r.nextInt(26)+20, r.nextInt(6)+5, i);
	}
	int Nfl = r.nextInt(20)+1;	//number of flocks to be generated (moving model doesn't use this)
	int c,xsz,ysz,xpos,ypos,nf,x,y;
	double dir,dir1,mod;
	Nf=0;
	Fish[][] fl = new Fish[Nfl][];
	for (i=0; i<Nfl; i++)
	{   //get color and generate the fish of flock i
	    //params of flock as a whole (but not of the species)
	    c = r.nextInt(Nc)+1;		//species 1..Nc
	    xsz = ysz = sp[c].separationRange*4;
	    xpos = r.nextInt(S/2-xsz)+S/4+xsz/2;	//"position"
	    ypos = r.nextInt(S/2-ysz)+S/4+ysz/2;
	    nf = r.nextInt(26)+5;		//number of fish in the flock
	    dir = r.nextInt(360)*Math.PI/180;	//speed is the same for all now, while direction may vary
	    mod = r.nextInt(sp[c].maxSpeed/3)+sp[c].maxSpeed*2/3;
	    Nf+=nf;
	    fl[i] = new Fish[nf];
	    for (j=0; j<nf; j++)
	    {	//generate new fish within the flock
		x = r.nextInt(xsz)-xsz/2+xpos;
		y = r.nextInt(ysz)-ysz/2+ypos;
		dir1 = dir + (r.nextInt(7)-3)*Math.PI/180;
		//with random speed which doesn't not exceed maxSpeed of this species
		fl[i][j] = new Fish();
		fl[i][j].setParam(x,y,mod*Math.cos(dir1),mod*Math.sin(dir1),sp[c].maxSpeed,c);
	    }
	}
	//store all flocks together
	fish = new Fish[Nf];
	k=0;
	for (i=0; i<Nfl; i++)
	for (j=0; j<fl[i].length; j++)
	{   fish[k]=fl[i][j];
	    k++;
	}
	//shuffle the fish (in case someone wants to use flock info)
	Fish t;
	for (i=0; i<Nf-1; i++)
	{   j=r.nextInt(Nf-i)+i;
	    if (i==j) continue;
	    t=fish[j];
	    fish[j]=fish[i];
	    fish[i]=t;
	}
	//generate target
	ind = r.nextInt(Nc)+1;
	xsz = r.nextInt(51)+50;
	ysz = r.nextInt(51)+50;
	x1 = r.nextInt(S-100-xsz)+50;
	y1 = r.nextInt(S-100-ysz)+50;
	x2 = x1+xsz;
	y2 = y1+ysz;
	formatParams();
      }
      catch (Exception e) { e.printStackTrace(); }
    }
    // -----------------------------------------
    Point2D.Double force(int i) {
        //calc the force which produces the acceleration
        Point2D.Double f,fs,fc,fa,fg;
        Point2D.Double dp;
        f  = new Point2D.Double(0,0);
        fs = new Point2D.Double(0,0);
        fc = new Point2D.Double(0,0);
        fa = new Point2D.Double(0,0);
        fg = new Point2D.Double(0,0);
        int c = allfish[i].col, dR = sp[c].detectionRange, sR = sp[c].separationRange;
        int j, na=0;
        double d,mind;
        //gravity effect
        mind = Math.min(Math.min(allfish[i].p.x, S-allfish[i].p.x), Math.min(allfish[i].p.y, S-allfish[i].p.y));
        fg = G2D.add(fg,1, new Point2D.Double(1,0), 1/Math.max(1,allfish[i].p.x)-1/Math.max(1,S-allfish[i].p.x));
        fg = G2D.add(fg,1, new Point2D.Double(0,1), 1/Math.max(1,allfish[i].p.y)-1/Math.max(1,S-allfish[i].p.y));
        //other fish and obstacles effects
        for (j=0; j<Nf+No; j++)
        {   if (i==j) continue;
            dp = G2D.add(allfish[j].p, 1,allfish[i].p, -1);	//offset from i to j
            d = G2D.norm(dp);				//dist between them
            if (d>dR)
                continue;				//i doesn't see j because of distance
            if (allfish[j].col==c)
            {	//alignment, cohesion and short-distance separation
                na++;
                fa = G2D.add(fa, 1, G2D.add(allfish[j].v, 1, allfish[i].v, -1), 1);
                if (d>sR)
                    fc = G2D.add(fc, 1, dp, 1);
                else if (d>0)
                    fs = G2D.add(fs,1,dp,-1/Math.pow(Math.max(d-sR*0.5,1),2));
            }
            else //long-distance separation
                if (d>0)
                    fs = G2D.add(fs,1,dp,-1/Math.pow(Math.max(d-sR,0.1),2));
        }
        //alignment and cohesion are averaged (separation isn't)
        if (na>0)
        {   fa = G2D.mult(fa, 1.0/na);
            fc = G2D.mult(fc, 1.0/na);
        }
        //final force is a weighted average of all forces
        f = G2D.add(f, 1, fa, 3);
        f = G2D.add(f, 1, fc, 1.5);
        f = G2D.add(f, 1, fs, 1);
        if (mind<25)
            f = G2D.add(f, 1, fg, 100);
        //and a small random component
        f = G2D.add(f,1, new Point2D.Double(r.nextInt(101)-50,r.nextInt(101)-50),0.5);
        f = G2D.mult(f,0.05);
        //if(sp[c].maxAcc < G2D.norm(f)) System.out.println(G2D.norm(f)+" "+sp[c].maxAcc);
        //normalized to maxAcc
        return G2D.trunc(f,sp[c].maxAcc);
    }
    // -----------------------------------------
    // -----------------------------------------
    void formatParams() {
	//formats params to be passed to the solution
	int i,j;
	p_species = new String[Nc];
	for (i=1; i<=Nc; i++)
	    p_species[i-1] = sp[i].maxSpeed + " " + sp[i].maxAcc + " " + sp[i].detectionRange + " " + sp[i].separationRange;
	p_fish = new String[Nf];
	for (i=0; i<Nf; i++)
	    p_fish[i] = (int)(fish[i].p.getX()) + " " + (int)(fish[i].p.getY()) + " " + (int)(fish[i].v.getX()) + " " + (int)(fish[i].v.getY()) + " " + fish[i].col;
	p_wanted = x1 + " " + y1 + " " + x2 + " " + y2 + " " + ind;
    }
    // -----------------------------------------
    public double runTest() {
	//get the result from the solution
	int[] ret = placeObstacles();
	//parse and place the returned obstacles
	if (ret.length%3!=0)
	{   System.err.println("The number of elements in return must be divisible by 3.");
	    return 0.0;
	}
	//add the obstacles to the fish list (with 0 speed)
	No=ret.length/3;
	allfish = new Fish[Nf+No];
	int i,j;
	for (i=0; i<Nf; i++)
	    allfish[i]=fish[i];
	for (i=0; i<No; i++)
	{   allfish[Nf+i] = new Fish();
	    //check the validity of returned params per obstacle here
        //System.out.println(ret[3*i+0]);
	    allfish[Nf+i].setParam(ret[3*i], ret[3*i+1], 0, 0, 0, ret[3*i+2]);
	}

	Point2D.Double[] force = new Point2D.Double[Nf];
	for (j=0; j<500; j++)
	{   //one iteration step
	    for (i=0; i<Nf; i++)
		force[i] = force(i);		//calc moves for fish[i] (don't move yet!)
	    for (i=0; i<Nf; i++)
		allfish[i].move(force[i], sp[allfish[i].col].maxSpeed);	//move
	    //visualize
	    if (vis)
	    {	v.repaint();
		    if(del > 0)
		rob.delay(del);
	    }
	}
	//estimate the quality of the final position of fish
	//something about the number of wanted and unwanted fish in the area
	int nw=0, nuw=0;
	double x,y;
	for (i=0; i<Nf; i++)
	{   x=allfish[i].p.getX();
	    y=allfish[i].p.getY();
	    if (x>=x1 && x<=x2 && y>=y1 && y<=y2)
	        if (allfish[i].col==ind)
		    nw++;
		else
		    nuw++;
	}
	if (nw==0)
	    return 0.0;
	return nw*nw*1.0/(nw+nuw)/(No+1);
    }
    // -----------------------------------------
    public double[] score(double[][] sc) {
        double[] res = new double[sc.length];
        double maxsc;
        for (int j=0; j<sc[0].length; j++)
        {   maxsc=0;
            for (int i=0; i<sc.length; i++)
                if (sc[i][j]>maxsc)
                    maxsc=sc[i][j];
            if (maxsc==0)
                continue;
            for (int i=0; i<sc.length; i++)
                res[i] += sc[i][j]/maxsc;
        }
	return res;
    }
    public String checkData(String test) {
        return "";
    }
    public String displayTestCase(String test) {
        generate(test);
	StringBuffer sb = new StringBuffer();

	return sb.toString();
    }
// ------------- visualization part ------------
    Vis v;
    Robot rob;
    static String exec;
    static boolean vis = true;
    static Process proc;
    static int del;
    InputStream is;
    OutputStream os;
    // -----------------------------------------
    public int[] placeObstacles() {
	try
	{   StringBuffer sb = new StringBuffer();
	    int i;
	    //output the params here
	    sb.append(Nc+"").append('\n');
	    for (i=0; i<Nc; i++)
		sb.append(p_species[i]).append('\n');
	    sb.append(Nf+"").append('\n');
	    for (i=0; i<Nf; i++)
		sb.append(p_fish[i]).append('\n');
	    sb.append(p_wanted).append('\n');
	    os.write(sb.toString().getBytes());
        os.flush();
	    //and get the return
	    BufferedReader br = new BufferedReader(new InputStreamReader(is));
	    int N = Integer.parseInt(br.readLine());	//number of elements in return
	    int[] ret = new int[N];
            for (i=0; i<N; i++)
                ret[i] = Integer.parseInt(br.readLine());
            return ret;
        } catch(Exception e) {
            System.err.println("An exception occurred while trying to get your program's results.");
            e.printStackTrace();
            return new int[0];
        }
    }
    // -----------------------------------------
    public class Vis extends JPanel {
        public void paint(Graphics g) {
	    //paint the current state of the flock
            BufferedImage bi = new BufferedImage(S+10,S+10,BufferedImage.TYPE_INT_RGB);
	    Graphics2D g2 = bi.createGraphics();
	    g2.setColor(new Color(0xCCCCCC));
	    g2.fillRect(0,0,S+10,S+10);
	    g2.setColor(Color.black);
        g2.drawLine(x1,y1,x1,y2);
        g2.drawLine(x2,y1,x2,y2);
        g2.drawLine(x1,y1,x2,y1);
        g2.drawLine(x1,y2,x2,y2);
	    int i;
	    if (allfish != null){
            //System.out.println(No);
	        for (i=0; i<Nf+No; i++)
		    allfish[i].draw(g2, new Color(sp[allfish[i].col].color));
        }else
	        for (i=0; i<Nf; i++)
		    fish[i].draw(g2, new Color(sp[fish[i].col].color));
            g.drawImage(bi,0,0,null);
	}
    }
    // -----------------------------------------
    public Flock(String seed) {
	//interface for runTest
	generate(seed);
	if (vis)
	{   JFrame jf = new JFrame();
            Closer cl = new Closer();
            jf.addWindowListener(cl);
            jf.setSize(S+20,S+50);
            v = new Vis();
	    jf.getContentPane().add(v);
            jf.setVisible(true);
	    try { rob = new Robot(); }
	    catch (Exception e) { e.printStackTrace(); }
	}
        if(exec != null){
            try{
                Runtime rt = Runtime.getRuntime();
                proc = rt.exec(exec);
                os = proc.getOutputStream();
                is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
	System.out.println("Score = "+runTest());
    }
    // -----------------------------------------
    public static void main(String[] args) {
        String seed = "1";
	vis = true;
	del = 0;
        for (int i = 0; i<args.length; i++)
        {   if (args[i].equals("-seed"))
                seed = args[++i];
            if (args[i].equals("-exec"))
                exec = args[++i];
	    if (args[i].equals("-delay"))
		del = Integer.parseInt(args[++i]);
            if (args[i].equals("-novis"))
                vis = false;
	}
	Flock f = new Flock(seed);
    }
    // -----------------------------------------
    class Closer implements WindowListener {
        public void windowActivated(WindowEvent e) {}
        public void windowDeactivated(WindowEvent e) {}
        public void windowOpened(WindowEvent e) {}
        public void windowClosing(WindowEvent e)
	{   if(proc != null) {
                try { proc.destroy(); } 
		catch (Exception ex) { ex.printStackTrace(); }
            }
            System.exit(0); 
        }
        public void windowClosed(WindowEvent e) {}
        public void windowIconified(WindowEvent e) {}
        public void windowDeiconified(WindowEvent e) {}
    }
}
class ErrorReader extends Thread{
    InputStream error;
    public ErrorReader(InputStream is) {
        error = is;
    }
    public void run() {
        try {
            byte[] ch = new byte[50000];
            int read;
            while ((read = error.read(ch)) > 0)
	    {   String s = new String(ch,0,read);
                System.out.print(s);
                System.out.flush();
            }
        } catch(Exception e){
            //System.err.println("Failed to read from stderr");
        }
    }
}

