/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FixTheFenceVis {
    static final int MIN_DIAGRAM_SIZE = 15;
    static final int MAX_DIAGRAM_SIZE = 100;
    static final double MIN_DIAGRAM_FILL = 0.1;
    static final double MAX_DIAGRAM_FILL = 1.0;
    static final double[] MAX_WEIGHTS = new double[]{1.0, 1.0, 1.0, 0.5};
    static final String directions = "UDLR";
    static final int[] dirRow = new int[]{-1, 1, 0, 0};
    static final int[] dirCol = new int[]{0, 0, -1, 1};
    int size;
    double fill;
    double[] weights;
    int[][] diagram = null;
    boolean[][] grid = null;
    boolean[][] correct = null;
    static int side = 10;
    static String exec = null;
    static boolean vis = true;
    static Process proc = null;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    JFrame jf;
    Vis v;

    public FixTheFenceVis(String string) {
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void generate(String string) {
        int n;
        do {
            SecureRandom secureRandom = null;
            try {
                secureRandom = SecureRandom.getInstance("SHA1PRNG");
                secureRandom.setSeed(Long.parseLong(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.fill = secureRandom.nextDouble() * 0.9 + 0.1;
            this.weights = new double[4];
            double d = 0.0;
            for (n = 0; n < 4; ++n) {
                this.weights[n] = secureRandom.nextDouble() * MAX_WEIGHTS[n];
                d += this.weights[n];
            }
            n = 0;
            while (n < 4) {
                int n2 = n++;
                this.weights[n2] = this.weights[n2] / d;
            }
            this.size = secureRandom.nextInt(86) + 15;
            this.diagram = new int[this.size][this.size];
            n = 1;
            for (int i = 0; i < this.size; ++i) {
                block6: for (int j = 0; j < this.size; ++j) {
                    this.diagram[i][j] = -1;
                    if (!(secureRandom.nextDouble() < this.fill)) continue;
                    n = 0;
                    double d2 = secureRandom.nextDouble();
                    this.diagram[i][j] = 3;
                    for (int k = 0; k < 4; ++k) {
                        if (!((d2 -= this.weights[k]) <= 0.0)) continue;
                        this.diagram[i][j] = k;
                        continue block6;
                    }
                }
            }
        } while (n != 0);
    }

    private String callSolution() throws IOException {
        if (exec == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.size).append('\n');
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                stringBuilder.append(this.diagram[i][j] == -1 ? (char)'-' : (char)(48 + this.diagram[i][j]));
            }
            stringBuilder.append("\n");
        }
        this.os.write(stringBuilder.toString().getBytes());
        this.os.flush();
        return this.br.readLine();
    }

    public double runTest(String string) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            this.generate(string);
            if (exec == null) {
                System.out.println("Nothing to run. Please specify your solution with -exec option.");
                this.draw();
                return 0.0;
            }
            String string2 = this.callSolution();
            if (vis) {
                this.jf.setSize(this.size * side + 55, this.size * side + 75);
                this.jf.setVisible(true);
            }
            if (string2 == null) {
                this.addFatalError("Unable to get any return value from your solution.");
                return 0.0;
            }
            String[] stringArray = string2.split(" ");
            try {
                if (stringArray.length != 3) {
                    throw new Exception();
                }
                n4 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                this.addFatalError("Your return value should be in \"Row Column LoopDescription\" format, where Row and Column are valid integers.");
                return 0.0;
            }
            String string3 = stringArray[2];
            if (string3.length() == 0) {
                this.addFatalError("Your loop description can not by empty.");
                return 0.0;
            }
            int n5 = n4 *= 2;
            int n6 = n3 *= 2;
            if (n4 < 0 || n4 > this.size * 2 || n3 < 0 || n3 > this.size * 2) {
                this.addFatalError("Row and Column should be inside [0, DiagramSize] range.");
                return 0.0;
            }
            this.grid = new boolean[2 * this.size + 1][2 * this.size + 1];
            for (n2 = 0; n2 < string3.length(); ++n2) {
                n = directions.indexOf(string3.charAt(n2));
                if (n == -1) {
                    this.addFatalError("Loop description can contain only 'U', 'D', 'L' and 'R' characters.");
                    return 0.0;
                }
                if ((n4 += dirRow[n]) < 0 || n4 > 2 * this.size || (n3 += dirCol[n]) < 0 || n3 > 2 * this.size) {
                    this.addFatalError("Your loop goes outside of the diagram boundary.");
                    return 0.0;
                }
                if (this.grid[n4][n3]) {
                    this.addFatalError("Your loop visits the same edge twice.");
                    return 0.0;
                }
                this.grid[n4][n3] = true;
                if (this.grid[n4 += dirRow[n]][n3 += dirCol[n]]) {
                    this.addFatalError("Your loop visits the same lattice point twice.");
                    return 0.0;
                }
                this.grid[n4][n3] = true;
            }
            if (n4 != n5 || n3 != n6) {
                this.addFatalError("Your loop should start and finish at the same lattice point.");
                return 0.0;
            }
            n2 = 0;
            n = 0;
            this.correct = new boolean[this.size][this.size];
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    if (this.diagram[i][j] == -1) continue;
                    ++n2;
                    int n7 = 0;
                    for (int k = 0; k < 4; ++k) {
                        n7 += this.grid[i * 2 + 1 + dirRow[k]][j * 2 + 1 + dirCol[k]] ? 1 : 0;
                    }
                    this.correct[i][j] = n7 == this.diagram[i][j];
                    n += this.correct[i][j] ? 1 : 0;
                }
            }
            this.draw();
            return (double)n / (double)n2;
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results: ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
                continue;
            }
            if (!stringArray[i].equals("-side")) continue;
            side = Integer.parseInt(stringArray[++i]);
        }
        new FixTheFenceVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public String checkData(String string) {
        return "";
    }

    public String displayTestCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.generate(string);
        stringBuilder.append("Seed = " + string + "\n");
        stringBuilder.append("Diagram size = " + this.size + "\n");
        stringBuilder.append("Diagram =\n");
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                stringBuilder.append(this.diagram[i][j] == -1 ? (char)'-' : (char)(48 + this.diagram[i][j]));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public double[] score(double[][] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        if (dArray.length == 0) {
            return dArray2;
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < dArray[0].length; ++n) {
            int n2;
            double d = 0.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                d = Math.max(d, dArray[n2][n]);
            }
            if (!(d > 0.0)) continue;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + dArray[n2][n] / d;
            }
        }
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = dArray2[n] / (double)dArray[n].length * 1000000.0;
        }
        return dArray2;
    }

    void draw() {
        if (this.v == null) {
            return;
        }
        this.v.repaint();
    }

    class Vis
    extends JPanel
    implements WindowListener {
        static final int MARGIN = 20;
        static final int HMARGINS = 55;
        static final int VMARGINS = 75;
        static final int LATTICE_POINT_SIZE = 4;
        final Color CORRECT_COLOR = new Color(0xC0C0FF);
        final Color INCORRECT_COLOR = new Color(0xFFC0C0);
        static final int MINIMUM_FONT_SIZE = 10;
        static final int MINIMUM_POINT_SIZE = 10;

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            BufferedImage bufferedImage = new BufferedImage(FixTheFenceVis.this.size * side + 55, FixTheFenceVis.this.size * side + 75, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(new Color(0xFFFFFF));
            graphics2D.fillRect(0, 0, FixTheFenceVis.this.size * side + 55, FixTheFenceVis.this.size * side + 75);
            if (FixTheFenceVis.this.grid != null) {
                for (n2 = 0; n2 < FixTheFenceVis.this.size; ++n2) {
                    for (n = 0; n < FixTheFenceVis.this.size; ++n) {
                        if (FixTheFenceVis.this.diagram[n2][n] == -1) continue;
                        graphics2D.setColor(FixTheFenceVis.this.correct[n2][n] ? this.CORRECT_COLOR : this.INCORRECT_COLOR);
                        graphics2D.fillRect(20 + n * side, 20 + n2 * side, side, side);
                    }
                }
                graphics2D.setColor(new Color(0));
                graphics2D.setStroke(new BasicStroke(2.0f));
                for (n2 = 0; n2 <= FixTheFenceVis.this.size; ++n2) {
                    for (n = 0; n <= FixTheFenceVis.this.size; ++n) {
                        if (n < FixTheFenceVis.this.size && FixTheFenceVis.this.grid[2 * n2][2 * n + 1]) {
                            graphics2D.drawLine(20 + n * side, 20 + n2 * side, 20 + n * side + side, 20 + n2 * side);
                        }
                        if (n2 >= FixTheFenceVis.this.size || !FixTheFenceVis.this.grid[2 * n2 + 1][2 * n]) continue;
                        graphics2D.drawLine(20 + n * side, 20 + n2 * side, 20 + n * side, 20 + n2 * side + side);
                    }
                }
            }
            if (side >= 10) {
                graphics2D.setColor(new Color(0));
                graphics2D.setStroke(new BasicStroke(1.0f));
                for (n2 = 0; n2 <= FixTheFenceVis.this.size; ++n2) {
                    for (n = 0; n <= FixTheFenceVis.this.size; ++n) {
                        graphics2D.fillRect(20 + n2 * side - 2, 20 + n * side - 2, 4, 4);
                    }
                }
            }
            if (side >= 10) {
                graphics2D.setColor(new Color(0));
                graphics2D.setFont(new Font("Monospaced", 1, side));
                FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
                n = fontMetrics.charWidth('0');
                int n3 = fontMetrics.getHeight();
                for (int i = 0; i < FixTheFenceVis.this.size; ++i) {
                    for (int j = 0; j < FixTheFenceVis.this.size; ++j) {
                        if (FixTheFenceVis.this.diagram[i][j] == -1) continue;
                        String string = "" + (char)(48 + FixTheFenceVis.this.diagram[i][j]);
                        graphics2D.drawString(string, 20 + j * side + side / 2 - n / 2, 20 + i * side + side / 2 + side - n3 / 2);
                    }
                }
            }
            graphics.drawImage(bufferedImage, 0, 0, FixTheFenceVis.this.size * side + 55, FixTheFenceVis.this.size * side + 75, null);
        }

        public Vis() {
            FixTheFenceVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

