import java.util.*;
import java.io.*;
import java.security.*;


public class FactoryManager{
    SecureRandom r;
    int B, M, L, C, contractId;
    double P[], P0[], F[];
    int Pi[];

    double money;
    int W[];
    int Processes[][];

    void generate(int seed) throws Exception {
        r = SecureRandom.getInstance("SHA1PRNG");
        r.setSeed(seed);
        B = 5 + r.nextInt(21);
        M = 5 + r.nextInt(21);
        L = 100 + r.nextInt(901);
        C = 1000 + r.nextInt(9001);
        money = 0.;
        contractId = 0;

        W = new int[B+M];
        Processes = new int[M][];
        for(int i = 0; i < M; i++) {
            // int nb = (int)(1.5 + Math.log(1/(0.001 + 0.999*r.nextDouble()))/Math.log(2.));     
            double rd = r.nextDouble();
            int nb = (int)(1.5 + rd*rd*6); 
            Processes[i] = new int[nb];
            for(int j = 0; j < Processes[i].length; j++) Processes[i][j] = r.nextInt(B+i);
        }
        P0 = new double[B];
        for(int i = 0; i < B; i++) P0[i] = 50.*Math.pow(2,2*r.nextDouble()-1);

        F = new double[M];
        for(int i = 0; i < M; i++) F[i] = 5*Math.pow(2,2*r.nextDouble()-1);

        P = new double[B+M];
        for(int i = 0; i < B; i++) P[i] = P0[i];
        for(int i = 0; i < B; i++) for(int j = 0; j < 1000; j++) P[i] = Math.pow(P0[i], 0.01) * Math.pow(P[i], 0.99) * Math.pow(1.05, 2*r.nextDouble()-1);

        for(int i = 0; i < M; i++) for(int j = 0; j < Processes[i].length; j++) P[B+i] += F[i] + P[Processes[i][j]];

        Pi = new int[B+M];
        for(int i = 0; i < B+M; i++) Pi[i] = (int)Math.round(P[i]);
    }


    void updatePrices() {
        for(int i = 0; i < B; i++) P[i] = Math.pow(P0[i], 0.01) * Math.pow(P[i], 0.99) * Math.pow(1.05, 2*r.nextDouble()-1);
        for(int i = 0; i < M; i++) {
            P[B+i] = 0;
            for(int j = 0; j < Processes[i].length; j++) P[B+i] += F[i] + P[Processes[i][j]];
        }
        for(int i = 0; i < B+M; i++) Pi[i] = (int)Math.round(P[i]);
    }


    int[][] genContracts() {
        int k = r.nextInt(11);
        int[][] ret = new int[k][];

        for(int i = 0; i < k; i++) {
            int length = r.nextInt(101);
            int rate = r.nextInt(51);
            ret[i] = new int[M+4];
            int nbP = 1 + r.nextInt(5);      
            double price = 0.;
            for(int j = 0; j < nbP; j++) {
                int p = r.nextInt(M);
                while(ret[i][p+4] != 0) p = r.nextInt(M);
                double rd = r.nextDouble(); 
                ret[i][p+4] = (int)Math.ceil(rd*rd*rd*1000.);
                price += ret[i][p+4]*P[B+p];
            }

            price *= Math.pow(1.5,2*r.nextDouble()-1);

            double f = 0;
            for(int j = 4; j < ret[i].length; j++) f += ret[i][j];
            f = 1 + (f/(double)length)*rate/10000.;
            if(f > 1.5) f = 1.5;
            if(length == 0 && rate == 0)f = 1;
            //System.out.println(f);
            price *= f;

            ret[i][0] = contractId++;
            ret[i][1] = (int)Math.round(price);
            ret[i][2] = length;
            ret[i][3] = rate;

            if(price > 2e9) i--;
        }
        return ret;
    }

    String intToString(int[] A) {
        StringBuffer sb = new StringBuffer();
        for(int i = 0; i < A.length; i++) {
            if(i != 0) sb.append(" ");
            sb.append(A[i]);
        }
        return sb.toString();
    }

    int[] stringToInt(String S) {
        StringTokenizer ST = new StringTokenizer(S);
        int nb = ST.countTokens();
        int[] ret = new int[nb];    
        for(int i = 0; i < nb; i++) ret[i] = Integer.parseInt(ST.nextToken());
        return ret;
    }


    public double runTest() throws IOException {
        double buymoney = 0, penmoney = 0, shipmoney = 0;

        Map Contracts = new HashMap();
        int[][] ret = new int[4][];
        int[] pic = new int[B];

        for(int day = 0; day < 5000; day++) { // main simulation loop
            //System.out.println(day);

            int[][] todayContracts = genContracts();
            String[] todayContractsString = new String[todayContracts.length];
            for(int i = 0; i < todayContracts.length; i++) todayContractsString[i] = intToString(todayContracts[i]);

            for(int i = 0; i<B; i++)pic[i] = Pi[i];
            String[] retString = manage(W, pic, todayContractsString);

            if(retString.length != 4) { // verify size of arrays
                addFatalError("Bad return format (array size)");
                return 0;      
            }
            try{
                for(int i = 0; i < 4; i++) ret[i] = stringToInt(retString[i]);
            }catch(Exception e){
                addFatalError("Bad return format");
                return 0;      
            }

            if(ret[0].length != B || ret[1].length != M) { // verify size of arrays
                addFatalError("Bad return format (array size)");
                return 0;      
            }

            for(int i = 0; i < ret[2].length; i++) { // put accepted contracts in a Map
                int pos = 0;
                for(; pos < todayContracts.length; pos++) if(todayContracts[pos][0] == ret[2][i]) break;
                if(pos == todayContracts.length) {
                    addFatalError("Invalid contract ID");
                    return 0;
                }
                if(Contracts.containsKey(ret[2][i])) {
                    addFatalError("Contract ID accepted twice");
                    return 0;
                }
                todayContracts[pos][2] += day; // last day before penalties
                Contracts.put(ret[2][i], todayContracts[pos]);
            }

            int totalProduction = 0;
            for(int i = 0; i < M; i++) { // remove required products
                totalProduction += ret[1][i];
                if(ret[1][i] < 0 || ret[1][i] > L || totalProduction > L) {
                    addFatalError("Invalid production Quantities");
                    return 0;
                }
            }

            for(int i = 0; i < M; i++) { // remove required products
                for(int j = 0; j < Processes[i].length; j++) W[Processes[i][j]] -= ret[1][i];       
            }

            for(int i = 0; i < W.length; i++) { // verify required products quantities
                if(W[i] < 0) {
                    addFatalError("Insufficient quantity for production");
                    return 0;
                }
            }
            for(int i = 0; i < M; i++) { // produce
                W[B+i] += ret[1][i];
            }

            for(int i = 0; i < ret[3].length; i++) { // ship contracts
                if(!Contracts.containsKey(ret[3][i])) {
                    addFatalError("Invalid contract ID shipped");
                    return 0;
                }
                int[] contr = (int[]) Contracts.remove(ret[3][i]);
                for(int j = 4; j < contr.length; j++) { // remove shiped products
                    W[B + j - 4] -= contr[j];
                }
                money += contr[1];
                shipmoney += contr[1];
            }
            for(int i = 0; i < W.length; i++) { // verify shipped products quantities
                if(W[i] < 0) {
                    addFatalError("Insufficient quantity for shipping.");
                    return 0;
                }
            }

            for(int i = 0; i < B; i++) if(ret[0][i] < 0 || ret[0][i] > C) { // base products quantities
                addFatalError("Invalid product quantity");
                return 0;
            }

            for(int i = 0; i < B; i++) { // receive bougth products
                W[i] += ret[0][i];
                money -= Pi[i]*ret[0][i];        
                buymoney += Pi[i]*ret[0][i];        
            }

            int totalW = 0;// verify warehouse capacity
            for(int i = 0; i < W.length; i++) totalW += W[i];
            if(totalW > C) {
                addFatalError("Warehouse capacity exceeded");
                return 0;
            }

            // pay penalties
            Iterator it = Contracts.values().iterator();
            while(it.hasNext()) {
                int[] contr = (int[]) it.next();
                if(contr[2] <= day) {
                    money -= (double)contr[1]*(double)contr[3]/1000.;
                    penmoney += (double)contr[1]*(double)contr[3]/1000.;
                }
            }

            updatePrices();
        } // end of main simulation loop
        addFatalError("spent = "+buymoney);
        addFatalError("earned = "+shipmoney);
        addFatalError("penalties = "+penmoney);

        if(money < 0) return 0;
        else return money;
    }
    public static void main(String[] args){
        if(args.length != 2){
            System.err.println("Usage: java -Xmx1024M FactoryManager <command> <seed>");
            return;
        }
        new FactoryManager(args);
    }

    BufferedReader in;
    OutputStream out;
    String[] manage(int [] warehouse, int[] prices, String[] contracts) throws IOException{
        StringBuffer sb = new StringBuffer();
        sb.append(warehouse[0]);
        for(int i = 1; i<warehouse.length; i++){
            sb.append(' ').append(warehouse[i]);
        }
        sb.append('\n');
        sb.append(prices[0]);
        for(int i = 1; i<prices.length; i++){
            sb.append(' ').append(prices[i]);
        }
        sb.append('\n');
        sb.append(contracts.length).append('\n');
        for(int i = 0; i<contracts.length; i++){
            sb.append(contracts[i]).append('\n');
        }
        out.write(sb.toString().getBytes());
        out.flush();
        String[] ret = new String[4];
        ret[0] = in.readLine();
        ret[1] = in.readLine();
        ret[2] = in.readLine();
        ret[3] = in.readLine();
        return ret;
    }
    public FactoryManager(String[] args){
        try{
            Runtime rt = Runtime.getRuntime();
            generate(Integer.parseInt(args[1]));
            final Process proc = rt.exec(args[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable() {
                public void run() {
                    proc.destroy();
                }
            }));
            new ErrorReader(proc.getErrorStream()).start();
            out = proc.getOutputStream();
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            StringBuffer sb = new StringBuffer();
            sb.append(B).append(' ').append(M).append(' ').append(L).append(' ').append(C).append('\n');
            for(int i = 0; i<M; i++){
                sb.append(intToString(Processes[i])).append('\n');
            }
            out.write(sb.toString().getBytes());
            out.flush();
            addFatalError("score = "+runTest());
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    
    public class ErrorReader extends Thread{
        InputStream error;
        public ErrorReader(InputStream err){
            error = err;
        }
        public void run(){
            try{
                byte[] ch = new byte[50000];
                int read;
                while((read = error.read(ch)) > 0){
                    String s = new String(ch,0,read);
                    System.out.print(s);
                    System.out.flush();
                }
            }catch(Exception e){
                System.err.println("Failed to read from stderr");
            }
        }
    }
    void addFatalError(String s){
        System.out.println(s);
    }
}
