/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class EnclosingCirclesVis {
    SecureRandom r;
    int[] pointx;
    int[] pointy;
    boolean[] pointOK;
    int N;
    int M;
    double[] circlex;
    double[] circley;
    double[] circler;
    String[] ret;
    static String exec;
    static String file;
    static String diff;
    static double diffsc;
    static Process proc;
    InputStream is;
    OutputStream os;

    void generate(String string) {
        try {
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(Long.parseLong(string));
            this.N = this.r.nextInt(951) + 50;
            this.M = this.r.nextInt(Math.max(10, this.N / 10) - 9) + 10;
            this.pointx = new int[this.N];
            this.pointy = new int[this.N];
            for (int i = 0; i < this.N; ++i) {
                this.pointx[i] = this.r.nextInt(512);
                this.pointy[i] = this.r.nextInt(512);
            }
            System.out.println("N = " + this.N + "\nM = " + this.M);
        }
        catch (Exception exception) {
            System.err.println("An exception occured while generating the test case.");
            exception.printStackTrace();
        }
    }

    public double runTest(String string) {
        try {
            int n;
            this.generate(string);
            this.ret = this.place(this.pointx, this.pointy, this.M);
            this.circlex = new double[0];
            this.circley = new double[0];
            this.circler = new double[0];
            if (this.ret.length > this.M) {
                throw new Exception("Too many circles in return.");
            }
            if (this.ret.length == 0) {
                throw new Exception("You need to place at least one circle.");
            }
            this.circlex = new double[this.ret.length];
            this.circley = new double[this.ret.length];
            this.circler = new double[this.ret.length];
            for (n = 0; n < this.ret.length; ++n) {
                String[] stringArray = this.ret[n].split(" ");
                if (stringArray.length != 3) {
                    throw new Exception("Incorrect number of elements on line " + n);
                }
                this.circlex[n] = Double.parseDouble(stringArray[0]);
                this.circley[n] = Double.parseDouble(stringArray[1]);
                this.circler[n] = Double.parseDouble(stringArray[2]);
                if (!(this.circler[n] <= 0.1)) continue;
                throw new Exception("Radius must be greater than 0.1");
            }
            this.pointOK = new boolean[this.N];
            n = 0;
            block3: for (int i = 0; i < this.N; ++i) {
                this.pointOK[i] = false;
                for (int j = 0; j < this.circlex.length; ++j) {
                    double d = this.circlex[j] - (double)this.pointx[i];
                    double d2 = this.circley[j] - (double)this.pointy[i];
                    if (!(d * d + d2 * d2 <= this.circler[j] * this.circler[j])) continue;
                    this.pointOK[i] = true;
                    ++n;
                    continue block3;
                }
            }
            if (n != this.N) {
                throw new Exception("Not all the points fall inside a circle.");
            }
            double d = 0.0;
            for (int i = 0; i < this.circlex.length; ++i) {
                d += Math.PI * this.circler[i] * this.circler[i];
            }
            return d;
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String[] place(int[] nArray, int[] nArray2, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append('\n');
        stringBuffer.append(this.N).append('\n');
        for (n2 = 0; n2 < this.N; ++n2) {
            stringBuffer.append(nArray[n2]).append('\n');
        }
        for (n2 = 0; n2 < this.N; ++n2) {
            stringBuffer.append(nArray2[n2]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
        int n3 = Integer.parseInt(bufferedReader.readLine());
        if (n3 > n) {
            System.out.println("Too many circles in return.");
        }
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = bufferedReader.readLine();
        }
        return stringArray;
    }

    BufferedImage drawCase() {
        int n;
        int n2;
        int n3;
        int n4;
        BufferedImage bufferedImage = new BufferedImage(600, 600, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.fill(new Rectangle(0, 0, 600, 600));
        int n5 = n4 = this.pointx[0];
        int n6 = n3 = this.pointy[0];
        for (n2 = 1; n2 < this.N; ++n2) {
            n4 = Math.min(n4, this.pointx[n2]);
            n5 = Math.max(n5, this.pointx[n2]);
            n3 = Math.min(n3, this.pointy[n2]);
            n6 = Math.max(n6, this.pointy[n2]);
        }
        for (n2 = 0; n2 < this.circlex.length; ++n2) {
            n4 = Math.min(n4, (int)(this.circlex[n2] - this.circler[n2]));
            n5 = Math.max(n5, (int)(this.circlex[n2] + this.circler[n2]));
            n3 = Math.min(n3, (int)(this.circley[n2] - this.circler[n2]));
            n6 = Math.max(n6, (int)(this.circley[n2] + this.circler[n2]));
        }
        n6 += 20;
        double d = 600.0 / (double)((n5 += 20) - (n4 -= 20));
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect((int)((double)(-n4) * d), (int)((double)(-(n3 -= 20)) * d), (int)(d * 512.0), (int)(d * 512.0));
        for (n = 0; n < this.N; ++n) {
            graphics2D.setColor(this.pointOK[n] ? Color.GREEN : Color.RED);
            graphics2D.drawRect((int)((double)(this.pointx[n] - n4) * d) - 1, (int)((double)(this.pointy[n] - n3) * d) - 1, 2, 2);
        }
        for (n = 0; n < this.circlex.length; ++n) {
            graphics2D.setColor(Color.BLUE);
            graphics2D.drawOval((int)((this.circlex[n] - this.circler[n] - (double)n4) * d), (int)((this.circley[n] - this.circler[n] - (double)n3) * d), (int)(this.circler[n] * 2.0 * d), (int)(this.circler[n] * 2.0 * d));
        }
        return bufferedImage;
    }

    public EnclosingCirclesVis(String string) throws IOException {
        Object object;
        if (exec != null) {
            try {
                object = Runtime.getRuntime();
                proc = ((Runtime)object).exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (file != null) {
            object = this.drawCase();
            if (file.equals("-")) {
                JFrame jFrame = new JFrame();
                jFrame.setSize(610, 630);
                jFrame.getContentPane().add(new JPanel((BufferedImage)object){
                    final /* synthetic */ BufferedImage val$bi;
                    {
                        this.val$bi = bufferedImage;
                    }

                    public void paint(Graphics graphics) {
                        graphics.drawImage(this.val$bi, 0, 0, null);
                    }
                });
                jFrame.setDefaultCloseOperation(3);
                jFrame.setVisible(true);
            } else {
                ImageIO.write((RenderedImage)object, "png", new File(file + ".png"));
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (!stringArray[i].equals("-vis")) continue;
            file = stringArray[++i];
        }
        EnclosingCirclesVis enclosingCirclesVis = new EnclosingCirclesVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

