/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Mining {
    Controller c;
    View v;
    String[] paramNames = new String[]{"seed", "fuelTank", "cargoBay", "maxMineral", "costFactor", "hole_prob", "gob_prob"};
    static Object runlock = new Object();

    public String getProcess() {
        if (this.v != null) {
            return this.v.fileName.getText();
        }
        return this.c.process;
    }

    public void setProcess(String string) {
        this.c.process = string;
        if (this.v != null) {
            this.v.fileName.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        new Mining(stringArray);
    }

    public Mining(String[] stringArray) {
        int n = 1000;
        int n2 = 1000;
        boolean bl = false;
        boolean bl2 = false;
        this.c = new Controller();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                bl2 = true;
                this.setProcess(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-drop")) {
                this.c.setDrop(true);
                continue;
            }
            if (stringArray[i].equals("-go")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                bl = true;
                this.c.novis = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-speed")) {
                int n3 = Integer.parseInt(stringArray[++i]);
                this.c.setSlide(n3);
                if (n3 >= 80) {
                    this.c.setPause(100 - n3);
                    continue;
                }
                this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, n3)));
                continue;
            }
            if (!stringArray[i].startsWith("-")) continue;
            String string = stringArray[i].substring(1);
            String string2 = stringArray[++i];
            try {
                Field field = this.c.getClass().getDeclaredField(string);
                if (field.getType().getName().equals("int")) {
                    field.set(this.c, new Integer(string2));
                    continue;
                }
                if (field.getType().getName().equals("double")) {
                    field.set(this.c, new Double(string2));
                    continue;
                }
                if (field.getType().getName().equals("char")) {
                    field.set(this.c, Character.valueOf(string2.charAt(0)));
                    continue;
                }
                field.set(this.c, string2);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Invalid parameters");
                return;
            }
        }
        if (this.c.novis && !bl2) {
            System.err.println("You must specify the executable when using -novis");
            return;
        }
        this.c.generate(false, this.c.getSeed());
        if (!this.c.novis) {
            this.v = new View(n);
            this.v.setSize(n2, n);
            this.v.setVisible(true);
        }
        if (bl) {
            this.c.start();
        }
    }

    class View
    extends JFrame
    implements WindowListener,
    ChangeListener {
        JTextArea err;
        JTextField fileName;
        JScrollPane scroll;
        JTextField[] params;
        int position;
        Vis sim;

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Mining.this.c.stop();
            System.exit(0);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public View(int n) {
            JSlider jSlider = new JSlider(0, 0, 100, Mining.this.c.getSlide());
            jSlider.addChangeListener(this);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(5);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.sim = new Vis();
            this.err = new JTextArea("Standard Error from your program, as well as other messages will appear here");
            this.scroll = new JScrollPane(this.err);
            JSplitPane jSplitPane = new JSplitPane(0, this.sim, this.scroll);
            jSplitPane.setDividerLocation(n - 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            JLabel jLabel = new JLabel("Speed");
            jLabel.setAlignmentX(0.5f);
            jSplitPane.setAlignmentX(0.5f);
            jPanel.add(jLabel);
            jPanel.add(jSlider);
            this.err.setEditable(false);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 2));
            this.params = new JTextField[Mining.this.paramNames.length];
            for (int i = 0; i < Mining.this.paramNames.length; ++i) {
                this.params[i] = new JTextField(Mining.this.c.getParameter(Mining.this.paramNames[i]));
                if (i <= this.params.length / 2) {
                    jPanel2.add(new Label(Mining.this.paramNames[i] + ": "));
                    jPanel2.add(this.params[i]);
                    continue;
                }
                jPanel3.add(new Label(Mining.this.paramNames[i] + ": "));
                jPanel3.add(this.params[i]);
            }
            jPanel2.setAlignmentX(0.5f);
            jPanel3.setAlignmentX(0.5f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
            JButton jButton = new JButton("Generate Map");
            JButton jButton2 = new JButton("New Parameters and Map");
            JButton jButton3 = new JButton("Start Simulation");
            JButton jButton4 = new JButton("Stop Simulation");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jPanel4.add(jButton3);
            jPanel4.add(jButton4);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mining.this.c.stop();
                    Mining.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.sim.rebuffer();
                    View.this.repaintSim(false);
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mining.this.c.stop();
                    if (Mining.this.c.getSeed() == Integer.parseInt(View.this.params[0].getText())) {
                        View.this.params[0].setText(String.valueOf(Mining.this.c.newSeed()));
                        Mining.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    } else {
                        Mining.this.c.generate(true, Integer.parseInt(View.this.params[0].getText()));
                    }
                    for (int i = 1; i < View.this.params.length; ++i) {
                        View.this.params[i].setText(Mining.this.c.getParameter(Mining.this.paramNames[i]));
                    }
                    View.this.sim.bi = null;
                    View.this.sim.rebuffer();
                    View.this.repaintSim(false);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mining.this.c.stop();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Mining.this.c.generate(false, Integer.parseInt(View.this.params[0].getText()));
                    View.this.sim.bi = null;
                    View.this.sim.rebuffer();
                    View.this.repaintSim(false);
                    Mining.this.c.start();
                }
            });
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Mining.this.c.stop();
                }
            });
            JPanel jPanel5 = new JPanel();
            JButton jButton5 = new JButton("Select Executable");
            this.fileName = new JTextField(Mining.this.c.process);
            jPanel5.add(jButton5);
            jPanel5.add(this.fileName);
            jPanel5.setLayout(new BoxLayout(jPanel5, 2));
            jButton5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(View.this);
                    if (n == 0) {
                        View.this.fileName.setText(jFileChooser.getSelectedFile().getPath());
                        Mining.this.c.process = jFileChooser.getSelectedFile().getPath();
                    }
                }
            });
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 3));
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            jPanel6.add(jPanel5);
            this.add((Component)jPanel, "North");
            this.add((Component)jSplitPane, "Center");
            this.add((Component)jPanel6, "South");
            this.addWindowListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValue() >= 80) {
                Mining.this.c.setPause(100 - jSlider.getValue());
            } else {
                Mining.this.c.setPause((int)(5000.0 * Math.pow(0.9333096363135965, jSlider.getValue())));
            }
        }

        void addMessage(final String string) {
            final JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            if (!(jScrollBar.getValueIsAdjusting() || jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum() && jScrollBar.getValue() != this.position)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        View.this.err.append(string);
                        View.this.position = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
                        jScrollBar.setValue(View.this.position);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.position = -1;
                this.err.append(string);
            }
        }

        void repaintSim(boolean bl) {
            Runnable runnable = new Runnable(){

                public void run() {
                    View.this.sim.paintImmediately(0, 0, View.this.sim.getWidth(), View.this.sim.getHeight());
                }
            };
            if (bl && !Mining.this.c.drop()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.sim.repaint();
            }
        }

        public String getParam(int n) {
            String string = this.params[n].getText();
            return string;
        }

        class Vis
        extends JPanel {
            Color[] cs = new Color[26];
            int size = 12;
            BufferedImage bi = null;

            Vis() {
                this.cs[0] = Color.white;
                this.cs[1] = Color.blue;
                this.cs[2] = Color.red;
                this.cs[3] = new Color(0, 255, 0);
                this.cs[4] = Color.yellow;
                this.cs[5] = Color.black;
                this.cs[6] = new Color(192, 192, 192);
                this.cs[7] = new Color(192, 0, 255);
                Random random = new Random(33L);
                for (int i = 8; i < this.cs.length; ++i) {
                    this.cs[i] = new Color(random.nextInt(6) * 51, random.nextInt(6) * 51, random.nextInt(6) * 51);
                }
            }

            public void paint(Graphics graphics) {
                if (this.bi == null) {
                    this.rebuffer();
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                Font font = new Font(graphics2D.getFont().getName(), 0, 40);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n = fontMetrics.getAscent();
                double d = Math.min((double)this.getWidth() / (double)this.bi.getWidth(), (double)(this.getHeight() - 2 * n - 2) / (double)this.bi.getHeight());
                if (d > 1.0) {
                    d = (int)d;
                } else {
                    int n2 = 1;
                    while (true) {
                        if (d > 1.0 / (double)n2) {
                            d = 1.0 / (double)n2;
                            break;
                        }
                        ++n2;
                    }
                }
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(d, d);
                graphics2D.translate(((double)this.getWidth() - (double)this.bi.getWidth() * d) / 2.0 / d, ((double)(this.getHeight() + 2 * n + 2) - (double)this.bi.getHeight() * d) / 2.0 / d);
                graphics2D.drawImage(this.bi, null, 0, 0);
                graphics2D.setTransform(affineTransform);
                double d2 = 0.0;
                for (int i = 0; i < Mining.this.c.maxMineral - 65 + 1; ++i) {
                    d2 += (double)Mining.this.c.cargo[i] * Mining.this.c.costs[i];
                }
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String string = "Value of cargo bay: " + decimalFormat.format(d2);
                String string2 = "Value returned: " + decimalFormat.format(Mining.this.c.score);
                int n3 = fontMetrics.stringWidth(string);
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string, 0, n);
                graphics2D.drawString(string2, 1, 2 * n + 1);
            }

            public void rebuffer() {
                int n = 30;
                if (this.bi == null) {
                    this.bi = new BufferedImage(9 * n, 7 * n, 1);
                }
                Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                Font font = new Font(graphics2D.getFont().getName(), 0, 20);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n2 = fontMetrics.getAscent();
                for (int i = 0; i < 7; ++i) {
                    for (int j = 0; j < 9; ++j) {
                        char c = Mining.this.c.charAt(Mining.this.c.xm + i - 3, Mining.this.c.ym + j - 4);
                        if (i == 3 && j == 4) {
                            graphics2D.setColor(new Color(65280));
                            graphics2D.fillRect(j * n, i * n, j * n + n, i * n + n);
                            continue;
                        }
                        if (c == '.') {
                            graphics2D.setColor(new Color(0));
                            graphics2D.fillRect(j * n, i * n, j * n + n, i * n + n);
                            continue;
                        }
                        if (c == '-') {
                            graphics2D.setColor(new Color(0xFF0000));
                            graphics2D.fillRect(j * n, i * n, j * n + n, i * n + n);
                            continue;
                        }
                        if (c == ' ') {
                            graphics2D.setColor(new Color(0xDDDDDD));
                            graphics2D.fillRect(j * n, i * n, j * n + n, i * n + n);
                            continue;
                        }
                        if (c <= 'I') {
                            graphics2D.setColor(new Color((c - 65) * 25));
                            graphics2D.fillRect(j * n, i * n, j * n + n, i * n + n);
                        } else if (c <= 'Q') {
                            graphics2D.setColor(new Color((c - 73) * 25 << 16 | 0xFF));
                            graphics2D.fillRect(j * n, i * n, j * n + n, i * n + n);
                        } else {
                            graphics2D.setColor(new Color(0xFF0000 | 255 - (c - 81) * 25));
                            graphics2D.fillRect(j * n, i * n, j * n + n, i * n + n);
                        }
                        graphics2D.setColor(Color.white);
                        String string = "" + c;
                        int n3 = fontMetrics.stringWidth(string);
                        graphics2D.drawString(string, j * n + (n - n3) / 2, i * n + n - (n - n2) / 2 - 2);
                    }
                }
            }
        }
    }

    class Controller {
        int fuelTank;
        int ncargo;
        int cargoBay;
        int[] cargo;
        char maxMineral;
        double costFactor;
        double[] costs;
        char[][] field;
        double score;
        int xm;
        int ym;
        double hole_prob;
        double gob_prob;
        double[][] p_min;
        String process = "Enter your executable and its arguments here";
        Runner current;
        Random r;
        int ST = 20;
        int slide = 80;
        int seed;
        boolean running;
        boolean novis;
        boolean drop;

        Controller() {
        }

        char charAt(int n, int n2) {
            if (n < 0) {
                return ' ';
            }
            int n3 = n < 3 ? 0 : n - 2;
            if (n >= this.field.length || n2 - 4 * n3 < 0 || n2 - 4 * n3 >= this.field[n].length) {
                return '-';
            }
            if (this.field[n][n2 - 4 * n3] != '?') {
                return this.field[n][n2 - 4 * n3];
            }
            if (n == 0 && n2 == this.field[0].length / 2) {
                this.field[0][n2] = 46;
                return '.';
            }
            this.r.setSeed(n * 234117 + n2 + this.seed);
            double d = this.r.nextDouble();
            if (d < this.hole_prob) {
                this.field[n][n2 - 4 * n3] = 32;
                return ' ';
            }
            if (d < this.hole_prob + this.gob_prob) {
                this.field[n][n2 - 4 * n3] = 46;
                return '.';
            }
            double d2 = this.hole_prob + this.gob_prob;
            for (int i = 0; i < this.costs.length; ++i) {
                if (d < d2 + this.p_min[n][i]) {
                    this.field[n][n2 - 4 * n3] = (char)(65 + i);
                    return (char)(65 + i);
                }
                d2 += this.p_min[n][i];
            }
            this.field[n][n2 - 4 * n3] = 46;
            return '.';
        }

        int clearAt(int n, int n2) {
            if (n < 0 || n >= this.field.length) {
                return 0;
            }
            int n3 = n < 3 ? 0 : n - 2;
            if (n2 - 4 * n3 >= 0 && n2 - 4 * n3 < this.field[n].length) {
                this.field[n][n2 - 4 * n3] = 32;
            }
            return 0;
        }

        String[] getPic(int n, int n2) {
            String[] stringArray = new String[7];
            char[] cArray = new char[9];
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 9; ++j) {
                    cArray[j] = this.charAt(n - 3 + i, n2 - 4 + j);
                }
                if (i == 3) {
                    cArray[4] = 42;
                }
                stringArray[i] = new String(cArray);
            }
            return stringArray;
        }

        int fuelToMove(int n, int n2, int n3, int n4) {
            char c = this.charAt(n + 1, n2);
            char c2 = this.charAt(n + n3, n2 + n4);
            char c3 = this.charAt(n + n3 + 1, n2 + n4);
            if (n3 == 0 && c2 == ' ' && c != ' ' && c3 != ' ' || c2 == ' ' && (c == ' ' || c3 == ' ') || (n3 != -1 || n4 != 0) && c2 != ' ' && c != ' ') {
                int n5 = n3 == 0 && c2 == ' ' && c != ' ' && c3 != ' ' ? 1 : 2;
                if (n + n3 + 1 > 0 && this.fuelTank - n5 < (n + n3 + 1) * 2) {
                    return -2;
                }
                if (n + n3 + 1 < 0 && this.fuelTank - n5 < -(n + n3 + 1) * 2) {
                    return -2;
                }
                return n5;
            }
            return -1;
        }

        int addToCargo(char c) {
            if (c == ' ' || c == '.') {
                return 0;
            }
            if (this.ncargo < this.cargoBay) {
                ++this.ncargo;
                int n = c - 65;
                this.cargo[n] = this.cargo[n] + 1;
                return 0;
            }
            for (int i = 0; i < c - 65; ++i) {
                if (this.cargo[i] <= 0) continue;
                int n = i;
                this.cargo[n] = this.cargo[n] - 1;
                int n2 = c - 65;
                this.cargo[n2] = this.cargo[n2] + 1;
                return 0;
            }
            return 0;
        }

        double addCargoToScore() {
            double d = 0.0;
            for (int i = 0; i < this.maxMineral - 65 + 1; ++i) {
                d += (double)this.cargo[i] * this.costs[i];
                this.cargo[i] = 0;
            }
            this.ncargo = 0;
            return d;
        }

        public void generate(boolean bl, int n) {
            int n2;
            this.seed = n;
            try {
                this.r = SecureRandom.getInstance("SHA1PRNG");
                this.r.setSeed(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                this.fuelTank = this.r.nextInt(9801) + 200;
                this.cargoBay = this.r.nextInt(151) + 50;
                this.maxMineral = (char)(65 + this.r.nextInt(26));
                this.costFactor = this.r.nextDouble() * 0.18999999999999995 + 1.01;
            } else {
                if (this.fuelTank == 0) {
                    this.fuelTank = this.r.nextInt(9801) + 200;
                } else {
                    this.r.nextInt(9801);
                }
                if (this.cargoBay == 0) {
                    this.cargoBay = this.r.nextInt(151) + 50;
                } else {
                    this.r.nextInt(151);
                }
                if (this.maxMineral == '\u0000') {
                    this.maxMineral = (char)(65 + this.r.nextInt(26));
                } else {
                    this.r.nextInt(26);
                }
                if (this.costFactor == 0.0) {
                    this.costFactor = this.r.nextDouble() * 0.18999999999999995 + 1.01;
                } else {
                    this.r.nextDouble();
                }
                if (Mining.this.v != null) {
                    try {
                        int n3 = 1;
                        while (n3 + 2 < Mining.this.paramNames.length) {
                            Field field = this.getClass().getDeclaredField(Mining.this.paramNames[n3]);
                            if (field.getType().getName().equals("int")) {
                                field.set(this, new Integer(Mining.this.v.getParam(n3)));
                            } else if (field.getType().getName().equals("double")) {
                                field.set(this, new Double(Mining.this.v.getParam(n3)));
                            } else if (field.getType().getName().equals("char")) {
                                field.set(this, Character.valueOf(Mining.this.v.getParam(n3).charAt(0)));
                            } else {
                                field.set(this, Mining.this.v.getParam(n3));
                            }
                            ++n3;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            int n4 = this.maxMineral - 65 + 1;
            this.costs = new double[n4];
            double d = 1.0;
            for (n2 = 0; n2 < n4; ++n2) {
                this.costs[n2] = d;
                d *= this.costFactor;
            }
            int n5 = this.fuelTank / 4;
            this.field = new char[n5 + 3][];
            this.p_min = new double[n5 + 3][n4];
            int n6 = (n5 + 3) / n4;
            int[] nArray = new int[n4];
            nArray[0] = n6 + this.r.nextInt(2 * n6);
            for (n2 = 1; n2 < n4; ++n2) {
                nArray[n2] = nArray[n2 - 1] + this.r.nextInt(2 * n6);
            }
            if (bl) {
                this.hole_prob = this.r.nextDouble() * 0.1 + 0.05;
                this.gob_prob = this.r.nextDouble() * 0.2 + 0.2;
            } else {
                if (this.hole_prob == 0.0) {
                    this.hole_prob = this.r.nextDouble() * 0.1 + 0.05;
                } else {
                    this.r.nextDouble();
                }
                if (this.gob_prob == 0.0) {
                    this.gob_prob = this.r.nextDouble() * 0.2 + 0.2;
                } else {
                    this.r.nextDouble();
                }
                if (Mining.this.v != null) {
                    try {
                        for (n2 = 1; n2 < Mining.this.paramNames.length; ++n2) {
                            Field field = this.getClass().getDeclaredField(Mining.this.paramNames[n2]);
                            if (field.getType().getName().equals("int")) {
                                field.set(this, new Integer(Mining.this.v.getParam(n2)));
                                continue;
                            }
                            if (field.getType().getName().equals("double")) {
                                field.set(this, new Double(Mining.this.v.getParam(n2)));
                                continue;
                            }
                            if (field.getType().getName().equals("char")) {
                                field.set(this, Character.valueOf(Mining.this.v.getParam(n2).charAt(0)));
                                continue;
                            }
                            field.set(this, Mining.this.v.getParam(n2));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            for (n2 = 0; n2 < n5 + 3; ++n2) {
                int n7;
                this.field[n2] = n2 < 3 ? new char[2 * this.fuelTank + 9] : new char[this.field[n2 - 1].length - 8];
                for (n7 = 0; n7 < this.field[n2].length; ++n7) {
                    this.field[n2][n7] = 63;
                }
                double d2 = 0.0;
                for (n7 = 0; n7 < n4; ++n7) {
                    this.p_min[n2][n7] = Math.exp((double)(-(n2 - nArray[n7]) * (n2 - nArray[n7])) * 1.0 / (double)(n6 * n6));
                    d2 += this.p_min[n2][n7];
                }
                n7 = 0;
                while (n7 < n4) {
                    double[] dArray = this.p_min[n2];
                    int n8 = n7++;
                    dArray[n8] = dArray[n8] * ((1.0 - this.gob_prob - this.hole_prob) / d2);
                }
            }
            this.ncargo = 0;
            this.score = 0.0;
            this.cargo = new int[this.maxMineral - 65 + 1];
            this.xm = -1;
            this.ym = this.field[0].length / 2;
        }

        void start() {
            if (Mining.this.v != null) {
                Mining.this.v.err.setText("");
            }
            this.current = new Runner();
            this.current.start();
        }

        void stop() {
            this.running = false;
            if (this.current != null) {
                try {
                    if (this.current.pr != null) {
                        this.current.pr.destroy();
                        this.current.pr.waitFor();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.current = null;
            }
        }

        public int newSeed() {
            return this.r.nextInt();
        }

        public void setSeed(int n) {
            this.seed = n;
        }

        public int getSeed() {
            return this.seed;
        }

        public String getParameter(String string) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                return field.get(this).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "ERR";
            }
        }

        public void setParameter(String string, String string2) {
            try {
                Field field = this.getClass().getDeclaredField(string);
                field.set(this, Integer.parseInt(string2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public int getSlide() {
            return this.slide;
        }

        public void setSlide(int n) {
            this.slide = n;
        }

        public void setPause(int n) {
            this.ST = n;
        }

        public void addMessage(String string) {
            if (this.novis) {
                System.out.print(string);
            } else {
                Mining.this.v.addMessage(string);
            }
        }

        public void addFatalError(String string) {
            this.addMessage(string);
        }

        public boolean drop() {
            return this.drop;
        }

        public void setDrop(boolean bl) {
            this.drop = bl;
        }

        class Runner
        extends Thread {
            Process pr;
            BufferedReader input;
            InputStream error;
            DataOutputStream os;

            Runner() {
            }

            void write(String[] stringArray) throws IOException {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]).append('\n');
                }
                this.os.write(stringBuffer.toString().getBytes());
                this.os.flush();
            }

            void init() throws IOException {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Mining.this.c.fuelTank).append('\n');
                stringBuffer.append(Mining.this.c.cargoBay).append('\n');
                stringBuffer.append(Mining.this.c.maxMineral).append('\n');
                stringBuffer.append(Mining.this.c.costFactor).append('\n');
                this.os.write(stringBuffer.toString().getBytes());
                this.os.flush();
            }

            char move(String[] stringArray) throws IOException {
                this.write(stringArray);
                String string = this.input.readLine();
                if (string == null || string.length() == 0) {
                    return '\u0000';
                }
                return string.charAt(0);
            }

            public void run() {
                this.runTest();
                this.pr.destroy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runTest() {
                Controller.this.running = true;
                try {
                    Object object = runlock;
                    synchronized (object) {
                        this.pr = Runtime.getRuntime().exec(Mining.this.getProcess());
                        this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
                        this.error = this.pr.getErrorStream();
                        this.os = new DataOutputStream(this.pr.getOutputStream());
                        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                            public void run() {
                                Runner.this.pr.destroy();
                            }
                        }));
                        Thread thread = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    int n;
                                    byte[] byArray = new byte[50000];
                                    while ((n = Runner.this.error.read(byArray)) > 0 && Controller.this.running) {
                                        Controller.this.addMessage(new String(byArray, 0, n));
                                    }
                                    Controller.this.addMessage("\n");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        thread.start();
                        boolean bl = false;
                        this.init();
                        while (Controller.this.fuelTank > 0) {
                            String[] stringArray = Controller.this.getPic(Controller.this.xm, Controller.this.ym);
                            char c = this.move(stringArray);
                            if (c == 'X' || c == '\u0000') {
                                Controller.this.addMessage("Simulation over\n");
                                break;
                            }
                            int n = 0;
                            int n2 = 0;
                            if (c == 'D') {
                                n = 1;
                                n2 = 0;
                            }
                            if (c == 'U') {
                                n = -1;
                                n2 = 0;
                            }
                            if (c == 'L') {
                                n = 0;
                                n2 = -1;
                            }
                            if (c == 'R') {
                                n = 0;
                                n2 = 1;
                            }
                            if (n == 0 && n2 == 0) {
                                Controller.this.addMessage("unexpected return\n");
                                break;
                            }
                            int n3 = Controller.this.fuelToMove(Controller.this.xm, Controller.this.ym, n, n2);
                            if (n3 < 1) {
                                Controller.this.addMessage("illegal move\n");
                                break;
                            }
                            Controller.this.xm += n;
                            Controller.this.ym += n2;
                            Controller.this.addToCargo(Controller.this.charAt(Controller.this.xm, Controller.this.ym));
                            Controller.this.clearAt(Controller.this.xm, Controller.this.ym);
                            Controller.this.fuelTank -= n3;
                            if (Controller.this.xm == -1) {
                                Controller.this.score += Controller.this.addCargoToScore();
                            }
                            if (Controller.this.novis) continue;
                            Mining.this.v.sim.rebuffer();
                            Mining.this.v.repaintSim(true);
                            if (Controller.this.ST == 0) continue;
                            Thread.sleep(Controller.this.ST);
                        }
                        if (Controller.this.novis) {
                            Controller.this.addMessage("Score = " + Controller.this.score + "\n");
                        }
                    }
                }
                catch (IOException iOException) {
                    Controller.this.addMessage("Simulation over because communication between the visualizer and your process ended.\n");
                    Controller.this.addMessage(iOException.getMessage() + "\n");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

