/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Random;
import java.util.Scanner;

public class Deanonymize {
    int N;
    int M;
    int C;
    int U;
    int Q;
    double SD;
    double[][] means;
    double[][] sds;
    double[][] data;
    double[][] perturbed;
    Random r = new Random(1L);
    static Process proc;
    static InputStream is;
    static OutputStream os;

    public void generate(int n) {
        try {
            int n2;
            int n3;
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(n);
            this.N = (int)Math.pow(100.0, this.r.nextDouble());
            this.M = (int)Math.pow(100.0, this.r.nextDouble());
            this.U = 100 + (int)Math.pow(100000.0, this.r.nextDouble());
            this.C = (int)Math.pow(1000.0, this.r.nextDouble());
            this.Q = this.U / 10;
            this.SD = Math.min(0.5, Math.pow(this.U, -1.0 / (double)this.N)) * (this.r.nextDouble() + 0.5);
            this.means = new double[this.C][this.N + this.M];
            this.sds = new double[this.C][this.N + this.M];
            this.data = new double[this.U][this.N + this.M];
            this.perturbed = new double[this.U][this.N + this.M];
            for (n3 = 0; n3 < this.C; ++n3) {
                for (n2 = 0; n2 < this.N + this.M; ++n2) {
                    this.means[n3][n2] = this.r.nextDouble() * 2.0 - 1.0;
                    this.sds[n3][n2] = this.r.nextDouble();
                }
            }
            for (n3 = 0; n3 < this.U; ++n3) {
                n2 = this.r.nextInt(this.C);
                for (int i = 0; i < this.N + this.M; ++i) {
                    this.data[n3][i] = this.r.nextGaussian() * this.sds[n2][i] + this.means[n2][i];
                    this.perturbed[n3][i] = this.data[n3][i] + this.r.nextGaussian() * this.SD;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double[] deanonymize(int n, int n2, double[] dArray, double[] dArray2, double d) throws IOException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer((dArray.length + dArray2.length) * 18);
        stringBuffer.append(n).append('\n');
        stringBuffer.append(n2).append('\n');
        stringBuffer.append(dArray[0]);
        for (n3 = 1; n3 < dArray.length; ++n3) {
            stringBuffer.append(' ').append(dArray[n3]);
        }
        stringBuffer.append('\n');
        stringBuffer.append(dArray2[0]);
        for (n3 = 1; n3 < dArray2.length; ++n3) {
            stringBuffer.append(' ').append(dArray2[n3]);
        }
        stringBuffer.append('\n');
        stringBuffer.append(d).append('\n');
        os.write(stringBuffer.toString().getBytes());
        os.flush();
        Scanner scanner = new Scanner(is);
        double[] dArray3 = new double[this.Q * n2];
        for (int i = 0; i < this.Q * n2; ++i) {
            dArray3[i] = scanner.nextDouble();
        }
        return dArray3;
    }

    public void output(int n) throws IOException {
        double d;
        int n2;
        int n3;
        this.generate(n);
        double[] dArray = new double[this.U * (this.N + this.M)];
        double[] dArray2 = new double[this.Q * this.N];
        double[] dArray3 = new double[this.Q * this.M];
        double[] dArray4 = new double[this.Q * this.M];
        boolean[] blArray = new boolean[this.U];
        int[] nArray = new int[this.Q];
        for (n3 = 0; n3 < dArray.length; ++n3) {
            dArray[n3] = this.perturbed[n3 / (this.N + this.M)][n3 % (this.N + this.M)];
        }
        for (n3 = 0; n3 < this.Q; ++n3) {
            int n4;
            int n5 = this.r.nextInt(this.U);
            if (blArray[n5]) {
                --n3;
                continue;
            }
            blArray[n5] = true;
            nArray[n3] = n5;
            for (n4 = 0; n4 < this.N; ++n4) {
                dArray2[n3 * this.N + n4] = this.data[n5][n4];
            }
            for (n4 = 0; n4 < this.M; ++n4) {
                dArray3[n3 * this.M + n4] = this.data[n5][this.N + n4];
                dArray4[n3 * this.M + n4] = this.perturbed[n5][this.N + n4];
            }
        }
        double[] dArray5 = this.deanonymize(this.N, this.M, dArray, dArray2, this.SD);
        if (dArray5 == null) {
            return;
        }
        if (dArray5.length != dArray3.length) {
            System.err.println("Wrong number of elements in return.");
            return;
        }
        double[] dArray6 = new double[dArray3.length];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.sqrt(Math.PI * 2);
        for (n2 = 0; n2 < this.Q; ++n2) {
            int n6;
            d = 0.0;
            for (n6 = 0; n6 < this.C; ++n6) {
                int n7;
                double d6 = 1.0;
                for (n7 = 0; n7 < this.N; ++n7) {
                    double d7 = (dArray2[n2 * this.N + n7] - this.means[n6][n7]) / this.sds[n6][n7];
                    d6 *= 1.0 / this.sds[n6][n7] / d5 * Math.exp(-d7 * d7 / 2.0);
                }
                d += d6;
                for (n7 = 0; n7 < this.M; ++n7) {
                    int n8 = n2 * this.M + n7;
                    dArray6[n8] = dArray6[n8] + d6 * this.means[n6][this.N + n7];
                }
            }
            for (n6 = 0; n6 < this.M; ++n6) {
                int n9 = n2 * this.M + n6;
                dArray6[n9] = dArray6[n9] / d;
            }
        }
        for (n2 = 0; n2 < dArray5.length; ++n2) {
            d = dArray5[n2] - dArray3[n2];
            d2 += d * d;
            d = dArray6[n2] - dArray3[n2];
            d3 += d * d;
            d = dArray4[n2] - dArray3[n2];
            d4 += d * d;
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            System.err.println("NaN of Infinity in return.");
            return;
        }
        System.err.println("Baseline Error: " + (d3 /= (double)dArray5.length));
        System.err.println("Your Error: " + (d2 /= (double)dArray5.length));
        System.err.println("Error when using permuated private values: " + (d4 /= (double)dArray5.length));
        System.err.println("Score: " + Math.max(0.0, d3 - d2));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: java -jar Deanonymize.jar \"command\" seed");
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            proc = runtime.exec(stringArray[0]);
            os = proc.getOutputStream();
            is = proc.getInputStream();
            new ErrorReader(proc.getErrorStream()).start();
            new Deanonymize().output(Integer.parseInt(stringArray[1]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

