/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CrystalLightingVis {
    static char[] types = new char[]{'1', '2', '4', '\\', '/', 'X'};
    static int minS = 10;
    static int maxS = 100;
    static int minLanternCost = 1;
    static int maxLanternCost = 10;
    static int minMirrorCost = 3;
    static int maxMirrorCost = 30;
    static int minObstacleCost = 2;
    static int maxObstacleCost = 20;
    static final int invalidScore = -1000000;
    int H;
    int W;
    int costLantern;
    int costMirror;
    int costObstacle;
    int maxMirrors;
    int maxObstacles;
    int numCrystals;
    int numCorrectPrimary;
    int numCorrectSecondary;
    int numIncorrect;
    volatile char[][] targetBoard;
    volatile List<Item> addedItems;
    volatile List<Ray> rays;
    volatile char[][] resultBoard;
    static String seed;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static boolean manual;
    static boolean debug;
    static boolean plain;
    static boolean mark;
    static boolean showRays;
    static boolean save;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    volatile boolean manualReady;
    int[] lightColor = new int[]{0xFFFFFF, 26367, 0xF0F000, 0x33FF33, 0xFF4D4D, 0xE600E6, 16756017, 0x663300};
    int[] targetColor = new int[]{0xFFFFFF, 204, 0xE0E000, 60928, 0xEE0000, 0xAA00AA, 0xFF9900, 0x663300};

    boolean isInside(int n, int n2) {
        return n >= 0 && n < this.H && n2 >= 0 && n2 < this.W;
    }

    int getTypeIdx(char c) {
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != c) continue;
            return i;
        }
        return -1;
    }

    String generate(String string) {
        try {
            int n;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.H = secureRandom.nextInt(maxS - minS + 1) + minS;
            this.W = secureRandom.nextInt(maxS - minS + 1) + minS;
            if (l == 1L) {
                this.W = this.H = minS;
            } else if (l == 2L) {
                this.W = this.H = (minS + maxS) / 2;
            } else if (l == 3L) {
                this.W = this.H = maxS;
            }
            int n2 = secureRandom.nextInt(11) + 5;
            int n3 = secureRandom.nextInt(11) + 15;
            this.targetBoard = new char[this.H][this.W];
            this.numCrystals = 0;
            for (int i = 0; i < this.H; ++i) {
                for (n = 0; n < this.W; ++n) {
                    int n4 = secureRandom.nextInt(100);
                    char c = n4 < n3 ? (char)(secureRandom.nextInt(6) + 1 + 48) : (char)(this.targetBoard[i][n] = (char)(n4 < n3 + n2 ? 88 : 46));
                    if (n4 >= n3) continue;
                    ++this.numCrystals;
                }
            }
            this.costLantern = secureRandom.nextInt(maxLanternCost - minLanternCost + 1) + minLanternCost;
            this.costMirror = secureRandom.nextInt(maxMirrorCost - minMirrorCost + 1) + minMirrorCost;
            this.costObstacle = secureRandom.nextInt(maxObstacleCost - minObstacleCost + 1) + minObstacleCost;
            this.maxMirrors = secureRandom.nextInt(this.numCrystals / 8 + 1);
            this.maxObstacles = secureRandom.nextInt(this.numCrystals / 16 + 1);
            if (l == 1L) {
                this.maxObstacles = 3;
                this.maxMirrors = 3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("H = ").append(this.H).append('\n');
            stringBuffer.append("W = ").append(this.W).append('\n');
            stringBuffer.append("Probability of a crystal = ").append(n3).append('\n');
            stringBuffer.append("Probability of an obstacle = ").append(n2).append('\n');
            stringBuffer.append("Lantern cost = ").append(this.costLantern).append('\n');
            stringBuffer.append("Mirror cost = ").append(this.costMirror).append('\n');
            stringBuffer.append("Obstacle cost = ").append(this.costObstacle).append('\n');
            stringBuffer.append("Max mirrors = ").append(this.maxMirrors).append('\n');
            stringBuffer.append("Max obstacles = ").append(this.maxObstacles).append('\n');
            for (n = 0; n < this.H; ++n) {
                stringBuffer.append(new String(this.targetBoard[n])).append('\n');
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
            return "";
        }
    }

    void calculateLighting() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < this.H; ++n5) {
            for (int i = 0; i < this.W; ++i) {
                this.resultBoard[n5][i] = this.targetBoard[n5][i] == '.' || this.targetBoard[n5][i] == 'X' ? this.targetBoard[n5][i] : 48;
            }
        }
        this.rays.clear();
        for (n5 = 0; n5 < this.addedItems.size(); ++n5) {
            Item item = this.addedItems.get(n5);
            this.resultBoard[item.r][item.c] = item.type;
            if (!item.isLantern()) continue;
            item.valid = true;
            for (n4 = 0; n4 < 4; ++n4) {
                n3 = n4 == 0 ? 1 : (n4 == 1 ? -1 : 0);
                n2 = item.r + n3;
                n = n4 == 2 ? 1 : (n4 == 3 ? -1 : 0);
                int n6 = item.c + n;
                this.rays.add(new Ray(item.r, item.c, n2, n6, n3, n, item));
            }
        }
        n5 = 0;
        while (n5 < this.rays.size()) {
            Ray ray = this.rays.get(n5++);
            if (!this.isInside(ray.r1, ray.c1)) continue;
            n4 = this.resultBoard[ray.r1][ray.c1];
            n3 = this.targetBoard[ray.r1][ray.c1];
            n2 = ray.dr;
            n = ray.dc;
            if (n4 == 88) continue;
            if (n4 == 47) {
                n2 = -ray.dc;
                n = -ray.dr;
            } else if (n4 == 92) {
                n2 = ray.dc;
                n = ray.dr;
            } else {
                if (n3 != 46) {
                    this.resultBoard[ray.r1][ray.c1] = (char)((n4 - 48 | ray.source.type - 48) + 48);
                    continue;
                }
                if (n4 != 46 && n3 == 46) {
                    ray.source.valid = false;
                    continue;
                }
            }
            this.rays.add(new Ray(ray.r1, ray.c1, ray.r1 + n2, ray.c1 + n, n2, n, ray.source));
        }
    }

    String removeOneItem(int n, int n2) {
        if (!this.isInside(n, n2)) {
            return "You can only remove items from within the board.";
        }
        for (int i = 0; i < this.addedItems.size(); ++i) {
            Item item = this.addedItems.get(i);
            if (item.r != n || item.c != n2) continue;
            this.addedItems.remove(i);
            this.resultBoard[item.r][item.c] = 46;
            return "";
        }
        return "You can only remove items already placed on the board.";
    }

    String placeOneItem(int n, int n2, char c) {
        if (!this.isInside(n, n2)) {
            return "You can only place items within the board.";
        }
        if (this.getTypeIdx(c) < 0) {
            return "Invalid item type: " + c + ". You can only place lanterns of primary colors (1, 2 or 4), mirrors (\\ or /) or obstacles (X).";
        }
        if (this.targetBoard[n][n2] != '.') {
            return "You can only place items on empty cells of the board.";
        }
        if (this.resultBoard[n][n2] != '.') {
            return "You can not place two items on the same cell.";
        }
        this.resultBoard[n][n2] = c;
        if (c == 'X') {
            int n3 = 0;
            for (Item item : this.addedItems) {
                if (!item.isObstacle()) continue;
                ++n3;
            }
            if (n3 >= this.maxObstacles) {
                return "You can place at most " + this.maxObstacles + " obstacles.";
            }
        } else if (c == '/' || c == '\\') {
            int n4 = 0;
            for (Item item : this.addedItems) {
                if (!item.isMirror()) continue;
                ++n4;
            }
            if (n4 >= this.maxMirrors) {
                return "You can place at most " + this.maxMirrors + " mirrors.";
            }
        }
        this.addedItems.add(new Item(n, n2, c));
        return "";
    }

    double getScore() {
        for (Item item : this.addedItems) {
            if (!item.isLantern() || item.valid) continue;
            return -1000000.0;
        }
        this.numIncorrect = 0;
        this.numCorrectSecondary = 0;
        this.numCorrectPrimary = 0;
        double d = 0.0;
        for (int i = 0; i < this.H; ++i) {
            for (int j = 0; j < this.W; ++j) {
                char c = this.targetBoard[i][j];
                char c2 = this.resultBoard[i][j];
                if (c == 'X') continue;
                if (c == '.') {
                    if (c2 == '/' || c2 == '\\') {
                        d -= (double)this.costMirror;
                        continue;
                    }
                    if (c2 == 'X') {
                        d -= (double)this.costObstacle;
                        continue;
                    }
                    if (c2 != '1' && c2 != '2' && c2 != '4') continue;
                    d -= (double)this.costLantern;
                    continue;
                }
                if (c == c2) {
                    if (c == '1' || c == '2' || c == '4') {
                        d += 20.0;
                        ++this.numCorrectPrimary;
                        continue;
                    }
                    d += 30.0;
                    ++this.numCorrectSecondary;
                    continue;
                }
                if (c2 == '0') continue;
                d -= 10.0;
                ++this.numIncorrect;
            }
        }
        return d;
    }

    public double runTest(String string) {
        try {
            Object object;
            int n;
            int n2;
            String[] stringArray;
            String string2 = this.generate(string);
            if (debug) {
                System.out.println(string2);
            }
            this.addedItems = new ArrayList<Item>();
            this.rays = new ArrayList<Ray>();
            this.resultBoard = new char[this.H][this.W];
            this.calculateLighting();
            if (vis) {
                this.jf.setVisible(true);
                stringArray = this.jf.getInsets();
                n2 = stringArray.left + stringArray.right + 8;
                n = stringArray.top + stringArray.bottom + 8;
                object = Toolkit.getDefaultToolkit();
                Dimension dimension = ((Toolkit)object).getScreenSize();
                Insets insets = ((Toolkit)object).getScreenInsets(this.jf.getGraphicsConfiguration());
                dimension.width -= insets.left + insets.right;
                dimension.height -= insets.top + insets.bottom;
                if (SZ == 0) {
                    SZ = Math.min((dimension.width - n2 - 120) / this.W, (dimension.height - n) / this.H);
                    if (!plain && SZ < 20) {
                        plain = true;
                    }
                }
                Dimension dimension2 = this.v.getVisDimension();
                this.v.setPreferredSize(dimension2);
                this.jf.setSize(Math.min(dimension2.width + n2, dimension.width), Math.min(dimension2.height + n, dimension.height));
                this.manualReady = false;
                this.draw();
            }
            if (proc != null) {
                String[] stringArray2;
                stringArray = new String[this.H];
                for (n2 = 0; n2 < this.H; ++n2) {
                    stringArray[n2] = new String(this.targetBoard[n2]);
                }
                try {
                    stringArray2 = this.placeItems(stringArray, this.costLantern, this.costMirror, this.costObstacle, this.maxMirrors, this.maxObstacles);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from placeItems.");
                    return -1000000.0;
                }
                if (stringArray2 == null) {
                    this.addFatalError("Your return contained invalid number of elements.");
                    return -1000000.0;
                }
                if (stringArray2.length > this.W * this.H) {
                    this.addFatalError("Your return contained more than " + this.W * this.H + " elements.");
                    return -1000000.0;
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    int n3;
                    int n4;
                    object = stringArray2[n].split(" ");
                    if (((String[])object).length != 3) {
                        this.addFatalError("Item " + n + ": Each element of your return must be formatted as \"ROW COL TYPE\"");
                        return -1000000.0;
                    }
                    try {
                        n4 = Integer.parseInt(object[0]);
                        n3 = Integer.parseInt((String)object[1]);
                    }
                    catch (Exception exception) {
                        this.addFatalError("Item " + n + ": R and C in each element of your return must be integers.");
                        return -1000000.0;
                    }
                    if (((String)object[2]).length() != 1) {
                        this.addFatalError("Item " + n + ": Invalid item type: " + (String)object[2] + ". Item type must be a single character.");
                        return -1000000.0;
                    }
                    char c = ((String)object[2]).charAt(0);
                    String string3 = this.placeOneItem(n4, n3, c);
                    if (string3.equals("")) continue;
                    this.addFatalError("Item " + n + ": " + string3);
                    return -1000000.0;
                }
                this.calculateLighting();
                if (vis) {
                    this.draw();
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    object = this.addedItems.get(n);
                    if (!((Item)object).isLantern() || ((Item)object).valid) continue;
                    this.addFatalError("Item " + n + ": A lantern should not be illuminated by any light ray.");
                    return -1000000.0;
                }
            }
            if (manual) {
                this.addFatalError("Manual play on");
                while (!this.manualReady) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return this.getScore();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1000000.0;
        }
    }

    String[] placeItems(String[] stringArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.H).append("\n");
        for (n6 = 0; n6 < this.H; ++n6) {
            stringBuffer.append(stringArray[n6]).append("\n");
        }
        stringBuffer.append(n).append("\n");
        stringBuffer.append(n2).append("\n");
        stringBuffer.append(n3).append("\n");
        stringBuffer.append(n4).append("\n");
        stringBuffer.append(n5).append("\n");
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        n6 = Integer.parseInt(this.br.readLine());
        String[] stringArray2 = new String[n6];
        for (int i = 0; i < n6; ++i) {
            stringArray2[i] = this.br.readLine();
        }
        return stringArray2;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    public CrystalLightingVis(String string) {
        try {
            Object object;
            if (vis) {
                this.jf = new JFrame();
                this.jf.setTitle("Seed " + string);
                this.v = new Vis();
                object = new JScrollPane(this.v);
                this.jf.getContentPane().add((Component)object);
            }
            if (exec != null) {
                try {
                    object = Runtime.getRuntime();
                    proc = ((Runtime)object).exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        seed = "1";
        vis = true;
        manual = false;
        SZ = 0;
        plain = false;
        mark = false;
        showRays = false;
        save = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                seed = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
            }
            if (stringArray[i].equals("-plain")) {
                plain = true;
            }
            if (stringArray[i].equals("-mark")) {
                mark = true;
            }
            if (stringArray[i].equals("-rays")) {
                showRays = true;
            }
            if (!stringArray[i].equals("-save")) continue;
            save = true;
        }
        if (exec == null) {
            manual = true;
        }
        if (manual) {
            vis = true;
        }
        CrystalLightingVis crystalLightingVis = new CrystalLightingVis(seed);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            super.paint(graphics);
            Dimension dimension = this.getVisDimension();
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(0xDDDDDD));
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, CrystalLightingVis.this.W * SZ, CrystalLightingVis.this.H * SZ);
            graphics2D.setBackground(Color.WHITE);
            if (mark) {
                for (int i = 0; i < CrystalLightingVis.this.H; ++i) {
                    for (int j = 0; j < CrystalLightingVis.this.W; ++j) {
                        if (CrystalLightingVis.this.targetBoard[i][j] == '.' || CrystalLightingVis.this.targetBoard[i][j] == 'X') continue;
                        if (CrystalLightingVis.this.targetBoard[i][j] == CrystalLightingVis.this.resultBoard[i][j]) {
                            graphics2D.setColor(new Color(0xBBFFBB));
                            graphics2D.fillRect(j * SZ + 1, i * SZ + 1, SZ - 1, SZ - 1);
                            continue;
                        }
                        if (CrystalLightingVis.this.targetBoard[i][j] == CrystalLightingVis.this.resultBoard[i][j] || CrystalLightingVis.this.resultBoard[i][j] == '0') continue;
                        graphics2D.setColor(new Color(0xFFBBBB));
                        graphics2D.fillRect(j * SZ + 1, i * SZ + 1, SZ - 1, SZ - 1);
                    }
                }
            }
            graphics2D.setColor(Color.RED);
            for (Item item : CrystalLightingVis.this.addedItems) {
                if (!item.isLantern() || item.valid) continue;
                graphics2D.drawRect(item.c * SZ + 1, item.r * SZ + 1, SZ - 2, SZ - 2);
                if (SZ <= 15) continue;
                graphics2D.drawRect(item.c * SZ + 2, item.r * SZ + 2, SZ - 4, SZ - 4);
            }
            if (showRays) {
                if (SZ > 10) {
                    graphics2D.setStroke(new BasicStroke(2.0f));
                }
                for (Ray ray : CrystalLightingVis.this.rays) {
                    graphics2D.setColor(new Color(CrystalLightingVis.this.lightColor[ray.source.type - 48]));
                    graphics2D.drawLine(ray.c0 * SZ + SZ / 2, ray.r0 * SZ + SZ / 2, Math.min(CrystalLightingVis.this.W * SZ, ray.c1 * SZ + SZ / 2), Math.min(CrystalLightingVis.this.H * SZ, ray.r1 * SZ + SZ / 2));
                }
            }
            for (n4 = 0; n4 < CrystalLightingVis.this.H; ++n4) {
                for (int i = 0; i < CrystalLightingVis.this.W; ++i) {
                    if (CrystalLightingVis.this.targetBoard[n4][i] == '.' || CrystalLightingVis.this.targetBoard[n4][i] == 'X' || CrystalLightingVis.this.resultBoard[n4][i] == '.') continue;
                    n3 = n4 * SZ + SZ / 2;
                    n2 = i * SZ + SZ / 2;
                    graphics2D.setColor(new Color(CrystalLightingVis.this.lightColor[CrystalLightingVis.this.resultBoard[n4][i] - 48]));
                    graphics2D.fillPolygon(new int[]{n2 - SZ / 3, n2, n2 + SZ / 3, n2 + SZ / 6, n2 - SZ / 6, n2 - SZ / 3}, new int[]{n3, n3 + SZ / 3, n3, n3 - SZ / 6, n3 - SZ / 6, n3}, 5);
                }
            }
            if (SZ > 10) {
                graphics2D.setStroke(new BasicStroke(1.5f));
            }
            for (n4 = 0; n4 < CrystalLightingVis.this.addedItems.size(); ++n4) {
                Item item = CrystalLightingVis.this.addedItems.get(n4);
                if (item.isLantern()) {
                    n3 = item.r * SZ + SZ / 2;
                    n2 = item.c * SZ + SZ / 2;
                    n = (int)((double)SZ / 1.0 / 4.0);
                    graphics2D.setColor(new Color(CrystalLightingVis.this.targetColor[item.getColor()]));
                    graphics2D.drawLine(n2 - SZ / 3, n3, n2 + SZ / 3, n3);
                    graphics2D.drawLine(n2, n3 - SZ / 3, n2, n3 + SZ / 3);
                    graphics2D.drawLine(n2 - n, n3 - n, n2 + n, n3 + n);
                    graphics2D.drawLine(n2 - n, n3 + n, n2 + n, n3 - n);
                    graphics2D.drawOval(n2 - SZ / 6, n3 - SZ / 6, SZ / 3, SZ / 3);
                    graphics2D.setColor(new Color(CrystalLightingVis.this.lightColor[item.getColor()]));
                    graphics2D.fillOval(n2 - SZ / 6, n3 - SZ / 6, SZ / 3, SZ / 3);
                    continue;
                }
                graphics2D.setColor(Color.DARK_GRAY);
                if (item.type == 'X') {
                    graphics2D.clearRect(item.c * SZ + SZ / 3, item.r * SZ + SZ / 3, SZ / 3, SZ / 3);
                    graphics2D.drawRect(item.c * SZ + SZ / 3, item.r * SZ + SZ / 3, SZ / 3, SZ / 3);
                    graphics2D.drawLine(item.c * SZ + SZ / 3, item.r * SZ + SZ / 3, item.c * SZ + 2 * SZ / 3, item.r * SZ + 2 * SZ / 3);
                    graphics2D.drawLine(item.c * SZ + 2 * SZ / 3, item.r * SZ + SZ / 3, item.c * SZ + SZ / 3, item.r * SZ + 2 * SZ / 3);
                    continue;
                }
                if (item.type == '\\') {
                    graphics2D.drawLine(item.c * SZ, item.r * SZ, (item.c + 1) * SZ, (item.r + 1) * SZ);
                    continue;
                }
                if (item.type != '/') continue;
                graphics2D.drawLine(item.c * SZ, (item.r + 1) * SZ, (item.c + 1) * SZ, item.r * SZ);
            }
            for (n4 = 0; n4 < CrystalLightingVis.this.H; ++n4) {
                for (int i = 0; i < CrystalLightingVis.this.W; ++i) {
                    if (CrystalLightingVis.this.targetBoard[n4][i] == '.') continue;
                    if (CrystalLightingVis.this.targetBoard[n4][i] == 'X') {
                        graphics2D.setColor(Color.DARK_GRAY);
                        graphics2D.fillRect(i * SZ + 1, n4 * SZ + 1, SZ - 1, SZ - 1);
                        continue;
                    }
                    n3 = n4 * SZ + SZ / 2;
                    n2 = i * SZ + SZ / 2;
                    graphics2D.setColor(new Color(CrystalLightingVis.this.targetColor[CrystalLightingVis.this.targetBoard[n4][i] - 48]));
                    graphics2D.drawPolyline(new int[]{n2 - SZ / 3, n2, n2 + SZ / 3, n2 + SZ / 6, n2 - SZ / 6, n2 - SZ / 3}, new int[]{n3, n3 + SZ / 3, n3, n3 - SZ / 6, n3 - SZ / 6, n3}, 6);
                    if (plain) continue;
                    graphics2D.drawPolyline(new int[]{n2 - SZ / 3, n2 + SZ / 3}, new int[]{n3, n3}, 2);
                    graphics2D.drawPolyline(new int[]{n2 + SZ / 6, n2, n2 - SZ / 6, n2, n2 + SZ / 6}, new int[]{n3, n3 + SZ / 3, n3, n3 - SZ / 6, n3}, 5);
                }
            }
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.BLACK);
            for (n4 = 0; n4 <= CrystalLightingVis.this.H; ++n4) {
                graphics2D.drawLine(0, n4 * SZ, CrystalLightingVis.this.W * SZ, n4 * SZ);
            }
            for (n4 = 0; n4 <= CrystalLightingVis.this.W; ++n4) {
                graphics2D.drawLine(n4 * SZ, 0, n4 * SZ, CrystalLightingVis.this.H * SZ);
            }
            graphics2D.setFont(new Font("Arial", 1, 13));
            n4 = SZ * CrystalLightingVis.this.W + 10;
            int n5 = 100;
            n3 = 10;
            n2 = 30;
            n = 20;
            int n6 = 10;
            if (CrystalLightingVis.this.manualReady) {
                graphics2D.clearRect(n4, n3, n5, n2);
            }
            this.drawString(graphics2D, "READY", n4, n3, n5, n2, 0);
            graphics2D.drawRect(n4, n3, n5, n2);
            n3 += n2 + n6;
            if (plain) {
                graphics2D.clearRect(n4, n3, n5, n2);
            }
            this.drawString(graphics2D, "PLAIN", n4, n3, n5, n2, 0);
            graphics2D.drawRect(n4, n3, n5, n2);
            n3 += n2 + n6;
            if (mark) {
                graphics2D.clearRect(n4, n3, n5, n2);
            }
            this.drawString(graphics2D, "MARK", n4, n3, n5, n2, 0);
            graphics2D.drawRect(n4, n3, n5, n2);
            n3 += n2 + n6;
            if (showRays) {
                graphics2D.clearRect(n4, n3, n5, n2);
            }
            this.drawString(graphics2D, "RAYS", n4, n3, n5, n2, 0);
            graphics2D.drawRect(n4, n3, n5, n2);
            this.drawString(graphics2D, "SCORE", n4, n3 += n2 + n6, n5, n, 0);
            this.drawString(graphics2D, String.format("%d", (int)CrystalLightingVis.this.getScore()), n4, n3 += n, n5, n, 0);
            this.drawString(graphics2D, "COSTS", n4, n3 += n * 2, n5, n, 0);
            this.drawString(graphics2D, "Lantern:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(CrystalLightingVis.this.costLantern), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "Mirror:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(CrystalLightingVis.this.costMirror), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "Obstacle:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(CrystalLightingVis.this.costObstacle), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            n3 += n * 2;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (Item item : CrystalLightingVis.this.addedItems) {
                if (item.isLantern()) {
                    ++n7;
                    if (item.valid) continue;
                    ++n10;
                    continue;
                }
                if (item.isMirror()) {
                    ++n8;
                    continue;
                }
                if (!item.isObstacle()) continue;
                ++n9;
            }
            this.drawString(graphics2D, "ADDED ITEMS", n4, n3, n5, n, 0);
            this.drawString(graphics2D, "Lanterns:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(n7), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "Invalid:", n4, n3 += n, n5 * 2 / 3, n, 1);
            if (n10 > 0) {
                graphics2D.setColor(Color.RED);
            }
            this.drawString(graphics2D, String.valueOf(n10), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            graphics2D.setColor(Color.BLACK);
            this.drawString(graphics2D, "Mirrors:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, n8 + "/" + CrystalLightingVis.this.maxMirrors, n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "Obstacles:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, n9 + "/" + CrystalLightingVis.this.maxObstacles, n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "CRYSTALS", n4, n3 += n * 2, n5, n, 0);
            this.drawString(graphics2D, "Total:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(CrystalLightingVis.this.numCrystals), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "Prim.OK:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(CrystalLightingVis.this.numCorrectPrimary), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "Sec.OK:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(CrystalLightingVis.this.numCorrectSecondary), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            this.drawString(graphics2D, "Incorrect:", n4, n3 += n, n5 * 2 / 3, n, 1);
            this.drawString(graphics2D, String.valueOf(CrystalLightingVis.this.numIncorrect), n4 + n5 * 2 / 3 + 2, n3, n5 / 3, n, -1);
            if (save) {
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", new File(seed + ".png"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            graphics.drawImage(bufferedImage, 0, 0, null);
        }

        void drawString(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4, int n5) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            int n6 = (int)rectangle2D.getHeight();
            int n7 = (int)rectangle2D.getWidth();
            if (n5 == 0) {
                n += (n3 - n7) / 2;
            } else if (n5 > 0) {
                n = n + n3 - n7;
            }
            n2 = n2 + (n4 - n6) / 2 + fontMetrics.getAscent();
            graphics2D.drawString(string, n, n2);
        }

        public Vis() {
            this.addMouseListener(this);
            CrystalLightingVis.this.jf.addWindowListener(this);
        }

        public Dimension getVisDimension() {
            return new Dimension(CrystalLightingVis.this.W * SZ + 126, Math.max(CrystalLightingVis.this.H * SZ + 1, 550));
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            String string;
            int n;
            int n2 = mouseEvent.getX() - SZ * CrystalLightingVis.this.W - 10;
            int n3 = mouseEvent.getY() - 10;
            if (n2 >= 0 && n2 <= 100 && n3 >= 40 && n3 <= 70) {
                plain = !plain;
                this.repaint();
                return;
            }
            if (n2 >= 0 && n2 <= 100 && n3 >= 80 && n3 <= 110) {
                mark = !mark;
                this.repaint();
                return;
            }
            if (n2 >= 0 && n2 <= 100 && n3 >= 120 && n3 <= 150) {
                showRays = !showRays;
                this.repaint();
                return;
            }
            if (!manual || CrystalLightingVis.this.manualReady) {
                return;
            }
            if (n2 >= 0 && n2 <= 100 && n3 >= 0 && n3 <= 30) {
                CrystalLightingVis.this.manualReady = true;
                this.repaint();
                return;
            }
            int n4 = mouseEvent.getY() / SZ;
            if (!CrystalLightingVis.this.isInside(n4, n = mouseEvent.getX() / SZ)) {
                return;
            }
            if (CrystalLightingVis.this.targetBoard[n4][n] != '.' && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                CrystalLightingVis.this.addFatalError("You can only place lanterns on empty cells of the board.");
                return;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && !(string = CrystalLightingVis.this.removeOneItem(n4, n)).equals("")) {
                CrystalLightingVis.this.addFatalError(string);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                char c = '\u0000';
                for (int i = 0; i < CrystalLightingVis.this.addedItems.size(); ++i) {
                    Item item = CrystalLightingVis.this.addedItems.get(i);
                    if (item.r != n4 || item.c != n) continue;
                    int n5 = CrystalLightingVis.this.getTypeIdx(item.type);
                    int n6 = 0;
                    int n7 = 0;
                    for (Item item2 : CrystalLightingVis.this.addedItems) {
                        if (item2.isObstacle()) {
                            ++n6;
                            continue;
                        }
                        if (!item2.isMirror()) continue;
                        ++n7;
                    }
                    while ((c = types[++n5 % types.length]) == 'X' && n6 >= CrystalLightingVis.this.maxObstacles || (c == '\\' || c == '/') && item.type != '\\' && item.type != '/' && n7 >= CrystalLightingVis.this.maxMirrors) {
                    }
                }
                if (c != '\u0000') {
                    string = CrystalLightingVis.this.removeOneItem(n4, n);
                    if (!string.equals("")) {
                        CrystalLightingVis.this.addFatalError(string);
                        return;
                    }
                } else {
                    c = types[0];
                }
                if (!(string = CrystalLightingVis.this.placeOneItem(n4, n, c)).equals("")) {
                    CrystalLightingVis.this.addFatalError(string);
                    return;
                }
            }
            CrystalLightingVis.this.calculateLighting();
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

