/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ConnectedComponentVis {
    static int maxS = 500;
    static int minS = 50;
    static int maxM = 9;
    static int minM = -9;
    static int[] dr = new int[]{0, 1, 0, -1};
    static int[] dc = new int[]{-1, 0, 1, 0};
    int S;
    int[][] matrix;
    int[][] permuted;
    static String exec;
    static String fileName;
    static boolean vis;
    static boolean debug;
    static boolean show_original;
    static boolean save;
    static Process proc;
    JFrame jf;
    Vis v;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    int SZX;
    int SZY;
    static int SZ;
    boolean[][] maxComponent;

    String generate(String string) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.S = secureRandom.nextInt(maxS - minS + 1) + minS;
            if (l == 1L) {
                this.S = 10;
            } else if (l == 2L) {
                this.S = minS;
            } else if (l == 3L) {
                this.S = maxS;
            }
            this.SZX = this.S * SZ + (show_original ? this.S * SZ + 10 : 0);
            this.SZY = this.S * SZ;
            this.matrix = new int[this.S][this.S];
            int[][] nArray = new int[this.S][this.S];
            for (n5 = 0; n5 < this.S; ++n5) {
                for (n4 = 0; n4 < this.S; ++n4) {
                    nArray[n5][n4] = secureRandom.nextInt(2) == 0 ? 0 : secureRandom.nextInt(maxM - minM + 1) + minM;
                }
            }
            n5 = secureRandom.nextInt(this.S / 10);
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = secureRandom.nextInt(1 + this.S * n5);
                n2 = secureRandom.nextInt(this.S);
                n = secureRandom.nextInt(this.S);
                for (int i = 0; i < n3; ++i) {
                    nArray[n2][n] = secureRandom.nextInt(maxM - minM + 1) + minM;
                    int n6 = secureRandom.nextInt(4);
                    int n7 = n2 + dr[n6];
                    int n8 = n + dc[n6];
                    if (n7 < 0 || n8 < 0 || n7 >= this.S || n8 >= this.S) continue;
                    n2 = n7;
                    n = n8;
                }
            }
            int[] nArray2 = new int[this.S];
            for (n3 = 0; n3 < this.S; ++n3) {
                nArray2[n3] = n3;
            }
            for (n3 = 0; n3 < this.S - 1; ++n3) {
                n2 = secureRandom.nextInt(this.S - n3) + n3;
                n = nArray2[n3];
                nArray2[n3] = nArray2[n2];
                nArray2[n2] = n;
            }
            for (n3 = 0; n3 < this.S; ++n3) {
                for (n2 = 0; n2 < this.S; ++n2) {
                    this.matrix[n3][n2] = nArray[nArray2[n3]][nArray2[n2]];
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.S).append('\n');
            if (l < 3L) {
                for (n2 = 0; n2 < this.S; ++n2) {
                    for (n = 0; n < this.S; ++n) {
                        if (this.matrix[n2][n] >= 0) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(this.matrix[n2][n]).append(' ');
                    }
                    stringBuffer.append('\n');
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
            return "";
        }
    }

    public double runTest(String string) {
        try {
            int n;
            int[] nArray;
            int n2;
            String string2 = this.generate(string);
            if (debug) {
                System.out.println(string2);
            }
            int[] nArray2 = new int[this.S * this.S];
            for (int i = 0; i < this.S; ++i) {
                for (n2 = 0; n2 < this.S; ++n2) {
                    nArray2[i * this.S + n2] = this.matrix[i][n2];
                }
            }
            if (proc != null) {
                try {
                    nArray = this.permute(nArray2);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from permute.");
                    return 0.0;
                }
                if (nArray.length != this.S) {
                    this.addFatalError("Your return must contain " + this.S + " elements, and it contained " + nArray.length + ".");
                    return 0.0;
                }
                boolean[] blArray = new boolean[this.S];
                for (n = 0; n < this.S; ++n) {
                    if (nArray[n] < 0 || nArray[n] >= this.S) {
                        this.addFatalError("All elements of your return must be between 0 and " + (this.S - 1) + ", and your return contained " + nArray[n] + ".");
                        return 0.0;
                    }
                    if (blArray[nArray[n]]) {
                        this.addFatalError("All elements of your return must be unique, and your return contained " + nArray[n] + " twice.");
                        return 0.0;
                    }
                    blArray[nArray[n]] = true;
                }
            } else {
                nArray = new int[this.S];
                for (n2 = 0; n2 < this.S; ++n2) {
                    nArray[n2] = n2;
                }
            }
            this.permuted = new int[this.S][this.S];
            for (int i = 0; i < this.S; ++i) {
                for (n = 0; n < this.S; ++n) {
                    this.permuted[i][n] = this.matrix[nArray[i]][nArray[n]];
                }
            }
            int[][] nArray3 = new int[this.S][this.S];
            n = 0;
            double d = (double)(-this.S * this.S) * 10.0 * (double)this.S;
            for (int i = 0; i < this.S; ++i) {
                for (int j = 0; j < this.S; ++j) {
                    int n3;
                    if (this.permuted[i][j] == 0 || nArray3[i][j] > 0) continue;
                    int[] nArray4 = new int[this.S * this.S];
                    int[] nArray5 = new int[this.S * this.S];
                    int n4 = 0;
                    double d2 = 0.0;
                    nArray3[i][j] = ++n;
                    nArray4[n4] = i;
                    nArray5[n4] = j;
                    ++n4;
                    d2 += (double)this.permuted[i][j];
                    for (n3 = 0; n3 < n4; ++n3) {
                        for (int k = 0; k < 4; ++k) {
                            int n5 = nArray4[n3] + dr[k];
                            int n6 = nArray5[n3] + dc[k];
                            if (n5 < 0 || n6 < 0 || n5 >= this.S || n6 >= this.S || nArray3[n5][n6] != 0 || this.permuted[n5][n6] == 0) continue;
                            nArray3[n5][n6] = n;
                            nArray4[n4] = n5;
                            nArray5[n4] = n6;
                            ++n4;
                            d2 += (double)this.permuted[n5][n6];
                        }
                    }
                    if (debug) {
                        System.out.println("Component " + n + " of size " + n4 + " and sum " + d2);
                    }
                    if (!((d2 *= Math.sqrt(n4)) > d)) continue;
                    d = d2;
                    if (!vis) continue;
                    this.maxComponent = new boolean[this.S][this.S];
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.maxComponent[nArray4[n3]][nArray5[n3]] = true;
                    }
                }
            }
            if (vis) {
                this.jf.setSize(this.SZX + 10, this.SZY + 30);
                this.jf.setVisible(true);
                this.draw();
            }
            return Math.max(0.0, d);
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to process your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    int[] permute(int[] nArray) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray.length).append('\n');
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append(nArray[n]).append('\n');
        }
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        int n2 = Integer.parseInt(this.br.readLine());
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = Integer.parseInt(this.br.readLine());
        }
        return nArray2;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    int getColor(int n, boolean bl) {
        if (n == 0) {
            return 0xFFFFFF;
        }
        if (n > 0) {
            return (15 - n * 1) * (bl ? 4352 : 17);
        }
        return (15 + n * 1) * (bl ? 0x110000 : 0x111111);
    }

    public ConnectedComponentVis(String string) {
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        SZ = 5;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-vis")) {
                vis = true;
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-show-original")) {
                show_original = true;
            }
            if (!stringArray[i].equals("-save")) continue;
            save = true;
        }
        if (string.equals("1") && SZ < 10) {
            SZ = 10;
        }
        if (string.equals("1") && !show_original) {
            show_original = true;
        }
        if (save) {
            fileName = string;
            vis = true;
        }
        ConnectedComponentVis connectedComponentVis = new ConnectedComponentVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements WindowListener {
        @Override
        public void paint(Graphics graphics) {
            try {
                int n;
                int n2;
                BufferedImage bufferedImage = new BufferedImage(ConnectedComponentVis.this.SZX + 5, ConnectedComponentVis.this.SZY + 5, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(new Color(0xD3D3D3));
                graphics2D.fillRect(0, 0, ConnectedComponentVis.this.SZX + 10, ConnectedComponentVis.this.SZY + 10);
                int n3 = 0;
                if (show_original) {
                    for (n2 = 0; n2 < ConnectedComponentVis.this.S; ++n2) {
                        for (n = 0; n < ConnectedComponentVis.this.S; ++n) {
                            graphics2D.setColor(new Color(ConnectedComponentVis.this.getColor(ConnectedComponentVis.this.matrix[n2][n], false)));
                            graphics2D.fillRect(n * SZ + n3, n2 * SZ, SZ - 1, SZ - 1);
                        }
                    }
                    n3 = ConnectedComponentVis.this.S * SZ + 10;
                }
                for (n2 = 0; n2 < ConnectedComponentVis.this.S; ++n2) {
                    for (n = 0; n < ConnectedComponentVis.this.S; ++n) {
                        graphics2D.setColor(new Color(ConnectedComponentVis.this.getColor(ConnectedComponentVis.this.permuted[n2][n], ConnectedComponentVis.this.maxComponent[n2][n])));
                        graphics2D.fillRect(n * SZ + n3, n2 * SZ, SZ - 1, SZ - 1);
                    }
                }
                graphics2D.setColor(Color.BLACK);
                for (n2 = 0; n2 < ConnectedComponentVis.this.S; ++n2) {
                    for (n = 0; n < ConnectedComponentVis.this.S; ++n) {
                        if (!ConnectedComponentVis.this.maxComponent[n2][n]) continue;
                        for (int i = 0; i < 4; ++i) {
                            int n4 = n2 + dr[i];
                            int n5 = n + dc[i];
                            if (n4 >= 0 && n5 >= 0 && n4 != ConnectedComponentVis.this.S && n5 != ConnectedComponentVis.this.S && ConnectedComponentVis.this.maxComponent[n4][n5]) continue;
                            if (i == 0) {
                                graphics2D.drawLine(n * SZ + n3 - 1, n2 * SZ - 1, n * SZ + n3 - 1, (n2 + 1) * SZ - 1);
                            }
                            if (i == 1) {
                                graphics2D.drawLine(n * SZ + n3 - 1, (n2 + 1) * SZ - 1, (n + 1) * SZ + n3 - 1, (n2 + 1) * SZ - 1);
                            }
                            if (i == 2) {
                                graphics2D.drawLine((n + 1) * SZ + n3 - 1, n2 * SZ - 1, (n + 1) * SZ + n3 - 1, (n2 + 1) * SZ - 1);
                            }
                            if (i != 3) continue;
                            graphics2D.drawLine(n * SZ + n3 - 1, n2 * SZ - 1, (n + 1) * SZ + n3 - 1, n2 * SZ - 1);
                        }
                    }
                }
                graphics.drawImage(bufferedImage, 0, 0, ConnectedComponentVis.this.SZX + 10, ConnectedComponentVis.this.SZY + 10, null);
                if (save) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", new File(fileName + ".png"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Vis() {
            ConnectedComponentVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

