/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Runner {
    boolean paused = false;
    boolean running = false;
    Process pr;
    BufferedReader input;
    InputStream error;
    DataOutputStream os;
    Problem prob;
    Display dis;
    int pause;

    public Runner(Problem problem, Display display) {
        this.prob = problem;
        this.dis = display;
    }

    public void start(boolean bl) {
        this.running = true;
        this.paused = false;
        try {
            this.pr = Runtime.getRuntime().exec(Main.getProcess());
            this.input = new BufferedReader(new InputStreamReader(this.pr.getInputStream()));
            this.error = this.pr.getErrorStream();
            this.os = new DataOutputStream(this.pr.getOutputStream());
            new ErrorReader().start();
            if (bl) {
                new Stepper().start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void stop() {
        this.running = false;
        if (this.pr != null) {
            this.pr.destroy();
            this.pr = null;
        }
    }

    public synchronized void step() throws IOException {
    }

    public void pause() {
        if (this.paused) {
            this.paused = false;
            new Stepper().start();
        } else {
            this.paused = true;
        }
    }

    public void setPause(int n) {
        this.pause = n;
    }

    public class ErrorReader
    extends Thread {
        public void run() {
            try {
                int n;
                byte[] byArray = new byte[50000];
                while ((n = Runner.this.error.read(byArray)) > 0 && Runner.this.running) {
                    String string = new String(byArray, 0, n);
                    Main.addMessage(string);
                }
                Main.addMessage("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Stepper
    extends Thread {
        Stepper() {
        }

        public void run() {
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Runner.this.prob.N).append(' ').append(Runner.this.prob.M).append(' ');
                stringBuffer.append(Runner.this.prob.C).append(' ').append(Runner.this.prob.L).append(' ');
                stringBuffer.append(Runner.this.prob.S).append(' ').append(Runner.this.prob.P).append('\n');
                for (n = 0; n < Runner.this.prob.N; ++n) {
                    stringBuffer.append(Runner.this.prob.p[n]).append(' ');
                    stringBuffer.append(Runner.this.prob.w[n]).append(' ');
                    stringBuffer.append(Runner.this.prob.h[n]).append('\n');
                }
                for (n = 0; n < Runner.this.prob.M; ++n) {
                    stringBuffer.append(Runner.this.prob.edges[n]).append('\n');
                }
                Runner.this.os.write(stringBuffer.toString().getBytes());
                Runner.this.os.flush();
                String[] stringArray = new String[Runner.this.prob.N + Runner.this.prob.M];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = Runner.this.input.readLine();
                }
                Runner.this.prob.runTest(stringArray);
                if (!Main.novis) {
                    Runner.this.dis.repaintSim(false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

