/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Display
extends JPanel {
    BufferedImage bi;
    Problem p;
    int scale = 2;
    int offx = 0;
    int offy = 0;
    int initx;
    int inity;
    JPanel vis;
    DecimalFormat df = new DecimalFormat("0.000");

    public Display(Problem problem) {
        this.p = problem;
        JSlider jSlider = new JSlider(1, 0, 50, 2);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                Display.this.scale = jSlider.getValue();
                Display.this.vis.repaint();
            }
        });
        jSlider.setMajorTickSpacing(5);
        jSlider.setMinorTickSpacing(1);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.vis = new Vis();
        this.setLayout(new BorderLayout());
        this.vis.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Display.this.initx = mouseEvent.getX();
                Display.this.inity = mouseEvent.getY();
            }
        });
        this.vis.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() - Display.this.initx;
                int n2 = mouseEvent.getY() - Display.this.inity;
                Display.this.offx += n * Display.this.scale;
                Display.this.offy += n2 * Display.this.scale;
                Display.this.initx = mouseEvent.getX();
                Display.this.inity = mouseEvent.getY();
                Display.this.vis.repaint();
            }
        });
        this.add((Component)this.vis, "Center");
        this.add((Component)jSlider, "West");
    }

    private void rebuffer(boolean bl) {
        if (this.p.boxes == null) {
            return;
        }
        this.bi = new BufferedImage(1600, 1600, 1);
        Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
    }

    public void repaintSim(boolean bl) {
        this.bi = null;
        this.repaint();
    }

    public class Vis
    extends JPanel {
        public void paint(Graphics graphics) {
            Object object;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            Color[] colorArray = new Color[]{Color.blue, Color.green, Color.yellow, Color.gray, Color.cyan, Color.black, Color.white};
            if (Display.this.p.done) {
                int n;
                int n2;
                for (n2 = 0; n2 < 10; ++n2) {
                    for (n = 0; n < Display.this.p.boxes.length; ++n) {
                        if (Display.this.p.level[n] != n2) continue;
                        graphics.setColor(colorArray[Display.this.p.level[n]]);
                        graphics.fillRect(Display.this.offx + Display.this.scale * Display.this.p.boxes[n][0], Display.this.offy + Display.this.scale * Display.this.p.boxes[n][1], Display.this.scale * Display.this.p.boxes[n][2] - Display.this.scale * Display.this.p.boxes[n][0], Display.this.scale * Display.this.p.boxes[n][3] - Display.this.scale * Display.this.p.boxes[n][1]);
                    }
                }
                graphics.setColor(Color.red);
                for (n2 = 0; n2 < Display.this.p.segments.length; ++n2) {
                    for (n = 0; n < Display.this.p.segments[n2].length; n += 4) {
                        graphics.drawLine(Display.this.offx + Display.this.scale * Display.this.p.segments[n2][n], Display.this.offy + Display.this.scale * Display.this.p.segments[n2][n + 1], Display.this.offx + Display.this.scale * Display.this.p.segments[n2][n + 2], Display.this.offy + Display.this.scale * Display.this.p.segments[n2][n + 3]);
                    }
                }
            }
            Font font = new Font(graphics2D.getFont().getName(), 0, 20);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getAscent();
            if (Display.this.bi != null) {
                object = new AffineTransform();
                double d = (double)Math.min(this.getWidth(), this.getHeight()) / 1600.0;
                double d2 = ((double)this.getWidth() - (double)Display.this.bi.getWidth() * d) / 2.0 / d;
                double d3 = ((double)this.getHeight() - (double)Display.this.bi.getHeight() * d) / 2.0 / d;
                ((AffineTransform)object).scale(d, d);
                ((AffineTransform)object).translate(d2, d3);
                AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, 3);
                graphics2D.drawImage(Display.this.bi, affineTransformOp, 0, 0);
            }
            object = "";
            String string = "";
            int n3 = fontMetrics.stringWidth((String)object);
            graphics2D.setColor(Color.black);
            graphics2D.drawString((String)object, 0, n);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, 0, 2 * n);
        }
    }
}

