/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ColorCaptureVis {
    static int maxSize = 100;
    static int minSize = 10;
    static int maxColors = 16;
    static int minColors = 4;
    final int[] dr = new int[]{0, 1, 0, -1};
    final int[] dc = new int[]{-1, 0, 1, 0};
    int D;
    int C;
    int[][] map;
    int[][] control;
    int[] area;
    SecureRandom r1;
    int turnN;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static boolean manual;
    static boolean debug;
    static Process proc;
    static int del;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    static int W;
    static int H;
    static int TL;
    volatile boolean manualReady;
    volatile int manualMove;
    BufferedImage cache;
    Color[] colors;
    int[] cs = new int[]{16769792, 255, 16738304, 10927575, 0xFF0000, 13541986, 8482918, 32052, 16156318, 21386, 8329229, 9677312, 0xFF00FF, 7351909, 0xFFFFFF, 0};
    HashMap<Integer, Integer> colorMap;

    char getChar(int n) {
        return (char)(65 + n);
    }

    String[] getBoard() {
        String[] stringArray = new String[this.D];
        for (int i = 0; i < this.D; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < this.D; ++j) {
                stringBuffer.append(this.getChar(this.map[i][j]));
            }
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    void updateArea(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n == 0 ? this.map[0][0] : this.map[this.D - 1][this.D - 1];
        this.area[n] = 0;
        int[] nArray = new int[this.D * this.D];
        int[] nArray2 = new int[this.D * this.D];
        boolean[][] blArray = new boolean[this.D][this.D];
        int n7 = 0;
        for (n5 = 0; n5 < this.D; ++n5) {
            for (n4 = 0; n4 < this.D; ++n4) {
                if (this.control[n5][n4] != n) continue;
                blArray[n5][n4] = true;
                nArray[n7] = n5;
                nArray2[n7] = n4;
                ++n7;
                int n8 = n;
                this.area[n8] = this.area[n8] + 1;
            }
        }
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < 4; ++n4) {
                n3 = nArray[n5] + this.dr[n4];
                n2 = nArray2[n5] + this.dc[n4];
                if (n3 < 0 || n2 < 0 || n3 >= this.D || n2 >= this.D || blArray[n3][n2] || this.map[n3][n2] != n6) continue;
                this.control[n3][n2] = n;
                blArray[n3][n2] = true;
                nArray[n7] = n3;
                nArray2[n7] = n2;
                ++n7;
                int n9 = n;
                this.area[n9] = this.area[n9] + 1;
            }
        }
        blArray = new boolean[this.D][this.D];
        n7 = 0;
        for (n5 = 0; n5 < this.D; ++n5) {
            for (n4 = 0; n4 < this.D; ++n4) {
                if (this.control[n5][n4] != 1 - n) continue;
                blArray[n5][n4] = true;
                nArray[n7] = n5;
                nArray2[n7] = n4;
                ++n7;
            }
        }
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < 4; ++n4) {
                n3 = nArray[n5] + this.dr[n4];
                n2 = nArray2[n5] + this.dc[n4];
                if (n3 < 0 || n2 < 0 || n3 >= this.D || n2 >= this.D || blArray[n3][n2] || this.control[n3][n2] != -1) continue;
                blArray[n3][n2] = true;
                nArray[n7] = n3;
                nArray2[n7] = n2;
                ++n7;
            }
        }
        for (n5 = 0; n5 < this.D; ++n5) {
            for (n4 = 0; n4 < this.D; ++n4) {
                if (blArray[n5][n4] || this.control[n5][n4] != -1) continue;
                this.control[n5][n4] = n;
                this.map[n5][n4] = n6;
                int n10 = n;
                this.area[n10] = this.area[n10] + 1;
            }
        }
    }

    double getScore(int n) {
        return (double)this.area[n] * 1.0 / (double)(this.D * this.D);
    }

    boolean endGame() {
        return this.area[0] + this.area[1] == this.D * this.D || this.turnN == this.D * this.D + 1;
    }

    void generate(String string) {
        try {
            int n;
            this.r1 = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            this.r1.setSeed(l);
            this.D = this.r1.nextInt(maxSize - minSize + 1) + minSize;
            this.C = this.r1.nextInt(maxColors - minColors + 1) + minColors;
            if (l <= 3L) {
                this.D = minSize * (int)l;
                this.C = minColors + 2 * (int)(l - 1L);
            }
            if (l == 4L) {
                this.D = maxSize;
                this.C = maxColors;
            }
            this.map = new int[this.D][this.D];
            for (n = 0; n < this.D; ++n) {
                for (int i = 0; i < this.D; ++i) {
                    this.map[n][i] = this.r1.nextInt(this.C);
                }
            }
            while (this.map[this.D - 1][this.D - 1] == this.map[0][0]) {
                this.map[0][0] = this.r1.nextInt(this.C);
            }
            this.control = new int[this.D][this.D];
            for (n = 0; n < this.D; ++n) {
                Arrays.fill(this.control[n], -1);
            }
            this.control[0][0] = 0;
            this.control[this.D - 1][this.D - 1] = 1;
            this.area = new int[2];
            this.updateArea(0);
            this.updateArea(1);
            if (debug) {
                String[] stringArray;
                System.out.println("D = " + this.D);
                System.out.println("C = " + this.C);
                System.out.println("Starting board: ");
                for (String string2 : stringArray = this.getBoard()) {
                    System.out.println(string2);
                }
                System.out.println("Player 0 area = " + this.area[0]);
                System.out.println("Player 1 area = " + this.area[1]);
            }
            if (vis) {
                W = this.D * SZ + 40 + SZ * 4;
                H = this.D * SZ + 40;
            }
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while generating test case.");
            exception.printStackTrace();
        }
    }

    public double runTest(String string) {
        try {
            this.generate(string);
            if (vis) {
                this.jf.setSize(W, H);
                this.jf.setVisible(true);
                this.draw();
            }
            ColorCaptureAI colorCaptureAI = new ColorCaptureAI(this.r1.nextInt(), 1);
            this.turnN = 1;
            int n = TL * 1000;
            while (!this.endGame()) {
                int n2;
                String[] stringArray = this.getBoard();
                int n3 = (this.turnN - 1) % 2;
                long l = System.currentTimeMillis();
                int n4 = n2 = n3 == 0 ? this.makeTurn(stringArray, n) : colorCaptureAI.makeTurn(stringArray, n);
                if (n3 == 0 && !manual && (n -= (int)(System.currentTimeMillis() - l)) < 0) {
                    this.addFatalError("Turn #" + this.turnN + ": time limit exceeded.");
                    return 0.0;
                }
                if (n2 < 0 || n2 >= this.C) {
                    this.addFatalError("Turn #" + this.turnN + ": return is not a valid color: " + n2 + ".");
                    return 0.0;
                }
                if (n2 == this.map[0][0] || n2 == this.map[this.D - 1][this.D - 1]) {
                    this.addFatalError("Turn #" + this.turnN + ": return is the same as your previous color or opponent's color.");
                    return 0.0;
                }
                for (int i = 0; i < this.D; ++i) {
                    for (int j = 0; j < this.D; ++j) {
                        if (this.control[i][j] != n3) continue;
                        this.map[i][j] = n2;
                    }
                }
                this.updateArea(n3);
                if (vis) {
                    this.draw();
                }
                if (debug) {
                    System.out.println("Turn #" + this.turnN + ": player 0 = " + this.area[0] + ", player 1 = " + this.area[1]);
                }
                ++this.turnN;
            }
            System.out.println(this.turnN - 1 + " turns done.");
            System.out.println("Time left: " + n + " ms.");
            return this.getScore(0);
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    int makeTurn(String[] stringArray, int n) throws IOException {
        if (!manual && proc != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringArray.length).append("\n");
            for (String string : stringArray) {
                stringBuffer.append(string).append("\n");
            }
            stringBuffer.append(n).append("\n");
            this.os.write(stringBuffer.toString().getBytes());
            this.os.flush();
        }
        int n2 = -1;
        if (manual) {
            this.manualReady = false;
            while (!this.manualReady) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            n2 = this.manualMove;
        } else if (proc != null) {
            n2 = Integer.parseInt(this.br.readLine());
        }
        return n2;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
        try {
            Thread.sleep(del);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void GeneratePalette() {
        this.colors = new Color[this.C];
        this.colorMap = new HashMap();
        for (int i = 0; i < this.C; ++i) {
            this.colors[i] = new Color(this.cs[i]);
            this.colorMap.put(this.cs[i], i);
        }
    }

    public ColorCaptureVis(String string) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.v = new Vis();
                this.jf.getContentPane().add(this.v);
            }
            if (exec != null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    proc = runtime.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        manual = false;
        del = 100;
        SZ = 10;
        TL = 10;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-delay")) {
                del = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
            }
            if (!stringArray[i].equals("-timelimit")) continue;
            TL = Integer.parseInt(stringArray[++i]);
        }
        if (string.equals("1") || string.equals("2") || string.equals("3")) {
            SZ = 15;
        }
        if (exec == null) {
            manual = true;
        }
        if (manual) {
            vis = true;
        }
        ColorCaptureVis colorCaptureVis = new ColorCaptureVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener {
        @Override
        public void paint(Graphics graphics) {
            int n;
            if (ColorCaptureVis.this.colors == null) {
                ColorCaptureVis.this.GeneratePalette();
            }
            ColorCaptureVis.this.cache = new BufferedImage(W, H, 1);
            Graphics2D graphics2D = (Graphics2D)ColorCaptureVis.this.cache.getGraphics();
            graphics2D.setColor(new Color(0xDDDDDD));
            graphics2D.fillRect(0, 0, W, H);
            for (n = 0; n < ColorCaptureVis.this.D; ++n) {
                for (int i = 0; i < ColorCaptureVis.this.D; ++i) {
                    graphics2D.setColor(ColorCaptureVis.this.colors[ColorCaptureVis.this.map[n][i]]);
                    graphics2D.fillRect(i * SZ, n * SZ, SZ, SZ);
                }
            }
            if (manual) {
                for (n = 0; n < ColorCaptureVis.this.C; ++n) {
                    graphics2D.setColor(ColorCaptureVis.this.colors[n]);
                    graphics2D.fillRect((ColorCaptureVis.this.D + 1 + n / 4) * SZ, n % 4 * SZ, SZ, SZ);
                }
            }
            graphics.drawImage(ColorCaptureVis.this.cache, 0, 0, W, H, null);
        }

        public Vis() {
            this.addMouseListener(this);
            ColorCaptureVis.this.jf.addWindowListener(this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (!manual || ColorCaptureVis.this.manualReady) {
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = ColorCaptureVis.this.cache.getRGB(n2, n = mouseEvent.getY()) & 0xFFFFFF;
            if (ColorCaptureVis.this.colorMap.get(n3) != null) {
                ColorCaptureVis.this.manualMove = ColorCaptureVis.this.colorMap.get(n3);
                ColorCaptureVis.this.manualReady = true;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

