/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Visualizer
extends JFrame {
    Object moveLock = new Object();
    CollapsingMaze cm;
    static MazeVis mv;
    int delay;
    int[][] visited;
    int[][] prev;
    int curR;
    int curC;
    int zoom = 10;
    static Visualizer vis;

    public Visualizer(CollapsingMaze collapsingMaze, int n) {
        this.cm = collapsingMaze;
        this.delay = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doupdate() {
        block13: {
            if (this.visited == null) {
                this.visited = new int[this.cm.maze.length][this.cm.maze[0].length];
                this.prev = new int[this.cm.maze.length][this.cm.maze[0].length];
            }
            if (this.curR != this.cm.curR || this.curC != this.cm.curC) {
                int[] nArray = this.visited[this.cm.curR];
                int n = this.cm.curC;
                nArray[n] = nArray[n] + 1;
            }
            int n = vis.getWidth();
            int n2 = vis.getHeight();
            boolean bl = false;
            if (n < 200) {
                bl = true;
                n = 1000;
            }
            if (n2 < 100) {
                bl = true;
                n2 = 700;
            }
            if (n > this.visited[0].length * this.zoom + 20) {
                bl = true;
                n = this.visited[0].length * this.zoom + 20;
            }
            if (n2 > this.visited.length * this.zoom + 100) {
                bl = true;
                n2 = this.visited.length * this.zoom + 100;
            }
            if (bl) {
                vis.setSize(n, n2);
            }
            this.curR = this.cm.curR;
            this.curC = this.cm.curC;
            this.validate();
            this.repaint();
            try {
                if (this.delay > 0) {
                    Thread.sleep(this.delay);
                    break block13;
                }
                if (this.delay != -1) break block13;
                Object object = this.moveLock;
                synchronized (object) {
                    this.moveLock.wait();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        boolean bl = false;
        String string2 = "1";
        int n = 100;
        int n2 = 10;
        String string3 = null;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-delay")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-output")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-zoom")) {
                n2 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-H")) {
                n3 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-W")) {
                n4 = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (!stringArray[i].equals("-exit")) continue;
            bl2 = true;
        }
        if (n3 < 10 && n3 != 0) {
            n3 = 10;
        }
        if (n3 > 1000) {
            n3 = 1000;
        }
        if (n4 < 10 && n4 != 0) {
            n4 = 10;
        }
        if (n4 > 1000) {
            n4 = 1000;
        }
        CollapsingMaze collapsingMaze = new CollapsingMaze();
        collapsingMaze.W = n4;
        collapsingMaze.H = n3;
        if (string3 != null) {
            collapsingMaze.init(string2, false);
            object = new BufferedImage(collapsingMaze.W * n2, collapsingMaze.H * n2, 1);
            for (int i = 0; i < collapsingMaze.H; ++i) {
                for (int j = 0; j < collapsingMaze.W; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int n5 = i == collapsingMaze.curR && j == collapsingMaze.curC ? 255 : (collapsingMaze.maze[i][j] == 0 ? 0xFFFFFF : (collapsingMaze.maze[i][j] == 1 ? 16759296 : 0));
                            ((BufferedImage)object).setRGB(j * n2 + k, i * n2 + i2, n5);
                        }
                    }
                }
            }
            try {
                ImageIO.write((RenderedImage)object, "png", new File(string3));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
        if (!bl) {
            vis = new Visualizer(collapsingMaze, n);
        }
        object = new LongTest(string, string2, vis);
        if (!bl) {
            vis.addWindowListener(new WindowAdapter((LongTest)object){
                final /* synthetic */ LongTest val$lt;
                {
                    this.val$lt = longTest;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    if (this.val$lt.proc != null) {
                        this.val$lt.proc.destroy();
                    }
                    System.exit(0);
                }
            });
            vis.addKeyListener(new KeyAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void keyTyped(KeyEvent keyEvent) {
                    if (Visualizer.vis.delay == -1 && keyEvent.getKeyChar() == ' ') {
                        Object object = Visualizer.vis.moveLock;
                        synchronized (object) {
                            Visualizer.vis.moveLock.notify();
                        }
                    }
                }
            });
            mv = vis.new MazeVis();
            Visualizer.vis.zoom = n2;
            vis.getContentPane().add(mv);
            vis.setVisible(true);
        }
        collapsingMaze.runTest((LongTest)object);
        if (((LongTest)object).proc != null) {
            ((LongTest)object).proc.destroy();
        }
        if (!bl) {
            vis.doupdate();
        } else {
            System.exit(0);
        }
        if (bl2) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public class MazeVis
    extends JPanel {
        int left;
        int right;
        int top;
        int bottom;
        BufferedImage bi;

        public void paint(Graphics graphics) {
            int n;
            if (Visualizer.this.cm.maze == null) {
                return;
            }
            while (!Visualizer.this.cm.ready) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            int n2 = 100 / Visualizer.this.zoom;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Font font = new Font(graphics2D.getFont().getName(), 0, 20);
            graphics2D.setFont(font);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n3 = fontMetrics.getAscent();
            int n4 = this.getWidth();
            int n5 = this.getHeight() - n3 - 10;
            if (Visualizer.this.cm.curC - this.left < n2 && Visualizer.this.cm.curC > n2 || this.right - 1 - Visualizer.this.cm.curC < n2 && Visualizer.this.cm.curC < Visualizer.this.cm.W - n2 || Visualizer.this.cm.curR - this.top < n2 && Visualizer.this.cm.curR > n2 || this.bottom - 1 - Visualizer.this.cm.curR < n2 && Visualizer.this.cm.curR < Visualizer.this.cm.H - n2 || this.right == 0) {
                Visualizer.this.prev = new int[Visualizer.this.prev.length][Visualizer.this.prev[0].length];
                n = n4 / Visualizer.this.zoom;
                int n6 = n5 / Visualizer.this.zoom;
                this.left = Visualizer.this.cm.curC - n / 2;
                this.top = Visualizer.this.cm.curR - n6 / 2;
                if (this.left + n > Visualizer.this.cm.W) {
                    this.left = Visualizer.this.cm.W - n;
                }
                if (this.top + n6 > Visualizer.this.cm.H) {
                    this.top = Visualizer.this.cm.H - n6;
                }
                if (this.left < 0) {
                    this.left = 0;
                }
                if (this.top < 0) {
                    this.top = 0;
                }
                this.right = this.left + n;
                this.bottom = this.top + n6;
                if (this.right > Visualizer.this.cm.W) {
                    this.right = Visualizer.this.cm.W;
                }
                if (this.bottom > Visualizer.this.cm.H) {
                    this.bottom = Visualizer.this.cm.H;
                }
            }
            n = Visualizer.this.zoom;
            if (this.bi == null) {
                this.bi = new BufferedImage((this.right - this.left) * n, (this.bottom - this.top) * n, 1);
            }
            Graphics graphics2 = this.bi.getGraphics();
            Color color = new Color(255, 186, 0);
            for (int i = this.top; i < this.bottom; ++i) {
                for (int j = this.left; j < this.right; ++j) {
                    int n7;
                    if (Visualizer.this.cm.maze[i][j] == -1) {
                        if (Visualizer.this.prev[i][j] == 1) continue;
                        Visualizer.this.prev[i][j] = 1;
                        n7 = Visualizer.this.cm.drilled[i][j] * 256 / Visualizer.this.cm.T;
                        if (n7 >= 256) {
                            n7 = 255;
                        }
                        if (Visualizer.this.prev[i][j] == n7 + 1000) continue;
                        Visualizer.this.prev[i][j] = n7 + 1000;
                        graphics2.setColor(new Color(n7, n7, n7));
                    } else if (Visualizer.this.cm.maze[i][j] == -2) {
                        n7 = Visualizer.this.cm.drilled[i][j] * 256 / Visualizer.this.cm.T;
                        if (n7 >= 256) {
                            n7 = 255;
                        }
                        if (Visualizer.this.prev[i][j] == n7 + 10) continue;
                        Visualizer.this.prev[i][j] = n7 + 10;
                        graphics2.setColor(new Color(255, n7, n7));
                    } else if (i == Visualizer.this.cm.curR && j == Visualizer.this.cm.curC) {
                        if (Visualizer.this.prev[i][j] == 3) continue;
                        Visualizer.this.prev[i][j] = 3;
                        graphics2.setColor(Color.blue);
                    } else if (Visualizer.this.visited != null && Visualizer.this.visited[i][j] == 1) {
                        if (Visualizer.this.prev[i][j] == 4) continue;
                        Visualizer.this.prev[i][j] = 4;
                        graphics2.setColor(Color.green);
                    } else if (Visualizer.this.visited != null && Visualizer.this.visited[i][j] > 1) {
                        if (Visualizer.this.prev[i][j] == 5) continue;
                        Visualizer.this.prev[i][j] = 5;
                        graphics2.setColor(Color.green);
                    } else if (Visualizer.this.cm.maze[i][j] == 1) {
                        if (Visualizer.this.prev[i][j] == 6) continue;
                        Visualizer.this.prev[i][j] = 6;
                        graphics2.setColor(color);
                    } else {
                        if (Visualizer.this.prev[i][j] == 7) continue;
                        Visualizer.this.prev[i][j] = 7;
                        graphics2.setColor(Color.white);
                    }
                    graphics2.fillRect((j - this.left) * n, (i - this.top) * n, n, n);
                }
            }
            graphics2D.drawImage(this.bi, null, 0, n3 + 10);
            graphics.setColor(Color.gray);
            graphics.fillRect(0, 0, 300, n3 + 10);
            graphics.setColor(Color.black);
            graphics.drawString("Coins so far = " + Visualizer.this.cm.L + ", time = " + Visualizer.this.cm.time, 0, n3 + 5);
        }
    }
}

