/*
 * Decompiled with CFR 0.152.
 */
import java.security.SecureRandom;
import java.util.Random;

public class CollapsingMaze {
    int W;
    int H;
    int D;
    int T;
    double p;
    double q;
    double exp;
    int P;
    int[][] maze;
    boolean ready = false;
    int[][] drilled;
    boolean done;
    int[] dr = new int[]{-1, 0, 1, 0};
    int[] dc = new int[]{0, 1, 0, -1};
    Random rnd;
    int curR;
    int curC;
    int[] colR;
    int[] colC;
    int[][] sol;
    int[] openr;
    int[] openc;
    int openptr;
    int[] qr;
    int[] qc;
    int[] qd;
    int[] adjs;
    int[][] rsa;
    int[][] csa;
    int[][] trsa;
    int[][] tcsa;
    int[] ptrs;
    int L;
    int time;

    int adj(int n, int n2, int n3) {
        int n4 = 0;
        n3 = 1 << n3;
        for (int i = 0; i < 4; ++i) {
            int n5 = n + this.dr[i];
            int n6 = n2 + this.dc[i];
            if (n5 < 0 || n6 < 0 || n5 > this.H - 1 || n6 > this.W - 1 || this.maze[n5][n6] <= 0 || (this.maze[n5][n6] & n3) <= 0) continue;
            ++n4;
        }
        return n4;
    }

    void set(int n, int n2, int n3) {
        if (this.maze[n][n2] < 0) {
            this.maze[n][n2] = 0;
        }
        int[] nArray = this.maze[n];
        int n4 = n2;
        nArray[n4] = nArray[n4] | 1 << n3;
    }

    void dfs(int n, int n2, int n3) {
        int[] nArray = new int[this.W * this.H];
        int[] nArray2 = new int[this.W * this.H];
        nArray[0] = n;
        nArray2[0] = n2;
        int n4 = 1;
        int[] nArray3 = new int[4];
        this.set(n, n2, n3);
        this.done = false;
        while (n4 > 0) {
            int n5;
            int n6;
            int n7;
            n = nArray[--n4];
            n2 = nArray2[n4];
            if (n2 != 0 && this.adj(n, n2, n3) != 1) continue;
            this.set(n, n2, n3);
            for (n7 = 0; n7 < 4; ++n7) {
                nArray3[n7] = n7;
                n6 = this.rnd.nextInt(n7 + 1);
                n5 = nArray3[n6];
                nArray3[n6] = nArray3[n7];
                nArray3[n7] = n5;
            }
            for (n7 = 0; n7 < 4; ++n7) {
                int n8;
                n6 = nArray3[n7];
                n5 = n + this.dr[n6];
                int n9 = n2 + this.dc[n6];
                if (n5 <= 0 || n9 <= 0 || n5 >= this.H - 1 || n9 >= this.W - 1 && this.done || (n8 = this.adj(n5, n9, n3)) != 1) continue;
                if (n9 == this.W - 1) {
                    this.set(n5, n9, n3);
                    this.done = true;
                    continue;
                }
                nArray[n4] = n5;
                nArray2[n4] = n9;
                ++n4;
            }
        }
    }

    void collapseInit() {
        if (this.openr == null) {
            this.openr = new int[this.H * this.W];
            this.openc = new int[this.H * this.W];
            this.qr = new int[this.D * this.D * 4 + 1];
            this.qc = new int[this.D * this.D * 4 + 1];
            this.qd = new int[this.D * this.D * 4 + 1];
        }
    }

    int collapseTime() {
        int n;
        int n2;
        this.collapseInit();
        this.openptr = 0;
        for (n2 = 0; n2 < this.H; ++n2) {
            for (n = 0; n < this.W; ++n) {
                if (this.maze[n2][n] < 0) continue;
                this.openr[this.openptr] = n2;
                this.openc[this.openptr] = n;
                ++this.openptr;
            }
        }
        n2 = 0;
        n = 0;
        while (true) {
            int n3;
            int n4;
            int n5;
            if ((double)n2 > (double)this.openptr * 0.8) {
                n2 = 0;
                this.openptr = 0;
                for (n5 = 0; n5 < this.H; ++n5) {
                    for (n4 = 0; n4 < this.W; ++n4) {
                        if (this.maze[n5][n4] < 0) continue;
                        this.openr[this.openptr] = n5;
                        this.openc[this.openptr] = n4;
                        ++this.openptr;
                    }
                }
            }
            if (this.openptr == 0) {
                return n;
            }
            while (this.maze[n4 = this.openr[n5 = this.rnd.nextInt(this.openptr)]][n3 = this.openc[n5]] < 0) {
            }
            int n6 = this.rnd.nextInt(this.D + 1);
            int n7 = 0;
            int n8 = 1;
            this.qr[0] = n4;
            this.qc[0] = n3;
            this.qd[0] = 0;
            this.maze[n4][n3] = -2;
            ++n2;
            while (n7 < n8) {
                n4 = this.qr[n7];
                n3 = this.qc[n7];
                int n9 = this.qd[n7];
                ++n7;
                for (int i = 0; i < 4 && n9 < n6; ++i) {
                    int n10 = n4 + this.dr[i];
                    int n11 = n3 + this.dc[i];
                    if (n10 < 0 || n10 >= this.H || n11 < 0 || n11 >= this.W || this.maze[n10][n11] < 0) continue;
                    this.maze[n10][n11] = -2;
                    ++n2;
                    this.qr[n8] = n10;
                    this.qc[n8] = n11;
                    this.qd[n8] = n9 + 1;
                    ++n8;
                }
            }
            ++n;
        }
    }

    void collapse() {
        int n;
        int n2;
        int n3;
        this.collapseInit();
        this.openptr = 0;
        for (n3 = 0; n3 < this.H; ++n3) {
            for (n2 = 0; n2 < this.W; ++n2) {
                if (this.maze[n3][n2] < 0) continue;
                this.openr[this.openptr] = n3;
                this.openc[this.openptr] = n2;
                ++this.openptr;
            }
        }
        if (this.openptr == 0) {
            return;
        }
        n3 = this.rnd.nextInt(this.openptr);
        n2 = this.openr[n3];
        int n4 = this.openc[n3];
        int n5 = this.rnd.nextInt(this.D + 1);
        int n6 = 0;
        int n7 = 1;
        this.qr[0] = n2;
        this.qc[0] = n4;
        this.qd[0] = 0;
        this.maze[n2][n4] = -2;
        while (n6 < n7) {
            n2 = this.qr[n6];
            n4 = this.qc[n6];
            n = this.qd[n6];
            ++n6;
            for (int i = 0; i < 4 && n < n5; ++i) {
                int n8 = n2 + this.dr[i];
                int n9 = n4 + this.dc[i];
                if (n8 < 0 || n8 >= this.H || n9 < 0 || n9 >= this.W || this.maze[n8][n9] < 0) continue;
                this.maze[n8][n9] = -2;
                this.qr[n7] = n8;
                this.qc[n7] = n9;
                this.qd[n7] = n + 1;
                ++n7;
            }
        }
        this.colR = new int[n7];
        this.colC = new int[n7];
        for (n = 0; n < n7; ++n) {
            this.colR[n] = this.qr[n];
            this.colC[n] = this.qc[n];
        }
    }

    int pruneOne(int n) {
        int n2;
        int n3;
        int n4;
        int[] nArray = this.rsa[n];
        int[] nArray2 = this.csa[n];
        int[] nArray3 = this.trsa[n];
        int[] nArray4 = this.tcsa[n];
        int n5 = this.ptrs[n];
        if (nArray == null) {
            this.rsa[n] = new int[this.H * this.W];
            nArray = this.rsa[n];
            this.csa[n] = new int[this.H * this.W];
            nArray2 = this.csa[n];
            this.trsa[n] = new int[this.H * this.W];
            nArray3 = this.trsa[n];
            this.tcsa[n] = new int[this.H * this.W];
            nArray4 = this.tcsa[n];
            n4 = 1;
            while (n4 + 1 < this.H) {
                n3 = 1;
                while (n3 + 1 < this.W) {
                    nArray[n5] = n4;
                    nArray2[n5] = n3++;
                    ++n5;
                }
                ++n4;
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray[n4];
            n2 = nArray2[n4];
            if (this.maze[n3][n2] < 0) continue;
            this.adjs[n4] = this.adj(n3, n2, n);
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n6;
            int n7;
            if (this.adjs[n2] > 1 || this.maze[n7 = nArray[n2]][n6 = nArray2[n2]] < 0 || (this.maze[n7][n6] & 1 << n) <= 0) continue;
            int[] nArray5 = this.maze[n7];
            int n8 = n6;
            nArray5[n8] = nArray5[n8] & ~(1 << n);
            if (this.maze[n7][n6] == 0) {
                ++n3;
                this.maze[n7][n6] = -1;
            }
            for (int i = 0; i < 4; ++i) {
                int n9 = n7 + this.dr[i];
                int n10 = n6 + this.dc[i];
                if ((this.maze[n9][n10] & 1 << n) <= 0 || n9 < 1 || n9 + 1 >= this.H || n10 < 1 || n10 + 1 >= this.W) continue;
                nArray3[n4] = n9;
                nArray4[n4] = n10;
                ++n4;
            }
        }
        this.trsa[n] = nArray;
        this.rsa[n] = nArray3;
        this.tcsa[n] = nArray2;
        this.csa[n] = nArray4;
        this.ptrs[n] = n4;
        return n4 == 0 ? -1 : n3;
    }

    void prune(double d, int n) {
        int n2;
        int n3;
        this.adjs = new int[this.H * this.W];
        this.tcsa = new int[n][];
        this.rsa = new int[n][];
        this.csa = new int[n][];
        this.trsa = new int[n][];
        this.tcsa = new int[n][];
        this.ptrs = new int[n];
        int n4 = 0;
        for (n3 = 0; n3 < this.H; ++n3) {
            for (n2 = 0; n2 < this.W; ++n2) {
                if (this.maze[n3][n2] < 0) continue;
                ++n4;
            }
        }
        n3 = 0;
        while ((double)n4 > d * (double)this.W * (double)this.H) {
            n2 = 0;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n5 = this.pruneOne(i);
                if (n5 < 0) continue;
                n2 += n5;
                bl = true;
            }
            if (!bl) break;
            n4 -= n2;
        }
    }

    void reset() {
        for (int i = 0; i < this.H; ++i) {
            for (int j = 0; j < this.W; ++j) {
                this.maze[i][j] = -1;
            }
        }
    }

    public void init(String string, boolean bl) {
        int n;
        int n2;
        try {
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
            this.rnd.setSeed(Long.parseLong(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n3 = this.rnd.nextInt(901) + 100;
        int n4 = this.rnd.nextInt(901) + 100;
        if (this.W <= 0) {
            this.W = string.equals("1") ? 100 : n3;
        }
        if (this.H <= 0) {
            this.H = string.equals("1") ? 100 : n4;
        }
        this.T = this.rnd.nextInt(91) + 10;
        this.D = this.rnd.nextInt(20);
        this.p = this.rnd.nextDouble() / 10.0;
        this.q = this.rnd.nextDouble() / 10.0;
        if (string.equals("1")) {
            this.T = 10;
            this.p = 0.0;
            this.q = 0.1;
        }
        if (bl) {
            return;
        }
        int n5 = this.rnd.nextInt(3) + 1;
        this.maze = new int[this.H][this.W];
        this.drilled = new int[this.H][this.W];
        this.reset();
        this.done = false;
        this.curC = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            this.curR = this.rnd.nextInt(this.H);
            this.dfs(this.curR, this.curC, n2);
        }
        this.prune(0.0, n5);
        for (n2 = 0; n2 < this.H; ++n2) {
            for (n = 0; n < this.W; ++n) {
                if (this.maze[n2][n] < 0) continue;
                this.maze[n2][n] = this.rnd.nextDouble() < this.q ? 1 : 0;
            }
        }
        this.maze[this.curR][this.curC] = 0;
        int[][] nArray = this.maze;
        this.maze = new int[this.H][this.W];
        for (n = 0; n < 10; ++n) {
            int n6;
            for (n6 = 0; n6 < this.H; ++n6) {
                for (int i = 0; i < this.W; ++i) {
                    this.maze[n6][i] = nArray[n6][i];
                }
            }
            n6 = this.collapseTime();
            if (this.p == 0.0) {
                this.exp += (double)n6 * this.q / 10.0 / 0.01;
                continue;
            }
            this.exp += (double)n6 * this.q / 10.0 / this.p;
        }
        this.maze = nArray;
        this.ready = true;
    }

    String[] mazeAsString() {
        String[] stringArray = new String[this.H];
        for (int i = 0; i < this.H; ++i) {
            stringArray[i] = "";
            for (int j = 0; j < this.W; ++j) {
                if (this.curR == i && this.curC == j) {
                    int n = i;
                    stringArray[n] = stringArray[n] + '^';
                    continue;
                }
                if (this.maze[i][j] == 0) {
                    int n = i;
                    stringArray[n] = stringArray[n] + '.';
                    continue;
                }
                if (this.maze[i][j] == 1) {
                    int n = i;
                    stringArray[n] = stringArray[n] + '*';
                    continue;
                }
                int n = i;
                stringArray[n] = stringArray[n] + '#';
            }
        }
        return stringArray;
    }

    public double runTest(LongTest longTest) {
        this.init(longTest.getTest(), false);
        int n = 20000;
        longTest.setTimeLimit(n);
        String[] stringArray = this.mazeAsString();
        longTest.init(stringArray, this.T);
        if (!longTest.getStatus()) {
            return 0.0;
        }
        longTest.getResult_init();
        if (!longTest.getStatus()) {
            return 0.0;
        }
        n -= longTest.getTime();
        boolean bl = false;
        do {
            if (this.rnd.nextDouble() < this.p) {
                this.collapse();
            } else {
                this.colC = new int[0];
                this.colR = this.colC;
            }
            if (this.maze[this.curR][this.curC] < 0) {
                longTest.addFatalError("You were smushed! :(");
                return 0.0;
            }
            longTest.setTimeLimit(n);
            longTest.move(this.colR, this.colC, this.curR, this.curC);
            ++this.time;
            if (!longTest.getStatus()) {
                return 0.0;
            }
            int n2 = longTest.getResult_move();
            if (!longTest.getStatus()) {
                return 0.0;
            }
            n -= longTest.getTime();
            if (n2 < 0 || n2 > 3) {
                longTest.addFatalError("Invalid direction: " + n2);
                return 0.0;
            }
            int n3 = this.curR + this.dr[n2];
            int n4 = this.curC + this.dc[n2];
            if (n3 < 0 || n4 < 0 || n3 == this.H || n4 == this.W) {
                longTest.addFatalError("Attempted to move off the board");
                return 0.0;
            }
            if (this.maze[n3][n4] < 0) {
                int[] nArray = this.drilled[n3];
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
                if (this.drilled[n3][n4] == this.T) {
                    this.drilled[n3][n4] = 0;
                    this.maze[n3][n4] = 0;
                }
            } else {
                this.curR = n3;
                this.curC = n4;
            }
            if (this.maze[this.curR][this.curC] == 1) {
                ++this.L;
                this.maze[this.curR][this.curC] = 0;
            }
            if (stringArray[this.curR].charAt(this.curC) == '^') continue;
            bl = true;
        } while (this.curC != 0 && this.curR != 0 && this.curC != this.W - 1 && this.curR != this.H - 1 || stringArray[this.curR].charAt(this.curC) == '#' || !bl);
        longTest.addFatalError("You collected " + this.L + " coins and escaped successfully!  Your score is " + (double)this.L / this.exp + " (" + this.L + "/" + this.exp + ")");
        return (double)this.L / this.exp;
    }

    public String checkData(String string) {
        return "";
    }

    public double[] score(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray[0].length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] + dArray[j][i];
            }
        }
        return dArray2;
    }

    public String displayTestCase(String string) {
        this.init(string, true);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("seed = ").append(string).append("<br>\n");
        stringBuffer.append("T = ").append(this.T).append("<br>\n");
        stringBuffer.append("W = ").append(this.W).append("<br>\n");
        stringBuffer.append("H = ").append(this.H).append("<br>\n");
        stringBuffer.append("D = ").append(this.D).append("<br>\n");
        stringBuffer.append("p = ").append(this.p).append("<br>\n");
        stringBuffer.append("q = ").append(this.q).append("<br>\n");
        return stringBuffer.toString();
    }
}

