/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CoalMiningVis {
    SecureRandom r;
    int W;
    int H;
    int C;
    int[] truckX;
    int[] truckY;
    int[] truckLoad;
    int ntruck;
    int[][] mine;
    String[] mineString;
    String[] ret;
    int rockCount;
    int coalReturned;
    static int[] dx = new int[]{1, -1, 0, 0};
    static int[] dy = new int[]{0, 0, 1, -1};
    Vis v;
    Robot rob;
    static String exec;
    static String diff;
    static double diffsc;
    static Process proc;
    static boolean bNovis;
    static int del;
    InputStream is;
    OutputStream os;

    void fillSolid(int n, int n2) {
        if (this.rockCount <= 0 || n < 0 || n >= this.W || n2 < 0 || n2 >= this.H) {
            return;
        }
        if (this.mine[n][n2] == 1) {
            --this.rockCount;
        }
        this.mine[n][n2] = 2;
        this.fillSolid(n + this.r.nextInt(3) - 1, n2 + this.r.nextInt(3) - 1);
        this.fillSolid(n + this.r.nextInt(3) - 1, n2 + this.r.nextInt(3) - 1);
        this.fillSolid(n + this.r.nextInt(3) - 1, n2 + this.r.nextInt(3) - 1);
        this.fillSolid(n + this.r.nextInt(3) - 1, n2 + this.r.nextInt(3) - 1);
    }

    void generate(String string) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(Long.parseLong(string));
            this.W = this.r.nextInt(81) + 20;
            this.H = this.r.nextInt(81) + 20;
            this.C = this.r.nextInt(10) + 1;
            this.mine = new int[this.W][this.H];
            for (n5 = 0; n5 < this.H; ++n5) {
                for (n4 = 0; n4 < this.W; ++n4) {
                    this.mine[n4][n5] = 1;
                }
            }
            n5 = this.r.nextInt(10) + 1;
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = this.r.nextInt(this.W);
                n2 = this.r.nextInt(this.H);
                this.rockCount = this.r.nextInt(this.W * this.H / 20);
                this.fillSolid(n3, n2);
            }
            n4 = this.r.nextInt(9) + 2;
            this.truckX = new int[n4 * 4];
            this.truckY = new int[n4 * 4];
            this.truckLoad = new int[n4 * 4];
            this.ntruck = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                while (this.mine[n2 = this.r.nextInt(this.W - 2) + 1][n = this.r.nextInt(this.H - 2) + 1] == 3 || this.mine[n2 - 1][n] == 3 || this.mine[n2 + 1][n] == 3 || this.mine[n2][n - 1] == 3 || this.mine[n2][n + 1] == 3 || this.mine[n2 - 1][n - 1] == 3 || this.mine[n2 + 1][n - 1] == 3 || this.mine[n2 - 1][n + 1] == 3 || this.mine[n2 + 1][n + 1] == 3) {
                }
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        if (i + n2 < 0 || i + n2 >= this.W || j + n < 0 || j + n >= this.H || this.mine[i + n2][j + n] == 3) continue;
                        this.mine[i + n2][j + n] = 0;
                    }
                }
                this.mine[n2][n] = 3;
                this.truckX[this.ntruck] = n2 - 1;
                this.truckY[this.ntruck] = n;
                this.truckLoad[this.ntruck] = 0;
                ++this.ntruck;
                this.truckX[this.ntruck] = n2 + 1;
                this.truckY[this.ntruck] = n;
                this.truckLoad[this.ntruck] = 0;
                ++this.ntruck;
                this.truckX[this.ntruck] = n2;
                this.truckY[this.ntruck] = n - 1;
                this.truckLoad[this.ntruck] = 0;
                ++this.ntruck;
                this.truckX[this.ntruck] = n2;
                this.truckY[this.ntruck] = n + 1;
                this.truckLoad[this.ntruck] = 0;
                ++this.ntruck;
            }
            System.out.println("W = " + this.W + " H = " + this.H + " C = " + this.C);
            this.mineString = new String[this.H];
            for (n3 = 0; n3 < this.H; ++n3) {
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < this.W; ++n) {
                    if (this.mine[n][n3] == 0) {
                        stringBuffer.append('.');
                        continue;
                    }
                    if (this.mine[n][n3] == 1) {
                        stringBuffer.append('#');
                        continue;
                    }
                    if (this.mine[n][n3] == 2) {
                        stringBuffer.append('+');
                        continue;
                    }
                    if (this.mine[n][n3] != 3) continue;
                    stringBuffer.append('S');
                }
                this.mineString[n3] = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            System.err.println("An exception occured while generating the test case.");
            exception.printStackTrace();
        }
    }

    public double applyMove(String string) throws Exception {
        double d = -1.0;
        for (int i = 0; i < this.ntruck; ++i) {
            char c = string.charAt(i);
            if (c != 'P') {
                int n;
                int n2;
                int n3;
                if (c == 'N') {
                    int n4 = i;
                    this.truckY[n4] = this.truckY[n4] - 1;
                    if (this.truckY[i] < 0) {
                        throw new Exception("Truck " + i + " moved outside the boundary of the mine.");
                    }
                } else if (c == 'S') {
                    int n5 = i;
                    this.truckY[n5] = this.truckY[n5] + 1;
                    if (this.truckY[i] >= this.H) {
                        throw new Exception("Truck " + i + " moved outside the boundary of the mine.");
                    }
                } else if (c == 'W') {
                    int n6 = i;
                    this.truckX[n6] = this.truckX[n6] - 1;
                    if (this.truckX[i] < 0) {
                        throw new Exception("Truck " + i + " moved outside the boundary of the mine.");
                    }
                } else if (c == 'E') {
                    int n7 = i;
                    this.truckX[n7] = this.truckX[n7] + 1;
                    if (this.truckX[i] >= this.W) {
                        throw new Exception("Truck " + i + " moved outside the boundary of the mine.");
                    }
                } else if (c == 'X') {
                    for (n3 = 0; n3 < 4; ++n3) {
                        n2 = this.truckX[i] + dx[n3];
                        n = this.truckY[i] + dy[n3];
                        if (n2 < 0 || n2 >= this.W || n < 0 || n >= this.H || this.mine[n2][n] != 1) continue;
                        this.mine[n2][n] = 4;
                    }
                } else if (c == 'D') {
                    for (n3 = 0; n3 < 4; ++n3) {
                        n2 = this.truckX[i] + dx[n3];
                        n = this.truckY[i] + dy[n3];
                        if (n2 < 0 || n2 >= this.W || n < 0 || n >= this.H || this.mine[n2][n] != 3) continue;
                        d += 100.0 * (double)this.truckLoad[i];
                        this.coalReturned += this.truckLoad[i];
                        this.truckLoad[i] = 0;
                        break;
                    }
                } else {
                    throw new Exception("Illegal character '" + c + "' in movement of truck " + i);
                }
            }
            if (this.mine[this.truckX[i]][this.truckY[i]] == 4) {
                if (this.truckLoad[i] < this.C) {
                    this.mine[this.truckX[i]][this.truckY[i]] = 0;
                    int n = i;
                    this.truckLoad[n] = this.truckLoad[n] + 1;
                } else {
                    throw new Exception("Can not move through coal with a full load on the truck.");
                }
            }
            if (this.mine[this.truckX[i]][this.truckY[i]] == 1) {
                throw new Exception("Can not move through solid coal.");
            }
            if (this.mine[this.truckX[i]][this.truckY[i]] == 2) {
                throw new Exception("Can not move through solid rock.");
            }
            if (this.mine[this.truckX[i]][this.truckY[i]] != 3) continue;
            throw new Exception("Can not move through shaft.");
        }
        return d;
    }

    public double runTest(String string) {
        try {
            this.generate(string);
            this.ret = this.gather(this.mineString, this.C);
            if (!bNovis) {
                this.v.repaint();
            }
            System.out.println("Number of moves = " + this.ret.length);
            this.coalReturned = 0;
            double d = 0.0;
            for (int i = 0; i < this.ret.length && i < 10000; ++i) {
                if (this.ret[i].length() != this.ntruck) {
                    throw new Exception("Line does not contain a move for each truck.");
                }
                d += this.applyMove(this.ret[i]);
                if (bNovis) continue;
                this.v.repaint();
                if (del <= 0) continue;
                this.rob.delay(del);
            }
            System.out.println("Number of coal returned = " + this.coalReturned);
            return Math.max(d, 0.0);
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String[] gather(String[] stringArray, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.H).append('\n');
        for (n2 = 0; n2 < this.H; ++n2) {
            stringBuffer.append(stringArray[n2]).append('\n');
        }
        stringBuffer.append(this.ntruck).append('\n');
        for (n2 = 0; n2 < this.ntruck; ++n2) {
            stringBuffer.append(this.truckX[n2]).append('\n');
        }
        for (n2 = 0; n2 < this.ntruck; ++n2) {
            stringBuffer.append(this.truckY[n2]).append('\n');
        }
        stringBuffer.append(n).append('\n');
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is));
        int n3 = Integer.parseInt(bufferedReader.readLine());
        if (n3 > 10000) {
            n3 = 10000;
            System.out.println("Too many moves. Only 10000 used.");
        }
        String[] stringArray2 = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray2[n2] = bufferedReader.readLine();
        }
        return stringArray2;
    }

    BufferedImage drawMine() {
        int n;
        int n2;
        BufferedImage bufferedImage = new BufferedImage(this.W * 10, this.H * 10, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n3 = 10;
        for (n2 = 0; n2 < this.H; ++n2) {
            for (n = 0; n < this.W; ++n) {
                if (this.mine[n][n2] == 0) {
                    graphics2D.setColor(Color.WHITE);
                } else if (this.mine[n][n2] == 1) {
                    graphics2D.setColor(Color.BLACK);
                } else if (this.mine[n][n2] == 2) {
                    graphics2D.setColor(Color.ORANGE);
                } else if (this.mine[n][n2] == 3) {
                    graphics2D.setColor(Color.GREEN);
                } else if (this.mine[n][n2] == 4) {
                    graphics2D.setColor(Color.GRAY);
                }
                graphics2D.fillRect(n * n3, n2 * n3, n3, n3);
            }
        }
        for (n2 = 0; n2 < this.ntruck; ++n2) {
            if (this.truckLoad[n2] == this.C) {
                graphics2D.setColor(Color.RED);
            } else {
                graphics2D.setColor(Color.BLUE);
            }
            graphics2D.drawRect(this.truckX[n2] * n3, this.truckY[n2] * n3, n3 - 1, n3 - 1);
            if (this.truckLoad[n2] <= 0) continue;
            graphics2D.setColor(Color.GRAY);
            n = this.truckLoad[n2] * (n3 - 2) / this.C;
            graphics2D.fillRect(this.truckX[n2] * n3 + 1, this.truckY[n2] * n3 + n3 - 1 - n, n3 - 2, n);
        }
        return bufferedImage;
    }

    public CoalMiningVis(String string) throws IOException {
        Object object;
        if (exec != null) {
            try {
                object = Runtime.getRuntime();
                proc = ((Runtime)object).exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bNovis) {
            object = new JFrame();
            Closer closer = new Closer();
            ((Window)object).addWindowListener(closer);
            ((Window)object).setSize(1000, 1000);
            this.v = new Vis();
            ((JFrame)object).getContentPane().add(this.v);
            ((Window)object).setVisible(true);
            try {
                this.rob = new Robot();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest(string));
    }

    public static void main(String[] stringArray) throws IOException {
        bNovis = false;
        String string = "1";
        del = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                bNovis = true;
            }
            if (!stringArray[i].equals("-delay")) continue;
            del = Integer.parseInt(stringArray[++i]);
        }
        CoalMiningVis coalMiningVis = new CoalMiningVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    class Closer
    implements WindowListener {
        Closer() {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }

    public class Vis
    extends JPanel {
        public void paint(Graphics graphics) {
            if (CoalMiningVis.this.W > 0 && CoalMiningVis.this.H > 0) {
                graphics.drawImage(CoalMiningVis.this.drawMine(), 0, 0, null);
            }
        }
    }
}

