import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class Vis extends JFrame {
    int[][] board;
    Vis(){
        Random r = new Random();
        addMouseListener(new MouseAdapter(){
            public void mouseClicked(MouseEvent me){
                int x = (me.getX()-50)/ 10;
                int y = (me.getY()-50)/ 10;
                System.out.println(x+" "+y);
                if(y >= 0 && y < board.length && x >= 0 && x < board[0].length)
                    board[y][x] = ((board[y][x] << 1) | (board[y][x] >> 3)) & 15;
                repaint();
            }
        });
        board = new int[20][20];
        for(int i = 0; i<board.length; i++){
            for(int j = 0; j<board[0].length ;j++){
                board[i][j] = r.nextInt(15)+1;
            }
        }
    }
    public void paint(Graphics g){
        boolean changed = true;
        boolean[][] reach = new boolean[board.length][board[0].length];
        for(int i = 0; i<board.length; i++){
            reach[i][0] = (board[i][0] & 2) > 0;
        }
        g.setColor(Color.white);
        g.fillRect(0,0,getWidth(),getHeight());
        while(changed){
            changed = false;
            for(int i = 0; i<board.length; i++){
                for(int j = 0; j<board[0].length ;j++){
                    if(reach[i][j])continue;
                    if(i > 0 && (board[i][j] & 1) > 0 && reach[i-1][j] && (board[i-1][j] & 4) > 0){
                        reach[i][j] = true;
                        changed = true;
                    }
                    if(j > 0 && (board[i][j] & 2) > 0 && reach[i][j-1] && (board[i][j-1] & 8) > 0){
                        reach[i][j] = true;
                        changed = true;
                    }
                    if(i < board.length-1 && (board[i][j] & 4) > 0 && reach[i+1][j] && (board[i+1][j] & 1) > 0){
                        reach[i][j] = true;
                        changed = true;
                    }
                    if(j < board[0].length-1 && (board[i][j] & 8) > 0 && reach[i][j+1] && (board[i][j+1] & 2) > 0){
                        reach[i][j] = true;
                        changed = true;
                    }
                }
            }
        }
        for(int i = 0; i<board.length; i++){
            for(int j = 0; j<board[0].length ;j++){
                if(board[i][j] == 1 || board[i][j] == 2 || board[i][j] == 4 || board[i][j] == 8)continue;
                if(reach[i][j])g.setColor(Color.green);
                else g.setColor(Color.blue);
                int x = j*10 + 55;
                int y = i*10 + 55;
                if((board[i][j] & 2) > 0){
                    g.drawLine(x,y,x-5,y);
                }
                if((board[i][j] & 1) > 0){
                    g.drawLine(x,y,x,y-5);
                }
                if((board[i][j] & 8) > 0){
                    g.drawLine(x,y,x+5,y);
                }
                if((board[i][j] & 4) > 0){
                    g.drawLine(x,y,x,y+5);
                }
            }
        }
    }
    public static void main(String[] args){
        Vis v = new Vis();
        v.setSize(1000,1000);
        v.setVisible(true);
    }
}
