import java.util.*;
import java.io.*;
public class Runner {
    boolean paused = false;
    boolean running = false;
    boolean manual = false;
    Process pr;
    Scanner input;
    InputStream error;
    DataOutputStream os;
    Stepper st;

    Problem prob;
    Display dis;
    int pause;
    Thread runtest;


    public Runner(Problem prob, Display d){
        this.prob = prob;
        this.dis = d;
    }

    public void start(boolean go, boolean manual){
        this.manual = manual;
        running = true;
        paused = !go;


        try{
            if(!manual){
                pr = Runtime.getRuntime().exec(Main.getProcess());
                input = new Scanner(pr.getInputStream());
                error = pr.getErrorStream();
                os = new DataOutputStream(pr.getOutputStream());

                new ErrorReader().start();
            }

            (runtest = new Thread(){
                public void run(){
                    double score = prob.runTest();
                    Main.addFatalError("Your score is: "+score);
                    running = false;
                }
            }).start();
            if(go){
                (st = new Stepper()).start();
            }


        }catch(Exception e){
            running = false;
            e.printStackTrace();
            return;
        }
    }
    class Stepper extends Thread{
        public void run(){
            try{
                while(running && !paused){
                    try{
                        step();
                        if(!paused){
                            try{
                                Thread.sleep(pause);
                            }catch(Exception e){
                                if(!running){
                                    break;
                                }else {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }catch(Exception ex){
                        running = false;
                        ex.printStackTrace();
                        Main.addFatalError(ex.getMessage());
                    }
                }
                //Main.addMessage("Score = "+prob.score+"\n");
            }catch(Exception e){
                e.printStackTrace();
                return;
            }
        }
    }
    public void stop(){
        running = false;
        try{
            if(pr != null){
                pr.destroy();
                pr = null;
            }
            if(runtest != null){
                runtest.interrupt();
            }
            if(st != null){
                st.interrupt();
                st.join();
            }
            if(runtest != null){
                runtest.join();
            }
        }catch(InterruptedException e){
            e.printStackTrace();
        }
    }
    boolean go;
    public boolean step() {
        if(!running){
            return false;
        }
        synchronized(Main.step){
            if(go){
                try{
                    Main.step.wait();
                }catch(InterruptedException e){
                    return false;
                }
            }
            if(!go){
                go = true;
                Main.step.notify();
            }
        }
        return true;
    }
    public void pause(){
        if(paused){
            paused = false;
            (st = new Stepper()).start();
        }else{
            paused = true;
        }
    }
    public class ErrorReader extends Thread{
        public void run(){
            try{
                byte[] ch = new byte[50000];
                int read;
                while((read = error.read(ch)) > 0 && running){
                    String s = new String(ch,0,read);
                    //System.out.println("err: "+s+" "+s.endsWith("\n"));
                    Main.addMessage(s);
                }
                Main.addMessage("\n");
            }catch(Exception e){
                //System.err.println("Failed to read from stderr");
            }
        }
    }
    public void setPause(int p){
        pause = p;
    }
    public void done(){
        try{
            os.write(("-1\n").getBytes());
            os.flush();
        }catch(Exception ie){
            //tried...
        }
    }
    public int init(int W, int H, String C) throws IOException, StoppedException{
        if(manual)return 0;
        try{
            os.write((W+" "+H+" "+C+"\n").getBytes());
            os.flush();
            return 0;
        }catch(IOException ie){
            if(!running)throw new StoppedException();
            else throw ie;
        }
    }
    public int[] rotateSquare(int[] s)throws IOException, StoppedException, InterruptedException{
        if(!running)throw new StoppedException();
        synchronized(Main.step){
            try{
                if(!go) Main.step.wait();
                if(manual){
                    int[] ret;
                    synchronized(dis.click){
                        if(dis.ret == null){
                            dis.click.wait();
                        }
                        ret = dis.ret;
                        dis.ret = null;
                    }
                    go = false;
                    Main.step.notify();
                    return ret;
                }else{
                    StringBuffer sb = new StringBuffer();
                    for(int i = 0; i<s.length; i++){
                        sb.append(s[i]).append(' ');
                    }
                    sb.append('\n');
                    os.write(sb.toString().getBytes());
                    os.flush();
                    int[] ret = new int[3];
                    ret[0] = input.nextInt();
                    ret[1] = input.nextInt();
                    ret[2] = input.nextInt();
                    go = false;
                    Main.step.notify();
                    return ret;
                }
            }catch(IOException ie){
                if(!running)throw new StoppedException();
                else throw ie;
            }catch(NoSuchElementException e){
                if(!running)throw new StoppedException();
                else throw e;
            //}catch(Exception e){
                //Main.step.notify();
                //if(!running)throw new StoppedException();
                //else throw new RuntimeException(e);
            }
        }
    }
}
class StoppedException extends Exception{}
