import java.util.*;
import java.awt.geom.*;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.event.*;
public class Display extends JPanel{
    BufferedImage bi;
    Problem p;
    int size = 5;
    JPanel vis;
    Object click = new Object();
    int[] ret;
    public Display(final Problem p){
        this.p = p;
        vis = new Vis();
        setLayout(new BorderLayout());
        addMouseListener(new MouseAdapter(){
            public void mouseClicked(MouseEvent me){
                synchronized(click){
                    ret = new int[3];
                    ret[0] = (me.getY()-OFF)/SCALE/2;
                    ret[1] = (me.getX()-SCALE*2)/SCALE/2;
                    if(ret[0] < 0 || ret[0] >= p.H || ret[1] < 0 || ret[1] >= p.W){
                        ret = null;
                        return;
                    }
                    ret[2] = me.getButton() == MouseEvent.BUTTON1 ? 1 : -1;
                    click.notify();
                }
            }
        });

        add(vis,"Center");
    }
    static int SCALE = 10;
    static int OFF = 20;
    DecimalFormat df = new DecimalFormat("0.000");
    Color grey = new Color(220,220,220);
    public class Vis extends JPanel{
        public void paint(Graphics g){
            Graphics2D g2 = (Graphics2D)g;
           g.setColor(Color.white);
           g.fillRect(0,0,getWidth(),getHeight());
           SCALE = Math.min((getWidth())/(p.W+2)/2,(getHeight()-OFF)/p.H/2);
               Font f = new Font(g2.getFont().getName(),Font.PLAIN,20);
               g2.setFont(f);
               FontMetrics fm = g2.getFontMetrics();
               int th = fm.getAscent();
               OFF = fm.getAscent() + SCALE/2;
            /*
               if(bi == null){
               rebuffer();
               }
               int size = Math.min((getHeight()-th-10)/p.N/2,getWidth()/(100+p.M));
               g.setColor(grey);
               for(int i = 1; i<p.N; i+=2){
               g.fillRect(0,i*size*2+th+10,getWidth(),size*2);
               }
               g.setColor(Color.black);
               for(int i = 0; i<p.M; i++){
               int fl = p.testliftlocs[i];
               g.fillRect(i*size*2,(p.N-fl-1)*size*2+th+10,size*2,size*2);
               }
               for(int i = 0; i<p.N; i++){
               int up = p.waitingUp(p.N-i-1);
               int down = p.waitingDown(p.N-i-1);
               g.setColor(Color.blue);
               g.fillRect(p.M*size*2+1,i*size*2+th+10,up*size,size);
               g.setColor(Color.red);
               g.fillRect(p.M*size*2+1,i*size*2+3+th+10,down*size,size);
               }
            //g.drawLine(p.M*4,0,p.M*4,getHeight());
            */
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
            for(int i = 0; i < p.H; i++){
                for(int j = 0; j < p.W; j++){
                    int idx = i*p.W + j;
                    if(p.lefts[idx] && p.rights[idx]){
                        g.setColor(Color.magenta);
                    }else if(p.lefts[idx]){
                        g.setColor(Color.blue);
                    }else if(p.rights[idx]){
                        g.setColor(Color.red);
                    }else{
                        g.setColor(Color.black);
                    }
                    int x = j*SCALE*2 + SCALE*3;
                    int y = OFF+i*SCALE*2 + SCALE;
                    g.drawLine(x,y,x,y);
                    g2.setStroke(new BasicStroke(Math.max(1,SCALE/2)));
                    if((p.board[idx] & 8) > 0){
                        g.drawLine(x,y,x-SCALE,y);
                    }
                    if((p.board[idx] & 1) > 0){
                        g.drawLine(x,y,x,y-SCALE);
                    }
                    if((p.board[idx] & 2) > 0){
                        g.drawLine(x,y,x+SCALE,y);
                    }
                    if((p.board[idx] & 4) > 0){
                        g.drawLine(x,y,x,y+SCALE);
                    }
                }
            }
            for(int i = 0; i < p.H; i++){
                if(p.C.charAt(i) == '1'){
                    g.setColor(Color.blue);
                    g.fillOval(0,OFF+i*SCALE*2,SCALE*2,SCALE*2);
                }else{
                    g.setColor(Color.black);
                    g.fillOval(0,OFF+i*SCALE*2,SCALE*2,SCALE*2);
                }
            }
            for(int i = 0; i < p.H; i++){
                if(p.C.charAt(i+p.H) == '1'){
                    g.setColor(Color.red);
                    g.fillOval(p.W*SCALE*2+SCALE*2,OFF+i*SCALE*2,SCALE*2,SCALE*2);
                }else{
                    g.setColor(Color.black);
                    g.fillOval(p.W*SCALE*2+SCALE*2,OFF+i*SCALE*2,SCALE*2,SCALE*2);
                }
            }
            String txt = "Moves Made: "+p.nmoves;
            g2.setColor(Color.black);
            g2.drawString(txt,0,th);
            //g.drawImage(bi,0,0,null);
        }
    }
    /*
    void rebuffer(){
        bi = new BufferedImage(p.W*SCALE*2+SCALE*4,p.H*SCALE*2,BufferedImage.TYPE_INT_RGB);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0,0,bi.getWidth(),bi.getHeight());
        g.setColor(Color.blue);
        for(int i = 0; i < p.H; i++){
            if(p.C.charAt(i) == '1'){
                g.fillRect(0,i*SCALE*2,SCALE*2,SCALE*2);
            }
        }
        g.setColor(Color.red);
        for(int i = 0; i < p.H; i++){
            if(p.C.charAt(i+p.H) == '1'){
                g.fillRect(p.W*SCALE*2+SCALE*2,i*SCALE*2,SCALE*2,SCALE*2);
            }
        }
        //g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        for(int i = 0; i < p.H; i++){
            for(int j = 0; j < p.W; j++){
                int idx = i*p.W + j;
                if(p.lefts[idx] && p.rights[idx]){
                    g.setColor(Color.magenta);
                }else if(p.lefts[idx]){
                    g.setColor(Color.blue);
                }else if(p.rights[idx]){
                    g.setColor(Color.red);
                }else{
                    g.setColor(Color.black);
                }
                int x = j*SCALE*2 + SCALE*3;
                int y = i*SCALE*2 + SCALE;
                g.setStroke(new BasicStroke(2));
                if((p.board[idx] & 8) > 0){
                    g.drawLine(x,y,x-SCALE,y);
                }
                if((p.board[idx] & 1) > 0){
                    g.drawLine(x,y,x,y-SCALE);
                }
                if((p.board[idx] & 2) > 0){
                    g.drawLine(x,y,x+SCALE,y);
                }
                if((p.board[idx] & 4) > 0){
                    g.drawLine(x,y,x,y+SCALE);
                }
            }
        }
    }
    void updateCell(int ii, int jj){
        updateCell(ii,jj,(Graphics2D)bi.getGraphics());
        updateCell(ii,jj,(Graphics2D)vis.getGraphics());
    }
    void updateCell(int ii, int jj, Graphics2D g){
        g.setColor(Color.white);
        int x = jj*SCALE*2 + SCALE*3;
        int y = ii*SCALE*2 + SCALE;
        g.setStroke(new BasicStroke(2));
        g.drawLine(x,y,x-SCALE,y);
        g.drawLine(x,y,x,y-SCALE);
        g.drawLine(x,y,x+SCALE,y);
        g.drawLine(x,y,x,y+SCALE);


        for(int i = Math.max(0,ii-1); i<p.H && i < ii+2; i++)
            for(int j = Math.max(0,jj-1); j<p.W && j < jj+2; j++){
                int idx = i*p.W + j;
                x = j*SCALE*2 + SCALE*3;
                y = i*SCALE*2 + SCALE;
                if(p.lefts[idx] && p.rights[idx]){
                    g.setColor(Color.magenta);
                }else if(p.lefts[idx]){
                    g.setColor(Color.blue);
                }else if(p.rights[idx]){
                    g.setColor(Color.red);
                }else{
                    g.setColor(Color.black);
                }
                if((p.board[idx] & 8) > 0){
                    g.drawLine(x,y,x-SCALE,y);
                }
                if((p.board[idx] & 1) > 0){
                    g.drawLine(x,y,x,y-SCALE);
                }
                if((p.board[idx] & 2) > 0){
                    g.drawLine(x,y,x+SCALE,y);
                }
                if((p.board[idx] & 4) > 0){
                    g.drawLine(x,y,x,y+SCALE);
                }
            }
        //vis.repaint();
    }*/
    public void repaintSim(){
        bi = null;
        vis.repaint();
    }
}
