import java.util.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.event.*;
import javax.swing.*;

public class Controls extends JPanel {

    Runner r;
    Display d;
    Problem p;
    Errors e;


    JTextField fileName;
    JCheckBox manual;
    JTextField[] params;

    int initspeed = 100;

    public Controls(Problem pp, Display dd, Runner rr,Errors ee){
        this.e = ee;
        this.p = pp;
        this.d = dd;
        this.r = rr;
        JSlider speed = new JSlider(JSlider.HORIZONTAL, 0, 100, initspeed);
        speed.addChangeListener(new ChangeListener(){
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if((int)source.getValue() >= 80)r.setPause(100-(int)source.getValue());
                else r.setPause((int)(5000*Math.pow(0.93330963631359658956294462455157,(int)source.getValue())));
            }
        });
        manual = new JCheckBox("manual");

        speed.setMajorTickSpacing(20);
        speed.setMinorTickSpacing(5);
        speed.setPaintTicks(true);
        speed.setPaintLabels(true);
        speed.setBorder(BorderFactory.createEmptyBorder(0,0,10,0));

        JPanel north = new JPanel();
        north.setLayout(new BoxLayout(north, BoxLayout.PAGE_AXIS));
        //north.setLayout(new GridLayout(2,1));
        JLabel sliderLabel = new JLabel("Speed");
        sliderLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
        speed.setPreferredSize(new Dimension(400,60));
        north.add(sliderLabel);
        north.add(speed);

        JPanel southParams1 = new JPanel();
        southParams1.setLayout(new BoxLayout(southParams1, BoxLayout.LINE_AXIS));
        JPanel southParams2 = new JPanel();
        southParams2.setLayout(new BoxLayout(southParams2, BoxLayout.LINE_AXIS));

        params = new JTextField[Main.paramNames.length];
        for(int i = 0; i<Main.paramNames.length; i++){
            params[i] = new JTextField(Main.getParameter(Main.paramNames[i]).toString());
            if(i <= params.length/2 || params.length <= 4){
                southParams1.add(new Label(Main.paramNames[i]+": "));
                southParams1.add(params[i]);
            }else{
                southParams2.add(new Label(Main.paramNames[i]+": "));
                southParams2.add(params[i]);
            }
        }

        southParams1.setAlignmentX(Component.CENTER_ALIGNMENT);
        southParams2.setAlignmentX(Component.CENTER_ALIGNMENT);

        JPanel southButtons = new JPanel();
        southButtons.setLayout(new BoxLayout(southButtons, BoxLayout.LINE_AXIS));
        JButton regenerate = new JButton("Generate");
        JButton newparams = new JButton("New Parameters");
        JButton restart = new JButton("Restart");
        JButton stop = new JButton("Stop");
        JButton pause = new JButton("Pause");
        JButton step = new JButton("Step");

        southButtons.add(regenerate);
        southButtons.add(newparams);
        southButtons.add(restart);
        southButtons.add(stop);
        southButtons.add(pause);
        southButtons.add(step);
        southButtons.add(manual);
        regenerate.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                r.stop();
                for(int i = 0; i<params.length; i++){
                    Main.setParameter(i,params[i].getText());
                }
                p.generate(false,Integer.parseInt(params[0].getText()));
                d.repaintSim();
            }
        });
        newparams.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                r.stop();
                if(Main.getSeed() == Integer.parseInt(params[0].getText())){
                    params[0].setText(String.valueOf(Main.getSeed()+1));
                    p.generate(true,Integer.parseInt(params[0].getText()));
                }else{
                    p.generate(true,Integer.parseInt(params[0].getText()));
                }
                synchronized(p.ready){
                    if(!p.togo){
                        try{
                            p.ready.wait();
                        }catch(InterruptedException e){
                            e.printStackTrace();
                        }
                    }

                }
                for(int i = 1; i<params.length; i++){
                    params[i].setText(Main.getParameter(Main.paramNames[i]).toString());
                }
                d.repaintSim();
            }
        });
        restart.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                r.stop();
                for(int i = 0; i<params.length; i++){
                    Main.setParameter(i,params[i].getText());
                }
                p.generate(false,Integer.parseInt(params[0].getText()));
                d.repaintSim();
                e.reset();
                r.start(true,manual.isSelected());
            }
        });
        stop.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                r.stop();
            }
        });
        pause.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                r.pause();
            }
        });
        step.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                try{
                    if(!r.step()){
                        p.generate(false,Integer.parseInt(params[0].getText()));
                        d.repaintSim();
                        e.reset();
                        r.start(false,manual.isSelected());
                        r.step();
                    }
                }catch(Exception ex){
                    Main.addFatalError(ex.getMessage());
                }
            }
        });

        JPanel southFile = new JPanel();
        JButton select = new JButton("Select Executable");
        fileName = new JTextField(Main.process);
        southFile.add(select);
        southFile.add(fileName);
        southFile.setLayout(new BoxLayout(southFile, BoxLayout.LINE_AXIS));

        select.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(Controls.this);
                if(returnVal == JFileChooser.APPROVE_OPTION) {
                    fileName.setText(fc.getSelectedFile().getPath());
                }
            }
        });


        JPanel south = new JPanel();
        south.setLayout(new BoxLayout(south, BoxLayout.PAGE_AXIS));
        south.add(southParams1);
        if(params.length > 4){
            south.add(southParams2);
        }
        south.add(southButtons);
        south.add(southFile);

        add(north,"North");
        add(south,"South");
        setPreferredSize(new Dimension(400,200));

    }
}
