import java.util.*;
import java.io.*;
import java.security.*;
import java.text.*;

public class Problem {

// --------------------------------------------
    // global variables
    int W,H;
    String C="";
    int[] board;
    SecureRandom r;		// random number
    int nleft,nright,nmoves;
    boolean[] lefts, rights;
    int[] lefti, leftj, righti, rightj;

// --------------------------------------------
    void connect() {
        // check whether there is a connection of active contacts
        // if there is, count numbers of active contacts on each side which are connected to contacts on the other side
        // ALWAYS get active contacts from C
        int i,j,k;
        int lt = 0, rt = 0;
        Arrays.fill(lefts,false);
        Arrays.fill(rights,false);

        // find squares connected with active contacts on the left side
        for (i=0; i<H; i++)
            if ((board[i*W]&8)>0 && C.charAt(i)=='1')
            { 	lefti[lt] = i;
                leftj[lt] = 0;
                lt++;
                lefts[i*W]=true;
            }

        // bfs from left to right
        k=0;
        while (k<lt)
        {   i=lefti[k];
            j=leftj[k];
            if (i>0 && (board[i*W+j]&1)>0 && (board[(i-1)*W+j]&4)>0 && !lefts[(i-1)*W+j])
            {	// this square is connected to the one at the top
                lefts[(i-1)*W+j]=true;
                lefti[lt] = i-1;
                leftj[lt] = j;
                lt++;
            }
            if (j<W-1 && (board[i*W+j]&2)>0 && (board[i*W+j+1]&8)>0 && !lefts[i*W+j+1])
            {	// this square is connected to the one on the right
                lefts[i*W+j+1]=true;
                lefti[lt] = i;
                leftj[lt] = j+1;
                lt++;
            }
            if (i<H-1 && (board[i*W+j]&4)>0 && (board[(i+1)*W+j]&1)>0 && !lefts[(i+1)*W+j])
            {	// this square is connected to the one at the bottom
                lefts[(i+1)*W+j]=true;
                lefti[lt] = i+1;
                leftj[lt] = j;
                lt++;
            }
            if (j>0 && (board[i*W+j]&8)>0 && (board[i*W+j-1]&2)>0 && !lefts[i*W+j-1])
            {	// this square is connected to the one on the left
                lefts[i*W+j-1]=true;
                lefti[lt] = i;
                leftj[lt] = j-1;
                lt++;
            }
            k++;
        }

        // check whether there are right contacts connected to the left
        nleft=0;
        nright=0;
        for (i=0; i<H; i++)
            if ((board[i*W+W-1]&2)>0 && C.charAt(H+i)=='1' && lefts[i*W+W-1])
                nright++;
        //if (nright==0) return;

        // same procedure from right to left, to get nleft
        for (i=0; i<H; i++)
            if ((board[i*W+W-1]&2)>0 && C.charAt(H+i)=='1')
            { 	righti[rt] = i;
                rightj[rt] = W-1;
                rt++;
                rights[i*W+W-1]=true;
            }
        k=0;
        while (k<rt)
        {   i=righti[k];
            j=rightj[k];
            if (i>0 && (board[i*W+j]&1)>0 && (board[(i-1)*W+j]&4)>0 && !rights[(i-1)*W+j])
            {	// this square is connected to the one at the top
                rights[(i-1)*W+j]=true;
             	righti[rt] = i-1;
                rightj[rt] = j;
                rt++;
            }
            if (j<W-1 && (board[i*W+j]&2)>0 && (board[i*W+j+1]&8)>0 && !rights[i*W+j+1])
            {	// this square is connected to the one on the right
                rights[i*W+j+1]=true;
             	righti[rt] = i;
                rightj[rt] = j+1;
                rt++;
            }
            if (i<H-1 && (board[i*W+j]&4)>0 && (board[(i+1)*W+j]&1)>0 && !rights[(i+1)*W+j])
            {	// this square is connected to the one at the bottom
                rights[(i+1)*W+j]=true;
             	righti[rt] = i+1;
                rightj[rt] = j;
                rt++;
            }
            if (j>0 && (board[i*W+j]&8)>0 && (board[i*W+j-1]&2)>0 && !rights[i*W+j-1])
            {	// this square is connected to the one on the left
                rights[i*W+j-1]=true;
             	righti[rt] = i;
                rightj[rt] = j-1;
                rt++;
            }
            k++;
        }
        for (i=0; i<H; i++)
            if ((board[i*W]&8)>0 && C.charAt(i)=='1' && rights[i*W])
                nleft++;
    }
// --------------------------------------------
void init(final long seed){
    new Thread(){
        public void run(){
            generate(seed);
        }
    }.start();
}
private void generate(long seed) {
    synchronized(ready){
        try {
            r = SecureRandom.getInstance("SHA1PRNG");
            r.setSeed(seed);
            if(W == 0) {
                W = r.nextInt(91) + 10;
                if(seed == 1)W = 10;
            } else r.nextInt(91);
            if(H == 0) {
                H = r.nextInt(91) + 10;
                if(seed == 1) H = 10;
            } else r.nextInt(91);

            // "on-off" sequences
            int i,j,m,n;
            if(C.length() != 2*H){
                char[] seq = new char[2*H];
                for (i=0; i<2*H; i++)
                    seq[i] = (r.nextInt(2)+"").charAt(0);
                C = new String(seq);
            }else{
                for (i=0; i<2*H; i++)
                    r.nextInt(2);
            }

            // the board itself
            board = new int[W*H];
            lefts = new boolean[W*H];
            rights = new boolean[W*H];
            lefti = new int[W*H];
            leftj = new int[W*H];
            righti = new int[W*H];
            rightj = new int[W*H];
            do {
                for (i=0; i<W*H; i++){
                    int type = r.nextInt(5);
                    if(type == 0){
                        board[i] = 15;
                    }else if(type == 1){
                        board[i] = 15 ^ (1<<r.nextInt(4));
                    }else if(type == 2){
                        board[i] = 5 <<r.nextInt(2);
                    }else if(type == 3){
                        board[i] = 3 << r.nextInt(4);
                        if(board[i] > 15)board[i] = 9;
                    }else{
                        board[i] = 0;
                    }
                    //board[i] = r.nextInt(15)+1;	//disallow empty squares, but allow squares with one wire
                }
                connect();
            } while (nleft+nright>0);
        }
        catch (Exception e) {   
            e.printStackTrace();
        }
        togo = true;
        ready.notify();
    }
}
// --------------------------------------------
public double runTest() {
    synchronized(ready){
        if(!togo){
            try{
                ready.wait();
            }catch(Exception e){
                e.printStackTrace();
            }
        }
        int time=0,  old;
        nmoves=0;
        int[] ret;


        // call init
        try{
            Main.r.init(W,H,C);
        }catch(StoppedException e){
            Main.addFatalError("Stopped");
            return 0;
        }catch(IOException e){
            Main.addFatalError("An IOException occurred");
            return 0;
        }

        do {
            // call rotateSquare
            try{
                ret = Main.r.rotateSquare(board);
            }catch(StoppedException e){
                Main.addFatalError("Stopped");
                return 0;
            }catch(IOException e){
                Main.addFatalError("An IOException occurred");
                return 0;
            }catch(InterruptedException e){
                Main.addFatalError("Stopped");
                return 0;
            }
            // check whether the return is valid
            if (ret.length==3 && ret[0]>=0 && ret[0]<H && ret[1]>=0 && ret[1]<W && (ret[2]==1 || ret[2]==-1))
            {	// valid - rotate
                old = board[ret[0]*W+ret[1]];
                if (ret[2]==1)
                    board[ret[0]*W+ret[1]] = ((old&7)<<1) | (old>>3);
                else  board[ret[0]*W+ret[1]] = (old>>1) | ((old&1)<<3);
                nmoves++;
                connect();
                if(!Main.novis)
                    Main.d.repaintSim();
            }
            else {
                Main.addFatalError("Invalid return.");
                return 0;
            }
            //System.out.println(nmoves);
        } while (nleft+nright==0 && nmoves<2*W*H);
        Main.addFatalError("Connected "+(nleft+nright)+".");
        Main.addFatalError("Finished in "+nmoves+" moves.");
        return (double)(nleft+nright)/nmoves;
    }
}

    // -----------------------------------------
    public String checkData(String test) {
        return "";
    }
    // -----------------------------------------
    // -----------------------------------------
    public double[] score(double[][] sc) {
	// relative - each individual score is divided by a maximal score for that test case
        double[] res = new double[sc.length];
        double maxsc;
        for (int j=0; j<sc[0].length; j++)
        {   maxsc=0;
            for (int i=0; i<sc.length; i++)
                if (sc[i][j]>maxsc)
                    maxsc=sc[i][j];
            if (maxsc==0)
                continue;
            for (int i=0; i<sc.length; i++)
                res[i] += sc[i][j]/maxsc;
        }
        return res;
    }


    

Object ready = new Object();
boolean togo;
boolean makeall;
    Errors err;
    long seed = 1;
    void generate(boolean b, long s){
        togo = false;
        synchronized(Main.step){
            makeall = !b && r != null;
            //System.out.println(makeall);
            if(b){
                W = H = 0;
            }
            init(seed = s);
        }
    }
}

