import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
public class Errors extends JPanel{
    JScrollPane scroll;
    JTextArea err;
    int position;
    JComboBox font, style, size;
    public Errors(){
        err = new JTextArea("Standard Error from your program, as well as other messages will appear here\n");
        err.setEditable(false);
        scroll = new JScrollPane(err);
        //scroll.setSize(getWidth(),getHeight());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        setLayout(gbl);
        c.weightx = 1;
        c.weighty = 1;
        c.gridx=0;
        c.gridy=0;
        c.fill=1;
        gbl.setConstraints(scroll,c);
        add(scroll);

		JPanel fontstuff = new JPanel();
		fontstuff.setPreferredSize(new Dimension(400,40));
		fontstuff.setLayout(new FlowLayout());
 
		GraphicsEnvironment ge  = GraphicsEnvironment.getLocalGraphicsEnvironment();
		
		Object[] fontlist = ge.getAvailableFontFamilyNames();
		font = new JComboBox(fontlist);
        for(int i = 0; i<fontlist.length; i++){
            if(fontlist[i].toString().toLowerCase().indexOf("courier") != -1){
                font.setSelectedIndex(i);
                break;
            }
        }
		font.setPreferredSize(new Dimension(150,30));
		fontstuff.add(font);
 
        ActionListener al = new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                setFont();
            }
        };

 
		Object[] sizelist = {"8", "9", "10","11","12", "14", "16","18","20", "22", "24","26","28", "32", "36","72"};
		size = new JComboBox(sizelist);
        size.setSelectedIndex(4);
		size.setPreferredSize(new Dimension(40,30));
		fontstuff.add(size);
        font.addActionListener(al);
        size.addActionListener(al);
		setFont();
 
        c.gridy=1;
        c.weightx = 1;
        c.weighty = 0;
        gbl.setConstraints(fontstuff,c);
        add(fontstuff);


    }
    void reset(){
        final JScrollBar bar = scroll.getVerticalScrollBar();
        SwingUtilities.invokeLater(
            new Runnable(){
                public void run(){
                    err.setText("");
                    bar.setValue(0);//-bar.getVisibleAmount());
                }
            });
    }
    void setFont(){
        String name = font.getSelectedObjects()[0].toString();
        int s = Integer.parseInt(size.getSelectedObjects()[0].toString());
        err.setFont(new Font(name,Font.PLAIN,s));
    }
    void addMessage(final String s){
        final JScrollBar bar = scroll.getVerticalScrollBar();
        //System.out.println(s.endsWith("\n")+" "+s);
        //if(!bar.getValueIsAdjusting() && (bar.getValue() + bar.getVisibleAmount() == bar.getMaximum() || bar.getValue() == position)){
        SwingUtilities.invokeLater(
            new Runnable(){
                public void run(){
                    err.append(s);
                    bar.setValue(bar.getMaximum());//-bar.getVisibleAmount());
                }
            });
        //}else{
            //position = -1;
            //err.append(s);
        //}
    }

}
